

#ifndef OPTIONSREQUESTER_H
#define OPTIONSREQUESTER_H

#include <kdialog.h>

#include "conversionoptions.h"

class Options;
class Config;
class QStringList;
class KPushButton;

/**
 * @short Shows an input dialog for selecting conversion options
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsRequester : public KDialog
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    OptionsRequester( Config*, QStringList list, QWidget *parent=0, const char *name=0, bool modal=true, WFlags f=0 );

    /**
     * Default Destructor
     */
    virtual ~OptionsRequester();

    void setProfile( const QString& profile );
    void setFormat( const QString& format );
    void setOutputDirectory( const QString& directory );

private slots:
    void okClicked();

signals:
    void setCurrentOptions( const ConversionOptions& );
    void addFiles( QStringList );

private:
    KPushButton* pOk;
    KPushButton* pCancel;
    QStringList files;

    Options* options;
};

#endif // OPTIONSREQUESTER_H

