#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <cycletimer.h>
#include <mainloop_events.h>
#include <idecode_m16c.h>
#include <fio.h>
#include <m16c_cpu.h>


/* global variable for faster access */
M16C_Cpu gm16c;

M16C_Cpu *
M16C_CpuNew(void) 
{
	M16C_Cpu *cpu = &gm16c;
	memset(&gm16c,0,sizeof(M16C_Cpu));
	M16C_IDecoderNew();	
	return cpu;
}

static inline void
CheckSignals() {
        if(unlikely(mainloop_event_pending)) {
                mainloop_event_pending = 0;
                if(mainloop_event_io) {
                        FIO_HandleInput();
                }
		if(gm16c.signals) {
			// Interrupt handling not implemented
		}
	}
}

void
M16C_Run(void) 
{
	uint16_t icode;
	M16C_Instruction *instr;
	while(1) 
	{
		icode = M16C_Read8(M16C_REG_PC) | (M16C_Read8(M16C_REG_PC+1) <<8);
		instr = M16C_InstructionFind(icode);
		M16C_REG_PC += instr->len;
		instr->proc(icode);
		CheckSignals();	
		CycleCounter+=2;
                CycleTimers_Check();
	}
}

void
_init(void) {
        fprintf(stderr,"Loading M16C emulation module.\n");
}
