#
# bibliography package for Perl
#
# Character set tables, to be loaded on demand
#
# Dana Jacobsen (dana@acm.org)
# 30 November 1995

#
# Remember, these are loaded on demand because of their size, so if you're
# going to use these, you must do something like:
#
#   require "${glb_bpprefix}p-cstab.pl" unless defined %bib'uapprox_tab;
#
# which will properly load the file if it hasn't done so already.

# XXXXX We really ought to be reading these in from tables

%mapprox_tab = (
'0000',	'0000',
  # HTML 2.0 idiomatic mappings -> common display styles
'2110',	'0120',
'2111',	'0140',
'2112',	'0120',
'2113',	'0140',
'2114',	'0140',
'2115',	'0130',
'2116',	'0120',
'2120',	'0121',
'2121',	'0141',
'2122',	'0121',
'2123',	'0141',
'2124',	'0141',
'2125',	'0131',
'2126',	'0121',
  # begin/end protect
'3100',	'0000',
'3110',	'0000',
);

# These should never have objectionable characters in them, such as
# \, <, >, |, %, #, &, ...
%uapprox_tab = (
#'0107', 'c',
#'010D', 'c',
##'0159', 'r',
#'0161', 's',
#'017A',	'z',
#'017E', 'z',
#'0268',	'i',
#'03B3', 'gamma',
#'03B4', 'delta',
#'03BC', 'mu',
#'03C3', 'sigma',
#'2002', ' ',
#'2003', '  ',
#'2007', ' ',
#'2008', ' ',
#'2009', ' ',
'2212', '-',
'2013', '--',
'2014', '---',
'201C', '``',
'201D', '\'\'',
'0107', q-{\'c}-,
'010C', '{\vC}',
'010D', '{\vc}',
'0159', '{\vr}',
'015F', '{\c{s}}',
'0160', '{\vS}',
'0161', '{\vs}',
'017A', q-{\'z}-,
'017E', '{\vz}',
# XXXXX
# Should these be surrounded by $ (math mode)?
# Also, what to do with \mu, which is listed twice?
'03B1', '\alpha',
'03B2', '\beta',
'03B3', '\gamma',
'03B4', '\delta',
'03B5', '\epsilon',
'03B6', '\zeta',
'03B7', '\eta',
'03B8', '\theta',
'03B9', '\iota',
'03BA', '\kappa',
'03BB', '\lambda',
'03BC', '\mu',
'03BD', '\nu',
'03BE', '\xi',
'03C0', '\pi',
'03C1', '\rho',
'03C2', '\varsigma',
'03C3', '\sigma',
'03C4', '\tau',
'03C5', '\upsilon',
'03C6', '\phi',
'03C7', '\chi',
'03C8', '\psi',
'03C9', '\omega',
'2007', '$\:$',
'2009', '$\,$',
'201C', '``',
'201D', '\'\''
);

&debugs("Loading approx tables", 8192);

1;
