/***************************************************************************
                          instrumentmap.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INSTRUMENTMAP_H
#define INSTRUMENTMAP_H
#include "gm.h"
#include "typedefs.h"

#define MAX_BANKS 50

enum {

	BANK_SELECT_METHOD_NONE,
	BANK_SELECT_MSB_LSB,
	BANK_SELECT_CUSTOM_STRING
};

/**Midi Instrument Map
  *@author Juan Linietsky
  */

class Bank {
public:

	string name;
	char bank_select_method;
	char MSB,LSB;
	string custom_bank_select_string;	
	string patch_names[128];

	void clear() {
		
		int i;

		for (i=0;i<128;i++) patch_names[i]="";
		bank_select_method=0; // none!
		MSB=LSB=0;
		custom_bank_select_string="";
	};

	void set_gm_names() {

		int i;

		for (i=0;i<128;i++) patch_names[i]=gm_names[i];
		name="General Midi";
	};

	Bank () {

		clear();
	};
};

class InstrumentMap {

	int banks_count;

	
public:

	Bank *bank[MAX_BANKS];

	int get_banks_count() { return banks_count; };
        string controller_names[128];

	void add_bank();
	void add_bank_gm();
	void delete_bank(int banknum);

	InstrumentMap();
	~InstrumentMap();
};

#endif
