#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

KillIt () {
    i=1
    while [ "$i" -le 15 ]
    do
        sleep 1
        if [ `xpaaccess $XPA` = yes ]
        then
	    sleep 1
	    xpaset -p $XPA quit
	    break
        fi

        i=`expr $i + 1`
    done
}

DoXPA () {
    echo "$1"
    xpaset -p ds9 scale $4
    xpaset -p ds9 scale mode $5
    xpaset -p ds9 file $2 $3
    sleep 1
    xpaset -p ds9 frame clear
}

DoSXPA () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    xpaset -p ds9 file $2 $3 $4
    sleep 1
    xpaset -p ds9 frame clear
}

DoXPA2 () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    cat $3 | xpaset ds9 $2 $4
    sleep 1
    xpaset -p ds9 frame clear
}

StartDS9 () {
    if [ `xpaaccess $XPA` = no ]; then
	$CMD&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess $XPA` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# Fits

if [ "$1" = "fits" -o  -z "$1" ]; then
echo "Testing Fits"

StartDS9
xpaset -p $XPA scale linear
xpaset -p $XPA scale mode zscale

echo "..Bitpix = 8"
xpaset -p $XPA file fits img8.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = 16"
xpaset -p $XPA file fits img16.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = 32"
xpaset -p $XPA file fits img32.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = -32"
xpaset -p $XPA file fits img-32.fits
sleep 1
xpaset -p $XPA frame clear

echo "..Bitpix = -64"
xpaset -p $XPA file fits img-64.fits
sleep 1
xpaset -p $XPA frame clear

echo "..BSCALE"
xpaset -p $XPA file fits imgbscale.fits
sleep 1
xpaset -p $XPA frame clear

echo "..BLANK"
xpaset -p $XPA file fits imgblank.fits
sleep 1
xpaset -p $XPA frame clear

echo "..NaN"
xpaset -p $XPA file fits imgnan.fits
sleep 1
xpaset -p $XPA frame clear

echo "..INF"
xpaset -p $XPA file fits imginf.fits
sleep 1
xpaset -p $XPA frame clear

xpaset -p $XPA quit
echo "PASSED"

fi

# Command Line

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..fits"
$CMD -zscale img16.fits&
KillIt

echo "..fits gz"
$CMD -zscale img16.fits.gz &
KillIt

echo "..fits"
$CMD -zscale -fits img16.fits&
KillIt

echo "..sfits"
$CMD -zscale -sfits sfits.hdr sfits.arr&
KillIt

echo "..table"
$CMD -log table.fits &
KillIt

echo "..table filter"
$CMD -log table.fits[bin=rawx,rawy] &
KillIt

echo "..multiple extension data cube"
$CMD -zscale -medatacube mosaicimage.fits &
KillIt

echo "..mosaic image iraf"
$CMD -zscale -mosaicimage iraf mosaicimage.fits &
KillIt

echo "..mosaic image iraf datacube"
$CMD -zscale -mosaicimage naxis4.fits &
KillIt

echo "..mosaic image wcs"
$CMD -zscale -mosaicimage wcs mosaicimage.fits &
KillIt

echo "..mosaic image next wcs"
$CMD -zscale -mosaicimage wcs mosaicimage.fits -mosaicimagenext wcs mosaicimage.fits &
KillIt

echo "..mosaic image wcsp"
$CMD -zscale -mosaicimage wcsp ds9_8amp_2x2.fits&
KillIt

echo "..mosaic image wfpc2"
$CMD -zscale -mosaicimage wfpc2 hst.fits &
KillIt

echo "..mosaic iraf"
$CMD -zscale -mosaic iraf mosaicimage.fits &
KillIt

echo "..mosaic iraf datacube"
$CMD -zscale -mosaic iraf naxis4.fits &
KillIt

echo "..mosaic wcs"
$CMD -zscale -mosaic wcs mosaicimage.fits &
KillIt

echo "..mosaic wcsp"
$CMD -mosaic wcsp ds9_8amp_2x2.fits &
KillIt

echo "..mosaic wcs sfits"
$CMD -zscale -smosaic wcs sfits.hdr sfits.arr &
KillIt

echo "..mosaic image iraf(bc)"
$CMD -zscale -mosaicimageiraf mosaicimage.fits &
KillIt

echo "..mosaic image wcs(bc)"
$CMD -zscale -mosaicimagewcs mosaicimage.fits &
KillIt

echo "..mosaic image wfpc2(bc)"
$CMD -zscale -mosaicimagewfpc2 hst.fits &
KillIt

echo "..mosaic image next wcs(bc)"
$CMD -zscale -mosaicimagewcs mosaicimage.fits -mosaicimagenextwcs mosaicimage.fits &
KillIt

echo "..mosaic iraf(bc)"
$CMD -zscale -mosaiciraf mosaicimage.fits &
KillIt

echo "..mosaic wcs(bc)"
$CMD -zscale -mosaicwcs mosaicimage.fits &
KillIt

echo "..rgb cube"
$CMD -rgbcube rgbcube.fits &
KillIt

echo "..rgb cube sfits"
$CMD -srgbcube rgb.hdr rgb.arr &
KillIt

echo "..rgb image"
$CMD -rgbimage rgbimage.fits &
KillIt

echo "..rgb array"
$CMD -rgbarray rgb.arr[dim=200,zdim=3,bitpix=8] &
KillIt

echo "..array"
$CMD -array 'array.arr[dim=512,bitpix=-32,arch=bigendian]' &
KillIt

echo "..array cube"
$CMD -array 'cube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' &
KillIt

#echo "..url ftp"
#$CMD -zscale -url 'ftp://sao-ftp.harvard.edu/pub/rd/ds9/data/img-32.fits' &
#KillIt

#echo "..url http"
#$CMD -zscale -url 'http://hea-www.harvard.edu/RD/ds9/data/img-32.fits' &
#KillIt

echo "..external"
$CMD -zscale ds9.foo&
KillIt

echo "PASSED"
fi

# Stdin

if [ "$1" = "stdin" -o  -z "$1" ]; then
echo "Testing Stdin File"

echo "..fits"
cat img16.fits | $CMD -zscale - &
KillIt

echo "..fits gz"
cat img16.fits.gz | $CMD -zscale - &
KillIt

echo "..table"
cat table.fits | $CMD -log - &
KillIt

echo "..table filter"
cat table.fits | $CMD -log -[bin=rawx,rawy] &
KillIt

echo "..array"
cat array.arr | $CMD -array '-[dim=512,bitpix=-32,arch=bigendian]' &
KillIt

echo "..array cube"
cat cube.arr | $CMD -array '-[dim=512,zdim=3,bitpix=-32,arch=bigendian]' &
KillIt

echo "..multiple extension data cube"
cat mosaicimage.fits | $CMD -zscale -medatacube - &
KillIt

echo "..mosaic image iraf"
cat mosaicimage.fits | $CMD -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image iraf datacube"
cat naxis4.fits | $CMD -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image wcs"
cat mosaicimage.fits | $CMD -zscale -mosaicimage wcs - &
KillIt

echo "..mosaic image wcsp"
cat ds9_8amp_2x2.fits | $CMD -mosaicimage wcsp - &
KillIt

echo "..mosaic image wfpc2"
cat hst.fits | $CMD -zscale -mosaicimage wfpc2 - &
KillIt

echo "..mosaic iraf"
cat mosaicimage.fits | $CMD -zscale -mosaic iraf - &
KillIt

echo "..mosaic iraf datacube"
cat naxis4.fits | $CMD -zscale -mosaic iraf - &
KillIt

echo "..mosaic wcs"
cat mosaicimage.fits | $CMD -zscale -mosaic wcs - &
KillIt

echo "..mosaic wcsp"
cat ds9_8amp_2x2.fits | $CMD -mosaic wcsp - &
KillIt

echo "..mosaic image iraf(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaicimageiraf - &
KillIt

echo "..mosaic image wcs(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaicimagewcs - &
KillIt

echo "..mosaic image wfpc2(bc)"
cat hst.fits | $CMD -zscale -mosaicimagewfpc2 - &
KillIt

echo "..mosaic iraf(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaiciraf - &
KillIt

echo "..mosaic wcs(bc)"
cat mosaicimage.fits | $CMD -zscale -mosaicwcs - &
KillIt

echo "..rgb cube"
cat rgbcube.fits | $CMD -rgbcube - &
KillIt

echo "..rgb image"
cat rgbimage.fits | $CMD -rgbimage - &
KillIt

echo "..rgb array"
cat rgb.arr | $CMD -rgbarray -[dim=200,zdim=3,bitpix=8] &
KillIt

echo "PASSED"
fi

# XPA
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA"

StartDS9

echo "Testing file"
DoXPA "..fits" fits img16.fits linear zscale
DoXPA "..fits gz" fits img16.fits.gz linear zscale
DoSXPA "..sfits" sfits sfits.hdr sfits.arr linear zscale
DoXPA "..table" fits table.fits log minmax
DoXPA "..table filter" fits table.fits[bin=rawx,rawy] log minmax
DoXPA "..multiple extension data cube" medatacube mosaicimage.fits linear zscale
DoXPA "..mosaic image iraf" "mosaicimage iraf" mosaicimage.fits linear zscale

DoXPA "..mosaic image iraf datacube" "mosaicimage iraf" naxis4.fits linear zscale
DoXPA "..mosaic image wcs" "mosaicimage wcs" mosaicimage.fits linear zscale
DoXPA "..mosaic image wcsp" "mosaicimage wcsp" ds9_8amp_2x2.fits linear zscale
DoXPA "..mosaic image wfpc2" "mosaicimage wfpc2" hst.fits linear zscale
DoXPA "..mosaic iraf" "mosaic iraf" mosaicimage.fits linear zscale
DoXPA "..mosaic wcs" "mosaic wcs" mosaicimage.fits linear zscale
DoXPA "..mosaic iraf datacube" "mosaic iraf" naxis4.fits linear zscale
DoXPA "..mosaic wcsp" "mosaic wcsp" ds9_8amp_2x2.fits linear zscale
DoSXPA "..mosaic wcs sfits" "smosaic wcs" sfits.hdr sfits.arr linear zscale
DoXPA "..mosaic image iraf(bc)" mosaicimageiraf mosaicimage.fits linear zscale
DoXPA "..mosaic image wcs(bc)" mosaicimagewcs mosaicimage.fits linear zscale
DoXPA "..mosaic image wfpc2(bc)" mosaicwfpc2 hst.fits linear zscale
DoXPA "..mosaic iraf(bc)" mosaiciraf mosaicimage.fits linear zscale
DoXPA "..mosaic wcs(bc)" mosaicwcs mosaicimage.fits linear zscale

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p $XPA rgb
DoXPA "..rgb cube" rgbcube rgbcube.fits linear minmax
DoSXPA "..rgb cube sfits" srgbcube rgb.hdr rgb.arr linear minmax
DoXPA "..rgb image" rgbimage rgbimage.fits linear minmax
DoXPA "..rgb array" rgbarray rgb.arr[dim=200,zdim=3,bitpix=8] linear minmax
xpaset -p $XPA frame delete

DoXPA "..array" array 'array.arr[dim=512,bitpix=-32,arch=bigendian]' linear minmax
DoXPA "..array cube" array 'cube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' linear minmax

#DoXPA "..url ftp" url 'ftp://sao-ftp.harvard.edu/pub/rd/ds9/data/img-32.fits' linear zscale
#DoXPA "..url http" url 'http://hea-www.harvard.edu/RD/ds9/data/img-32.fits' linear zscale

DoXPA "..external" "" ds9.foo linear zscale 

echo "Testing Array"
DoXPA2 "..array" array array.arr 'array.arr[dim=512,bitpix=-32,arch=bigendian]' linear minmax
DoXPA2 "..array cube" array cube.arr 'arraycube.arr[dim=512,zdim=3,bitpix=-32,arch=bigendian]' linear minmax

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p $XPA rgb
DoXPA2 "..array rgb" "array rgb" rgb.arr 'rgb.arr[dim=200,zdim=3,bitpix=8]' linear minmax
xpaset -p $XPA frame delete

echo "Testing Fits"
DoXPA2 "..fits" fits img16.fits foo linear zscale
DoXPA2 "..fits gz" fits img16.fits.gz foo linear zscale
DoXPA2 "..table" fits table.fits foo log minmax
DoXPA2 "..table filter" fits table.fits 'table.fits[bin=rawx,rawy]' log minmax
DoXPA2 "..multiple extension data cube" "fits medatacube" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic image iraf" "fits mosaicimage iraf" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic image iraf datacube" "fits mosaicimage iraf" naxis4.fits foo linear zscale
DoXPA2 "..mosaic image wcs" "fits mosaicimage wcs" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic image wcsp" "fits mosaicimage wcsp" ds9_8amp_2x2.fits foo linear minmax
DoXPA2 "..mosaic image wfpc2" "fits mosaicimage wfpc2" hst.fits foo linear zscale
DoXPA2 "..mosaic iraf" "fits mosaic iraf" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic wcs" "fits mosaic wcs" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic iraf datacube" "fits mosaic iraf" naxis4.fits foo linear zscale
DoXPA2 "..mosaic wcsp" "fits mosaic wcsp" ds9_8amp_2x2.fits foo linear minmax
DoXPA2 "..mosaic image iraf(bc)" "fits mosaicimageiraf" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic image wcs(bc)" "fits mosaicimagewcs" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic image wfpc2(bc)" "fits mosaicimagewfpc2" hst.fits foo linear zscale
DoXPA2 "..mosaic iraf(bc)" "fits mosaiciraf" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic wcs(bc)" "fits mosaicwcs" mosaicimage.fits foo linear zscale

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p $XPA rgb
DoXPA2 "..rgb cube" "fits rgbcube" rgbcube.fits foo linear minmax
DoXPA2 "..rgb image" "fits rgbimage" rgbimage.fits foo linear minmax
xpaset -p $XPA frame delete

xpaset -p $XPA quit
echo "PASSED"
fi

echo "DONE"
