#! /bin/sh

if [ "$1" = "2mass" ]; then
echo "Testing 2MASS"
ds9 -2mass m31 -sleep 1 -exit
ds9 -2mass name m31 -sleep 1 -exit
ds9 -2mass coord 00:42:44.404 +41:16:08.78 -sleep 1 -exit
ds9 -2mass survey j -sleep 1 -exit
ds9 -2mass size 600 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "about" -o  -z "$1" ]; then
echo "Testing About"
ds9 -about -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "bin" -o  -z "$1" ]; then
echo "Testing Bin"
ds9 -bin about 4096 4096 -sleep 1 -exit
ds9 -bin buffersize 512 -sleep 1 -exit
ds9 -bin cols detx dety -sleep 1 -exit
ds9 -bin factor 4 -sleep 1 -exit
ds9 -bin factor 4 2 -sleep 1 -exit
ds9 -bin depth 10 -sleep 1 -exit
ds9 -bin filter '{pha > 5}' -sleep 1 -exit
ds9 -bin function sum -sleep 1 -exit
ds9 -bin to fit -sleep 1 -exit
ds9 -bin smooth yes -sleep 1 -exit
ds9 -bin smooth function boxcar -sleep 1 -exit
ds9 -bin smooth radius 3 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "blink" -o  -z "$1" ]; then
echo "Testing blink"
ds9 -blink -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "blue" -o  -z "$1" ]; then
echo "Testing blue"
ds9 -rgb -blue -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "cmap" -o  -z "$1" ]; then
echo "Testing cmap"
ds9 -cmap Heat -sleep 1 -exit
ds9 -cmap file foo.sao -sleep 1 -exit
ds9 -cmap invert yes -sleep 1 -exit
ds9 -cmap value 5 .5 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "contour" -o  -z "$1" ]; then
echo "Testing Contour"
ds9 -contour -sleep 1 -exit
ds9 -contour yes -sleep 1 -exit
ds9 -contour copy -sleep 1 -exit
ds9 -contour clear -sleep 1 -exit
ds9 -contour paste wcs fk4 red 2 -sleep 1 -exit
ds9 -contour load foo.con wcs fk5 yellow 2 -sleep 1 -exit
ds9 -contour save foo.con wcs fk5 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "crosshair" -o  -z "$1" ]; then
echo "Testing Crosshair"
ds9 -crosshair 100 100 physical -sleep 1 -exit
ds9 -crosshair 345 58.8 wcs fk5 -sleep 1 -exit
ds9 -crosshair 23:01:00 +58:52:51 wcs fk5 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "datacube" -o  -z "$1" ]; then
echo "Testing datacube"
ds9 -datacube play -sleep 1 -exit
ds9 -datacube last -sleep 1 -exit
ds9 -datacube 3 -sleep 1 -exit
ds9 -datacube interval 2 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "dss" ]; then
echo "Testing DSS"
ds9 -dss m31 -sleep 1 -exit
ds9 -dss name m31 -sleep 1 -exit
ds9 -dss coord 00:42:44.404 +41:16:08.78 -sleep 1 -exit
ds9 -dss server eso -sleep 1 -exit
ds9 -dss survey dss2red -sleep 1 -exit
ds9 -dss size 10 10 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "exit" -o  -z "$1" ]; then
echo "Testing exit"
ds9 -sleep 1 -exit
ds9 -sleep 1 -quit
echo "PASSED"
fi

if [ "$1" = "fifo" -o  -z "$1" ]; then
echo "Testing fifo"
ds9 -fifo /dev/imt1 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "fifo_only" -o  -z "$1" ]; then
echo "Testing fifo_only"
ds9 -fifo_only -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "frame" -o  -z "$1" ]; then
echo "Testing Frame"
ds9 -frame center -sleep 1 -exit
ds9 -frame center 1 -sleep 1 -exit
ds9 -frame center all -sleep 1 -exit
ds9 -frame clear -sleep 1 -exit
ds9 -frame new -sleep 1 -exit
ds9 -frame new rgb -sleep 1 -exit
ds9 -frame delete -sleep 1 -exit
ds9 -frame reset -sleep 1 -exit
ds9 -frame refresh -sleep 1 -exit
ds9 -frame hide -sleep 1 -exit
ds9 -frame show 1 -sleep 1 -exit
ds9 -frame first -sleep 1 -exit
ds9 -frame next -sleep 1 -exit
ds9 -frame prev -sleep 1 -exit
ds9 -frame last -sleep 1 -exit
ds9 -frame frameno 4 -sleep 1 -exit
ds9 -frame 3 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "geometry" -o  -z "$1" ]; then
echo "Testing geometry"
ds9 -geometry 640x480 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "grid" -o  -z "$1" ]; then
echo "Testing Grid"
ds9 -grid -sleep 1 -exit
ds9 -grid yes -sleep 1 -exit
ds9 -grid load foo.grd -sleep 1 -exit
ds9 -grid save foo.grd -sleep 1 -exit
ds9 -grid system wcs -sleep 1 -exit
ds9 -grid sky fk5 -sleep 1 -exit
ds9 -grid skyformat degrees -sleep 1 -exit
ds9 -grid type analysis -sleep 1 -exit
ds9 -grid type axes interior -sleep 1 -exit
ds9 -grid type numerics interior -sleep 1 -exit
ds9 -grid view grid yes -sleep 1 -exit
ds9 -grid view axes yes -sleep 1 -exit
ds9 -grid view axes numbers yes -sleep 1 -exit
ds9 -grid view axes tickmarks yes -sleep 1 -exit
ds9 -grid view axes label yes -sleep 1 -exit
ds9 -grid view title yes -sleep 1 -exit
ds9 -grid view border yes -sleep 1 -exit
ds9 -grid view vertical no -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "help" -o  -z "$1" ]; then
echo "Testing help"
ds9 -- -help
ds9 '-?'
echo "PASSED"
fi

if [ "$1" = "help" -o  -z "$1" ]; then
echo "Testing help"
$ds9 img16.fits -histequ -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "iconify" -o  -z "$1" ]; then
echo "Testing iconify"
ds9 -iconify yes -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "invert" -o  -z "$1" ]; then
echo "Testing invert"
ds9 -invert -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "linear" -o  -z "$1" ]; then
echo "Testing linear"
ds9 img16.fits -linear -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "lock" -o  -z "$1" ]; then
echo "Testing lock"
ds9 -lock crosshairs wcs -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "lower" -o  -z "$1" ]; then
echo "Testing lower"
$ds9 -lower -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "match" -o  -z "$1" ]; then
echo "Testing match"
ds9 -match frames wcs -sleep 1 -exit
ds9 -match colorbars -sleep 1 -exit
ds9 -match scales -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "minmax" -o  -z "$1" ]; then
echo "Testing MinMax"
ds9 -minmax -sleep 1 -exit
ds9 -minmax scan -sleep 1 -exit
ds9 -minmax mode sample -sleep 1 -exit
ds9 -minmax interval 10 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "mode" -o  -z "$1" ]; then
echo "Testing Mode"
ds9 -mode crosshair -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "nameserver" ]; then
echo "Testing nameserver"
ds9 -nameserver m31 -sleep 1 -exit
ds9 -nameserver name m31 -sleep 1 -exit
ds9 -nameserver server ned-sao -sleep 1 -exit
ds9 -nameserver skyformat sexagesimal -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "orient" -o  -z "$1" ]; then
echo "Testing orient"
ds9 img16.fits -orient xy -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "pagesetup" -o  -z "$1" ]; then
echo "Testing pagesetup"
$ds9 -pagesetup orientation portrait -sleep 1 -exit
$ds9 -pagesetup pagescale scaled -sleep 1 -exit
$ds9 -pagesetup pagesize poster -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "pan" -o  -z "$1" ]; then
echo "Testing pan"
$ds9 img16.fits -pan 200 200 image -sleep 1 -exit
$ds9 img16.fits -pan to 400 400 physical -sleep 1 -exit
$ds9 img16.fits -pan to 13:29:55 47:11:50 wcs fk5 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "pixeltable" -o  -z "$1" ]; then
echo "Testing pixeltable"
ds9 img16.fits -pixeltable yes -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "port" -o  -z "$1" ]; then
echo "Testing port"
ds9 -port 5137 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "port_only" -o  -z "$1" ]; then
echo "Testing port_only"
ds9 -port_only -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "prefs" -o  -z "$1" ]; then
echo "Testing prefs"
ds9 -prefs mosaicfast no -sleep 1 -exit
ds9 -prefs bgcolor black -sleep 1 -exit
ds9 -prefs nancolor red -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "preserve" -o  -z "$1" ]; then
echo "Testing Preserve"
ds9 -preserve scale yes -sleep 1 -exit
ds9 -preserve pan yes -sleep 1 -exit
ds9 -preserve regions yes -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "print" -o  -z "$1" ]; then
echo "Testing print"
ds9 -print destination file -sleep 1 -exit
ds9 -print command 'gv -' -sleep 1 -exit
ds9 -print filename foo.ps -sleep 1 -exit
ds9 -print palette cmyk -sleep 1 -exit
ds9 -print level 2 -sleep 1 -exit
ds9 -print resolution 75 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "private" -o  -z "$1" ]; then
echo "Testing private"
ds9 -visual peusdocolor -private -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "regions" -o  -z "$1" ]; then
echo "Testing regions"
ds9 -regions foo.reg -sleep 1 -exit
ds9 -regions load foo.reg -sleep 1 -exit
ds9 -regions save foo.reg -sleep 1 -exit
ds9 -regions move back -sleep 1 -exit
ds9 -regions move front -sleep 1 -exit
ds9 -regions select all -sleep 1 -exit
ds9 -regions select none -sleep 1 -exit
ds9 -regions select group foo -sleep 1 -exit
ds9 -regions delete all -sleep 1 -exit
ds9 -regions delete select -sleep 1 -exit
ds9 -regions format ds9 -sleep 1 -exit
ds9 -regions system wcs -sleep 1 -exit
ds9 -regions sky fk5 -sleep 1 -exit
ds9 -regions skyformat degrees -sleep 1 -exit
ds9 -regions delim nl -sleep 1 -exit
ds9 -regions strip yes -sleep 1 -exit
ds9 -regions wcs yes -sleep 1 -exit
ds9 -regions shape ellipse -sleep 1 -exit
ds9 -regions color red -sleep 1 -exit
ds9 -regions width 3 -sleep 1 -exit
ds9 -regions command {circle 100 100 20} -sleep 1 -exit

ds9 -regions group foo color red -sleep 1 -exit
ds9 -regions group foo copy -sleep 1 -exit
ds9 -regions group foo delete -sleep 1 -exit
ds9 -regions group foo cut -sleep 1 -exit
ds9 -regions group foo font {times 14 bold} -sleep 1 -exit
ds9 -regions group foo move 100 100 -sleep 1 -exit
ds9 -regions group foo movefront -sleep 1 -exit
ds9 -regions group foo moveback -sleep 1 -exit
ds9 -regions group foo property delete no -sleep 1 -exit
ds9 -regions group foo select -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "red" -o  -z "$1" ]; then
echo "Testing red"
ds9 -rgb -red -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "rgb" -o  -z "$1" ]; then
echo "Testing rgb"
ds9 -rgb -sleep 1 -exit
ds9 -rgb red -sleep 1 -exit
ds9 -rgb channel red -sleep 1 -exit
ds9 -rgb view blue no -sleep 1 -exit
ds9 -rgb system wcs -sleep 1 -exit
ds9 -rgb lock scale yes -sleep 1 -exit
ds9 -rgb lock bin yes -sleep 1 -exit
ds9 -rgb lock colorbar yes -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "rotate" -o  -z "$1" ]; then
echo "Testing rotate"
ds9 img16.fits -rotate 45 -sleep 1 -exit
ds9 img16.fits -rotate to 45 -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "saveimage" -o  -z "$1" ]; then
echo "Testing saveimage"
ds9 img16.fits -saveimage fits ds9.fits -sleep 1 -exit
ds9 img16.fits -saveimage jpeg ds9.jpg  -sleep 1 -exit
ds9 img16.fits -saveimage tiff ds9.tif  -sleep 1 -exit
ds9 img16.fits -saveimage png  ds9.png  -sleep 1 -exit
ds9 img16.fits -saveimage ppm  ds9.ppm  -sleep 1 -exit
ds9 img16.fits -saveimage mpeg ds9.mpg  -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "savefits" -o  -z "$1" ]; then
echo "Testing savefits"
ds9 table.fits -savefits ds9.fits -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "savempeg" -o  -z "$1" ]; then
echo "Testing savempeg"
ds9 img16.fits table.fits -savempeg ds9.mpg -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "scale" -o  -z "$1" ]; then
echo "Testing Scale"
ds9 -scale datasec yes -sleep 1 -exit
ds9 -scale histequ -sleep 1 -exit
ds9 -scale limits 1 100 -sleep 1 -exit
ds9 -scale mode zscale -sleep 1 -exit
ds9 -scale mode 99.5 -sleep 1 -exit
ds9 -scale scope local -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "single" -o  -z "$1" ]; then
echo "Testing single"
ds9 img16.fits -single -sleep 1 -exit
echo "PASSED"
fi

if [ "$1" = "source" -o  -z "$1" ]; then
echo "Testing Source"
echo "PASSED"
fi

if [ "$1" = "tcl" -o  -z "$1" ]; then
echo "Testing TCL"
echo "PASSED"
fi

if [ "$1" = "update" -o  -z "$1" ]; then
echo "Testing Update"
echo "PASSED"
fi

if [ "$1" = "version" -o  -z "$1" ]; then
echo "Testing Version"
echo "PASSED"
fi

if [ "$1" = "view" -o  -z "$1" ]; then
echo "Testing View"
echo "PASSED"
fi

if [ "$1" = "wcs" -o  -z "$1" ]; then
echo "Testing WCS"
echo "PASSED"
fi

if [ "$1" = "zoom" -o  -z "$1" ]; then
echo "Testing Zoom"
echo "PASSED"
fi

echo "DONE"
