#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc Debug {which varname} {
    upvar $varname var
    global current

    if {$current(frame) != ""} {
	$current(frame) debug $which $var
    }
}

proc ProcessDebugTclCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global debug

    switch -- [lindex $var $i] {
	events {set debug(tcl,events) 1}
	update {set debug(tcl,update) 1}
	idletasks {set debug(tcl,idletasks) 1}
	layout {set debug(tcl,layout) 1}
	info {set debug(tcl,info) 1}
	watch {set debug(tcl,watch) 1}
	hv {set debug(tcl,hv) 1}
	grid {set debug(tcl,grid) 1}
	http {set debug(tcl,http) 1}
	ftp {set debug(tcl,ftp) 1}
    }
}

proc ProcessDebugCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global debug

    DebugMenu

    switch -- [lindex $var $i] {
	ast {
	    set debug(saotk,ast) 1
	    Debug ast debug(saotk,ast)
	}
	mosaic {
	    set debug(saotk,mosaic) 1
	    Debug mosaic debug(saotk,mosaic)
	}
	parser {
	    set debug(saotk,parser) 1
	    Debug parser debug(saotk,parser)
	}
	perf {
	    set debug(saotk,perf) 1
	    Debug perf debug(saotk,perf)
	}
	wcs {
	    set debug(saotk,wcs) 1
	    Debug wcs debug(saotk,wcs)
	}
	bin {
	    set debug(saotk,bin) 1
	    Debug bin debug(saotk,bin)
	}
	gz {
	    set debug(saotk,gz) 1
	    Debug gz debug(saotk,gz)
	}
	iis {
	    set debug(iis) 1
	    IISDebug
	}
	rgb {
	    set debug(saotk,rgb) 1
	    Debug rgb debug(saotk,rgb)
	}
    }
}

proc DebugMenu {} {
    global ds9
    global menu
    global debug

    if {[winfo exist $ds9(mb).debug]} {
	return
    }

    $ds9(mb) add cascade -label "Debug" -menu $ds9(mb).debug

    menu $ds9(mb).debug -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug"
    $ds9(mb).debug add cascade -label "Tcl" -menu $ds9(mb).debug.tcl
    $ds9(mb).debug add cascade -label "SAOTk" -menu $ds9(mb).debug.saotk
    $ds9(mb).debug add cascade -label "IIS" -menu $ds9(mb).debug.iis

    menu $ds9(mb).debug.tcl -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug Tcl"
    $ds9(mb).debug.tcl add checkbutton -label "Events" \
	-variable debug(tcl,events)
    $ds9(mb).debug.tcl add checkbutton -label "Update" \
	-variable debug(tcl,update)
    $ds9(mb).debug.tcl add checkbutton -label "Idletasks" \
	-variable debug(tcl,idletasks)
    $ds9(mb).debug.tcl add checkbutton -label "Layout" \
	-variable debug(tcl,layout)
    $ds9(mb).debug.tcl add checkbutton -label "Info" \
	-variable debug(tcl,info)
    $ds9(mb).debug.tcl add checkbutton -label "Watch" \
	-variable debug(tcl,watch)
    $ds9(mb).debug.tcl add checkbutton -label "HV" \
	-variable debug(tcl,hv)
    $ds9(mb).debug.tcl add checkbutton -label "Grid" \
	-variable debug(tcl,grid)
    $ds9(mb).debug.tcl add checkbutton -label "HTTP" \
	-variable debug(tcl,http)
    $ds9(mb).debug.tcl add checkbutton -label "FTP" \
	-variable debug(tcl,ftp)

    menu $ds9(mb).debug.saotk -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug SAOTk"
    $ds9(mb).debug.saotk add checkbutton -label "AST" \
	-variable debug(saotk,ast) \
	-command "Debug ast debug(saotk,ast)"
    $ds9(mb).debug.saotk add checkbutton -label "Mosaic" \
	-variable debug(saotk,mosaic) \
	-command "Debug mosaic debug(saotk,mosaic)"
    $ds9(mb).debug.saotk add checkbutton -label "Parser" \
	-variable debug(saotk,parser) \
	-command "Debug parser debug(saotk,parser)"    
    $ds9(mb).debug.saotk add checkbutton -label "Perf" \
	-variable debug(saotk,perf) \
	-command "Debug perf debug(saotk,perf)"    
    $ds9(mb).debug.saotk add checkbutton -label "WCS" \
	-variable debug(saotk,wcs) \
	-command "Debug wcs debug(saotk,wcs)"    
    $ds9(mb).debug.saotk add checkbutton -label "Bin" \
	-variable debug(saotk,bin) \
	-command "Debug bin debug(saotk,bin)"    
    $ds9(mb).debug.saotk add checkbutton -label "GZ" \
	-variable debug(saotk,gz) \
	-command "Debug gz debug(saotk,gz)"    
    $ds9(mb).debug.saotk add checkbutton -label "RGB" \
	-variable debug(saotk,rgb) \
	-command "Debug rgb debug(saotk,rgb)"    

    menu $ds9(mb).debug.iis -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug IIS"
    $ds9(mb).debug.iis add checkbutton -label "IIS" \
	-variable debug(iis) -command IISDebug
}
