#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc BoxDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base
    MarkerBaseRectDialog $frame $id 275 150 size
}

# actions

proc BoxClose {frame id} {
    MarkerBaseRectClose $frame $id
}

proc BoxApply {frame id} {
    MarkerBaseRectApply $frame $id
}

# callbacks

proc BoxCoordCB {frame id} {
    MarkerBaseRectCoordCB $frame $id
}

proc BoxEditCB {frame id} {
    MarkerBaseRectEditCB $frame $id
}

proc BoxDistCB {frame id} {
    MarkerBaseRectDistCB $frame $id
}

proc BoxDefaultDialog {} {
    MarkerBaseRectDefaultDialog box Size
}
