# Samizdat engine helper functions
#
#   Copyright (c) 2002-2006  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

# debug output
#
def log(msg)
  $stderr << 'Samizdat: ' << msg << "\n"
end

# expire timeout for permanent cookie
#
def forever
  60 * 60 * 24 * 365 * 5   # 5 years
end

# generate uniform hash
#
def digest(value)
  Digest::MD5.new(value).hexdigest   # todo: configurable digest function
end

# parse YAML data or return empty hash
#
def yaml_hash(yaml)
  YAML.load(yaml.to_s) or {}
end

# shortcut for page length limit config option
#
def limit_page
  config['limit']['page']
end

# record moderatorial action
#
def log_moderation(moderator, action, resource)
  db.do 'INSERT INTO Moderation (moderator, action, resource)
    VALUES (?, ?, ?)', moderator, action, resource
end
