/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Mouse.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __MOUSE_H__
#define __MOUSE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _MOUSE_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _MOUSE_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
void SagCad_MouseDown(GtkWidget *widget, int Button, int Shift, int x, int y);
void SagCad_MouseUp(GtkWidget *widget, int Button, int Shift, int x, int y);
void SagCad_MouseMove(GtkWidget *widget, int Button, int Shift, int x, int y);

/* Mode 0 */
int MouseMode_Non(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Non(GtkWidget *widget, int Button, int x, int y);

/* 中心設定 (100) */
int MouseMode_Center(GtkWidget *widget, int Button, double x, double y);
int MouseRet_CenterL(double x, double y);
int MouseRet_CenterR(double x,double y);

/* セレクトされた最後のデータのセレクト解除 */
int select_last_cansel(void);
/* スナップ設定 */
int snap_set(int snap, int mask);

/* １個選択 [ Only One ] */
int MouseMode_OnlyOne(GtkWidget *widget, int X, int Y, int Button);
int MouseRet_OnlyOne(GtkWidget *widget, int Button, int x, int y);
void OnlyOne(int Frag);

/* チェイン選択モード (ChainOne) */
int MouseMode_ChainOne(GtkWidget *widget, int X, int Y, int Button);
int MouseRet_ChainOne(GtkWidget *widget, int Button, int x, int y);



/* 作図 ＆ 編集 [ Draw & Edit ] */

/* 作図 [ Draw ] */
int MouseMode_Draw(GtkWidget *widget, int Button, int X, int Y);
int MouseRet_Draw(GtkWidget *widget, int Button, int x, int y);

/* トリム */
int MouseMode_Trim(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Trim(GtkWidget *widget, int Button, int x, int y);

/* 分割 */
int MouseMode_Split(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Split(GtkWidget *widget, int Button, int x, int y);

/* フィレット */
int MouseMode_Fillet(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Fillet(GtkWidget *widget, int Button, int x, int y);

/* Ｃ面 (chamfering) */
int MouseMode_Chamfering(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Chamfering(GtkWidget *widget, int Button, int x, int y);

/* 連続線 (continuation line) */
int MouseMode_ContLine(GtkWidget *widget, int Button, int x, int y);
int MouseRet_ContLine(GtkWidget *widget, int Button, int x, int y);

/* ３点で円 */
int MouseMode_3P_Circle(GtkWidget *widget, int Button, int x, int y);
int MouseRet_3P_Circle(GtkWidget *widget, int Button, int x, int y);

/* ３辺で円 */
int MouseMode_3L_Circle(GtkWidget *widget, int Button, int x, int y);
int MouseRet_3L_Circle(GtkWidget *widget, int Button, int x, int y);

/* 部品図読込 */
int MouseMode_PartsRead(GtkWidget *widget, int Button, int x, int y);
int MouseRet_PartsRead(GtkWidget *widget, int Button, int x, int y);
#ifdef AFTER
int MouseMode110(GtkWidget *widget, int Button, int x, int y);
int Ret_Mode110(GtkWidget *widget, int Button, int x, int y);
#endif


/* 選択 [ Edit ] */

/* 選択 [ Select ] */
int MouseMode_Select(GtkWidget *widget, int Button, int X, int Y);
int MouseRet_Select(GtkWidget *widget, int Button, int x, int y);
/* 範囲選択モード */
int MouseMode_Rect(GtkWidget *widget, int Button, int X, int Y);
int MouseRet_Rect(GtkWidget *widget, int Button, int x, int y);

/* ops */
int MouseMode_Select_ops(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Select_ops(GtkWidget *widget, int Button, int x, int y);
int MouseMode_Rect_ops(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Rect_ops(GtkWidget *widget, int Button, int x, int y);





/* 移動 & 複写 [ move & copy ] */

/* 平行 (Parallel) */
int MouseMode_Parallel(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Parallel(GtkWidget *widget, int Button, int x, int y);
/* 回転 (Turn) */
int MouseMode_Turn(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Turn(GtkWidget *widget, int Button, int x, int y);
/* 対称 (Mirror Image) */
int MouseMode_Mirror(GtkWidget *widget, int Button, int x, int y);
int MouseRet_Mirror(GtkWidget *widget, int Button, int x, int y);
/* 格子 (Grid) */
//int MouseMode_Grid(GtkWidget *widget, int Button, int x, int y);
//int MouseRet_Grid(GtkWidget *widget, int Button, int x, int y);
/* スケーリング (Scaling) */
//int MouseMode_Scaling(GtkWidget *widget, int Button, int x, int y);
//int MouseRet_Scaling(GtkWidget *widget, int Button, int x, int y);



/* 寸法 [ dimension ] */
int PicPointCheck(GtkWidget *widget, int Button, int x, int y, int n);

int MouseMode_DimensionX(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionX(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionY(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionY(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionP(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionP(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionR(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionR(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionD(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionD(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionA(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionA(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionPT(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionPT(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionHD(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionHD(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionAT(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionAT(GtkWidget *widget, int Button, int x, int y);

int MouseMode_DimensionEDT(GtkWidget *widget, int Button, int x, int y);
int MouseRet_DimensionEDT(GtkWidget *widget, int Button, int x, int y);

int MouseMode_PolyLine(GtkWidget *widget, int Button, int x, int y);
int MouseRet_PolyLine(GtkWidget *widget, int Button, int x, int y);

/* CAM */
int MouseMode_CamProfile(GtkWidget *widget, int Button, int x, int y);
int MouseRet_CamProfile(GtkWidget *widget, int Button, int x, int y);


#ifdef TEST
/* offset */
int MouseMode_offset(GtkWidget *widget, int Button, int x, int y);
int MouseRet_offset(GtkWidget *widget, int Button, int x, int y);
#endif



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __MOUSE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Mouse.h
 * ====================================================================
 */
