.\" 
.\"/*************************************************
.\"*     rpld - an IBM style RIPL server            *
.\"*************************************************/
.\"
.\"Copyright (c) 1999,2000, James McKenzie.
.\"                     All rights reserved
.\"Copyright (c) 1998,2000, Christopher Lightfoot.
.\"                     All rights reserved
.\"
.\"By using this file, you agree to the terms and conditions set
.\"forth in the LICENSE file which can be found at the top level of
.\"the rpld distribution.
.\"
.\"IBM is a trademark of IBM Corp.
.\"
.\"
.\"
.\" $Id: rpld.conf.man,v 1.7 2000/07/17 10:45:38 root Exp $;
.\"
.\" $Log: rpld.conf.man,v $
.\" Revision 1.7  2000/07/17 10:45:38  root
.\" #
.\"
.\" Revision 1.6  2000/07/17 10:43:34  root
.\" #
.\"
.\" Revision 1.5  2000/07/16 14:22:06  root
.\" #
.\"
.\" Revision 1.4  2000/07/16 14:05:28  root
.\" #
.\"
.\" Revision 1.3  2000/07/16 13:18:10  root
.\" #
.\"
.\" Revision 1.1  2000/07/16 13:16:33  root
.\" #
.\"
.\" Revision 1.7  1999/09/15 14:29:10  root
.\" #
.\"
.\" Revision 1.6  1999/09/15 01:22:18  root
.\" #
.\"
.\" Revision 1.5  1999/09/15 00:36:29  root
.\" #
.\"
.\" Revision 1.4  1999/09/15 00:22:07  root
.\" #
.\"
.\" Revision 1.3  1999/09/15 00:14:29  root
.\" #
.\"
.\" Revision 1.2  1999/09/14 21:25:59  root
.\" #
.\"
.\" Revision 1.1  1999/09/14 21:00:47  root
.\" #
.\"
.\" Revision 1.1  1999/09/14 17:19:37  root
.\" Initial revision
.\"
.\";
.Dd Jun 16, 2000
.Dt RPLD.CONF 5
.Os Linux
.Sh NAME
.Nm rpld.conf
.Nd rpld configuration file
.Sh DESCRIPTION
The 
.Xr rpld.conf
file is the configuration file for the
.Pa rpld(1)
program.
It consists of a number of HOST blocks of the form:
.Bd -literal -ffset indent
HOST {
     ...
};

.Ed
Within the HOST blocks there can be 
ethernet, execute, framesize, blocksize, nospew, and pacing  directives 
and FILE blocks.
FILE blocks are of the form:
.Bd -literal -ffset indent
	FILE {
	     ...
	};

.Ed
Within FILE blocks there can be path, offset, length, load and linux directives.
Directives are of the form
.Bd -literal -ffset indent
	foo = something;
or
.Bd -literal -ffset indent
	bar;

.Ed
and are detailed below. Comments are allowed in the configuration file and
can either be in C-form (i.e. starting with /* and ending with */) or C++ form
(starting with // and ending at the line break).
.Pp
.Sh DIRECTIVES
.Pp
Directives are of the form 
.Bd -literal -ffset indent
	foo = something;
or
.Bd -literal -ffset indent
	bar;

.Ed
If something is a string it should be entered between quotes. Numbers are
assumed to be decimal unless preceded by 0x in which case they are interpreted
in hexadecimal. MAC addresses should be given as 6 octets in hexadecimal without
the leading 0x. The octets should be separated by colons.
.Bd -literal -ffset indent
	number = 131;
	hexnumber = 0x7382;
	macaddr = 08:00:02:43:21:22;
	string = "fish soup";

.Ed
.Bl -tag -width 0 -compact
.It Pa blocksize
This directive sets the maximum size in octets of data that is transmitted in
each
FILE.DATA.RESPONSE frame that the server sends. The block size should
be at least 48 octets smaller than the frame size. After the client negotiates
a frame size the block size is checked and if it is no longer 48 octets smaller
than frame size it is adjusted accordingly. Some buggy boot ROMs will fail
if block size is not a multiple of four, accordingly you should be aware of the
situation that could arise if the client was to negotiate the block size down
to something that wasn't a multiple of four.
.Bd -literal -ffset indent
	blocksize = 528;

.Ed
.It Pa ethernet
This directive sets the MAC address of the client referenced
in this HOST block. It should either be formatted as six octets separated by colons. e.g..
.Bd -literal -ffset indent
	ethernet = 00:60:6e:33:4f:2c;

.Ed
or it can be specified as a range of mac addresses as six octets separated by colons followed by a solidus and the number of bytes to match. So:
.Bd -literal --ffset indent
	ethernet = 00:50:32:33:00:00/4;

.Ed
Will match anything of the form 00:50:32:33:xx:xx. It is expected that this 
support will be changed from bytes to bits in a future release.

.It Pa execute
This directive sets the execute address that control is transferred to when 
downloading has finished. It should be a number in either decimal or hexadecimal.
.Bd -literal -ffset indent
	execute = 0x92000;

.Ed
It is not clear whether or not the client's Ethernet adapter is or should be shut down
prior to the transfer of control. This may cause problems on systems where the
Ethernet adapter in the client can do DMA directly into host memory. As the adapter may 
continue writing to the buffers that the boot ROM set up, it may be necessary
to download a small program to reset the Ethernet adapter. See code under the
.Pa nics/
directory in the source distribution for examples.
.It Pa framesize
This directive sets the maximum size of the frames that the server uses to
communicate with the client. The actual frame size used is negotiated between
the client and the server, the server will force the client to use this value
if it requests a larger one. The maximum frame size that Ethernet can support is
1500, and this is the default value.
.Bd -literal -ffset indent
	framesize = 576;

.Ed
.It Pa length
This directive sets the number of octets transmitted to the client for this
FILE block. If this directive is not specified the server transmits data 
until an end of file condition occurs.
.Bd -literal -ffset indent
	length = 4096;

.Ed
would send 4096 octets from the file.
.It Pa linux
This directive takes no argument. It indicates to 
.Xr rpld 1
that the file specified in the path directive is a Linux kernel image. 
.Xr rpld 1
then analyses the kernel image and generates three FILE blocks corresponding
to the primary boot loader, secondary boot loader, and data portions of the image.
It then sets a default execute address which points to the secondary boot loader
which is loaded at 0x90200. The execute address may be over-ridden with an execute
directive which appears AFTER the FILE block. 
.Bd -literal -ffset indent
	linux;

.Ed
.Xr rpld 1
may have problems with bzImage kernels.
.It Pa load
This directive sets the load address for this FILE block. Data is read from 
.Pa offset
octets into the file at copied to the client starting at the address
specified by the load directive. The FILE block
.Bd -literal -ffset indent
FILE {
	path = "/rplboot/fish";
	offset = 512;
	length = 4096;
	load = 0x90200;
};

.Ed
would load 4096 octets from the file 
.Pa /rplboot/fish
starting 512 octets into the file into the
client's memory starting 
at address 0x90200. (so the 513th byte of the file will load to address 0x90200)
.It Pa nospew
This directive causes rpld to emit only one FILE.DATA.RESPONSE frame for SEND.FILE.REQUEST frame received. The usual behaviour is the client sends one FILE.DATA.RESPONSE frame which causes the server to transmit all the FILE.DATA.RESPONSE frames
in order (see 
.Pa pacing
) Some RPL boot proms have made this sensible modification to the protocol. 
.Pa NB
if you
specify this directive when it is not required, most roms will send another 
SEND.FILE.REQUEST frame after a timeout of about one second. Some roms will only
make twenty or so retransmits before aborting the boot.
.It Pa offset
This directive sets the offset for this FILE block. Data is read from 
.Pa offset
octets into the file at copied to the client starting at the address
specified by the load directive.
.Bd -literal -ffset indent
	offset = 512;

.Ed
.It Pa pacing
This directive sets the minimum time gap in us between sequential frames when
the 
.Pa nospew
option is NOT set. 1000 (or 1 ms) is a reasonable choice and the default. 
Increase this if the client has to issue retransmits.
.It Pa path
This directive sets the path to the file that is to be downloaded. The file
must exist, and is examined at startup and on reception of SEND.FILE.REQUEST
frames.
.Bd -literal -ffset indent
	path = "/rplboot/fish";

.Ed
.El
.Sh NOTES
.Pp
The server downloads the FILE blocks in the inverse order to that in which
they were specified. Boot ROMs typically prefer the blocks to arrive in
decreasing load address, so you should specify them in increasing load address.
The server recalculates the length of all the files specified on reception of
a SEND.FILE.REQUEST frame. If the file changes size during downloading
the server will attempt to read to the original length of the file. If it 
encounters an end of file condition empty FILE DATA FRAMES will be sent. For Linux
kernel images the first sector of the kernel image will only be read from
disk when rpld is started. The first sector contains information such as the
default root device and the length of secondary boot loader.
You should therefore restart rpld if you change the version
of the kernel you are downloading. The order of directives is important: the
execute directive, if present, should always come after the 
.Pa linux
directive. 

.Sh Example
.Pp
A complete example file using every directive:
.Bd -literal -ffset indent
// Sample rpld.conf file 
/* (c) 1999 James McKenzie and
 *          Christopher Lightfoot
 *          All rights reserved.
 */

HOST {
	ethernet=08:00:02:32:1e:fc;
 	FILE {
		path="/rplboot/vmlinuz";
		linux;
	};
	FILE {
		path="/rplboot/vesarom.img";
		offset=0x200;
		length=0x400;
		load=0x92000;
	};
	execute=0x92000;
	pacing=2000;
};

.Ed
.Sh FILES
.Bl -tag -width /etc/rpld.conf -compact
.It Pa /etc/rpld.conf
The
.Xr rpld 1
configuration file.
.El
.Sh SEE ALSO
.Xr rpld 1 ,
.Xr bootpd 1 ,
.Xr dhcpd 1 ,
.Xr http://gimel.esc.cam.ac.uk/james/rpld ;
.Sh AUTHORS AND COPYRIGHT
.Pp
(c) 1999,2000 James McKenzie, and Christopher Lightfoot. All rights reserved.
