/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


/*
 * $Id: client.h,v 1.8 2000/07/17 10:43:34 root Exp $
 *
 * $Log: client.h,v $
 * Revision 1.8  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.7  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.6  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.5  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.4  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.3  1999/09/13 11:04:13  root
 * \#
 *  
 */




#define ST_START	0
#define ST_FIND		1
#define ST_FOUND	2
#define ST_SENDFILE	3
#define ST_FILEDATA	4
#define ST_DONE		5

struct clfile
{
  char *path;
  unsigned char *data;

  int offset;
  int length;

  u32 load_addr;

  int sblock, eblock;
  struct clfile *next;

  FILE *f;
};

struct client
{
  int state;

  u8 mac[ETH_ALEN];
  int partial_mac_len;
  int framelen;
  int blocknum;
  int blocklen;

  int pacing;
  int nospew;

  u32 run_addr;

  struct clfile *files;
  struct clfile *file;

  struct client *next;
};
