#!/usr/bin/env python

from qt import *
from mainWindowBA import mainWindowBA
from sf import SF
from fm import FM
from sfcomm import SFComm
from fmcomm import FMComm
from sflogin import SFLogin
from fmlogin import FMLogin
import os
from constants import *
import logging
from ProjectVO import ProjectVO
from PackageVO import PackageVO
from messageQueue import mainMessageQueue
import releaseWizard
from releaseStatusWizard import ReleaseStatusWizard
#from releaseWizard import ReleaseWizard
from workerThread import WorkerThread
from help import Help
from aboutDialog import AboutDialog
from news import News
from freshmeatSetup import FreshmeatSetup
from freshmeatRelease import FreshmeatRelease
from freshmeatProjectChooser import FreshmeatProjectChooser
from preferences import Preferences
from addressBook import AddressBook
from emailSetup import EmailSetup
from emailAnnouncement import EmailAnnouncement
from utf8 import from_utf8, to_utf8

debug = logging.getLogger("mainwindow").debug
error = logging.getLogger("mainwindow").error

COL_PROJ_NAME = 0
COL_PROJ_UNIX = 1
COL_PROJ_GROUP = 2

COL_PKG_NAME = 0
COL_PKG_ID = 1
COL_PKG_STATUS = 2
COL_PKG_FULLACCESS = 3

class mainWindow(mainWindowBA):
    def __init__(self, settings, autologin, *args):
        apply(mainWindowBA.__init__,(self,) + args)
        self.settings = settings
        self.autologin = autologin
        
        self.projects_dict = {} # maps group_id to set of projectVO's
        self.projects = None
        self.freshmeat_dict = {} # maps SF project name to FMProjectVO's

        self.timer = QTimer(self)
        self.connect(self.timer, SIGNAL("timeout()"),
                     self.getStatusMsg)
        self.timer.start(500, False)


        data_path = settings['data_path']
        self.address_book = AddressBook(data_path)
        self.sf_comm = SFComm(data_path)
        self.fm_comm = FMComm(data_path)
        self.sf = SF(data_path, self.sf_comm)
        self.fm = FM(data_path, self.fm_comm)
        #self.setProxy()
                              
        self.connect(self, PYSIGNAL('sf_projects_fetched()'), self.populateProjects)
        self.connect(self, PYSIGNAL('fm_projects_fetched()'), self.freshmeatSetup)
        self.connect(self, PYSIGNAL('fm_release_project_selected()'), self.freshmeatReleaseMain)
        self.connect(self, PYSIGNAL("fm_settings_changed()"), self.getFreshmeatDict)
        self.connect(self, PYSIGNAL('freshmeat_release()'), self.freshmeatReleaseDialog)
        self.connect(self, PYSIGNAL("address_book_changed()"), self.address_book_action_toggle)

        self.current_project_item = None
        self.current_projectVO = None
        self.current_package_item = None
        self.current_packageVO = None
        self.news = None

        self.toolBar.hide()
        
        self.logged_in = False
        self.releaseWizards = []
        self.threads = []

        self.eventDict = {EVENT_REFRESH_PACKAGES: self.packageRefreshEvent,
                          EVENT_ADD_PACKAGE: self.projectNewPackageEvent}

##        self.projectsListView.hideColumn(COL_PROJ_UNIX)
##        self.projectsListView.hideColumn(COL_PROJ_GROUP)
##        self.packagesListView.hideColumn(COL_PKG_ID)
##        self.packagesListView.hideColumn(COL_PKG_STATUS)
##        self.packagesListView.hideColumn(COL_PKG_FULLACCESS)

        self.getFreshmeatDict()

        self.setMainFont()
        self.projectMenuCreate()
        self.packageMenuCreate()
        self.show()
        self.loginPrompt()
        

    def __del__(self):
        for t in self.threads:
            running = t.running()
            t.stop()
            if not t.finished():
                t.wait()


    def customEvent(self, event):
        data = event.data()
        etype = event.type()
        event_action = self.eventDict.get(etype)
        if event_action: event_action(data)


    def closeEvent(self, ev):
        self.sf_comm.remove_cookie()
        try:
            self.fm_comm.logout()
        except:
            pass
        
        ev.accept()


    def setMainFont(self):
        try:
            font = self.settings.getFont('main_font')
            self.setFont(font)
            qApp.setFont(font, True)
        except Exception, e:
            pass


    def setProxy(self):
        proxy = None
        debug('use_proxy: %s', self.settings['use_proxy'])
        if self.settings['use_proxy'] in ('1', 'True'):
            proxy = {'http': "http://%s:%s" % (self.settings['http_server'],
                                               self.settings['http_port']),
                     'https': "https://%s:%s" % (self.settings['ssl_server'],
                                                 self.settings['ssl_port']),
                     'ftp': "ftp://%s:%s" % (self.settings['ftp_server'],
                                             self.settings['ftp_port'])}

        debug("proxy: %s", proxy)
        self.sf_comm.set_proxy(proxy)


    def loginPrompt(self):
        if not self.logged_in:
            self.sf_login = SFLogin(self,
                                    self.settings['data_path'],
                                    self.sf.initialize,
                                    self.autologin)
        
    def getStatusMsg(self):
        # read the message queue.  If an item exists,
        # populate the status bar with it.
        msg = mainMessageQueue.get()
        if msg:
            self.statusBar().message(msg)


    def getFreshmeatDict(self, fm_projects=None):
        if not fm_projects:
            fm_projects = self.fm.load_projects()

        self.freshmeat_dict = {}
        for fmProjectVO in fm_projects:
            sf_project = fmProjectVO.getSFProjectName()
            if sf_project:
                vos = self.freshmeat_dict.get(sf_project, [])
                vos.append(fmProjectVO)
                self.freshmeat_dict[sf_project] = vos
        self.freshmeat_release_action_toggle()


    def address_book_action_toggle(self):
        if self.current_projectVO and \
               self.address_book.get(self.current_projectVO.getProjectName()) and \
               self.settings['smtp_server']:
            enable = True
        else:
            enable = False
        
        self.emailAnnouncementAction.setEnabled(enable)        
        

    def populateProjects(self, projects):
        self.projects = projects
        self.logged_in = True
        self.fileSourceforge_LoginAction.setEnabled(False)
        self.projectsListView.clear()
        self.current_project_item = None
        self.current_projectVO = None
        self.current_package_item = None
        self.current_packageVO = None

        if projects:
            self.freshmeatSettingsAction.setEnabled(True)

            for project in projects:
                proj_item = QListViewItem(self.projectsListView)
                proj_item.setText(COL_PROJ_NAME, project.getProjectName())
                proj_item.setText(COL_PROJ_UNIX, project.getUnixName())
                proj_item.setText(COL_PROJ_GROUP, project.getGroupId())
                self.projects_dict[project.getGroupId()] = project.getPackages()
            if len(projects) == 1:
                self.projectSelected(proj_item)
            #else:
            #    self.packageTabWidget.setFocus()
        

    def hasFullAccess(self, packages):
        # if any package has full access return true, false otherwise
        if not packages: return False
        
        for pkg in packages:
            print pkg.getFullAccess()
            if pkg.getFullAccess() == "True": return True
        return False


    def populatePackages(self, group_id):
        self.packagesListView.clear()
        packages = self.projects_dict.get(group_id)
        debug("packages: %s", packages)
        self.__initialize_package_fields()
        full_access = False
        if packages:
            for package in packages:
                pkg_item = QListViewItem(self.packagesListView)
                pkg_item.setText(COL_PKG_NAME, from_utf8(package.getPackageName()))
                pkg_item.setText(COL_PKG_ID, package.getPackageId())
                pkg_item.setText(COL_PKG_STATUS, package.getPackageStatus())
                pkg_item.setText(COL_PKG_FULLACCESS, package.getFullAccess())
                if package.getFullAccess() == "True": full_access = True
            if len(packages) == 1:
                self.packagesListView.setSelected(pkg_item, True)
                #self.packageSelected(pkg_item)
        self.hideTabWidgets(full_access)


    def __initialize_package_fields(self):
        self.current_package_item = None
        self.current_packageVO = None

        self.packageIdLineEdit.setText("")
        self.updatePackageLineEdit.setText("")
        self.newPackageLineEdit.setText("")

        # enable
        self.refreshPackagesPushButton.setEnabled(1)
        self.newPackageLineEdit.setEnabled(1)

        # disable
        self.AddPackagePushButton.setEnabled(0)
        self.newReleasePushButton.setEnabled(0)
        self.editReleasePushButton.setEnabled(0)
        self.packageStatusComboBox.setEnabled(0)
        self.updatePackagePushButton.setEnabled(0)
        self.updatePackageLineEdit.setEnabled(0)
        self.editReleaseAction.setEnabled(0)
        self.newReleaseAction.setEnabled(0)
        self.emailSetupAction.setEnabled(0)
        self.editReleaseStatusAction.setEnabled(0)
        self.emailAnnouncementAction.setEnabled(0)

        
    def projectSelected(self, item):
        self.current_project_item = item
        self.current_projectVO = self.__getProjectFromItem(item)
        group_id = self.current_projectVO.getGroupId()
        
        debug("projectSelected: %s", group_id)
        
        self.populatePackages(group_id)

        self.submitNewsAction.setEnabled(1)

        self.freshmeat_release_action_toggle()

        self.emailSetupAction.setEnabled(1)

        self.address_book_action_toggle()


    def freshmeat_release_action_toggle(self):
        enabled = False
        try:
            project_name = self.current_projectVO.getProjectName()
            if project_name in self.freshmeat_dict:
                enabled = True
        except: pass
            
        self.freshmeatReleaseAction.setEnabled(enabled)


            
    def newPackageEdited(self, val):
        if not val:
            self.AddPackagePushButton.setEnabled(0)
        else:
            self.AddPackagePushButton.setEnabled(1)

            
    def updatePackageEdited(self, val):
        if val:
            self.updatePackagePushButton.setEnabled(1)
        else:
            self.updatePackagePushButton.setEnabled(0)


    def updatePackage(self):
        package_name = to_utf8(self.updatePackageLineEdit.text())
        package_status = str(self.packageStatusComboBox.currentText())
        package_id = str(self.packageIdLineEdit.text())

        result = self.sf_comm.update_package(self.current_projectVO.getGroupId(),
                                             package_id,
                                             package_name,
                                             package_status)
        debug("Update package int: %d", result)
        if result == 1:
            msg = "Package updated successfully"
        elif result == -1:
            msg = "Package could not be hidden - active releases"
            self.packageStatusComboBox.setCurrentText("Active")
        else:
            msg = "Could not update package"

        self.statusBar().message(msg)
        debug("Update package result: %s", msg)
        if result != 0:
            self.packageRefresh()

            ##self.packageRefresh(PackageVO(package_name,
            ##                              package_id,
            ##                              package_status))

            

    def __getPackageFromItem(self, item):
        return PackageVO(to_utf8(item.text(COL_PKG_NAME)),
                         str(item.text(COL_PKG_ID)),
                         str(item.text(COL_PKG_STATUS)),
                         str(item.text(COL_PKG_FULLACCESS)))

    def __getProjectFromItem(self, item):
        return ProjectVO(str(item.text(COL_PROJ_NAME)),
                         str(item.text(COL_PROJ_UNIX)),
                         str(item.text(COL_PROJ_GROUP)))


    def hideTabWidgets(self, full_access):
        if not full_access:
            self.updatePackageLineEdit.setReadOnly(True)
            self.newPackageLineEdit.hide()
            self.newPackageTextLabel.hide()
            self.AddPackagePushButton.hide()
            self.updatePackagePushButton.hide()
        else:
            self.newPackageLineEdit.show()
            self.newPackageTextLabel.show()

    def packageSelected(self, item):       
        self.current_package_item = item
        pkg = self.__getPackageFromItem(item)
        self.current_packageVO = pkg

        self.updatePackageLineEdit.setText(from_utf8(pkg.getPackageName()))
        status = pkg.getPackageStatus()

        if status == 'Active':
            self.packageStatusComboBox.setCurrentItem(0)
        else:
            self.packageStatusComboBox.setCurrentItem(1)

        if pkg.getFullAccess() == "True":
            self.updatePackageLineEdit.setReadOnly(False)
            self.newPackageLineEdit.show()
            self.newPackageTextLabel.show()
            self.AddPackagePushButton.show()
            self.updatePackagePushButton.show()
        else:
            self.updatePackageLineEdit.setReadOnly(True)
            self.newPackageLineEdit.hide()
            self.newPackageTextLabel.hide()
            self.AddPackagePushButton.hide()
            self.updatePackagePushButton.hide()

        self.packageIdLineEdit.setText(pkg.getPackageId())

        #enable
        self.packageStatusComboBox.setEnabled(1)
        self.updatePackageLineEdit.setEnabled(1)
        self.newReleasePushButton.setEnabled(1)
        self.editReleasePushButton.setEnabled(1)
        self.editReleaseAction.setEnabled(1)
        self.newReleaseAction.setEnabled(1)
        self.editReleaseStatusAction.setEnabled(1)
        
        # disable
        self.updatePackagePushButton.setEnabled(0)
        

    def packageRefresh(self):
        project = self.current_projectVO        
        group_id = project.getGroupId()

        # disable
        self.projectsListView.setEnabled(0)
        
        self.setCursor(Qt.waitCursor)
        thread = WorkerThread(self,
                              EVENT_REFRESH_PACKAGES,
                              self.sf_comm.get_packages,
                              group_id)
        thread.start()
        self.threads.append(thread)                              


    def packageRefreshEvent(self, pkgs):
        selectedVO = self.current_packageVO       
        project = self.current_projectVO
        
        group_id = project.getGroupId()
        current_pkgs = self.projects_dict[group_id]

        if current_pkgs != pkgs:
            debug("Packages updated.  Adding %d packages", len(pkgs))

            # remove the current project from
            # the set: self.projects
            self.projects.remove(project)
            project.setPackages(pkgs)

            # re-add this project, with the
            # new pkgs to self.projects
            self.projects.add(project)

            # save them for future runs
            self.sf.save_projects()

            # update the hash & listview
            self.projects_dict[group_id] = pkgs
            self.populatePackages(group_id)
        else:
            debug("No new packages detected")

        if selectedVO:
            self.__set_package_selected(selectedVO)

        # disable
        self.updatePackagePushButton.setEnabled(0)

        # enable
        self.projectsListView.setEnabled(1)
        
        self.setCursor(Qt.arrowCursor)



    def __set_package_selected(self, selectedVO):
        pkg = self.packagesListView.firstChild()
        while pkg != None:
            pkgVO = self.__getPackageFromItem(pkg)
            if pkgVO.getPackageId() == selectedVO.getPackageId():
                self.packagesListView.setCurrentItem(pkg)
                break
            pkg = pkg.nextSibling()


    def projectNewPackage(self):
        name = to_utf8(self.newPackageLineEdit.text())
        if not name:
            QMessageBox.information(self, "Package Name",
                                 "Cannot create package..\n"
                                 "Package name is empty.")
            return
        
        debug("Creating package: %s", name)
        group_id = str(self.projectsListView.currentItem().text(2))

        self.setCursor(Qt.waitCursor)
        thread = WorkerThread(self,
                              EVENT_ADD_PACKAGE,
                              self.sf_comm.add_package,
                              group_id,
                              name)
        thread.start()
        self.threads.append(thread)                              


        

    def projectNewPackageEvent(self, result):
        self.setCursor(Qt.arrowCursor)
        debug("add package result: %d", result)
        if result:
            self.packageRefresh()

    def editReleaseStatus(self):
        self.status_wizard = ReleaseStatusWizard(self,
                                                 self.settings,
                                                 self.sf_comm,
                                                 self.current_projectVO.copy(),
                                                 self.current_packageVO.copy())
        


    def releaseWizard(self, create):
        debug("%s", self.current_packageVO)
        
        release_wizard = releaseWizard.ReleaseWizard(self,
                                                     self.settings,
                                                     self.sf_comm,
                                                     self.current_projectVO.copy(),
                                                     self.current_packageVO.copy(),
                                                     create)
        release_wizard.show()
        self.releaseWizards.append(release_wizard)


    def createNewRelease(self):
        self.releaseWizard(True)

        
    def editRelease(self):
        self.releaseWizard(False)
        
        

    def packageNewRelease(self):
        item = self.projectsListView.currentItem()
        package = PackageVO(str(item.text(0)), str(item.text(1)))
        debug("packageNewRelease(): %s", package)
        

    def help(self):
        self._help = Help(self, "mainwindow.html")
        

    def reloadWizard(self):
        reload(releaseWizard)


    def submitNews(self):
        self.news = News(self,
                         self.current_projectVO,
                         self.sf_comm)


    def freshmeatSettings(self):
        debug("freshmeatSettings()")
        if self.fm_comm.sid is None:
            self.fm_login = FMLogin(self,
                                    self.settings['data_path'],
                                    self.fm.initialize,
                                    self.autologin)
        else:
            fm_projects = self.fm.load_projects()
            self.freshmeatSetup(fm_projects)
            

    def freshmeatSetup(self, fm_projects):
        debug("freshmeatSetup()")
        self.fm_setup = FreshmeatSetup(self,
                                       self.settings['data_path'],
                                       fm_projects,
                                       self.projects)



    def freshmeatRelease(self):
        proj_name = self.current_projectVO.getProjectName()
        fm_proj_vos = self.freshmeat_dict.get(proj_name)
        
        if not fm_proj_vos:
            msg = "Invalid state: projects.fm file may be corrupted"
            error(msg)
            QMessageBox.warning(self, "Problem encountered", msg)
            return

        if len(fm_proj_vos) > 1:
            fpc = FreshmeatProjectChooser(self, proj_name, fm_proj_vos)
        else:
            fm_proj_vo = fm_proj_vos[0]
            self.freshmeatReleaseMain(fm_proj_vo)


    def freshmeatReleaseMain(self, fm_project_vo):
        self.fm_release = FreshmeatRelease(self,
                                           self.fm_comm,
                                           fm_project_vo)

        if self.fm_comm.sid is None:
            self.fm_login = FMLogin(self,
                                    self.settings['data_path'],
                                    self.fm_release.initialize,
                                    self.autologin,
                                    "freshmeat_release()")
        else:
            self.freshmeatReleaseDialog(None)
            

    def freshmeatReleaseDialog(self, data):
        self.fm_release.show()


    def emailSetup(self):
        self.email_setup = EmailSetup(self,
                                      self.address_book,
                                      self.current_projectVO)
        self.email_setup.show()
                                                   

    def emailAnnouncement(self):
        self.email_announcement = EmailAnnouncement(self,
                                                    self.settings,
                                                    self.address_book,
                                                    self.current_projectVO)
        self.email_announcement.show()
        

    def editPreferences(self):
        try:
            username = self.sf_login.username
        except:
            username = ""
        self.preferences = Preferences(self, self.settings, username)


    def packageMenuCreate(self):
        self.package_menu = QPopupMenu(self)
        self.newReleaseAction.addTo(self.package_menu)
        self.editReleaseAction.addTo(self.package_menu)
        self.editReleaseStatusAction.addTo(self.package_menu)
        self.package_menu.insertSeparator()
        self.submitNewsAction.addTo(self.package_menu)
        self.package_menu.insertSeparator()
        self.freshmeatReleaseAction.addTo(self.package_menu)
        self.freshmeatSettingsAction.addTo(self.package_menu)
        self.package_menu.insertSeparator()
        self.emailAnnouncementAction.addTo(self.package_menu)
        self.emailSetupAction.addTo(self.package_menu)


    def projectMenuCreate(self):
        self.project_menu = QPopupMenu(self)
        self.submitNewsAction.addTo(self.project_menu)
        self.project_menu.insertSeparator()
        self.freshmeatReleaseAction.addTo(self.project_menu)
        self.freshmeatSettingsAction.addTo(self.project_menu)
        self.project_menu.insertSeparator()
        self.emailAnnouncementAction.addTo(self.project_menu)
        self.emailSetupAction.addTo(self.project_menu)


    def packageMenuPopup(self, row, col, qpt):
        self.package_menu.popup(QCursor.pos())

    def projectMenuPopup(self, row, col, qpt):
        self.project_menu.popup(QCursor.pos())
        


##    def uploadWebPages(self):
##        self.scp = SecureCopy(self)
##        self.scp.show()
        
        
    def editCopy(self, *args):
        print "mainWindow.editCopy(): Not implemented yet"
    
    def editCut(self, *args):
        print "mainWindow.editCut(): Not implemented yet"
    
    def editFind(self, *args):
        print "mainWindow.editFind(): Not implemented yet"
    
    def editPaste(self, *args):
        print "mainWindow.editPaste(): Not implemented yet"
    
    def editRedo(self, *args):
        print "mainWindow.editRedo(): Not implemented yet"
    
    def editUndo(self, *args):
        print "mainWindow.editUndo(): Not implemented yet"

    def fileExit(self):
        self.close()
        
    
    def fileNew(self, *args):
        print "mainWindow.fileNew(): Not implemented yet"
    
    def fileOpen(self, *args):
        print "mainWindow.fileOpen(): Not implemented yet"
    
    def filePrint(self, *args):
        print "mainWindow.filePrint(): Not implemented yet"
    
    def fileSave(self, *args):
        print "mainWindow.fileSave(): Not implemented yet"
    
    def fileSaveAs(self, *args):
        print "mainWindow.fileSaveAs(): Not implemented yet"
    
    def helpAbout(self, *args):
        self.aboutWindow = AboutDialog(self)
        self.aboutWindow.show()
    
    
