/******************************************************************************
*		       							      *
* engine/output.h (part of rcalc)				       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* Various kinds of formatted printing used by the calculation engine.
*/

#ifndef __RC_OUTPUT_H__
#define __RC_OUTPUT_H__

#include <glib.h>
#include <stdio.h>


void		rc_printf			( const gchar *format,
						  ... );
void		rc_error			( gchar err_reason, const gchar *format,
						  ... );

void		rc_output_set_streams		( FILE *output,
						  FILE *error );

void		rc_output_set_help_func		( RcDisplayHelpFunc func );

gboolean	rc_display_help			( const gchar *topic );


#endif /* __RC_OUTPUT_H__ */
