/*
               Razzle! (C) Copyright 1995 Richard L. Smith             
                         Email: rick@gte.net                 
               
           THIS PROGRAM GENERATES REAL-TIME 3-D STEREOGRAMS!           
        Sorry, but only the Linux version is available at present     

Permission to use, copy, modify, distribute and sell this software and it's
documentation for any purpose is hereby granted without fee. 
I make no representations about the suitability of this software for any
purpose.  It is provided "as is" without express or implied warranty.
*/

/* Rev Oct-16-96 to use pointer dereference instead of array indexing for 
             performance (?) boost 
  Oct-23-96  Added "Candy Stripe" to fill_palette() 
  Dec-17-96  Added asymetrical drawing functions and vars x3, y3, xs6, ys6
  Dec-24-96  Added xfseed-yf1seed vars so lines can sometimes skip 2 spaces
             instead of one.  Gives a lacy-moire effect.
  Dec-26-96  Randomised the x1,y1,x3,y3 start points. (instead of defaulting 
             to center of cells) for more variability.  Some minor fudging to
             enhance the depth of images.
  Jan-18-97  Added vga_init() to give up root priviledges after start.  (You
             should do a: chmod 4111 if you want others to exc razzle.)
  Feb-03-97  Got rid of klutzy goto in fill_palette().
  Apr-17-97  Added more drawing functions baised on x1,x3,x4,y1,y3,y4. 
*/
 
/* 
TO MAKE:
[your_root_prompt]# gcc -O2 -o razzle razzle.c -lvga
                    (use the -m486 flag if you got one)

TO RUN:
[your_root_prompt]# razzle       opens a 640x480 256 color screen   
[your_root_prompt]# razzle -l    opens a 320x200 256 color screen

TO QUIT:
Press any key!

*/

#include <stdio.h>
#include <stdlib.h>
#include <vga.h>

/* you can define NUM_C_REGISTERS up to 256 or as little as 64.  Use lower 
   for slower machines. */
#define NUM_C_REGISTERS 256 

int main(int argc, char *argv[]);         
void fill_palette(void);         
void cycle_colors(void);
void choose_values(void);
void make_stereo(void); 

void draw_bouncy_box1(void); 
void draw_bouncy_box2(void);
void draw_lines(void);
void draw_centered_box(void);
void draw_Xs(void);
void draw_twirlers(void);
void draw_double_Xs(void);
void draw_4pt_star(void);
void draw_6pth_star(void);
void draw_6ptv_star(void);
void draw_double_box(void);
void draw_8pt_star(void);
void draw_slant6_star(void);
void draw_5pt_star(void);
void draw_pinwheel(void);
void draw_box_Xs(void);
void draw_criss_cross(void);
void draw_4Xs(void);
void draw_aline(void);
void draw_asym1(void);
void draw_asym2(void);
void draw_asym3(void);
void draw_asym4(void);
void draw_asym5(void);
void draw_asym6(void);
void draw_asym7(void);
void draw_asym8(void);
void draw_asym9(void);
void draw_asym10(void);
void draw_asym11(void);
void draw_asym12(void);
void draw_sym1(void);
void draw_sym2(void);
void draw_sym3(void);
void draw_sym4(void);
void draw_sym5(void);
void draw_sym6(void);
void draw_sym7(void);

int whichmax=38; /* increase by one if you add your own drawing function. */
int whichtest=0; /* Should equal case statement calling your drawing     *.
                 /* function for testing or otherwise equal 0 */

/* xs1-ys5 are cordinates for the vga_drawline() statements */
int xs1, xs2, xs3, xs4, xs5, xs6, xs7, xs8, xs9;
int ys1, ys2, ys3, ys4, ys5, ys6, ys7, ys8, ys9;
int acr=NUM_C_REGISTERS -1, c;
int rcp[NUM_C_REGISTERS];
int gcp[NUM_C_REGISTERS];
int bcp[NUM_C_REGISTERS];
int width, height;
int xoffset[15], yoffset[10];
int maxboxsize=3, x1=10, x2, x3=10, x4=10, y1=10, y2, y3=10, y4=10;
int n3=0, nmax=1500, boxwidth, boxheight;
int xflag=1, xflag1=1, xflag2=1, yflag=1, yflag1=1, yflag2=1; 
int whichline, cflag;
int xfseed=1, yfseed=1, xf1seed=2, yf1seed=2, xf2seed=1, yf2seed=1;
int cmax, cdiv=2, howmanyx, howmanyy;  
float aspect;

int main(int argc, char *argv[])         
{
   int n, n1, n2;

   vga_init();
   xoffset[0]=0;
   yoffset[0]=0;
   n3=nmax;
   srand(time(0));               /* get a rand seed from time */
   width=639;                    /* high res is the default mode */
   height=479;
   vga_setmode(G640x480x256);

   while((argc>1)&&(argv[1][0]=='-')) {
     switch(argv[1][1]) {
       case 'l':   
         width=319; /* low res if you only have a vga card or slow 386 */
         height=199;
         vga_setmode(G320x200x256);
         break;
       case 'h':
         width=799;  /* Don't know if this works!  My S3 cards don't */
         height=599; /* work at 800x600 with svgalib */
         vga_setmode(G800x600x256);
         break;
       case 'n':
         whichtest=atoi(&argv[1][2]);
         if((whichtest>whichmax) ||  (whichtest<1)) whichtest=0;
         break;
       default:
         break;
     }
     argv++;
     argc--;
   }

   if (acr<100) cdiv=1; /* cdiv limits the depth of the image */
   if (acr>200) cdiv=3; 
   aspect=((float)height/width);

   fill_palette();

   while (!(vga_getkey())) {

      if (n3>=nmax) choose_values(); /* do a new pattern */
      ++n3;
      make_stereo(); /* comment out if you want to see non-stereo image */

      if (x1 <= *xoffset) {
         xflag=xfseed; /* check if x cord is out of bounds */
         x1=*xoffset;
      }
      if (x2 >= *(xoffset+1)) {
         xflag=-xfseed;
         x1=*(xoffset+1)-boxwidth;
      }
      if (x3 <= *xoffset)  xflag1=xf1seed; 
      if (x3 >= *(xoffset+1))  xflag1=-xf1seed;  
      if (x4 <= *xoffset)  xflag2=xf2seed;
      if (x4 >= *(xoffset+1))  xflag2=-xf2seed;
      x1+=xflag;                     /* update x cords */
      x3+=xflag1;
      x4+=xflag2;
      x2=x1+boxwidth;
      if (y1 <= *yoffset) {
         yflag=yfseed; /* check if y cord is out of bounds */
         y1=*yoffset;
      }
      if (y2 >= *(yoffset+1)) {
         yflag=-yfseed;
         y1=*(yoffset+1)-boxheight;
      }
      if (y3 <= *yoffset)  yflag1=yf1seed; 
      if (y3 >= *(yoffset+1))  yflag1=-yf1seed;
      if (y4 <= *yoffset)  yflag2=yf2seed;
      if (y4 >= *(yoffset+1))  yflag2=-yf2seed;
      y1+=yflag;                     /* update y cords */
      y3+=yflag1;
      y4+=yflag2;
      y2=y1+boxheight;   
      c+=cflag;                      /* choose color to draw with */
      if ((c == 1) || (c == cmax))  cflag=-cflag; /* go up and down */
      vga_setcolor(c);
      for (n1=0; n1<howmanyy; n1++) {
         for (n=0; n<howmanyx; n++) {
            xs1=x1+*(xoffset+n);  /* determine each cell's drawing cords */
            xs2=xs1+boxwidth;
            xs4=*(xoffset+n+1)-x1;
            xs3=xs4-boxwidth;
            xs5=(xs1+xs4)/2;
            xs6=x3+*(xoffset+n);
            xs7=x4+*(xoffset+n);
            xs8=*(xoffset+n+1)-x3;
            xs9=*(xoffset+n+1)-x4;
            ys1=y1+*(yoffset+n1);
            ys2=ys1+boxheight;
            ys4=*(yoffset+n1+1)-y1;
            ys3=ys4-boxheight;
            ys5=(ys1+ys4)/2;
            ys6=y3+*(yoffset+n1);
            ys7=y4+*(yoffset+n1);
            ys8=*(yoffset+n1+1)-y3;
            ys9=*(yoffset+n1+1)-y4;
            switch (whichline) {
               case 1:
                  draw_bouncy_box1();
                  break;
               case 2:
                  draw_bouncy_box2();
                  break;
               case 3:
                  draw_lines();
                  break;
               case 4:
                  draw_centered_box();
                  break;
               case 5:
                  draw_Xs();
                  break;
               case 6:
                  draw_twirlers();
                  break;
               case 7:
                  draw_double_Xs();
                  break;
               case 8:
                  draw_4pt_star();
                  break;
               case 9:
                  draw_6pth_star();
                  break;
               case 10:
                  draw_6ptv_star();
                  break;
               case 11:
                  draw_double_box();
                  break;
               case 12:
                   draw_8pt_star();
                   break;
               case 13:
                  draw_slant6_star();
                  break; 
               case 14:
                  draw_5pt_star(); 
                  break;
               case 15:
                  draw_pinwheel();
                  break;
               case 16:
                 draw_box_Xs(); 
                 break;
               case 17:
                 draw_criss_cross();
                 break;
               case 18:
                 draw_4Xs();
                 break;
               case 19:
                 draw_aline();
                 break;
               case 20:
                 draw_asym1();
                 break;
               case 21:
                 draw_asym2();
                 break;
               case 22:
                 draw_asym3();
                 break;
               case 23:
                 draw_asym4();
                 break;
               case 24:
                 draw_asym5();
                 break;
               case 25:
                 draw_asym6();
                 break;
               case 26:
                 draw_asym7();
                 break; 
               case 27:
                 draw_asym8();
                 break;
               case 28:
                 draw_asym9();
                 break;
               case 29:
                 draw_asym10();
                 break;
               case 30:
                 draw_asym11();
                 break;
               case 31:
                 draw_asym12();
                 break;
               case 32:
                 draw_sym1();
                 break;
               case 33:
                 draw_sym2();
                 break;
               case 34:
                 draw_sym3();
                 break;
               case 35:
                 draw_sym4();
                 break;
               case 36:
                 draw_sym5();
                 break;
               case 37:
                 draw_sym6();
                 break;
               case 38:
                 draw_sym7();
                 break;
               default:
            }
         }
      }
      cycle_colors();
   }
   vga_setmode (TEXT);           /* restore old screen */
   exit(EXIT_SUCCESS);
}


/**************** function to do color spreads, rands, etc *****************/
 
void fill_palette(void)
{
   int n, n1, r, g, b, cs, csmod, cstep, ctemp;
   int juggle, maxcv=63, which[3];  
   static int csf=1, cflag[3]={1,1,1};

   r=(rand() % (maxcv/2)); /* set the background color values to random */
   g=(rand() % (maxcv/2)); 
   b=(rand() % (maxcv/2));
   for(n=0; n<=acr; n++) {
      rcp[n]=r;
      gcp[n]=g;
      bcp[n]=b;
   }
   /* set up which[] and check for "blank" screen (all which[] hit default) 
      in following switch statement */
   do {
      for(n=0; n<=2; n++) which[n]=(rand() % 10)+1;
   } 
   while((which[0]>=9)&&(which[1]>=9)&&(which[2]>=9)); 
   for(n=0; n<=2; n++) {
      cstep=(rand() % 3)+1;           /* value to ++ spreads by */
      juggle=(rand() % acr);          /* reseed the values if n1==juggle */
      cs=(rand() % maxcv);            /* color value for candy stripe */
      csmod=(rand() % 15)+1;          /* vary the width of candy stripes */
      
      for(n1=1; n1<=acr; n1++) {
         if ((n1==juggle)&&((rand() % 2)==1)) {
            cstep=(rand() % 6)+1;
            which[n]=(rand() % 10)+1;
         }
         switch(which[n]) {
            case 1:                  /* fall through */
            case 2:
            case 3:
            case 4:  /* I'm gonna clean this up.. real soon now! */
            case 5:
            case 6: 
               if(n==0) ctemp=rcp[n1-1]; /* do a spread of colors */
               if(n==1) ctemp=gcp[n1-1];
               if(n==2) ctemp=bcp[n1-1]; 
               if((ctemp+(cflag[n]*cstep)>=maxcv)||(ctemp+(cflag[n]*cstep)<=0)) 
                  cflag[n]=-cflag[n];
               if(n==0) rcp[n1]=ctemp+(cflag[n]*cstep);
               if(n==1) gcp[n1]=ctemp+(cflag[n]*cstep);
               if(n==2) bcp[n1]=ctemp+(cflag[n]*cstep); 
               break;
            case 7:   /* Random colors */
               if(n==0) rcp[n1]=(rand() % (maxcv+1));
               if(n==1) gcp[n1]=(rand() % (maxcv+1));
               if(n==2) bcp[n1]=(rand() % (maxcv+1));
               break;
            case 8:
               if (csf==1) {  /* do candy stripes */
                  if(n==0) rcp[n1]=cs;
                  if(n==1) gcp[n1]=cs;
                  if(n==2) bcp[n1]=cs;
               } else {
                  if(n==0) rcp[n1]=0;
                  if(n==1) gcp[n1]=0;
                  if(n==2) bcp[n1]=0;
               }
               if((n1 % csmod)==0) csf=-csf; 
               break;
            default:
               break;   /* do nothing; keep background r, g or b color values */
         }  
      }   
   }
   for(n=0; n<=acr; n++) {
      vga_setpalette(n,rcp[n],gcp[n],bcp[n]);
   }
}  

/******************** function to cycle the colors ******************/

void cycle_colors(void)
{
   int n, n1;
   int rtemp, gtemp, btemp;

   rtemp=*(rcp+1);
   gtemp=*(gcp+1);
   btemp=*(bcp+1);

   for (n=1; n<acr; n++) {
      n1=n+1;
      *(rcp+n)=*(rcp+n1);
      *(gcp+n)=*(gcp+n1);
      *(bcp+n)=*(bcp+n1);
      vga_setpalette(n,*(rcp+n),*(gcp+n),*(bcp+n));
   }
   *(rcp+acr)=rtemp;
   *(gcp+acr)=gtemp;
   *(bcp+acr)=btemp;
   vga_setpalette(acr,*(rcp+acr),*(gcp+acr),*(bcp+acr));
}

/***************** Choose a bunch of values to draw with ***************/
 
void choose_values(void) {
   int n;
   howmanyx=(rand() % 8)+4; /* number of horiz cells on screen */
   howmanyy=(rand() % 7)+1; /* number of vert cells on screen */
   xoffset[0]=0;       /* x-yoffset[] holds cell corner cords */
   yoffset[0]=0;

   /* fill x-yoffset[] with cords */
   for (n=1; n<=howmanyx; n++) xoffset[n]=(width/howmanyx)*n;
   for (n=1; n<=howmanyy; n++) yoffset[n]=(height/howmanyy)*n;
   boxwidth=(rand() % xoffset[1])/maxboxsize+1;
   boxheight=(rand() % yoffset[1])/maxboxsize+1;

   x1=(rand() % (xoffset[1]-boxwidth)); 
   y1=(rand() % (yoffset[1]-boxheight)); 
   x3=(rand() % xoffset[1]);
   x4=(rand() % xoffset[1]);
   y3=(rand() % yoffset[1]);
   y4=(rand() % yoffset[1]);
   vga_clear();
   cmax=(rand() % (acr/2))+(acr/3); 
   c=1;
   cflag=1;  
   n3=0; 
   if ( whichtest==0) whichline=(rand() % whichmax)+1; 
   else whichline=whichtest; 
   if ((rand() % 5) == 0) xfseed=2; else xfseed=1;
   if ((rand() % 5) == 0) yfseed=2; else yfseed=1;
   if ((rand() % 8) == 0) xf1seed=2; else xf1seed=1;
   if ((rand() % 8) == 0) yf1seed=2; else yf1seed=1;
   if ((rand() % 8) == 0) xf2seed=2; else xf2seed=1;
   if ((rand() % 8) == 0) yf2seed=2; else yf2seed=1;
   fill_palette();            
}

/************************* StereoGram function ****************************/

void make_stereo(void) {
   int n, wh, hh, w, h;
   wh=width - c/cdiv;   /* The secret of the sauce.....I'm not going to tell! */
   hh=height-((int)((c/cdiv) * aspect)+.5);
   for(n=0; n<=howmanyx; n++) *(xoffset+n)=(wh/howmanyx)*n;
   for(n=0; n<=howmanyy; n++) *(yoffset+n)=(hh/howmanyy)*n;
   w=(width-*(xoffset+howmanyx))/2;  /* hint: center the cells */
   h=(height-*(yoffset+howmanyy))/2; 
   for(n=0; n<=howmanyx; n++) *(xoffset+n)+=w;
   for(n=0; n<=howmanyy; n++) *(yoffset+n)+=h;
}

/*****************  Pattern drawing functions follow *****************/
/*                                                                   */
/* Roll-your-own layout:        xs1 xs2 xs5 xs3 xs4                  */
/*                          ys1  *   *   *   *   *                   */
/*      Just                ys2  *   *   *   *   *                   */
/* Connect the dots!        ys5  *   *   *   *   *                   */
/*                          ys3  *   *   *   *   *                   */
/*                          ys4  *   *   *   *   *                   */
/*                                                                   */
/* The above cords are related and move "together" and are built     */
/* from x1, x2, y1 and y2.                                           */
/* The cords are symeterical, xs5 is always the center of the cell,  */
/* xs4 is the "complement" of xs1 and xs3 is the "complement" of xs2 */
/*                                                                   */
/*                           xs1 xs6 xs7 xs9 xs8 xs4                 */
/*                       ys4  *   *   *   *   *   *                  */
/*                       ys8  *   *   *   *   *   *                  */
/*                       ys9  *   *   *   *   *   *                  */
/*                       ys7  *   *   *   *   *   *                  */
/*                       ys6  *   *   *   *   *   *                  */
/*                       ys1  *   *   *   *   *   *                  */
/*                                                                   */
/* These cords are also symetrical in that xs9 is the complement of  */
/* xs7 but xs1, xs6, xs7 all move "independently" of each other.     */
/* They are built from x1, x3, x4, y1, y3 and y4.                    */
/* You can use them with the first set of cords.                     */
/*                                                                   */  
/* To add your own drawing function:  First add the function name to */
/* the proto-type list at the top of this file, then increase        */
/* whichmax by one.  Go to the big switch statement in main and add  */
/* a case statement calling your function.  Go to the bottom of the  */
/* file and add your drawing function using the above cords as your  */
/* guide. Make whichtest equal your calling case statment to test.   */
/* Otherwise whichtest should equal 0.                               */
/*                                                                   */
/*********************************************************************/
     
void draw_bouncy_box1(void) {
   vga_drawline(xs1,ys1,xs1,ys2); /* (1) draw boxes */
   vga_drawline(xs1,ys2,xs2,ys2);
   vga_drawline(xs2,ys2,xs2,ys1);
   vga_drawline(xs2,ys1,xs1,ys1);

   vga_drawline(xs1,ys3,xs1,ys4);
   vga_drawline(xs1,ys4,xs2,ys4);
   vga_drawline(xs2,ys4,xs2,ys3);
   vga_drawline(xs2,ys3,xs1,ys3);

   vga_drawline(xs3,ys1,xs3,ys2);
   vga_drawline(xs3,ys2,xs4,ys2);
   vga_drawline(xs4,ys2,xs4,ys1);
   vga_drawline(xs4,ys1,xs3,ys1);

   vga_drawline(xs3,ys3,xs3,ys4);
   vga_drawline(xs3,ys4,xs4,ys4);
   vga_drawline(xs4,ys4,xs4,ys3);
   vga_drawline(xs4,ys3,xs3,ys3);
}

void draw_bouncy_box2(void) {
   vga_drawline(xs1,ys1,xs1,ys2); /* (2) draw 2 color boxes */
   vga_drawline(xs1,ys2,xs2,ys2);
   vga_drawline(xs2,ys2,xs2,ys1);
   vga_drawline(xs2,ys1,xs1,ys1);

   vga_setcolor(acr-c);
   vga_drawline(xs1,ys3,xs1,ys4);
   vga_drawline(xs1,ys4,xs2,ys4);
   vga_drawline(xs2,ys4,xs2,ys3);
   vga_drawline(xs2,ys3,xs1,ys3);

   vga_drawline(xs3,ys1,xs3,ys2);
   vga_drawline(xs3,ys2,xs4,ys2);
   vga_drawline(xs4,ys2,xs4,ys1);
   vga_drawline(xs4,ys1,xs3,ys1);

   vga_setcolor(c);
   vga_drawline(xs3,ys3,xs3,ys4);
   vga_drawline(xs3,ys4,xs4,ys4);
   vga_drawline(xs4,ys4,xs4,ys3);
   vga_drawline(xs4,ys3,xs3,ys3);
}

void draw_lines(void) {
   vga_drawline(xs1,ys1,xs2,ys2); /* (3) lines */
   vga_drawline(xs1,ys4,xs2,ys3);
   vga_drawline(xs4,ys1,xs3,ys2);
   vga_drawline(xs4,ys4,xs3,ys3);
}

void draw_centered_box(void) {
   vga_setcolor(acr-c);    
   vga_drawline(xs7,ys8,xs7,ys6); /* (4) centered boxes */
   vga_drawline(xs9,ys8,xs9,ys6);
   vga_setcolor(c);
   vga_drawline(xs6,ys9,xs8,ys9);
   vga_drawline(xs6,ys7,xs8,ys7);
}

void draw_Xs(void) {
   vga_drawline(xs6,ys8,xs8,ys6); /* (5) X's */
   vga_drawline(xs8,ys8,xs6,ys6);
}

void draw_twirlers(void) {
   vga_drawline(xs1,ys2,xs3,ys4); /* (6) twirlers */
   vga_drawline(xs3,ys4,xs4,ys3);
   vga_drawline(xs4,ys3,xs2,ys1);
   vga_drawline(xs2,ys1,xs1,ys2);
}

void draw_double_Xs(void) {
   vga_drawline(xs1,ys2,xs3,ys4); /* (7) double X's */
   vga_drawline(xs3,ys4,xs4,ys3);
   vga_drawline(xs4,ys3,xs2,ys1);
   vga_drawline(xs2,ys1,xs1,ys2);

   vga_drawline(xs2,ys4,xs4,ys2);
   vga_drawline(xs4,ys2,xs3,ys1);
   vga_drawline(xs3,ys1,xs1,ys3);
   vga_drawline(xs1,ys3,xs2,ys4);
}

void draw_4pt_star(void) { 
   vga_drawline(xs1,ys1,xs5,ys2); /* (8) 4 point stars */
   vga_drawline(xs5,ys2,xs4,ys1);
   vga_drawline(xs4,ys1,xs3,ys5);
   vga_drawline(xs3,ys5,xs4,ys4);
   vga_drawline(xs4,ys4,xs5,ys3);
   vga_drawline(xs5,ys3,xs1,ys4);
   vga_drawline(xs1,ys4,xs2,ys5);
   vga_drawline(xs2,ys5,xs1,ys1);
}

void draw_6pth_star(void) {
   vga_drawline(xs1,ys2,xs4,ys2); /* (9) 6 point stars horz */
   vga_drawline(xs4,ys2,xs5,ys4);
   vga_drawline(xs5,ys4,xs1,ys2);
   vga_drawline(xs4,ys3,xs1,ys3);
   vga_drawline(xs1,ys3,xs5,ys1);
   vga_drawline(xs5,ys1,xs4,ys3);
}

void draw_6ptv_star(void) {
   vga_drawline(xs1,ys5,xs3,ys4); /* (10) 6 point stars vert */
   vga_drawline(xs3,ys4,xs3,ys1);
   vga_drawline(xs3,ys1,xs1,ys5);
   vga_drawline(xs2,ys4,xs4,ys5);
   vga_drawline(xs4,ys5,xs2,ys1);
   vga_drawline(xs2,ys1,xs2,ys4);
}

void draw_double_box(void) {
   vga_drawline(xs7,ys8,xs9,ys8); /* (11) doubled centered boxes */
   vga_drawline(xs9,ys8,xs9,ys6);
   vga_drawline(xs9,ys6,xs7,ys6);
   vga_drawline(xs7,ys6,xs7,ys8);

   vga_setcolor(acr-c);
   vga_drawline(xs6,ys9,xs8,ys9);
   vga_drawline(xs8,ys9,xs8,ys7);
   vga_drawline(xs8,ys7,xs6,ys7);
   vga_drawline(xs6,ys7,xs6,ys9); 
   vga_setcolor(c);
}

void draw_8pt_star(void) {
   vga_drawline(xs1,ys4,xs4,ys5); /* (12) 8 point star */
   vga_drawline(xs4,ys5,xs1,ys1);
   vga_drawline(xs1,ys1,xs5,ys4);
   vga_drawline(xs5,ys4,xs4,ys1);
   vga_drawline(xs4,ys1,xs1,ys5);
   vga_drawline(xs1,ys5,xs4,ys4);
   vga_drawline(xs4,ys4,xs5,ys1);
   vga_drawline(xs5,ys1,xs1,ys4);
}

void draw_slant6_star(void) {
   vga_drawline(xs1,ys4,xs4,ys5); /* (13) another 6 pointed star */
   vga_drawline(xs4,ys5,xs5,ys1);
   vga_drawline(xs5,ys1,xs1,ys4);
   vga_drawline(xs1,ys5,xs5,ys4);
   vga_drawline(xs5,ys4,xs4,ys1);
   vga_drawline(xs4,ys1,xs1,ys5);
}

void draw_5pt_star(void) {
   vga_drawline(xs1,ys1,xs5,ys2); /* (14) 5 pointed star */
   vga_drawline(xs5,ys2,xs4,ys1); /* snow angels ? */
   vga_drawline(xs4,ys1,xs1,ys4);
   vga_drawline(xs1,ys4,xs5,ys1);
   vga_drawline(xs5,ys1,xs4,ys4);
   vga_drawline(xs4,ys4,xs1,ys1);
}

void draw_pinwheel(void) {
   vga_drawline(xs1,ys1,xs2,ys1); /* (15) pin wheel */
   vga_drawline(xs2,ys1,xs3,ys4);
   vga_drawline(xs3,ys4,xs4,ys4);
   vga_drawline(xs4,ys4,xs4,ys3);
   vga_drawline(xs4,ys3,xs1,ys2);
   vga_drawline(xs1,ys2,xs1,ys1);

   vga_setcolor(acr-c);
   vga_drawline(xs3,ys1,xs4,ys1);
   vga_drawline(xs4,ys1,xs4,ys2);
   vga_drawline(xs4,ys2,xs1,ys3);
   vga_drawline(xs1,ys3,xs1,ys4);
   vga_drawline(xs1,ys4,xs2,ys4);
   vga_drawline(xs2,ys4,xs3,ys1);
   vga_setcolor(c);
}

void draw_box_Xs(void) {
   vga_drawline(xs6,ys8,xs8,ys6); /* (16) centered boxes with X's */
   vga_drawline(xs6,ys6,xs8,ys8);

   vga_setcolor(acr-c);
   vga_drawline(xs1,ys4,xs4,ys4);
   vga_drawline(xs4,ys4,xs4,ys1);
   vga_drawline(xs4,ys1,xs1,ys1);
   vga_drawline(xs1,ys1,xs1,ys4);
   vga_setcolor(c);
}

void draw_criss_cross(void) {
   vga_drawline(xs1,ys1,xs2,ys2); /* (17) crossed lines */
   vga_drawline(xs1,ys4,xs2,ys3);
   vga_drawline(xs4,ys1,xs3,ys2);
   vga_drawline(xs4,ys4,xs3,ys3);

   vga_setcolor(acr-c);
   vga_drawline(xs1,ys2,xs2,ys1); 
   vga_drawline(xs3,ys1,xs4,ys2);
   vga_drawline(xs1,ys3,xs2,ys4);
   vga_drawline(xs3,ys4,xs4,ys3);
   vga_setcolor(c);
}

void draw_4Xs(void) {
   vga_drawline(xs2,ys1,xs3,ys4); /* (18) */
   vga_drawline(xs1,ys3,xs4,ys2);
   vga_setcolor(acr-c);
   vga_drawline(xs1,ys2,xs4,ys3);
   vga_drawline(xs2,ys4,xs3,ys1);
   vga_setcolor(c);
}

void draw_aline(void) {
   vga_drawpixel(xs1,ys1); /* (19) */
   vga_drawpixel(xs2,ys2);
   vga_drawpixel(xs1,ys2);
   vga_drawpixel(xs2,ys1);

   vga_setcolor(acr-c);
   vga_drawpixel(xs1,ys4);
   vga_drawpixel(xs2,ys3);
   vga_drawpixel(xs1,ys3);
   vga_drawpixel(xs2,ys4);

   vga_drawpixel(xs4,ys1);
   vga_drawpixel(xs3,ys2);
   vga_drawpixel(xs4,ys2);
   vga_drawpixel(xs3,ys1);

   vga_setcolor(c);
   vga_drawpixel(xs4,ys4);
   vga_drawpixel(xs3,ys3);
   vga_drawpixel(xs4,ys3);
   vga_drawpixel(xs3,ys4);
}

void draw_asym1(void) {  /* (20) bouncing x */
   vga_setcolor(acr-c);   
   vga_drawline(xs7,ys7,xs6,ys6);
   vga_setcolor(c);
   vga_drawline(xs7,ys6,xs6,ys7);
}  

void draw_asym2(void) {   /* (21) bouncing line */
   vga_drawline(xs7,ys7,xs6,ys6);
}

void draw_asym3(void) {  /* (22) bouncing box */
   vga_drawline(xs7,ys7,xs6,ys7);
   vga_drawline(xs7,ys6,xs6,ys6);
   vga_drawline(xs7,ys7,xs7,ys6);
   vga_drawline(xs6,ys7,xs6,ys6);
}

void draw_asym4(void) {  /* (23) two lines connected */
   vga_setcolor(acr-c);
   vga_drawline(xs1,ys1,xs6,ys6);
   vga_setcolor(c);
   vga_drawline(xs6,ys6,xs7,ys7);
}

void draw_asym5(void) {
   vga_setcolor(acr-c);           /* (24) */
   vga_drawline(xs1,ys1,xs6,ys6);
   vga_drawline(xs6,ys6,xs4,ys4);
   vga_setcolor(c);
   vga_drawline(xs1,ys4,xs6,ys6);
   vga_drawline(xs6,ys6,xs4,ys1);
}

void draw_asym6(void) {
   vga_setcolor(acr-c);          /* (25) */
   vga_drawline(xs1,ys1,xs1,ys4);
   vga_drawline(xs4,ys4,xs4,ys1);
   vga_setcolor(c);
   vga_drawline(xs1,ys1,xs5,ys6);
   vga_drawline(xs1,ys4,xs5,ys6);
   vga_drawline(xs4,ys4,xs5,ys6);
   vga_drawline(xs4,ys1,xs5,ys6);
}

void draw_asym7(void) {
   vga_setcolor(acr-c);           /* (26) */
   vga_drawline(xs1,ys1,xs2,ys4);
   vga_drawline(xs4,ys1,xs3,ys4);
   vga_setcolor(c);
   vga_drawline(xs2,ys4,xs5,ys6);
   vga_drawline(xs3,ys4,xs5,ys6);
}

void draw_asym8(void) {     /* (27) triangle */
  vga_drawline(xs1,ys1,xs6,ys6);
  vga_drawline(xs6,ys6,xs7,ys7);
  vga_drawline(xs7,ys7,xs1,ys1);
}

void draw_asym9(void) {
  vga_setcolor(acr-c);          /* (28) */
  vga_drawline(xs1,ys1,xs5,ys6);
  vga_drawline(xs5,ys6,xs4,ys1);
  vga_setcolor(c);
  vga_drawline(xs1,ys1,xs5,ys7);
  vga_drawline(xs5,ys7,xs4,ys1);
}

void draw_asym10(void) {  /* (29) 4 bouncing boxes */
  vga_setcolor(acr-c);
  vga_drawline(xs6,ys4,xs7,ys4);
  vga_drawline(xs7,ys4,xs7,ys8);
  vga_drawline(xs7,ys8,xs6,ys8);
  vga_drawline(xs6,ys8,xs6,ys4);

  vga_drawline(xs9,ys6,xs8,ys6);
  vga_drawline(xs8,ys6,xs8,ys1);
  vga_drawline(xs8,ys1,xs9,ys1);
  vga_drawline(xs9,ys1,xs9,ys6);

  vga_setcolor(c);
  vga_drawline(xs8,ys7,xs4,ys7);
  vga_drawline(xs4,ys7,xs4,ys6);
  vga_drawline(xs4,ys6,xs8,ys6);
  vga_drawline(xs8,ys6,xs8,ys7);

  vga_drawline(xs1,ys8,xs6,ys8);
  vga_drawline(xs6,ys8,xs6,ys9);
  vga_drawline(xs6,ys9,xs1,ys9);
  vga_drawline(xs1,ys9,xs1,ys8);
}

void draw_asym11(void) {  /* (30) 4 right angle triangles changed! symetrical */
  vga_setcolor(acr-c);
  vga_drawline(xs1,ys4,xs6,ys4);
  vga_drawline(xs6,ys4,xs1,ys8);
  vga_drawline(xs1,ys8,xs1,ys4);

  vga_drawline(xs8,ys1,xs4,ys6);
  vga_drawline(xs4,ys6,xs4,ys1);
  vga_drawline(xs4,ys1,xs8,ys1);

  vga_setcolor(c);
  vga_drawline(xs8,ys4,xs4,ys4);
  vga_drawline(xs4,ys4,xs4,ys8);
  vga_drawline(xs4,ys8,xs8,ys4);

  vga_drawline(xs1,ys1,xs6,ys1);
  vga_drawline(xs6,ys1,xs1,ys6);
  vga_drawline(xs1,ys6,xs1,ys1);
} 

void draw_asym12(void) {  /* (31) 4 sided closed figure */
  vga_drawline(xs1,ys1,xs6,ys6);
  vga_drawline(xs6,ys6,xs4,ys4);
  vga_drawline(xs4,ys4,xs7,ys7);
  vga_drawline(xs7,ys7,xs1,ys1);
}

void draw_sym1(void) {  /* (32) more symetrical patterns */
  vga_setcolor(acr-c); 
  vga_drawline(xs1,ys4,xs6,ys8);
  vga_drawline(xs8,ys6,xs4,ys1);
  vga_setcolor(c); 
  vga_drawline(xs1,ys1,xs6,ys6);
  vga_drawline(xs8,ys8,xs4,ys4);
}

void draw_sym2(void) {
  vga_setcolor(acr-c);     /* (33) */
  vga_drawline(xs1,ys4,xs6,ys8);
  vga_drawline(xs8,ys6,xs4,ys1);
  vga_drawline(xs1,ys1,xs6,ys6);
  vga_drawline(xs8,ys8,xs4,ys4);
  vga_setcolor(c);
  vga_drawline(xs1,ys4,xs7,ys9);
  vga_drawline(xs9,ys7,xs4,ys1);
  vga_drawline(xs1,ys1,xs7,ys7);
  vga_drawline(xs9,ys9,xs4,ys4);
}

void draw_sym3(void) {  /* (34) mo boxes */
  vga_setcolor(acr-c);
  vga_drawline(xs1,ys8,xs6,ys4);
  vga_drawline(xs8,ys4,xs4,ys8);
  vga_drawline(xs1,ys6,xs6,ys1);
  vga_drawline(xs8,ys1,xs4,ys6);

  vga_setcolor(c);
  vga_drawline(xs1,ys8,xs4,ys8);
  vga_drawline(xs8,ys4,xs8,ys1);
  vga_drawline(xs6,ys4,xs6,ys1);
  vga_drawline(xs1,ys6,xs4,ys6);

}

void draw_sym4(void) {
  vga_setcolor(acr-c);       /* (35) */
  vga_drawline(xs1,ys4,xs6,ys8);
  vga_drawline(xs8,ys8,xs4,ys4);
  vga_drawline(xs1,ys1,xs6,ys6);
  vga_drawline(xs8,ys6,xs4,ys1);
 
  vga_setcolor(c);
  vga_drawline(xs1,ys8,xs6,ys4);
  vga_drawline(xs8,ys4,xs4,ys8);
  vga_drawline(xs1,ys6,xs6,ys1);
  vga_drawline(xs8,ys1,xs4,ys6);
}

void draw_sym5(void) {
  vga_setcolor(acr-c);          /* (36) */
  vga_drawline(xs1,ys8,xs6,ys4);
  vga_drawline(xs6,ys4,xs4,ys6);
  vga_drawline(xs4,ys6,xs8,ys1);
  vga_drawline(xs8,ys1,xs1,ys8);

  vga_drawline(xs1,ys6,xs8,ys4);
  vga_drawline(xs8,ys4,xs4,ys8);
  vga_drawline(xs4,ys8,xs6,ys1);
  vga_drawline(xs6,ys1,xs1,ys6);

  vga_setcolor(c);
  vga_drawline(xs7,ys8,xs9,ys8);
  vga_drawline(xs9,ys8,xs9,ys6);
  vga_drawline(xs9,ys6,xs7,ys6);
  vga_drawline(xs7,ys6,xs7,ys8);

  vga_drawline(xs6,ys9,xs8,ys9);
  vga_drawline(xs8,ys9,xs8,ys7);
  vga_drawline(xs8,ys7,xs6,ys7);
  vga_drawline(xs6,ys7,xs6,ys9);
}

void draw_sym6(void) {  /* (37) zig-zag */
  vga_drawline(xs1,ys8,xs6,ys4);
  vga_drawline(xs6,ys4,xs7,ys8);
  vga_drawline(xs7,ys8,xs6,ys9);
  vga_setcolor(acr-c);
  vga_drawline(xs6,ys9,xs7,ys7);
  vga_drawline(xs7,ys7,xs9,ys9);
  vga_drawline(xs9,ys9,xs8,ys7);
  vga_setcolor(c);
  vga_drawline(xs8,ys7,xs9,ys6);
  vga_drawline(xs9,ys6,xs8,ys1);
  vga_drawline(xs8,ys1,xs4,ys6);
}

void draw_sym7(void) {
  vga_setcolor(acr-c);         /* (38) */
  vga_drawline(xs1,ys8,xs6,ys4);
  vga_drawline(xs6,ys4,xs7,ys9);
  vga_drawline(xs7,ys9,xs1,ys8);

  vga_drawline(xs9,ys7,xs4,ys6);
  vga_drawline(xs4,ys6,xs8,ys1);
  vga_drawline(xs8,ys1,xs9,ys7);

  vga_setcolor(c);
  vga_drawline(xs1,ys6,xs7,ys7);
  vga_drawline(xs7,ys7,xs6,ys1);
  vga_drawline(xs6,ys1,xs1,ys6);

  vga_drawline(xs9,ys9,xs8,ys4);
  vga_drawline(xs8,ys4,xs4,ys8);
  vga_drawline(xs4,ys8,xs9,ys9);
}
