/*Randim47.h: Includes and global variable definitions for randim.
  Link files need to be: -lXaw -lXmu -lXt -lXext -lX11 */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.  Please see the file "COPYING"
   for details.  If you have not received it along with this program,
   please write to the Free Software Foundation, Inc., 675 Mass. Ave.,
   Cambridge, MA 02139, USA. */

/* TODO: split out all these includes - xwin.h */
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>

#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Composite.h>
#include <X11/Shell.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>

#ifndef RAND_MAX
#define RAND_MAX 2147483647.0
/* = 1 << 31; max of a 4-byte integer - may be changed later on */
#endif

/*In plot function, we plot N points each call, in batches of PN*/
/* #define PN 200 */
/* #define N 1000 */
/* #define PN 1000 */
/* #define N 5000 */
#define PN 2000
#define N 10000

/* number of sample points to use for autoscaling and distance computation */
#define SCALE_MAX 100000
#define SLISTN 500

/* related to transformation generation */
#define TRANS_MAX 16
#define LTRANS_MAX 4
#define MOD_MAX 6
#define MOD_MAX2 12
#define NCOLORS 256
#define N_INTS 16
#define TRANSTYPES 7
#define TRANSREPN 8
#define N_ADDFNS 7

/* initial window size */
#define HSIZE  450.0
#define HSIZE2 225.0
#define VSIZE  450.0
#define VSIZE2 225.0

/* "progress bar" length */
#define MAXDOTS 10

/* lib directory for "randim.map" file, usually defined from makefile */
#ifndef LIBDIR
#define LIBDIR "/usr/local/lib/Randim"
#endif

/* general utility macros */
#define min(x,y) ((x) > (y) ? (y) : (x))
#define max(x,y) ((x) > (y) ? (x) : (y))
#define sqr(x) ((x) * (x))
#define posneg() ((dr() < 0.5) ? -1 : 1)
#define nrand(n) (floor((float) n * dr()))
unsigned long _idum;
/* #define qrand(n) ((_idum = 1664525L * _idum + 1013904223L) % (n)) */
#define qrand() (_idum = 1664525L * _idum + 1013904223L)
#define sqrand(n) _idum = (n)

/* specialty macros */
#define nparams(d) (d * d + d)
#define inrange(x,y) (((x)>=-hsize2)&&((x)<hsize2) && \
((y)>=-vsize2)&&((y)<vsize2))
#define rinrange(x,y) (((x)>-rhsize2)&&((x)<=rhsize2) && \
((y)>-rvsize2)&&((y)<=rvsize2))

/* hold info on an image buffer pixel */
typedef struct {
  short	avgColor;
  long	hitFreq;
} IfsPixel;

/* hold info on an animation modification set for a transformation */
typedef struct {
  float		m[MOD_MAX2][12];
  int		modn[MOD_MAX2];
  int		cur;
} ModSet;

/**********************************************************************/
/* function protos */

/*Initialization functions*/
void	init();
int	main(int argc, char **argv);

/*transformation-related*/
void	define(int trans_type),	scale(int n_pts), calc_prob_array(),
  	modify_trans(), init_mods(), construct_mod(float *m),
	add_a(), add_r(), addI(int t), edit_rep(),
  	edit_rep_aux(Widget w,XtPointer cdata,XEvent *rep,Boolean cont_disp),
	shuffle(int *list, int n);
void	apply_ftrans(int tr);
int	set_mod(int tr, float *m);
char	check_mod(int tr, float *m);
Boolean draw(XtPointer cdata), animate(XtPointer cdata),
	densityDraw(XtPointer cdata);
float	*apply_trans();
float	cm_dist(int tr, float *m, float x, float y, float z),
	cm_norm(int tr, float x, float y, float z);
double 	dr();

/* quasi-window functions */
void	next_im(), add_trans(), halt_draw(), resume_draw(),
	win_setup(), panel_setup(), edit_setup(), ss_setup(),
	init_colors(char *uFname), free_colors(), build_colorfile_list();

/* Window functions */

/*Functions activated through notification of events, main panel.*/
void	next_imt(Widget w, XtPointer cdata, XtPointer rdata),
	pause_toggle(Widget w, XtPointer cdata, XtPointer rdata),
	edit_trans(Widget w, XtPointer cdata, XtPointer rdata),
	zoom_point(Widget w, XtPointer cdata, XtPointer rdata),
	zoom_rect(Widget w, XtPointer cdata, XtPointer rdata),
	zmag_query(Widget w, XtPointer cdata, XtPointer rdata),
	colorToggle1(Widget w, XtPointer cdata, XtPointer rdata),
	colorToggle2(Widget w, XtPointer cdata, XtPointer rdata),
	togDensIntens(Widget w, XtPointer cdata, XtPointer rdata),
	diffEqToggle(Widget w, XtPointer cdata, XtPointer rdata),
	printEvals(Widget w, XtPointer cdata, XtPointer rdata),
	slideshow_toggle(Widget w, XtPointer cdata, XtPointer rdata),
	animation_toggle(Widget w, XtPointer cdata, XtPointer rdata),
  	rescale(Widget w, XtPointer cdata, XtPointer rdata),
  	shut_down(Widget w, XtPointer cdata, XtPointer rdata),
	save_dat(Widget w, XtPointer cdata, XtPointer rdata),
	load_dat(Widget w, XtPointer cdata, XtPointer rdata),
	change_cmap(Widget w, XtPointer cdata, XtPointer rdata);

/*Functions activated through notification of events, edit panel.*/
void	set_ttype(Widget w, int *switched, XtPointer rdata),
	set_dim(Widget w, int *switched, XtPointer rdata),
  	close_edit(Widget w, XtPointer cdata, XtPointer rdata);

/*Other functions activated through notification of events.*/
void	dpopset(Widget w, XtPointer cdata, XtPointer rdata),
	trep_bpress(Widget w, int *cdata, XEvent *rep, Boolean cont_disp);

/*Draw-related auxiliaries*/
void	plot_transreps(), plot_transrep(int trans),
	zoom_point_aux(Widget w,XtPointer cdata,XEvent *rep,Boolean cont_disp),
	zoom_rect_aux(Widget w,XtPointer cdata,XEvent *rep,Boolean cont_disp),
	zoom_calc(int tzx, int tzy, float xmag, float ymag);

/*General auxiliaries*/
void	message(char *s), dotmsg(char reset), memfail(char *item),
	panel_off(), panel_on(), transreps_off(), transreps_on(),
	resize(Widget w, XtPointer cdata, XEvent *rep, Boolean cont_disp),
	rep_resize(Widget w, XtPointer cdata, XEvent *rep, Boolean cont_disp),
	itoh(int byteval, char *rtn);
  
char	getnextline(FILE *fp, char *line);

/*dialog i/o smoothing*/
void	dialog_set_int(Widget w, int i), dialog_set_float(Widget w, float f);
int	dialog_get_int(Widget w);
float	dialog_get_float(Widget w);


/**********************************************************************/
/* global variables */
/* TODO: use EXTERN macro */

/* Related to generation of image transformations. */
extern float	a[TRANS_MAX][12], /*matrices to hold affine transformations*/
		bb2[N_ADDFNS][6], /* and building block modifications, 2d*/
		bb3[N_ADDFNS][12]; /* and 3d*/
extern ModSet	mod[TRANS_MAX];	/* modification sets */
extern char	prob[32768],	/*array for rapid access to probabilities*/
		dimension;	/*dimension of source metric space*/
extern int	n_trans,	/*number of transformations in image*/
		logtn,		/*log number of transformations in image*/
		hfactor,	/*number of rotational trans. in "hybrid"*/
		loghtn,		/*log number of rot. trans. in "hybrid"*/
		tmodn,		/*number of transformation to change*/
		atmodn,		/*transformation to alter in animation*/
		n_mods,		/* size of anim modset (per transformation) */
		ttype;		/*type of transformation set to generate*/
extern long	seed;		/*random seed*/
extern float	fern[4][6];	/*Barnesley fern parameters*/

/*Related to mechanics of drawing image.*/
extern short	hsize, vsize,	/*draw window size, in pixels*/
		hsize2,vsize2,	/*1/2 of draw window size, in pixels*/
		rhsize2, rvsize2; /*transrep window sizes, pixels*/
extern float   xscale,yscale,zscale,/*scale factors to convert to pixel space*/
		xoffset,yoffset,zoffset, /*offsets to convert to pixel space*/
		oxscale,oyscale,ozscale,   /*old values, used when zooming*/
		oxoffset,oyoffset,ozoffset; /*old values, used when zooming*/
extern long	scale_max;	/* number of test points to use for scaling*/
extern float	zxmag,zymag,	/*cumulative zoom information*/
		zmag,		/*local mag factor for zoom_point*/
		_cx,_cy,_cz,_sx,_sy,_sz, /*3d projection cosines and sines*/
		startx,starty,startz,	/*start values for plot*/
		gx,gy,gz,	/*current values*/
		vx,vy;		/*point values in 2-d visual*/
extern short	ploopn,		/*precalculated loop max used in draw()*/
		asize;		/* precalc size of array for color mode use*/
extern int	plottedpoints,	/*number of points plotted*/
		slidepoints,	/*number of points to plot in slideshow mode*/
  		animpoints,	/*number of points in one animation frame*/
  		denspoints,	/*number of points to draw densIntense image */
  		animpersist,	/*length to stick with one tmodn*/
  		modcount;	/*number of times tmodn modified*/
extern float	animstep;	/*size of perturbation at each step*/
extern XPoint	plotlist[PN],	/*storage for list of pts to plot*/
		cplotlist[NCOLORS][PN]; /* storage for color lists */
extern char	zoomf,		/*flag - are we zoomed or not?*/
		drawflag,	/*flag - is background draw process on?*/
		animflag,	/*flag - is background animate process on?*/
		bsstate,	/*flag - are we doing backing store?*/
		cmode,		/*flag - are we in colormode?*/
		diFlag,		/*flag - are we in density-intensity?*/
		diNew,		/*flag - new density-intensity image?*/
		diffEqFlag;	/*flag - are we in diffEq mode?*/
extern int	RANDSHIFT;	/*amount to shift rand() by for prob array*/

/* Window-related. */

/* Xlib stuff */
extern Display	*display;	/*needed as argument to window commands*/
extern int	screen_n;	/*argument for some window commands*/
extern GC	gc,		/*"graphics context" for drawing*/
		gcCopy,		/*context for copying*/
		gcClear,	/*context for clearing*/
		cgc[NCOLORS+1];	/* color contexts */
extern Window	canvas,		/*window for drawing*/
		trepWin[TRANSREPN];	/*windows for transrep*/
extern Pixmap	hcanvas;	/* area for hidden drawing */
extern XEvent	report;		/*info structure for mouse interaction*/
extern unsigned long white, black;	/*colors to be given by server*/
extern int	ncolors;	/* number of colors to allocate */
extern Colormap	cmap;		/*a ref ID for server interaction*/
extern unsigned long *colors; /*color indices*/
extern unsigned long plane_masks[1]; /* color aux */
extern Visual	*visual;	/* type of color access */
extern int	depth;		/* number of color bitplanes */
extern XColor	*cdefs;		/* rgb and other info */
extern char	gcflag,		/* whether got any colors */
		isPrivateCmap,	/* whether allocated a private colormap */
		isLargeCmap;	/* whether allocated a large colormap */

/* Xt stuff */
extern XtAppContext appcontext;	/*id for process given by Xt for reference*/
extern Arg	arg[10];	/*structure used to set widget resources*/
extern XtWorkProcId DrawID;	/*id for a background process we will run*/
extern Widget	pwidget,	/*parent widget given to father all others*/
		mframe,		/*top window to hold canvas and main panel*/
		cwidg,		/*widget holding canvas for drawing*/
		apanel,		/*widget holding transrep subwindows*/
		trepWidg[TRANSREPN],	/*widgets for transrep subwindows*/
		mpanel,		/*widget holding main control panel*/
		epopup,		/*popup shell to hold edit window*/
		eframe,		/*window to hold edit panel*/
		dpopup,	/*popup shell to hold slidepoints query*/
		mbutton[16],	/*main panel control buttons*/
		mmlabel[1],	/*more main panel info output areas*/
		tradbutton[TRANSTYPES],	/*edit radio buttons for ttype sel.*/
		dradbutton[2],	/*edit radio buttons for dimension choice*/
		e_in[6],	/*edit info input dialog areas*/
		ebutton,	/*for edit done button*/
		ssframe,	/*slideshow setup frame*/
		ss_in,		/*for slideshow dialog*/
		ssbutton;	/*slideshow button*/
extern int	trdat[TRANSTYPES], drdat[2], /*infrastr. for radio buttons*/
		repdat[TRANSREPN];	/*for passing info on tmodn*/
extern char	dpopstate;	/* which variable we set with dialog */

/* Other */
extern char	cmapName[80];	/* current color file name or path */
extern char	**colorFileNames;  /* list of color map files in .lib dir */
extern int	nColorFiles;    /* number of these files */
