/* randefs47.h: global variable definitions for randim */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.  Please see the file "COPYING"
   for details.  If you have not received it along with this program,
   please write to the Free Software Foundation, Inc., 675 Mass. Ave.,
   Cambridge, MA 02139, USA. */

/*Related to generation of image transformations.*/
float		a[TRANS_MAX][12]; /*matrices to hold affine transformations*/
ModSet		mod[TRANS_MAX];
char		prob[32768],	/*array for rapid access to probabilities*/
		dimension;	/*dimension of source metric space*/
int		n_trans,	/*number of transformations in image*/
		logtn,		/*log number of transformations in image*/
		hfactor,	/*number of rotational trans. in "hybrid"*/
		loghtn,		/*log number of rot. trans. in "hybrid"*/
		tmodn,		/*number of transformation to change*/
		atmodn,		/*transformation to alter in animation*/
		n_mods,		/* size of anim modset (per transformation) */
		ttype;		/*type of transformation set to generate*/
long		seed;		/*random seed*/

/* Barnesley fern parameters*/
float fern[4][6] = 	{ 0,0,0,0,0.16,0,
			  0.85,0.04,0,-0.04,0.85,40,
			  0.2,-0.26,0,0.23,0.22,40,
			  -0.15,0.28,0,0.26,0.24,10 };

/* building blocks for animated transformation modification */
/*
float	bb2[N_ADDFNS][6] = { 0.5,0,0,0,0.5,0,
    			      0,0.5,0,0.5,0,0,
    			      0.5,0,0,0,-0.5,0,
    			      0,0.5,0,-0.5,0,0,
		0.595,-0.0998,0,0.0998,0.595,0,
    			      0,0,0.5,0,0,0,
    			      0,0,0,0,0,0.5 };
			      */
float	bb2[N_ADDFNS][6] = { 1,0,0,0,0,0,
    			     0,1,0,0,0,0,
    			     0,0,1,0,0,0,
    			     0,0,0,1,0,0,
			     0,0,0,0,1,0,
    			     0,0,0,0,0,1,
    			     0,0,0,0,0,0 };

float	bb3[N_ADDFNS][12] =
	{ 0.5,0,0,0,0,-0.5,0,0,0,0,0.5,0,	/* main, neg middle */
    	  0,0,0.5,0,0,-0.5,0,0,0.5,0,0,0,	/* minor, neg middle */
    	  -0.5,0,0,0,0,0.5,0,0,0,0,-0.5,0,	/* main, pos middle */
    	  0,0,-0.5,0,0,0.5,0,0,-0.5,0,0,0,	/* minor, pos middle */
    	  0.595,-0.0998*0.595,0.0998*0.595,0.5,
	  0.595*0.595,0.595*0.0998,0.0998*0.0998,0.5,
	  0.595*0.0998,0.595,0.5,		/* rotation */
    	  0,0,0,0.5,0,0,0,-0.5,0,0,0,0.5,	/* translate, neg middle */
    	  0,0,0,-0.5,0,0,0,0.5,0,0,0,-0.5 };	/* translate, pos middle */


/*Related to mechanics of drawing image.*/
short		hsize, vsize,	/*draw window size, in pixels*/
		hsize2,vsize2,	/*1/2 of draw window size, in pixels*/
		rhsize2, rvsize2; /*transrep window sizes, pixels*/
float	       xscale,yscale,zscale,/*scale factors to convert to pixel space*/
		xoffset,yoffset,zoffset, /*offsets to convert to pixel space*/
		oxscale,oyscale,ozscale,   /*old values, used when zooming*/
		oxoffset,oyoffset,ozoffset; /*old values, used when zooming*/
long		scale_max;	/* number of test points to use for scaling*/
float		zxmag,zymag,	/*cumulative zoom information*/
		zmag,		/*local mag factor for zoom_point*/
		_cx,_cy,_cz,_sx,_sy,_sz, /*3d projection cosines and sines*/
		startx,starty,startz,	/*start values for plot*/
		gx,gy,gz,	/*current values*/
		vx,vy;		/*point values in 2-d visual*/
short		ploopn,		/*precalculated loop max used in draw()*/
		asize;		/*precalc size of array for color mode use*/
int		plottedpoints,	/*number of points plotted*/
		slidepoints,	/*number of points to plot in slideshow mode*/
		animpoints,	/*number of points for one animation frame*/
  		denspoints,	/*number of points to draw densIntense image */
  		animpersist,	/*length to stick with one tmodn*/
  		modcount;	/*number of times tmodn modified*/
float		animstep;	/*size of perturbation at each step*/
XPoint		plotlist[PN],	/*storage for list of pts to plot*/
		cplotlist[NCOLORS][PN]; /* storage for color lists */
char		zoomf,		/*flag - are we zoomed or not?*/
		drawflag,	/*flag - is background draw process on?*/
		animflag,	/*flag - is background animate process on?*/
		bsstate,	/*flag - are we doing backing store?*/
		cmode,		/*flag - are we in colormode?*/
		diFlag,		/*flag - are we in density-intensity?*/
		diNew,		/*flag - new density-intensity image?*/
		diffEqFlag;	/*flag - are we in diffEq mode?*/
int		RANDSHIFT;	/*amount to shift rand() by for prob array*/

/*Window-related globals.*/

/*Xlib stuff*/
Display		*display;	/*needed as argument to window commands*/
int		screen_n;	/*argument for some window commands*/
GC		gc,		/*"graphics context" for drawing*/
		gcCopy,		/*context for copying*/
		gcClear,	/*context for clearing*/
		cgc[NCOLORS+1];	/* color contexts */
Window		canvas,		/*window for drawing*/
		trepWin[TRANSREPN];	/*windows for transrep*/
Pixmap		hcanvas;	/* area for hidden drawing */
XEvent		report;		/*info structure for mouse interaction*/
unsigned long	white, black;	/*colors to be given by server*/
Colormap	cmap;		/*a ref ID for server interaction*/
unsigned long	plane_masks[1];	/* color aux */
Visual		*visual;	/* type of color access */
int		depth;		/* number of color bitplanes */
int		ncolors;	/* number of colors to allocate */
unsigned long	*colors;	/*color indices*/
XColor		*cdefs;		/* rgb and other info */
char		gcflag,		/* whether can use color */
		isPrivateCmap,	/* whether allocated a private colormap */
		isLargeCmap;	/* whether allocated a large colormap */

/*Xt stuff*/
XtAppContext	appcontext;	/*id for process given by Xt for reference*/
Arg		arg[10];	/*structure used to set widget resources*/
XtWorkProcId	DrawID;		/*id for a background process we will run*/
Widget		pwidget,	/*parent widget given to father all others*/
		mframe,		/*top window to hold canvas and main panel*/
		cwidg,		/*widget holding canvas for drawing*/
		apanel,		/*widget holding transrep subwindows*/
		trepWidg[TRANSREPN],	/*widgets for transrep subwindows*/
		mpanel,		/*widget holding main control panel*/
		epopup,		/*popup shell to hold edit window*/
		eframe,		/*window to hold edit panel*/
		dpopup,		/*popup shell to hold slidepoints query*/
		mbutton[16],	/*main panel control buttons*/
		mmlabel[1],	/*more main panel info output areas*/
		tradbutton[TRANSTYPES],	/*edit radio buttons for ttype sel.*/
		dradbutton[2],	/*edit radio buttons for dimension choice*/
		e_in[6],	/*edit info input dialog areas*/
		ebutton,	/*for edit done button*/
		ssframe,	/*slideshow setup frame*/
		ss_in,		/*for slideshow dialog*/
		ssbutton;	/*slideshow button*/
int 		trdat[TRANSTYPES], drdat[2], /*infrastr. for radio buttons*/
		repdat[TRANSREPN];	/*for passing info on tmodn*/
char		dpopstate;	/* which variable we set with dialog */


/* Other */
char	cmapName[80];	/* current color file name or path */
char	**colorFileNames;  /* list of color map files in .lib dir */
int	nColorFiles;    /* number of these files */
