/***************************************************************************
                          qdoublespinbox.cpp  -  description
                             -------------------
    begin                : Tue Dec 12 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qdoublespinbox.h"
#include <qlineedit.h>
#include <qvalidator.h>

QDoubleSpinBox::QDoubleSpinBox(QWidget * parent,const char * name)
               :QSpinBox(parent,name)
{
  QDoubleValidator* dv = new QDoubleValidator(this);
  dv->setDecimals(2);
  setValidator(dv);
}
QDoubleSpinBox::~QDoubleSpinBox()
{
}
/**  */
QString QDoubleSpinBox::mapValueToText(int value)
{
  QString qs;
  qs.sprintf("%.2f",double(value)/100.0);
  return qs;
}
/**  */
int QDoubleSpinBox::mapTextToValue(bool* ok)
{
  return int(text().toDouble()*100.0);
}
/**  */
void QDoubleSpinBox::selectAll()
{
  editor()->selectAll();
}
