#ifndef __ENG_COMMON_H__
#define __ENG_COMMON_H__

/*
 * QTPixmap GTK engine
 *
 * This is a hacked/modified version of the Pixmap GTK engine. Modified to use
 * ~/.qt/qtrc to get colour information to recolour widgets.
 *
 * Changes are (C) Craig Drummond 2002 - Craig.Drummond@lycos.co.uk
 *
 */

#include <stdlib.h>
enum fcolor
{
  COLOR_BACKGROUND,
  COLOR_BUTTON,
  COLOR_SELECTED,
  COLOR_WINDOW,

  COLOR_FOREGROUND,
  COLOR_MID,
  COLOR_TEXT,
  COLOR_TEXT_SELECTED,

  COLOR_KWIN_ABGND,
  COLOR_KWIN_ABLEND,
  COLOR_KWIN_AFGND,
  COLOR_KWIN_ATBTN,
  COLOR_KWIN_FRAME,
  COLOR_KWIN_IBGND,
  COLOR_KWIN_IBLEND,
  COLOR_KWIN_IFGND,
  COLOR_KWIN_IFRAME,
  COLOR_KWIN_ITBTN,

  COLOR_NONE,
  COLOR_NUMCOLORS=COLOR_NONE,  /* NONE does not count! */
  COLOR_APP
};

enum fstretch
{
    STRETCH_NONE,
    STRETCH_BOTH,
    STRETCH_HEIGHT,
    STRETCH_WIDTH
};

struct qtpixmap_rgb
{
    unsigned char r, g, b;
};

struct image_file
  {
      gchar               *name;
      enum fcolor         color;
      union
      {
          gint                mod;
          struct qtpixmap_rgb rgb;   /* *ONLY* if color==COLOR_APP */
      } c;
  };

struct image_size
{
    guint width,
          height;
};

struct qtp_rect
{
    guint x, y, w, h;
};

struct qtpixmap_data
{
    struct qtpixmap_rgb colors[COLOR_NUMCOLORS];
#ifndef GTK2_VER
    int                 button_x_offset,
                        button_y_offset,
                        tb_button_x_offset,
                        tb_button_y_offset;
    struct qtp_rect     radio_check_focus_mod;
    GtkStyleClass       *parent_class;
#endif
    struct qtp_rect     button_focus_mod,
                        combo_focus_mod;
    char                *font;
    gboolean            no_radio_check_highlight,
                        use_selected_for_menu_item,
                        use_selected_for_menu;
};

extern struct qtpixmap_data qtpixmap_engine_data;


#define QTP_COL_EQ(A, B) (abs(A-B)<3)

#define QTP_IS_ON_MENU(WIDGET) (WIDGET && WIDGET->parent && WIDGET->parent->parent && \
                                GTK_IS_MENU_ITEM(WIDGET->parent) && GTK_IS_MENU(WIDGET->parent->parent))
#define QTP_IS_ON_MENU_BAR(WIDGET) (WIDGET && WIDGET->parent && WIDGET->parent->parent && \
                                    GTK_IS_MENU_ITEM(WIDGET->parent) && GTK_IS_MENU_BAR(WIDGET->parent->parent))

#define QTP_SET_COLOR_BUTTON(det, style) \
    (det && (0==strcmp(det, "button")||0==strcmp(det, "togglebutton")||0==strcmp(det, "buttondefault")) && style && \
    !(QTP_COL_EQ(qtpixmap_engine_data.colors[COLOR_WINDOW].r, (style->bg[GTK_STATE_NORMAL].red>>8)) && \
      QTP_COL_EQ(qtpixmap_engine_data.colors[COLOR_WINDOW].g, (style->bg[GTK_STATE_NORMAL].green>>8)) && \
      QTP_COL_EQ(qtpixmap_engine_data.colors[COLOR_WINDOW].b, (style->bg[GTK_STATE_NORMAL].blue>>8))))

#define QTP_GDK_COLOR_EQUAL(A, B) \
    (A.red==B.red && A.green==B.green && A.blue==B.blue)

#endif
