/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GAMENAMESPACE_H
#define GAMENAMESPACE_H

#include <QtCore/QFlags>

namespace Game {
    enum ObjectFlag {
        Blocking = 0x01,
        CanPickUp = 0x02,
        Flipped = 0x04
    };
    typedef QFlags<ObjectFlag> ObjectFlags;

    enum WalkingDirection {
        NoDirection,
        Left,
        Right,
        Up,
        Down
    };

    enum AnimationType {
        NoAnimation             = 0x000,
        WalkingHorizontally     = 0x001,
        WalkingFromScreen       = 0x002, 
        WalkingToScreen         = 0x003,
        StandingStill           = 0x004,

        UserAnimation           = 0xf00
    };

    enum ActionType {
        NoAction                = 0x000,
        Use                     = 0x001,
        Look                    = 0x002,
        Take                    = 0x003,
        PickUp                  = 0x003,

        UserAction              = 0xf00
    };
};

#endif
