#ifndef SEQDRIVER_H
#define SEQDRIVER_H

#include <qobject.h>
#include <qptrlist.h>
#include <qsocketnotifier.h>
#include <alsa/asoundlib.h>
#include "midimap.h"
#include "main.h"
#include "mapwidget.h"

class SeqDriver : public QWidget  {
    
  Q_OBJECT

  private:
    int portCount;
    QPtrList<MidiMap> *midiMapList; 
    QSocketNotifier *seqNotifier;
    snd_seq_t *seq_handle;
    int clientid;
    int portid_out[MAX_PORTS];
    int portid_in;

  public:
    bool discardUnmatched;
    int portUnmatched;
        
  private:
    void initSeqNotifier();  

  public:
    SeqDriver(QPtrList<MidiMap> *p_midiMapList, QWidget* parent=0, const char *name=0);
    ~SeqDriver();
    void registerPorts(int num);
    int getPortCount();

  signals:
    void midiEvent(snd_seq_event_t *ev);

  public slots:
    void procEvents(int fd);  
    void setDiscardUnmatched(bool on);
    void setPortUnmatched(int id);
};
                              
#endif
