#ifndef GUI_H
#define GUI_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qptrlist.h>
#include <qmessagebox.h>
#include <qtabwidget.h>
#include "mapwidget.h"
#include "logwidget.h"
#include "mapdata.h"
#include "passwidget.h"

const QString aboutText = "QMidiRoute 0.2.1\nby Matthias Nagorni\n(c)2002-2004 SuSE AG Nuremberg\n\n"
                          "QMidiRoute is licensed under the GPL.\n";

class Gui : public QVBox
{
  Q_OBJECT

  private:
    QMessageBox *aboutWidget;
    QTabWidget *tabWidget;
    MapData *mapData;
    LogWidget *logWidget;
    PassWidget *passWidget;
    QPushButton *removeMapButton;
    
  public:
    Gui(int p_portCount, QWidget* parent=0, const char *name=0);
    ~Gui();
    
  public slots: 
    void displayAbout();
    void addMap();
    void cloneMap();
    void addMap(QString qs);
    void renameMap();
    void removeMap();
    void removeMap(int index);
    void save();
    void load();
    void load(QString name);
    void clear();
};
  
#endif
