/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessibleapplication.h"

#include <qapplication.h>
#include <qaccessible.h>
#include <qaccessiblebridge.h>

#include <qstringlist.h>

class QObject;

static AccessibleApplication *accApp = 0;

class QDBusAccessibleBridge: public QAccessibleBridge
{
public:
    void setRootObject(QAccessibleInterface *);
    void notifyAccessibilityUpdate(int, QAccessibleInterface*, int);
};

class QDBusAccessibleBridgePlugin: public QAccessibleBridgePlugin
{
    Q_OBJECT
public:
    QDBusAccessibleBridgePlugin(QObject *parent = 0);

    QAccessibleBridge* create(const QString &);
    QStringList keys() const;
};

QDBusAccessibleBridgePlugin::QDBusAccessibleBridgePlugin(QObject *parent)
: QAccessibleBridgePlugin(parent)
{
}

QAccessibleBridge* QDBusAccessibleBridgePlugin::create(const QString &name)
{
    if (name == "QDBUSBRIDGE")
        return new QDBusAccessibleBridge();
    return 0;
}

QStringList QDBusAccessibleBridgePlugin::keys() const
{
    QStringList l;
    l  << "QDBUSBRIDGE";
    return l;
}

Q_EXPORT_PLUGIN(QDBusAccessibleBridgePlugin)


static void cleanupAccessibility()
{
    delete accApp;
    accApp = 0;
}

void QDBusAccessibleBridge::setRootObject(QAccessibleInterface *iface)
{
    if (!iface)
        return;

    Q_ASSERT(!accApp);

    qDebug("initializing D-BUS accessible bridge");
    accApp = new AccessibleApplication();
    accApp->initAccessibility();
    accApp->exportAll();

    qAddPostRoutine(cleanupAccessibility);
}

void QDBusAccessibleBridge::notifyAccessibilityUpdate(int /*QAccessible::Event event*/,
        QAccessibleInterface * /*iface*/, int /*child*/)
{
}

#include "qdbusaccessiblebridge.moc"

