/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: transactionwindow.cpp 401 2007-01-15 22:13:48Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "transactionwindow.h"
#include "kbanking.h"

#include <aqbanking/jobgetbalance.h>
#ifdef WIN32
# define strcasecmp stricmp
#endif

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qlayout.h>

#include <gwenhywfar/debug.h>




TransactionWindow::TransactionWindow(Account *a,
                                     QWidget* parent,
                                     const char* name,
                                     WFlags fl)
:QWidget(parent, name, fl), _app(0), _account(a)
,_statusBar(0)
,_balance(0)
,_transactionView(0)
,_tname(0){
  QString bankName;
  QString accountName;
  QString balance;

  _app=dynamic_cast<KBanking*>(a->getApi());
  assert(_app);

  _app->addTransactionWindow(this);

  QBoxLayout *vBoxLayout = new QVBoxLayout(this, 5);
  vBoxLayout->setAlignment(Qt::AlignTop);
  _transactionView=new TransactionView(a, true, this, "TransactionView");
  _transactionView->setSizePolicy(QSizePolicy::Expanding,
                                  QSizePolicy::Expanding);
  vBoxLayout->addWidget(_transactionView);
  _statusBar=new QStatusBar(this);
  _statusBar->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
  vBoxLayout->addWidget(_statusBar);

  bankName=a->getBankName().c_str();
  if (bankName.isEmpty())
    bankName=a->getBankCode().c_str();
  _statusBar->addWidget(new QLabel(tr("Account"), this, 0), 0, true);
  _statusBar->addWidget(new QLabel(bankName, 0, "BankName"), 0, true);
  accountName=a->getAccountName().c_str();
  if (accountName.isEmpty())
    accountName=a->getAccountNumber().c_str();
  _statusBar->addWidget(new QLabel(accountName, this, "AccountName"), 0,
                        true);

  _balance=new QLabel(QString("----------"), this, "Balance");
  _statusBar->addWidget(_balance, 0, true);
}



TransactionWindow::TransactionWindow(KBanking *app,
                                     const std::list<RefPointer<Transaction> > &l,
                                     const char *tname,
                                     QWidget* parent,
                                     const char* name,
                                     WFlags fl)
:QWidget(parent, name, fl), _app(0), _account(0)
,_statusBar(0)
,_balance(0)
,_transactionView(0)
,_tname(tname){
  QString bankName;
  QString accountName;
  QString balance;

  _app=app;
  _app->addTransactionWindow(this);

  QBoxLayout *vBoxLayout = new QVBoxLayout(this, 5);
  vBoxLayout->setAlignment(Qt::AlignTop);
  _transactionView=new TransactionView(app,
                                       l,
                                       _tname,
                                       true,
                                       this,
                                       "TransactionView");
  _transactionView->setSizePolicy(QSizePolicy::Expanding,
                                  QSizePolicy::Expanding);
  vBoxLayout->addWidget(_transactionView);
  _statusBar=new QStatusBar(this);
  _statusBar->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
  vBoxLayout->addWidget(_statusBar);

}


TransactionWindow::~TransactionWindow(){
}



bool TransactionWindow::init(){
  const AB_ACCOUNT_STATUS *ast;
  GWEN_DB_NODE *db;
  std::string s;

  db=_app->getAppData();
  if (db) {
    db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                        "gui/windows/transactionwindow");
    if (db) {
      if (_account) {
	s=_account->getBankCode();
	if (!s.empty()) {
	  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
			      s.c_str());
	  if (db) {
	    s=_account->getAccountNumber();
	    if (!s.empty()) {
	      db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
				  s.c_str());
	    }
	  }
	}
      }
      else {
	if (_tname)
	  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
			      _tname);
	else
	  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
			      "generic");
      }
    }
  }
  if (db) {
    int w;
    int h;

    /* found settings */
    w=GWEN_DB_GetIntValue(db, "width", 0, 640);
    h=GWEN_DB_GetIntValue(db, "height", 0, 480);
    resize(w, h);
  } // db

  if (!_transactionView->init())
    return false;

  if (_account) {
    ast=_account->getAccountStatus();
    if (ast) {
      QString s;
      const AB_BALANCE *bal;

      bal=AB_AccountStatus_GetBookedBalance(ast);
      if (bal) {
        const AB_VALUE *v;

        v=AB_Balance_GetValue(bal);
        if (v) {
          const char *c;

          s=QString::number(AB_Value_GetValueAsDouble(v), 'f', 2);
          c=AB_Value_GetCurrency(v);
          if (!c)
            c="EUR";
          s+=" ";
          s+=QString::fromUtf8(c);
        }
      }
      _balance->setText(s);
    }
    else {
      _balance->setText(QString::null);
    }
  }

  return true;
}



bool TransactionWindow::fini(){
  GWEN_DB_NODE *db;
  std::string s;

  DBG_DEBUG(0, "TransactionWindow::fini()");

  if (!_transactionView->fini())
    return false;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db,
                      GWEN_DB_FLAGS_DEFAULT,
                      "gui/windows/transactionwindow");
  assert(db);
  if (_account) {
    s=_account->getBankCode();
    if (!s.empty()) {
      db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                          s.c_str());
      assert(db);
      s=_account->getAccountNumber();
      if (!s.empty()) {
        db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                            s.c_str());
      }
    }
  }
  else {
    if (_tname)
      db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                          _tname);
    else
      db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                          "generic");
  }
  assert(db);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "height", height());

  return true;
}



void TransactionWindow::slotUpdated() {
  if (_transactionView)
    _transactionView->slotUpdated();
}



void TransactionWindow::closeEvent(QCloseEvent *e){
  if (!fini()) {
    DBG_ERROR(0, "Could not deinit transaction window");
  }
  _app->delTransactionWindow(this);
  e->accept();
}






