/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.Callback;
import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import java.lang.reflect.Method;
import java.nio.Buffer;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = new NativeMappedConverter(cls).nativeType();
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Native.WCHAR_SIZE;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Pointer.class.isAssignableFrom(cls) || Callback.class.isAssignableFrom(cls) || Structure.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls || cls.isArray() || Buffer.class.isAssignableFrom(cls)) {
            return Pointer.SIZE;
        }
        throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
    }

    public String getFunctionName(NativeLibrary library, Method method) {
        String name = method.getName();
        int pop = 0;
        Class<?>[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            pop += this.getArgumentNativeStackSize(argTypes[i]);
        }
        String decorated = name + "@" + pop;
        try {
            name = library.getFunction(decorated, 1).getName();
        }
        catch (UnsatisfiedLinkError e) {
            // empty catch block
        }
        return name;
    }
}

