#include "job_importplaylist.h"

#include "gui.h"
#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"
#include "job_modifyplaylist_tracks.h"

#include <qstringlist.h>
#include <qregexp.h>
#include <qfile.h>
#include <qfileinfo.h>

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_ImportPlaylist::Job_ImportPlaylist(QString _fileName)
  : fileName(_fileName)
{}

void Job_ImportPlaylist::run()
{
  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

  QFile file( fileName );
  QFileInfo info( file );
  QString extension = info.extension( /*complete*/ false );

  if( file.open( IO_ReadOnly ) ) {
#ifdef EMBEDDED 
    mysql_thread_init(); 
#endif
    database->lock();
    int playlistId = database->getPlaylistIdByName(info.baseName());
    if( playlistId <= 0 ) {
        playlistId = database->appendPlaylist(info.baseName());
    }
    database->unlock();
    if(!database->getError()) {
        QTextStream stream( &file );
        int filesInPlaylist = 0;
        int filesAdded = 0;
        QStringList notExistingFiles;
        QStringList notSyncedFiles;
        QList<TRACK> *tracks = new QList<TRACK>();
        while ( !stream.atEnd() ) {
            QString line = stream.readLine(); // line of text excluding '\n'
            if(verbose) qWarning( line.local8Bit().data() );
        
            if( "m3u" == extension ) {
              if( line.startsWith("#") ) continue;
            } else if( "pls" == extension ) {
              if( !line.startsWith("File") ) continue;
              line.replace(QRegExp("File[0-9]+="), "");
            }
            
            ++filesInPlaylist;
            QFileInfo fileToImport(line);
            
            if( !fileToImport.exists() ) {
              if(verbose) qWarning( "doesn't exist" );
              notExistingFiles.append( line );
              continue;
            }
            
	    database->lock();
            QList<TRACK> *track = database->queryTracksByWhere(
                "path='" + adjustQString(fileToImport.dirPath(true)) +
                "' AND filename='" + adjustQString(fileToImport.fileName()) + "'");
            
            if(track->count() != 1) {
              if(verbose) qWarning( "not synchronized" );
              notSyncedFiles.append( line );
              continue;
            }
            
            tracks->append(track->first());
            ++filesAdded;
            if(verbose) qWarning( "added" );
        }
        file.close();
        jobman->addJob(new Job_ModifyPlaylist_Tracks(APPEND_PLAYLIST_TRACK, tracks, playlistId));
      
        app->lock();
        datadispatcher->eventNewPlaylistBasis(database->getPlaylistBasis());
        datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
        app->unlock();
        
        PlaylistImportEvent* e = new PlaylistImportEvent(QString(_("Imported %1 of %2 tracks.")).arg(filesAdded).arg(filesInPlaylist), notExistingFiles, notSyncedFiles);
        QApplication::postEvent( gui->getPlaylisting(), e );  // Qt will delete event  when done
    } else {
      qWarning("Database Error");
    }
#ifdef EMBEDDED 
    mysql_thread_end(); 
#endif
  } else {
    MessageEvent* e = new MessageEvent(QString(_("Could not open File:")) + "\n" + fileName);
    QApplication::postEvent( gui, e );  // Qt will delete event  when done
  }

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  
  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_ImportPlaylist::~Job_ImportPlaylist() {}
