/*
    AppController.m

    Implementation of the AppController class for the KeyArcher
    application.

    Copyright (C) 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "AppController.h"

#import <AppKit/NSDocumentController.h>
#import <AppKit/NSOpenPanel.h>

#import "Document.h"

@implementation AppController

- (void) open: sender
{
  NSOpenPanel * op = [NSOpenPanel openPanel];

  if ([op runModalForTypes: nil] == NSOKButton)
    {
      NSString * filename = [op filename];
      NSDocumentController * dc = [NSDocumentController
        sharedDocumentController];
      id doc;

      doc = [dc documentForFileName: filename];
      if (doc != nil)
        {
          [doc showWindows];
        }
      else
        {
          doc = [[[Document alloc]
            initWithContentsOfFile: filename ofType: @"plist"]
            autorelease];

          if (doc == nil)
            {
              return;
            }
          
          [dc addDocument: doc];
          [doc makeWindowControllers];
          [doc showWindows];
        }
    }
}

@end
