/*                               
Service_ForwardMail.cc
*/

#include "Service_ForwardMail.h"
#include "ClientForwardMail.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

class HTMLPages: public HTMLBasic
  {
  private:
    //
  public:
    void PrintForwardMailDisplayPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                      StringList *SLForw);
  };

//retrieve the url for the Service icon
const char *GetService_ForwardMail_ICO_URL (void)
  {
  return skin->getI(L_FORWARDMAIL);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_ForwardMail_ICO_ALT (void)
  {
  return L->get(L_FORWARDMAIL);
  }

//Retrieve the Service name
const char *GetService_ForwardMail_NAME (void)
  {
  return L->get(L_FORWARDMAIL);
  }

//Retrieve the Service Description
const char *GetService_ForwardMail_DESCRIPTION (void)
  {
  return L->get(L_FORWARDMAIL_DESCRIPTION);
  }

//Entry point to service init
bool DoService_ForwardMail_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  LOG ("Initializating Service ForwardMail for user=%s", pd->username);
  return true;
  }

//Entry point to service end
bool DoService_ForwardMail_END (TProgData *pd)
  {
  return true;
  }

//Entry point to execute a service command
bool DoService_ForwardMail_CMD (TProgData *pd)
  {
  HTMLPages *html;
  int cmd;
  StringList *SLForwardsMail;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;
  SLForwardsMail = new StringList;
    
  switch (pd->cmd)
    {
    case (CMD_FORWARDMAIL_DISPLAYPAGE):
      {
      pd->uo->InitStatusLine ();
      html->PrintForwardMailDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, SLForwardsMail);
      break;   
      }
    case (CMD_FORWARDMAIL_ERASEALL):
      {
      bool b;
      TBuffer ErrMsg;
      ClientForwardMail *CliForw;
      
      CliForw = new ClientForwardMail (pd->uo->getForwardsServer(), pd->uo->getForwardsPort(), pd->username, pd->password);
      b = CliForw->doClearForwards (ErrMsg);
      delete CliForw;
      if (b == true) 
        {
        b = CliForw->doGetForwards (SLForwardsMail, ErrMsg);
        html->PrintForwardMailDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, 
                                           SLForwardsMail);
        }
      else 
        {
        LOG ("FORWARDMAIL: Error: server: %s, user: %s", pd->uo->getForwardsServer(), pd->username);
        html->ErrorPage(ErrMsg);
        }
      break;   
      }      
    case (CMD_FORWARDMAIL_SET):
      {
      bool b;
      TBuffer ErrMsg;
      ClientForwardMail *CliForw;
      
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "forwards", SLForwardsMail, true);
      CliForw = new ClientForwardMail (pd->uo->getForwardsServer(), pd->uo->getForwardsPort(), pd->username, pd->password);
      b = CliForw->doSetForwards (SLForwardsMail, ErrMsg);
      delete CliForw;
      if (b == true) 
        {
        b = CliForw->doGetForwards (SLForwardsMail, ErrMsg);
        html->PrintForwardMailDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo, SLForwardsMail);
        }
      else 
        {
        LOG ("FORWARDMAIL: Error: server: %s, user: %s", pd->uo->getForwardsServer(), pd->username);
        html->ErrorPage(ErrMsg);
        }
      break;   
      }            
    default: 
      {    
      LOG ("ERROR: Service_ForwardMail: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  delete SLForwardsMail;  
  return false;  
  }  

void HTMLPages::PrintForwardMailDisplayPage 
    (const char *lang, const char *user, const char *connid, UserOptions *uo, 
     StringList *SLForw)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_FORWARDMAIL_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  BotoneraTop (CMD_FORWARDMAIL_DISPLAYPAGE, lang, user, connid, uo);
  BeginCenter();
  BeginFormPost ("PrintForwardMailDisplayPage", PATH_CGI);
  FormHidden ("service", SERVICE_FORWARDMAIL);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "go");      
  FormHidden ("lastcmd", CMD_FORWARDMAIL_DISPLAYPAGE);    

  Label (L->get(L_CURRENTFORWARDS));
  BR();
  FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "forwards", SLForw->toPChar(true), false);  
  BR();
  
  FormButton ("theaction", L->get(L_FORWARDMAIL));
  FormButton ("theaction", L->get(L_FORWARD_ERASE));  
  
  EndForm ();
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
