#ifndef _WCEBASE_H_
#define _WCEBASE_H_

#include "sys/wcetypes.h"

/* Cache manipulation constants */
#define CACHE_SYNC_DISCARD       (0x001)
#define CACHE_SYNC_INSTRUCTIONS  (0x002)
#define CACHE_SYNC_WRITEBACK	    (0x004)

/* Kernel Constants from M$ kfuncs.h */
#if defined(SARM)
#define PUserKData ((LPBYTE)0xFFFFC800)
#else
#define PUserKData ((LPBYTE)0x00005800)
#endif
#define SYSHANDLE_OFFSET 0x004

#define NUM_SYS_HANDLES  32

#define SYS_HANDLE_BASE	 64
#define SH_WIN32                0
#define SH_CURTHREAD            1
#define SH_CURPROC              2

/* Access Types */
#define GENERIC_READ                     (0x80000000L)
#define GENERIC_WRITE                    (0x40000000L)
#define GENERIC_EXECUTE                  (0x20000000L)
#define GENERIC_ALL                      (0x10000000L)

#define DELETE                           (0x00010000L)
#define READ_CONTROL                     (0x00020000L)
#define WRITE_DAC                        (0x00040000L)
#define WRITE_OWNER                      (0x00080000L)
#define SYNCHRONIZE                      (0x00100000L)

#define STANDARD_RIGHTS_REQUIRED         (0x000F0000L)

#define STANDARD_RIGHTS_READ             (READ_CONTROL)
#define STANDARD_RIGHTS_WRITE            (READ_CONTROL)
#define STANDARD_RIGHTS_EXECUTE          (READ_CONTROL)

#define STANDARD_RIGHTS_ALL              (0x001F0000L)
#define SPECIFIC_RIGHTS_ALL              (0x0000FFFFL)

/* DLL Constants */
#define DLL_PROCESS_ATTACH 1    
#define DLL_THREAD_ATTACH  2    
#define DLL_THREAD_DETACH  3    
#define DLL_PROCESS_DETACH 0    
#define DLL_PROCESS_EXITING 4
#define DLL_SYSTEM_STARTED 5
#define DLL_MEMORY_LOW 6

typedef struct _SECURITY_ATTRIBUTES {
  DWORD nLength;
  LPVOID lpSecurityDescriptor;
  BOOL bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;

typedef struct _PROCESS_INFORMATION {
  HANDLE  hProcess;
  HANDLE  hThread;
  DWORD   dwProcessId;
  DWORD   dwThreadId;
} PROCESS_INFORMATION, *LPPROCESS_INFORMATION;

typedef struct _STARTUPINFOW {
  DWORD   cb;
  LPWSTR  lpReserved;
  LPWSTR  lpDesktop;
  LPWSTR  lpTitle;
  DWORD   dwX;
  DWORD   dwY;
  DWORD   dwXSize;
  DWORD   dwYSize;
  DWORD   dwXCountChars;
  DWORD   dwYCountChars;
  DWORD   dwFillAttribute;
  DWORD   dwFlags;
  WORD    wShowWindow;
  WORD    cbReserved2;
  LPBYTE  lpReserved2;
  HANDLE  hStdInput;
  HANDLE  hStdOutput;
  HANDLE  hStdError;
} STARTUPINFOW, *LPSTARTUPINFOW;

#ifdef __cplusplus
extern "C" {
#endif

DWORD  CacheSync(DWORD);
BOOL   CreateProcessW(LPCWSTR, LPCWSTR, LPSECURITY_ATTRIBUTES, LPSECURITY_ATTRIBUTES, BOOL, DWORD, LPVOID, LPWSTR, LPSTARTUPINFOW, LPPROCESS_INFORMATION);
BOOL   FlushFileBuffers(HANDLE);
BOOL   FlushInstructionCache(HANDLE, LPCVOID, DWORD);
LPWSTR GetCommandLineW();
DWORD  GetLastError();
DWORD  GetModuleFileNameW(HANDLE, LPWSTR, DWORD);
DWORD  GetTickCount();
LONG   InterlockedIncrement(LPLONG);
LONG   InterlockedDecrement(LPLONG);
LONG   InterlockedExchange(LPLONG, LONG);
LONG   InterlockedTestExchange(LPLONG, LONG, LONG);
HANDLE LoadLibrary(LPWSTR);
HANDLE LoadLibraryEx(LPWSTR, HANDLE, DWORD);
HANDLE OpenProcess(DWORD, BOOL, DWORD);
BOOL   ReadProcessMemory(HANDLE, LPCVOID, LPVOID, DWORD, LPDWORD);
BOOL   WriteProcessMemory(HANDLE, LPVOID, LPVOID, DWORD, LPDWORD);
VOID   Sleep(DWORD);
BOOL   TerminateProcess(HANDLE, DWORD);

#ifdef __cplusplus
}
#endif

#define InterlockedCompareExchange(ptr, newval, oldval) \
	((PVOID)InterlockedTestExchange((LPLONG)ptr, (LONG)oldval, (LONG)newval))

/* Process/Thread ID Methods */
#define GetCurrentThread() ((HANDLE)(SH_CURTHREAD+SYS_HANDLE_BASE))
#define GetCurrentProcess() ((HANDLE)(SH_CURPROC+SYS_HANDLE_BASE))
#define GetCurrentThreadId() ((DWORD)(((HANDLE *)(PUserKData+SYSHANDLE_OFFSET))[SH_CURTHREAD]))
#define GetCurrentProcessId() ((DWORD)(((HANDLE *)(PUserKData+SYSHANDLE_OFFSET))[SH_CURPROC]))

#endif  /* _WCEBASE_H_ */
