/**
 *
 * @file     interface.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Tue Aug 05, 2005 22:01
 * @brief    Playground GUI
 *
 * Copyright (C) 2005 Aleix Conchillo Flaque <aleix@member.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */


#ifndef INTERFACE_H_0508052201
#define INTERFACE_H_0508052201

#include "player.h"

#include <gtk/gtk.h>
#include <panel-applet.h>

/* Forward declarations */
typedef struct pg_gui_t pg_gui_t;

extern pg_gui_t* gui_create (void);
extern void gui_destroy (pg_gui_t *gui);
extern void gui_init (pg_gui_t *gui, GtkWidget *applet, gpointer *cb_data);
extern void gui_setup(pg_gui_t *gui, pg_player_t *player);
extern void gui_update(pg_gui_t *gui, pg_player_t *player);
extern gboolean gui_seek (pg_gui_t *gui, pg_player_t *player,
                          GdkEventButton *event);
extern gboolean gui_propagate_event (pg_gui_t *gui, pg_player_t *player,
                                     GdkEventButton *event);
extern void gui_set_size (pg_gui_t *gui, gint size);
extern void gui_set_orient (pg_gui_t *gui, PanelAppletOrient orient);
extern void gui_theme_load(pg_gui_t *gui, GtkStyle *style);
extern void gui_show_error(gchar const *msg);

#endif /* INTERFACE_H_0508052201 */
