/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef __PGT_GALLERIES_H__
#define __PGT_GALLERIES_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define PGT_TYPE_GALLERIES                  (pgt_galleries_get_gtype ())
#define PGT_GALLERIES(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGT_TYPE_GALLERIES, PgtGalleries))
#define PGT_GALLERIES_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), PGT_TYPE_GALLERIES, PgtGalleriesClass))
#define PGT_IS_GALLERIES(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGT_TYPE_GALLERIES))
#define PGT_IS_GALLERIES_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), PGT_TYPE_GALLERIES))
#define PGT_GALLERIES_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), PGT_TYPE_GALLERIES, PgtGalleriesClass))

typedef struct _PgtGalleries PgtGalleries;
typedef struct _PgtGalleriesClass PgtGalleriesClass;

GType pgt_galleries_get_gtype (void);

PgtGalleries*   pgt_galleries_new (GtkTreeModel *gallerystore);

GtkWidget*    pgt_galleries_get_window (PgtGalleries *self);
gchar const * pgt_galleries_get_name (PgtGalleries *self);
gchar const * pgt_galleries_get_url (PgtGalleries *self);
gchar* pgt_galleries_get_selected_name (PgtGalleries *self);

void pgt_galleries_set_model (PgtGalleries *self, GtkTreeModel *model);

void pgt_galleries_connect_add_gallery (PgtGalleries *self, GCallback handler, gpointer data);
void pgt_galleries_connect_del_gallery (PgtGalleries *self, GCallback handler, gpointer data);
void pgt_galleries_connect_close (PgtGalleries *self, GCallback handler, gpointer data);


G_END_DECLS

#endif /* __PGT_GALLERIES_H__ */
