/* GAPIC.cpp
   Generated by gSOAP 2.7.9e from GoogleSearch.h
   Copyright(C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "GAPIH.h"

SOAP_SOURCE_STAMP("@(#) GAPIC.cpp ver 2.7.9e 2007-07-29 10:34:02 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_gapi1__DirectoryCategory:
		return soap_in_gapi1__DirectoryCategory(soap, NULL, NULL, "gapi1:DirectoryCategory");
	case SOAP_TYPE_gapi1DirectoryCategoryArray:
		return soap_in_gapi1DirectoryCategoryArray(soap, NULL, NULL, "gapi1:DirectoryCategory");
	case SOAP_TYPE_gapi1ResultElementArray:
		return soap_in_gapi1ResultElementArray(soap, NULL, NULL, "gapi1:ResultElement");
	case SOAP_TYPE_gapi1__ResultElement:
		return soap_in_gapi1__ResultElement(soap, NULL, NULL, "gapi1:ResultElement");
	case SOAP_TYPE_gapi1__GoogleSearchResult:
		return soap_in_gapi1__GoogleSearchResult(soap, NULL, NULL, "gapi1:GoogleSearchResult");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_gapi1__doGoogleSearch:
		return soap_in_gapi1__doGoogleSearch(soap, NULL, NULL, "gapi1:doGoogleSearch");
	case SOAP_TYPE_gapi1__doGoogleSearchResponse:
		return soap_in_gapi1__doGoogleSearchResponse(soap, NULL, NULL, "gapi1:doGoogleSearchResponse");
	case SOAP_TYPE_gapi1__doSpellingSuggestion:
		return soap_in_gapi1__doSpellingSuggestion(soap, NULL, NULL, "gapi1:doSpellingSuggestion");
	case SOAP_TYPE_gapi1__doSpellingSuggestionResponse:
		return soap_in_gapi1__doSpellingSuggestionResponse(soap, NULL, NULL, "gapi1:doSpellingSuggestionResponse");
	case SOAP_TYPE_gapi1__doGetCachedPage:
		return soap_in_gapi1__doGetCachedPage(soap, NULL, NULL, "gapi1:doGetCachedPage");
	case SOAP_TYPE_gapi1__doGetCachedPageResponse:
		return soap_in_gapi1__doGetCachedPageResponse(soap, NULL, NULL, "gapi1:doGetCachedPageResponse");
	case SOAP_TYPE_PointerTogapi1__GoogleSearchResult:
		return soap_in_PointerTogapi1__GoogleSearchResult(soap, NULL, NULL, "gapi1:GoogleSearchResult");
	case SOAP_TYPE_PointerToPointerTogapi1__DirectoryCategory:
		return soap_in_PointerToPointerTogapi1__DirectoryCategory(soap, NULL, NULL, "gapi1:DirectoryCategory");
	case SOAP_TYPE_PointerToPointerTogapi1__ResultElement:
		return soap_in_PointerToPointerTogapi1__ResultElement(soap, NULL, NULL, "gapi1:ResultElement");
	case SOAP_TYPE_PointerTogapi1__ResultElement:
		return soap_in_PointerTogapi1__ResultElement(soap, NULL, NULL, "gapi1:ResultElement");
	case SOAP_TYPE_PointerTogapi1__DirectoryCategory:
		return soap_in_PointerTogapi1__DirectoryCategory(soap, NULL, NULL, "gapi1:DirectoryCategory");
	case SOAP_TYPE_PointerTogapi1DirectoryCategoryArray:
		return soap_in_PointerTogapi1DirectoryCategoryArray(soap, NULL, NULL, "gapi1:DirectoryCategory");
	case SOAP_TYPE_PointerTogapi1ResultElementArray:
		return soap_in_PointerTogapi1ResultElementArray(soap, NULL, NULL, "gapi1:ResultElement");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:DirectoryCategory"))
		{	*type = SOAP_TYPE_gapi1__DirectoryCategory;
			return soap_in_gapi1__DirectoryCategory(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "gapi1:DirectoryCategory"))
		{	*type = SOAP_TYPE_gapi1DirectoryCategoryArray;
			return soap_in_gapi1DirectoryCategoryArray(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "gapi1:ResultElement"))
		{	*type = SOAP_TYPE_gapi1ResultElementArray;
			return soap_in_gapi1ResultElementArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:ResultElement"))
		{	*type = SOAP_TYPE_gapi1__ResultElement;
			return soap_in_gapi1__ResultElement(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:GoogleSearchResult"))
		{	*type = SOAP_TYPE_gapi1__GoogleSearchResult;
			return soap_in_gapi1__GoogleSearchResult(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:doGoogleSearch"))
		{	*type = SOAP_TYPE_gapi1__doGoogleSearch;
			return soap_in_gapi1__doGoogleSearch(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:doGoogleSearchResponse"))
		{	*type = SOAP_TYPE_gapi1__doGoogleSearchResponse;
			return soap_in_gapi1__doGoogleSearchResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:doSpellingSuggestion"))
		{	*type = SOAP_TYPE_gapi1__doSpellingSuggestion;
			return soap_in_gapi1__doSpellingSuggestion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:doSpellingSuggestionResponse"))
		{	*type = SOAP_TYPE_gapi1__doSpellingSuggestionResponse;
			return soap_in_gapi1__doSpellingSuggestionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:doGetCachedPage"))
		{	*type = SOAP_TYPE_gapi1__doGetCachedPage;
			return soap_in_gapi1__doGetCachedPage(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "gapi1:doGetCachedPageResponse"))
		{	*type = SOAP_TYPE_gapi1__doGetCachedPageResponse;
			return soap_in_gapi1__doGetCachedPageResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE_gapi1__DirectoryCategory:
		return ((gapi1__DirectoryCategory *)ptr)->soap_out(soap, tag, id, "gapi1:DirectoryCategory");
	case SOAP_TYPE_gapi1DirectoryCategoryArray:
		return ((gapi1DirectoryCategoryArray *)ptr)->soap_out(soap, tag, id, "gapi1:DirectoryCategory");
	case SOAP_TYPE_gapi1ResultElementArray:
		return ((gapi1ResultElementArray *)ptr)->soap_out(soap, tag, id, "gapi1:ResultElement");
	case SOAP_TYPE_gapi1__ResultElement:
		return ((gapi1__ResultElement *)ptr)->soap_out(soap, tag, id, "gapi1:ResultElement");
	case SOAP_TYPE_gapi1__GoogleSearchResult:
		return ((gapi1__GoogleSearchResult *)ptr)->soap_out(soap, tag, id, "gapi1:GoogleSearchResult");
	case SOAP_TYPE_xsd__base64Binary:
		return ((xsd__base64Binary *)ptr)->soap_out(soap, tag, id, "xsd:base64Binary");
	case SOAP_TYPE_gapi1__doGoogleSearch:
		return soap_out_gapi1__doGoogleSearch(soap, tag, id, (const struct gapi1__doGoogleSearch *)ptr, "gapi1:doGoogleSearch");
	case SOAP_TYPE_gapi1__doGoogleSearchResponse:
		return soap_out_gapi1__doGoogleSearchResponse(soap, tag, id, (const struct gapi1__doGoogleSearchResponse *)ptr, "gapi1:doGoogleSearchResponse");
	case SOAP_TYPE_gapi1__doSpellingSuggestion:
		return soap_out_gapi1__doSpellingSuggestion(soap, tag, id, (const struct gapi1__doSpellingSuggestion *)ptr, "gapi1:doSpellingSuggestion");
	case SOAP_TYPE_gapi1__doSpellingSuggestionResponse:
		return soap_out_gapi1__doSpellingSuggestionResponse(soap, tag, id, (const struct gapi1__doSpellingSuggestionResponse *)ptr, "gapi1:doSpellingSuggestionResponse");
	case SOAP_TYPE_gapi1__doGetCachedPage:
		return soap_out_gapi1__doGetCachedPage(soap, tag, id, (const struct gapi1__doGetCachedPage *)ptr, "gapi1:doGetCachedPage");
	case SOAP_TYPE_gapi1__doGetCachedPageResponse:
		return soap_out_gapi1__doGetCachedPageResponse(soap, tag, id, (const struct gapi1__doGetCachedPageResponse *)ptr, "gapi1:doGetCachedPageResponse");
	case SOAP_TYPE_PointerTogapi1__GoogleSearchResult:
		return soap_out_PointerTogapi1__GoogleSearchResult(soap, tag, id, (gapi1__GoogleSearchResult *const*)ptr, "gapi1:GoogleSearchResult");
	case SOAP_TYPE_PointerToPointerTogapi1__DirectoryCategory:
		return soap_out_PointerToPointerTogapi1__DirectoryCategory(soap, tag, id, (gapi1__DirectoryCategory **const*)ptr, "gapi1:DirectoryCategory");
	case SOAP_TYPE_PointerToPointerTogapi1__ResultElement:
		return soap_out_PointerToPointerTogapi1__ResultElement(soap, tag, id, (gapi1__ResultElement **const*)ptr, "gapi1:ResultElement");
	case SOAP_TYPE_PointerTogapi1__ResultElement:
		return soap_out_PointerTogapi1__ResultElement(soap, tag, id, (gapi1__ResultElement *const*)ptr, "gapi1:ResultElement");
	case SOAP_TYPE_PointerTogapi1__DirectoryCategory:
		return soap_out_PointerTogapi1__DirectoryCategory(soap, tag, id, (gapi1__DirectoryCategory *const*)ptr, "gapi1:DirectoryCategory");
	case SOAP_TYPE_PointerTogapi1DirectoryCategoryArray:
		return soap_out_PointerTogapi1DirectoryCategoryArray(soap, tag, id, (gapi1DirectoryCategoryArray *const*)ptr, "gapi1:DirectoryCategory");
	case SOAP_TYPE_PointerTogapi1ResultElementArray:
		return soap_out_PointerTogapi1ResultElementArray(soap, tag, id, (gapi1ResultElementArray *const*)ptr, "gapi1:ResultElement");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_gapi1__DirectoryCategory:
		((gapi1__DirectoryCategory *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_gapi1DirectoryCategoryArray:
		((gapi1DirectoryCategoryArray *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_gapi1ResultElementArray:
		((gapi1ResultElementArray *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_gapi1__ResultElement:
		((gapi1__ResultElement *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_gapi1__GoogleSearchResult:
		((gapi1__GoogleSearchResult *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		((xsd__base64Binary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_gapi1__doGoogleSearch:
		soap_serialize_gapi1__doGoogleSearch(soap, (const struct gapi1__doGoogleSearch *)ptr);
		break;
	case SOAP_TYPE_gapi1__doGoogleSearchResponse:
		soap_serialize_gapi1__doGoogleSearchResponse(soap, (const struct gapi1__doGoogleSearchResponse *)ptr);
		break;
	case SOAP_TYPE_gapi1__doSpellingSuggestion:
		soap_serialize_gapi1__doSpellingSuggestion(soap, (const struct gapi1__doSpellingSuggestion *)ptr);
		break;
	case SOAP_TYPE_gapi1__doSpellingSuggestionResponse:
		soap_serialize_gapi1__doSpellingSuggestionResponse(soap, (const struct gapi1__doSpellingSuggestionResponse *)ptr);
		break;
	case SOAP_TYPE_gapi1__doGetCachedPage:
		soap_serialize_gapi1__doGetCachedPage(soap, (const struct gapi1__doGetCachedPage *)ptr);
		break;
	case SOAP_TYPE_gapi1__doGetCachedPageResponse:
		soap_serialize_gapi1__doGetCachedPageResponse(soap, (const struct gapi1__doGetCachedPageResponse *)ptr);
		break;
	case SOAP_TYPE_PointerTogapi1__GoogleSearchResult:
		soap_serialize_PointerTogapi1__GoogleSearchResult(soap, (gapi1__GoogleSearchResult *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTogapi1__DirectoryCategory:
		soap_serialize_PointerToPointerTogapi1__DirectoryCategory(soap, (gapi1__DirectoryCategory **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTogapi1__ResultElement:
		soap_serialize_PointerToPointerTogapi1__ResultElement(soap, (gapi1__ResultElement **const*)ptr);
		break;
	case SOAP_TYPE_PointerTogapi1__ResultElement:
		soap_serialize_PointerTogapi1__ResultElement(soap, (gapi1__ResultElement *const*)ptr);
		break;
	case SOAP_TYPE_PointerTogapi1__DirectoryCategory:
		soap_serialize_PointerTogapi1__DirectoryCategory(soap, (gapi1__DirectoryCategory *const*)ptr);
		break;
	case SOAP_TYPE_PointerTogapi1DirectoryCategoryArray:
		soap_serialize_PointerTogapi1DirectoryCategoryArray(soap, (gapi1DirectoryCategoryArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerTogapi1ResultElementArray:
		soap_serialize_PointerTogapi1ResultElementArray(soap, (gapi1ResultElementArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_xsd__base64Binary:
		return (void*)soap_instantiate_xsd__base64Binary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__GoogleSearchResult:
		return (void*)soap_instantiate_gapi1__GoogleSearchResult(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__ResultElement:
		return (void*)soap_instantiate_gapi1__ResultElement(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__DirectoryCategory:
		return (void*)soap_instantiate_gapi1__DirectoryCategory(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1ResultElementArray:
		return (void*)soap_instantiate_gapi1ResultElementArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1DirectoryCategoryArray:
		return (void*)soap_instantiate_gapi1DirectoryCategoryArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__doGetCachedPageResponse:
		return (void*)soap_instantiate_gapi1__doGetCachedPageResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__doGetCachedPage:
		return (void*)soap_instantiate_gapi1__doGetCachedPage(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__doSpellingSuggestionResponse:
		return (void*)soap_instantiate_gapi1__doSpellingSuggestionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__doSpellingSuggestion:
		return (void*)soap_instantiate_gapi1__doSpellingSuggestion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__doGoogleSearchResponse:
		return (void*)soap_instantiate_gapi1__doGoogleSearchResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_gapi1__doGoogleSearch:
		return (void*)soap_instantiate_gapi1__doGoogleSearch(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_xsd__base64Binary:
		if (p->size < 0)
			delete (xsd__base64Binary*)p->ptr;
		else
			delete[] (xsd__base64Binary*)p->ptr;
		break;
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__GoogleSearchResult:
		if (p->size < 0)
			delete (gapi1__GoogleSearchResult*)p->ptr;
		else
			delete[] (gapi1__GoogleSearchResult*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__ResultElement:
		if (p->size < 0)
			delete (gapi1__ResultElement*)p->ptr;
		else
			delete[] (gapi1__ResultElement*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__DirectoryCategory:
		if (p->size < 0)
			delete (gapi1__DirectoryCategory*)p->ptr;
		else
			delete[] (gapi1__DirectoryCategory*)p->ptr;
		break;
	case SOAP_TYPE_gapi1ResultElementArray:
		if (p->size < 0)
			delete (gapi1ResultElementArray*)p->ptr;
		else
			delete[] (gapi1ResultElementArray*)p->ptr;
		break;
	case SOAP_TYPE_gapi1DirectoryCategoryArray:
		if (p->size < 0)
			delete (gapi1DirectoryCategoryArray*)p->ptr;
		else
			delete[] (gapi1DirectoryCategoryArray*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__doGetCachedPageResponse:
		if (p->size < 0)
			delete (struct gapi1__doGetCachedPageResponse*)p->ptr;
		else
			delete[] (struct gapi1__doGetCachedPageResponse*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__doGetCachedPage:
		if (p->size < 0)
			delete (struct gapi1__doGetCachedPage*)p->ptr;
		else
			delete[] (struct gapi1__doGetCachedPage*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__doSpellingSuggestionResponse:
		if (p->size < 0)
			delete (struct gapi1__doSpellingSuggestionResponse*)p->ptr;
		else
			delete[] (struct gapi1__doSpellingSuggestionResponse*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__doSpellingSuggestion:
		if (p->size < 0)
			delete (struct gapi1__doSpellingSuggestion*)p->ptr;
		else
			delete[] (struct gapi1__doSpellingSuggestion*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__doGoogleSearchResponse:
		if (p->size < 0)
			delete (struct gapi1__doGoogleSearchResponse*)p->ptr;
		else
			delete[] (struct gapi1__doGoogleSearchResponse*)p->ptr;
		break;
	case SOAP_TYPE_gapi1__doGoogleSearch:
		if (p->size < 0)
			delete (struct gapi1__doGoogleSearch*)p->ptr;
		else
			delete[] (struct gapi1__doGoogleSearch*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{	switch (tt)
	{
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{
	return soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *p)
{	(void)soap; (void)p; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, type))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_std__string(struct soap *soap, int n)
{	return soap_instantiate_std__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__string(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void gapi1__DirectoryCategory::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->gapi1__DirectoryCategory::fullViewableName);
	soap_default_std__string(soap, &this->gapi1__DirectoryCategory::specialEncoding);
	/* transient soap skipped */
}

void gapi1__DirectoryCategory::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &this->gapi1__DirectoryCategory::fullViewableName);
	soap_serialize_std__string(soap, &this->gapi1__DirectoryCategory::specialEncoding);
	/* transient soap skipped */
}

int gapi1__DirectoryCategory::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_gapi1__DirectoryCategory);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int gapi1__DirectoryCategory::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_gapi1__DirectoryCategory(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__DirectoryCategory(struct soap *soap, const char *tag, int id, const gapi1__DirectoryCategory *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__DirectoryCategory), type);
	soap_out_std__string(soap, "fullViewableName", -1, &(a->gapi1__DirectoryCategory::fullViewableName), "");
	soap_out_std__string(soap, "specialEncoding", -1, &(a->gapi1__DirectoryCategory::specialEncoding), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *gapi1__DirectoryCategory::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_gapi1__DirectoryCategory(soap, this, tag, type);
}

SOAP_FMAC3 gapi1__DirectoryCategory * SOAP_FMAC4 soap_get_gapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__DirectoryCategory(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *gapi1__DirectoryCategory::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_gapi1__DirectoryCategory(soap, tag, this, type);
}

SOAP_FMAC3 gapi1__DirectoryCategory * SOAP_FMAC4 soap_in_gapi1__DirectoryCategory(struct soap *soap, const char *tag, gapi1__DirectoryCategory *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (gapi1__DirectoryCategory *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__DirectoryCategory, sizeof(gapi1__DirectoryCategory), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_gapi1__DirectoryCategory)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (gapi1__DirectoryCategory *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fullViewableName1 = 1, soap_flag_specialEncoding1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fullViewableName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "fullViewableName", &(a->gapi1__DirectoryCategory::fullViewableName), "xsd:string"))
				{	soap_flag_fullViewableName1--;
					continue;
				}
			if (soap_flag_specialEncoding1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "specialEncoding", &(a->gapi1__DirectoryCategory::specialEncoding), "xsd:string"))
				{	soap_flag_specialEncoding1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (gapi1__DirectoryCategory *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__DirectoryCategory, 0, sizeof(gapi1__DirectoryCategory), 0, soap_copy_gapi1__DirectoryCategory);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fullViewableName1 > 0 || soap_flag_specialEncoding1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 gapi1__DirectoryCategory * SOAP_FMAC6 soap_new_gapi1__DirectoryCategory(struct soap *soap, int n)
{	return soap_instantiate_gapi1__DirectoryCategory(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 gapi1__DirectoryCategory * SOAP_FMAC4 soap_instantiate_gapi1__DirectoryCategory(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__DirectoryCategory(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__DirectoryCategory, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new gapi1__DirectoryCategory;
		if (size)
			*size = sizeof(gapi1__DirectoryCategory);
		((gapi1__DirectoryCategory*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new gapi1__DirectoryCategory[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(gapi1__DirectoryCategory);
		for (int i = 0; i < n; i++)
			((gapi1__DirectoryCategory*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (gapi1__DirectoryCategory*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__DirectoryCategory(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying gapi1__DirectoryCategory %p -> %p\n", q, p));
	*(gapi1__DirectoryCategory*)p = *(gapi1__DirectoryCategory*)q;
}

void gapi1DirectoryCategoryArray::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void gapi1DirectoryCategoryArray::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_gapi1DirectoryCategoryArray))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTogapi1__DirectoryCategory(soap, this->__ptr + i);
		}
}

int gapi1DirectoryCategoryArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_gapi1DirectoryCategoryArray);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int gapi1DirectoryCategoryArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_gapi1DirectoryCategoryArray(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1DirectoryCategoryArray(struct soap *soap, const char *tag, int id, const gapi1DirectoryCategoryArray *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "gapi1:DirectoryCategory", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_gapi1DirectoryCategoryArray);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTogapi1__DirectoryCategory(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *gapi1DirectoryCategoryArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_gapi1DirectoryCategoryArray(soap, this, tag, type);
}

SOAP_FMAC3 gapi1DirectoryCategoryArray * SOAP_FMAC4 soap_get_gapi1DirectoryCategoryArray(struct soap *soap, gapi1DirectoryCategoryArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1DirectoryCategoryArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *gapi1DirectoryCategoryArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_gapi1DirectoryCategoryArray(soap, tag, this, type);
}

SOAP_FMAC3 gapi1DirectoryCategoryArray * SOAP_FMAC4 soap_in_gapi1DirectoryCategoryArray(struct soap *soap, const char *tag, gapi1DirectoryCategoryArray *a, const char *type)
{	int i, j;
	gapi1__DirectoryCategory **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (gapi1DirectoryCategoryArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1DirectoryCategoryArray, sizeof(gapi1DirectoryCategoryArray), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (gapi1__DirectoryCategory **)soap_malloc(soap, sizeof(gapi1__DirectoryCategory *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTogapi1__DirectoryCategory(soap, NULL, a->__ptr + i, "gapi1:DirectoryCategory"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (gapi1__DirectoryCategory **)soap_push_block(soap, sizeof(gapi1__DirectoryCategory *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTogapi1__DirectoryCategory(soap, NULL, p, "gapi1:DirectoryCategory"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (gapi1__DirectoryCategory **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (gapi1DirectoryCategoryArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1DirectoryCategoryArray, 0, sizeof(gapi1DirectoryCategoryArray), 0, soap_copy_gapi1DirectoryCategoryArray);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 gapi1DirectoryCategoryArray * SOAP_FMAC6 soap_new_gapi1DirectoryCategoryArray(struct soap *soap, int n)
{	return soap_instantiate_gapi1DirectoryCategoryArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1DirectoryCategoryArray(struct soap *soap, gapi1DirectoryCategoryArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 gapi1DirectoryCategoryArray * SOAP_FMAC4 soap_instantiate_gapi1DirectoryCategoryArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1DirectoryCategoryArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1DirectoryCategoryArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new gapi1DirectoryCategoryArray;
		if (size)
			*size = sizeof(gapi1DirectoryCategoryArray);
		((gapi1DirectoryCategoryArray*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new gapi1DirectoryCategoryArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(gapi1DirectoryCategoryArray);
		for (int i = 0; i < n; i++)
			((gapi1DirectoryCategoryArray*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (gapi1DirectoryCategoryArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1DirectoryCategoryArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying gapi1DirectoryCategoryArray %p -> %p\n", q, p));
	*(gapi1DirectoryCategoryArray*)p = *(gapi1DirectoryCategoryArray*)q;
}

void gapi1ResultElementArray::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void gapi1ResultElementArray::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_gapi1ResultElementArray))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTogapi1__ResultElement(soap, this->__ptr + i);
		}
}

int gapi1ResultElementArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_gapi1ResultElementArray);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int gapi1ResultElementArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_gapi1ResultElementArray(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1ResultElementArray(struct soap *soap, const char *tag, int id, const gapi1ResultElementArray *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "gapi1:ResultElement", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_gapi1ResultElementArray);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTogapi1__ResultElement(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *gapi1ResultElementArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_gapi1ResultElementArray(soap, this, tag, type);
}

SOAP_FMAC3 gapi1ResultElementArray * SOAP_FMAC4 soap_get_gapi1ResultElementArray(struct soap *soap, gapi1ResultElementArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1ResultElementArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *gapi1ResultElementArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_gapi1ResultElementArray(soap, tag, this, type);
}

SOAP_FMAC3 gapi1ResultElementArray * SOAP_FMAC4 soap_in_gapi1ResultElementArray(struct soap *soap, const char *tag, gapi1ResultElementArray *a, const char *type)
{	int i, j;
	gapi1__ResultElement **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (gapi1ResultElementArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1ResultElementArray, sizeof(gapi1ResultElementArray), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (gapi1__ResultElement **)soap_malloc(soap, sizeof(gapi1__ResultElement *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTogapi1__ResultElement(soap, NULL, a->__ptr + i, "gapi1:ResultElement"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (gapi1__ResultElement **)soap_push_block(soap, sizeof(gapi1__ResultElement *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTogapi1__ResultElement(soap, NULL, p, "gapi1:ResultElement"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (gapi1__ResultElement **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (gapi1ResultElementArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1ResultElementArray, 0, sizeof(gapi1ResultElementArray), 0, soap_copy_gapi1ResultElementArray);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 gapi1ResultElementArray * SOAP_FMAC6 soap_new_gapi1ResultElementArray(struct soap *soap, int n)
{	return soap_instantiate_gapi1ResultElementArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1ResultElementArray(struct soap *soap, gapi1ResultElementArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 gapi1ResultElementArray * SOAP_FMAC4 soap_instantiate_gapi1ResultElementArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1ResultElementArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1ResultElementArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new gapi1ResultElementArray;
		if (size)
			*size = sizeof(gapi1ResultElementArray);
		((gapi1ResultElementArray*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new gapi1ResultElementArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(gapi1ResultElementArray);
		for (int i = 0; i < n; i++)
			((gapi1ResultElementArray*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (gapi1ResultElementArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1ResultElementArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying gapi1ResultElementArray %p -> %p\n", q, p));
	*(gapi1ResultElementArray*)p = *(gapi1ResultElementArray*)q;
}

void gapi1__ResultElement::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &this->gapi1__ResultElement::summary);
	soap_default_std__string(soap, &this->gapi1__ResultElement::URL);
	soap_default_std__string(soap, &this->gapi1__ResultElement::snippet);
	soap_default_std__string(soap, &this->gapi1__ResultElement::title);
	soap_default_std__string(soap, &this->gapi1__ResultElement::cachedSize);
	soap_default_bool(soap, &this->gapi1__ResultElement::relatedInformationPresent);
	soap_default_std__string(soap, &this->gapi1__ResultElement::hostName);
	this->gapi1__ResultElement::directoryCategory = NULL;
	soap_default_std__string(soap, &this->gapi1__ResultElement::directoryTitle);
	/* transient soap skipped */
}

void gapi1__ResultElement::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::summary);
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::URL);
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::snippet);
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::title);
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::cachedSize);
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::hostName);
	soap_serialize_PointerTogapi1__DirectoryCategory(soap, &this->gapi1__ResultElement::directoryCategory);
	soap_serialize_std__string(soap, &this->gapi1__ResultElement::directoryTitle);
	/* transient soap skipped */
}

int gapi1__ResultElement::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_gapi1__ResultElement);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int gapi1__ResultElement::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_gapi1__ResultElement(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__ResultElement(struct soap *soap, const char *tag, int id, const gapi1__ResultElement *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__ResultElement), type);
	soap_out_std__string(soap, "summary", -1, &(a->gapi1__ResultElement::summary), "");
	soap_out_std__string(soap, "URL", -1, &(a->gapi1__ResultElement::URL), "");
	soap_out_std__string(soap, "snippet", -1, &(a->gapi1__ResultElement::snippet), "");
	soap_out_std__string(soap, "title", -1, &(a->gapi1__ResultElement::title), "");
	soap_out_std__string(soap, "cachedSize", -1, &(a->gapi1__ResultElement::cachedSize), "");
	soap_out_bool(soap, "relatedInformationPresent", -1, &(a->gapi1__ResultElement::relatedInformationPresent), "");
	soap_out_std__string(soap, "hostName", -1, &(a->gapi1__ResultElement::hostName), "");
	soap_out_PointerTogapi1__DirectoryCategory(soap, "directoryCategory", -1, &(a->gapi1__ResultElement::directoryCategory), "");
	soap_out_std__string(soap, "directoryTitle", -1, &(a->gapi1__ResultElement::directoryTitle), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *gapi1__ResultElement::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_gapi1__ResultElement(soap, this, tag, type);
}

SOAP_FMAC3 gapi1__ResultElement * SOAP_FMAC4 soap_get_gapi1__ResultElement(struct soap *soap, gapi1__ResultElement *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__ResultElement(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *gapi1__ResultElement::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_gapi1__ResultElement(soap, tag, this, type);
}

SOAP_FMAC3 gapi1__ResultElement * SOAP_FMAC4 soap_in_gapi1__ResultElement(struct soap *soap, const char *tag, gapi1__ResultElement *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (gapi1__ResultElement *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__ResultElement, sizeof(gapi1__ResultElement), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_gapi1__ResultElement)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (gapi1__ResultElement *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_summary1 = 1, soap_flag_URL1 = 1, soap_flag_snippet1 = 1, soap_flag_title1 = 1, soap_flag_cachedSize1 = 1, soap_flag_relatedInformationPresent1 = 1, soap_flag_hostName1 = 1, soap_flag_directoryCategory1 = 1, soap_flag_directoryTitle1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_summary1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "summary", &(a->gapi1__ResultElement::summary), "xsd:string"))
				{	soap_flag_summary1--;
					continue;
				}
			if (soap_flag_URL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "URL", &(a->gapi1__ResultElement::URL), "xsd:string"))
				{	soap_flag_URL1--;
					continue;
				}
			if (soap_flag_snippet1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "snippet", &(a->gapi1__ResultElement::snippet), "xsd:string"))
				{	soap_flag_snippet1--;
					continue;
				}
			if (soap_flag_title1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "title", &(a->gapi1__ResultElement::title), "xsd:string"))
				{	soap_flag_title1--;
					continue;
				}
			if (soap_flag_cachedSize1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "cachedSize", &(a->gapi1__ResultElement::cachedSize), "xsd:string"))
				{	soap_flag_cachedSize1--;
					continue;
				}
			if (soap_flag_relatedInformationPresent1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "relatedInformationPresent", &(a->gapi1__ResultElement::relatedInformationPresent), "xsd:boolean"))
				{	soap_flag_relatedInformationPresent1--;
					continue;
				}
			if (soap_flag_hostName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "hostName", &(a->gapi1__ResultElement::hostName), "xsd:string"))
				{	soap_flag_hostName1--;
					continue;
				}
			if (soap_flag_directoryCategory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTogapi1__DirectoryCategory(soap, "directoryCategory", &(a->gapi1__ResultElement::directoryCategory), "gapi1:DirectoryCategory"))
				{	soap_flag_directoryCategory1--;
					continue;
				}
			if (soap_flag_directoryTitle1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "directoryTitle", &(a->gapi1__ResultElement::directoryTitle), "xsd:string"))
				{	soap_flag_directoryTitle1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (gapi1__ResultElement *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__ResultElement, 0, sizeof(gapi1__ResultElement), 0, soap_copy_gapi1__ResultElement);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_summary1 > 0 || soap_flag_URL1 > 0 || soap_flag_snippet1 > 0 || soap_flag_title1 > 0 || soap_flag_cachedSize1 > 0 || soap_flag_relatedInformationPresent1 > 0 || soap_flag_hostName1 > 0 || soap_flag_directoryCategory1 > 0 || soap_flag_directoryTitle1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 gapi1__ResultElement * SOAP_FMAC6 soap_new_gapi1__ResultElement(struct soap *soap, int n)
{	return soap_instantiate_gapi1__ResultElement(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__ResultElement(struct soap *soap, gapi1__ResultElement *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 gapi1__ResultElement * SOAP_FMAC4 soap_instantiate_gapi1__ResultElement(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__ResultElement(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__ResultElement, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new gapi1__ResultElement;
		if (size)
			*size = sizeof(gapi1__ResultElement);
		((gapi1__ResultElement*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new gapi1__ResultElement[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(gapi1__ResultElement);
		for (int i = 0; i < n; i++)
			((gapi1__ResultElement*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (gapi1__ResultElement*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__ResultElement(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying gapi1__ResultElement %p -> %p\n", q, p));
	*(gapi1__ResultElement*)p = *(gapi1__ResultElement*)q;
}

void gapi1__GoogleSearchResult::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->gapi1__GoogleSearchResult::documentFiltering);
	soap_default_std__string(soap, &this->gapi1__GoogleSearchResult::searchComments);
	soap_default_int(soap, &this->gapi1__GoogleSearchResult::estimatedTotalResultsCount);
	soap_default_bool(soap, &this->gapi1__GoogleSearchResult::estimateIsExact);
	this->gapi1__GoogleSearchResult::resultElements = NULL;
	soap_default_std__string(soap, &this->gapi1__GoogleSearchResult::searchQuery);
	soap_default_int(soap, &this->gapi1__GoogleSearchResult::startIndex);
	soap_default_int(soap, &this->gapi1__GoogleSearchResult::endIndex);
	soap_default_std__string(soap, &this->gapi1__GoogleSearchResult::searchTips);
	this->gapi1__GoogleSearchResult::directoryCategories = NULL;
	soap_default_double(soap, &this->gapi1__GoogleSearchResult::searchTime);
	/* transient soap skipped */
}

void gapi1__GoogleSearchResult::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &this->gapi1__GoogleSearchResult::searchComments);
	soap_serialize_PointerTogapi1ResultElementArray(soap, &this->gapi1__GoogleSearchResult::resultElements);
	soap_serialize_std__string(soap, &this->gapi1__GoogleSearchResult::searchQuery);
	soap_serialize_std__string(soap, &this->gapi1__GoogleSearchResult::searchTips);
	soap_serialize_PointerTogapi1DirectoryCategoryArray(soap, &this->gapi1__GoogleSearchResult::directoryCategories);
	/* transient soap skipped */
}

int gapi1__GoogleSearchResult::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_gapi1__GoogleSearchResult);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int gapi1__GoogleSearchResult::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_gapi1__GoogleSearchResult(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__GoogleSearchResult(struct soap *soap, const char *tag, int id, const gapi1__GoogleSearchResult *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__GoogleSearchResult), type);
	soap_out_bool(soap, "documentFiltering", -1, &(a->gapi1__GoogleSearchResult::documentFiltering), "");
	soap_out_std__string(soap, "searchComments", -1, &(a->gapi1__GoogleSearchResult::searchComments), "");
	soap_out_int(soap, "estimatedTotalResultsCount", -1, &(a->gapi1__GoogleSearchResult::estimatedTotalResultsCount), "");
	soap_out_bool(soap, "estimateIsExact", -1, &(a->gapi1__GoogleSearchResult::estimateIsExact), "");
	soap_out_PointerTogapi1ResultElementArray(soap, "resultElements", -1, &(a->gapi1__GoogleSearchResult::resultElements), "");
	soap_out_std__string(soap, "searchQuery", -1, &(a->gapi1__GoogleSearchResult::searchQuery), "");
	soap_out_int(soap, "startIndex", -1, &(a->gapi1__GoogleSearchResult::startIndex), "");
	soap_out_int(soap, "endIndex", -1, &(a->gapi1__GoogleSearchResult::endIndex), "");
	soap_out_std__string(soap, "searchTips", -1, &(a->gapi1__GoogleSearchResult::searchTips), "");
	soap_out_PointerTogapi1DirectoryCategoryArray(soap, "directoryCategories", -1, &(a->gapi1__GoogleSearchResult::directoryCategories), "");
	soap_out_double(soap, "searchTime", -1, &(a->gapi1__GoogleSearchResult::searchTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *gapi1__GoogleSearchResult::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_gapi1__GoogleSearchResult(soap, this, tag, type);
}

SOAP_FMAC3 gapi1__GoogleSearchResult * SOAP_FMAC4 soap_get_gapi1__GoogleSearchResult(struct soap *soap, gapi1__GoogleSearchResult *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__GoogleSearchResult(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *gapi1__GoogleSearchResult::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_gapi1__GoogleSearchResult(soap, tag, this, type);
}

SOAP_FMAC3 gapi1__GoogleSearchResult * SOAP_FMAC4 soap_in_gapi1__GoogleSearchResult(struct soap *soap, const char *tag, gapi1__GoogleSearchResult *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (gapi1__GoogleSearchResult *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__GoogleSearchResult, sizeof(gapi1__GoogleSearchResult), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_gapi1__GoogleSearchResult)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (gapi1__GoogleSearchResult *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_documentFiltering1 = 1, soap_flag_searchComments1 = 1, soap_flag_estimatedTotalResultsCount1 = 1, soap_flag_estimateIsExact1 = 1, soap_flag_resultElements1 = 1, soap_flag_searchQuery1 = 1, soap_flag_startIndex1 = 1, soap_flag_endIndex1 = 1, soap_flag_searchTips1 = 1, soap_flag_directoryCategories1 = 1, soap_flag_searchTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_documentFiltering1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "documentFiltering", &(a->gapi1__GoogleSearchResult::documentFiltering), "xsd:boolean"))
				{	soap_flag_documentFiltering1--;
					continue;
				}
			if (soap_flag_searchComments1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "searchComments", &(a->gapi1__GoogleSearchResult::searchComments), "xsd:string"))
				{	soap_flag_searchComments1--;
					continue;
				}
			if (soap_flag_estimatedTotalResultsCount1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "estimatedTotalResultsCount", &(a->gapi1__GoogleSearchResult::estimatedTotalResultsCount), "xsd:int"))
				{	soap_flag_estimatedTotalResultsCount1--;
					continue;
				}
			if (soap_flag_estimateIsExact1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "estimateIsExact", &(a->gapi1__GoogleSearchResult::estimateIsExact), "xsd:boolean"))
				{	soap_flag_estimateIsExact1--;
					continue;
				}
			if (soap_flag_resultElements1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTogapi1ResultElementArray(soap, "resultElements", &(a->gapi1__GoogleSearchResult::resultElements), "gapi1:ResultElement"))
				{	soap_flag_resultElements1--;
					continue;
				}
			if (soap_flag_searchQuery1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "searchQuery", &(a->gapi1__GoogleSearchResult::searchQuery), "xsd:string"))
				{	soap_flag_searchQuery1--;
					continue;
				}
			if (soap_flag_startIndex1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "startIndex", &(a->gapi1__GoogleSearchResult::startIndex), "xsd:int"))
				{	soap_flag_startIndex1--;
					continue;
				}
			if (soap_flag_endIndex1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "endIndex", &(a->gapi1__GoogleSearchResult::endIndex), "xsd:int"))
				{	soap_flag_endIndex1--;
					continue;
				}
			if (soap_flag_searchTips1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "searchTips", &(a->gapi1__GoogleSearchResult::searchTips), "xsd:string"))
				{	soap_flag_searchTips1--;
					continue;
				}
			if (soap_flag_directoryCategories1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTogapi1DirectoryCategoryArray(soap, "directoryCategories", &(a->gapi1__GoogleSearchResult::directoryCategories), "gapi1:DirectoryCategory"))
				{	soap_flag_directoryCategories1--;
					continue;
				}
			if (soap_flag_searchTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_double(soap, "searchTime", &(a->gapi1__GoogleSearchResult::searchTime), "xsd:double"))
				{	soap_flag_searchTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (gapi1__GoogleSearchResult *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__GoogleSearchResult, 0, sizeof(gapi1__GoogleSearchResult), 0, soap_copy_gapi1__GoogleSearchResult);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_documentFiltering1 > 0 || soap_flag_searchComments1 > 0 || soap_flag_estimatedTotalResultsCount1 > 0 || soap_flag_estimateIsExact1 > 0 || soap_flag_resultElements1 > 0 || soap_flag_searchQuery1 > 0 || soap_flag_startIndex1 > 0 || soap_flag_endIndex1 > 0 || soap_flag_searchTips1 > 0 || soap_flag_directoryCategories1 > 0 || soap_flag_searchTime1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 gapi1__GoogleSearchResult * SOAP_FMAC6 soap_new_gapi1__GoogleSearchResult(struct soap *soap, int n)
{	return soap_instantiate_gapi1__GoogleSearchResult(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__GoogleSearchResult(struct soap *soap, gapi1__GoogleSearchResult *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 gapi1__GoogleSearchResult * SOAP_FMAC4 soap_instantiate_gapi1__GoogleSearchResult(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__GoogleSearchResult(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__GoogleSearchResult, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new gapi1__GoogleSearchResult;
		if (size)
			*size = sizeof(gapi1__GoogleSearchResult);
		((gapi1__GoogleSearchResult*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new gapi1__GoogleSearchResult[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(gapi1__GoogleSearchResult);
		for (int i = 0; i < n; i++)
			((gapi1__GoogleSearchResult*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (gapi1__GoogleSearchResult*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__GoogleSearchResult(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying gapi1__GoogleSearchResult %p -> %p\n", q, p));
	*(gapi1__GoogleSearchResult*)p = *(gapi1__GoogleSearchResult*)q;
}

void xsd__base64Binary::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
	this->id = NULL;
	this->type = NULL;
	this->options = NULL;
}

void xsd__base64Binary::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_xsd__base64Binary))
		if (this->id || this->type)
			soap->mode |= SOAP_ENC_DIME;
}

int xsd__base64Binary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int xsd__base64Binary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_xsd__base64Binary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_xsd__base64Binary);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
#endif
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *xsd__base64Binary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_xsd__base64Binary(soap, this, tag, type);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *xsd__base64Binary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_xsd__base64Binary(soap, tag, this, type);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (xsd__base64Binary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(xsd__base64Binary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(xsd__base64Binary), 0, soap_copy_xsd__base64Binary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 xsd__base64Binary * SOAP_FMAC6 soap_new_xsd__base64Binary(struct soap *soap, int n)
{	return soap_instantiate_xsd__base64Binary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__base64Binary(struct soap *soap, xsd__base64Binary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 xsd__base64Binary * SOAP_FMAC4 soap_instantiate_xsd__base64Binary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__base64Binary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__base64Binary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new xsd__base64Binary;
		if (size)
			*size = sizeof(xsd__base64Binary);
		((xsd__base64Binary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new xsd__base64Binary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(xsd__base64Binary);
		for (int i = 0; i < n; i++)
			((xsd__base64Binary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (xsd__base64Binary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__base64Binary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying xsd__base64Binary %p -> %p\n", q, p));
	*(xsd__base64Binary*)p = *(xsd__base64Binary*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_gapi1__doGoogleSearch(struct soap *soap, struct gapi1__doGoogleSearch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_std__string(soap, &a->key);
	soap_default_std__string(soap, &a->q);
	soap_default_int(soap, &a->start);
	soap_default_int(soap, &a->maxResults);
	soap_default_bool(soap, &a->filter);
	soap_default_std__string(soap, &a->restrict_);
	soap_default_bool(soap, &a->safeSearch);
	soap_default_std__string(soap, &a->lr);
	soap_default_std__string(soap, &a->ie);
	soap_default_std__string(soap, &a->oe);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_gapi1__doGoogleSearch(struct soap *soap, const struct gapi1__doGoogleSearch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &a->key);
	soap_serialize_std__string(soap, &a->q);
	soap_serialize_std__string(soap, &a->restrict_);
	soap_serialize_std__string(soap, &a->lr);
	soap_serialize_std__string(soap, &a->ie);
	soap_serialize_std__string(soap, &a->oe);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_gapi1__doGoogleSearch(struct soap *soap, const struct gapi1__doGoogleSearch *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_gapi1__doGoogleSearch);
	if (soap_out_gapi1__doGoogleSearch(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__doGoogleSearch(struct soap *soap, const char *tag, int id, const struct gapi1__doGoogleSearch *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__doGoogleSearch), type);
	soap_out_std__string(soap, "key", -1, &a->key, "xsd:string");
	soap_out_std__string(soap, "q", -1, &a->q, "xsd:string");
	soap_out_int(soap, "start", -1, &a->start, "xsd:int");
	soap_out_int(soap, "maxResults", -1, &a->maxResults, "xsd:int");
	soap_out_bool(soap, "filter", -1, &a->filter, "xsd:boolean");
	soap_out_std__string(soap, "restrict", -1, &a->restrict_, "xsd:string");
	soap_out_bool(soap, "safeSearch", -1, &a->safeSearch, "xsd:boolean");
	soap_out_std__string(soap, "lr", -1, &a->lr, "xsd:string");
	soap_out_std__string(soap, "ie", -1, &a->ie, "xsd:string");
	soap_out_std__string(soap, "oe", -1, &a->oe, "xsd:string");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct gapi1__doGoogleSearch * SOAP_FMAC4 soap_get_gapi1__doGoogleSearch(struct soap *soap, struct gapi1__doGoogleSearch *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__doGoogleSearch(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct gapi1__doGoogleSearch * SOAP_FMAC4 soap_in_gapi1__doGoogleSearch(struct soap *soap, const char *tag, struct gapi1__doGoogleSearch *a, const char *type)
{
	short soap_flag_key = 1, soap_flag_q = 1, soap_flag_start = 1, soap_flag_maxResults = 1, soap_flag_filter = 1, soap_flag_restrict_ = 1, soap_flag_safeSearch = 1, soap_flag_lr = 1, soap_flag_ie = 1, soap_flag_oe = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct gapi1__doGoogleSearch *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__doGoogleSearch, sizeof(struct gapi1__doGoogleSearch), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_gapi1__doGoogleSearch(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "key", &a->key, "xsd:string"))
				{	soap_flag_key--;
					continue;
				}
			if (soap_flag_q && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "q", &a->q, "xsd:string"))
				{	soap_flag_q--;
					continue;
				}
			if (soap_flag_start && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "start", &a->start, "xsd:int"))
				{	soap_flag_start--;
					continue;
				}
			if (soap_flag_maxResults && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "maxResults", &a->maxResults, "xsd:int"))
				{	soap_flag_maxResults--;
					continue;
				}
			if (soap_flag_filter && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "filter", &a->filter, "xsd:boolean"))
				{	soap_flag_filter--;
					continue;
				}
			if (soap_flag_restrict_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "restrict", &a->restrict_, "xsd:string"))
				{	soap_flag_restrict_--;
					continue;
				}
			if (soap_flag_safeSearch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "safeSearch", &a->safeSearch, "xsd:boolean"))
				{	soap_flag_safeSearch--;
					continue;
				}
			if (soap_flag_lr && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "lr", &a->lr, "xsd:string"))
				{	soap_flag_lr--;
					continue;
				}
			if (soap_flag_ie && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ie", &a->ie, "xsd:string"))
				{	soap_flag_ie--;
					continue;
				}
			if (soap_flag_oe && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "oe", &a->oe, "xsd:string"))
				{	soap_flag_oe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct gapi1__doGoogleSearch *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__doGoogleSearch, 0, sizeof(struct gapi1__doGoogleSearch), 0, soap_copy_gapi1__doGoogleSearch);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key > 0 || soap_flag_q > 0 || soap_flag_start > 0 || soap_flag_maxResults > 0 || soap_flag_filter > 0 || soap_flag_restrict_ > 0 || soap_flag_safeSearch > 0 || soap_flag_lr > 0 || soap_flag_ie > 0 || soap_flag_oe > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct gapi1__doGoogleSearch * SOAP_FMAC6 soap_new_gapi1__doGoogleSearch(struct soap *soap, int n)
{	return soap_instantiate_gapi1__doGoogleSearch(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__doGoogleSearch(struct soap *soap, struct gapi1__doGoogleSearch *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct gapi1__doGoogleSearch * SOAP_FMAC4 soap_instantiate_gapi1__doGoogleSearch(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__doGoogleSearch(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__doGoogleSearch, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct gapi1__doGoogleSearch;
		if (size)
			*size = sizeof(struct gapi1__doGoogleSearch);
	}
	else
	{	cp->ptr = (void*)new struct gapi1__doGoogleSearch[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct gapi1__doGoogleSearch);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct gapi1__doGoogleSearch*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__doGoogleSearch(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct gapi1__doGoogleSearch %p -> %p\n", q, p));
	*(struct gapi1__doGoogleSearch*)p = *(struct gapi1__doGoogleSearch*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_gapi1__doGoogleSearchResponse(struct soap *soap, struct gapi1__doGoogleSearchResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->return_ = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_gapi1__doGoogleSearchResponse(struct soap *soap, const struct gapi1__doGoogleSearchResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTogapi1__GoogleSearchResult(soap, &a->return_);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_gapi1__doGoogleSearchResponse(struct soap *soap, const struct gapi1__doGoogleSearchResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_gapi1__doGoogleSearchResponse);
	if (soap_out_gapi1__doGoogleSearchResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__doGoogleSearchResponse(struct soap *soap, const char *tag, int id, const struct gapi1__doGoogleSearchResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__doGoogleSearchResponse), type);
	if (a->return_)
		soap_element_result(soap, "return");
	soap_out_PointerTogapi1__GoogleSearchResult(soap, "return", -1, &a->return_, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct gapi1__doGoogleSearchResponse * SOAP_FMAC4 soap_get_gapi1__doGoogleSearchResponse(struct soap *soap, struct gapi1__doGoogleSearchResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__doGoogleSearchResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct gapi1__doGoogleSearchResponse * SOAP_FMAC4 soap_in_gapi1__doGoogleSearchResponse(struct soap *soap, const char *tag, struct gapi1__doGoogleSearchResponse *a, const char *type)
{
	short soap_flag_return_ = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct gapi1__doGoogleSearchResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__doGoogleSearchResponse, sizeof(struct gapi1__doGoogleSearchResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_gapi1__doGoogleSearchResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTogapi1__GoogleSearchResult(soap, "return", &a->return_, "gapi1:GoogleSearchResult"))
				{	soap_flag_return_--;
					continue;
				}
			soap_check_result(soap, "return");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct gapi1__doGoogleSearchResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__doGoogleSearchResponse, 0, sizeof(struct gapi1__doGoogleSearchResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct gapi1__doGoogleSearchResponse * SOAP_FMAC6 soap_new_gapi1__doGoogleSearchResponse(struct soap *soap, int n)
{	return soap_instantiate_gapi1__doGoogleSearchResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__doGoogleSearchResponse(struct soap *soap, struct gapi1__doGoogleSearchResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct gapi1__doGoogleSearchResponse * SOAP_FMAC4 soap_instantiate_gapi1__doGoogleSearchResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__doGoogleSearchResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__doGoogleSearchResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct gapi1__doGoogleSearchResponse;
		if (size)
			*size = sizeof(struct gapi1__doGoogleSearchResponse);
	}
	else
	{	cp->ptr = (void*)new struct gapi1__doGoogleSearchResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct gapi1__doGoogleSearchResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct gapi1__doGoogleSearchResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__doGoogleSearchResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct gapi1__doGoogleSearchResponse %p -> %p\n", q, p));
	*(struct gapi1__doGoogleSearchResponse*)p = *(struct gapi1__doGoogleSearchResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_gapi1__doSpellingSuggestion(struct soap *soap, struct gapi1__doSpellingSuggestion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_std__string(soap, &a->key);
	soap_default_std__string(soap, &a->phrase);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_gapi1__doSpellingSuggestion(struct soap *soap, const struct gapi1__doSpellingSuggestion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &a->key);
	soap_serialize_std__string(soap, &a->phrase);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_gapi1__doSpellingSuggestion(struct soap *soap, const struct gapi1__doSpellingSuggestion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_gapi1__doSpellingSuggestion);
	if (soap_out_gapi1__doSpellingSuggestion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__doSpellingSuggestion(struct soap *soap, const char *tag, int id, const struct gapi1__doSpellingSuggestion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__doSpellingSuggestion), type);
	soap_out_std__string(soap, "key", -1, &a->key, "xsd:string");
	soap_out_std__string(soap, "phrase", -1, &a->phrase, "xsd:string");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct gapi1__doSpellingSuggestion * SOAP_FMAC4 soap_get_gapi1__doSpellingSuggestion(struct soap *soap, struct gapi1__doSpellingSuggestion *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__doSpellingSuggestion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct gapi1__doSpellingSuggestion * SOAP_FMAC4 soap_in_gapi1__doSpellingSuggestion(struct soap *soap, const char *tag, struct gapi1__doSpellingSuggestion *a, const char *type)
{
	short soap_flag_key = 1, soap_flag_phrase = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct gapi1__doSpellingSuggestion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__doSpellingSuggestion, sizeof(struct gapi1__doSpellingSuggestion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_gapi1__doSpellingSuggestion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "key", &a->key, "xsd:string"))
				{	soap_flag_key--;
					continue;
				}
			if (soap_flag_phrase && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "phrase", &a->phrase, "xsd:string"))
				{	soap_flag_phrase--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct gapi1__doSpellingSuggestion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__doSpellingSuggestion, 0, sizeof(struct gapi1__doSpellingSuggestion), 0, soap_copy_gapi1__doSpellingSuggestion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key > 0 || soap_flag_phrase > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct gapi1__doSpellingSuggestion * SOAP_FMAC6 soap_new_gapi1__doSpellingSuggestion(struct soap *soap, int n)
{	return soap_instantiate_gapi1__doSpellingSuggestion(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__doSpellingSuggestion(struct soap *soap, struct gapi1__doSpellingSuggestion *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct gapi1__doSpellingSuggestion * SOAP_FMAC4 soap_instantiate_gapi1__doSpellingSuggestion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__doSpellingSuggestion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__doSpellingSuggestion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct gapi1__doSpellingSuggestion;
		if (size)
			*size = sizeof(struct gapi1__doSpellingSuggestion);
	}
	else
	{	cp->ptr = (void*)new struct gapi1__doSpellingSuggestion[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct gapi1__doSpellingSuggestion);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct gapi1__doSpellingSuggestion*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__doSpellingSuggestion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct gapi1__doSpellingSuggestion %p -> %p\n", q, p));
	*(struct gapi1__doSpellingSuggestion*)p = *(struct gapi1__doSpellingSuggestion*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_gapi1__doSpellingSuggestionResponse(struct soap *soap, struct gapi1__doSpellingSuggestionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_std__string(soap, &a->return_);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_gapi1__doSpellingSuggestionResponse(struct soap *soap, const struct gapi1__doSpellingSuggestionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &a->return_);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_gapi1__doSpellingSuggestionResponse(struct soap *soap, const struct gapi1__doSpellingSuggestionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_gapi1__doSpellingSuggestionResponse);
	if (soap_out_gapi1__doSpellingSuggestionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__doSpellingSuggestionResponse(struct soap *soap, const char *tag, int id, const struct gapi1__doSpellingSuggestionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__doSpellingSuggestionResponse), type);
	soap_element_result(soap, "return");
	soap_out_std__string(soap, "return", -1, &a->return_, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct gapi1__doSpellingSuggestionResponse * SOAP_FMAC4 soap_get_gapi1__doSpellingSuggestionResponse(struct soap *soap, struct gapi1__doSpellingSuggestionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__doSpellingSuggestionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct gapi1__doSpellingSuggestionResponse * SOAP_FMAC4 soap_in_gapi1__doSpellingSuggestionResponse(struct soap *soap, const char *tag, struct gapi1__doSpellingSuggestionResponse *a, const char *type)
{
	short soap_flag_return_ = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct gapi1__doSpellingSuggestionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__doSpellingSuggestionResponse, sizeof(struct gapi1__doSpellingSuggestionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_gapi1__doSpellingSuggestionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_return_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "return", &a->return_, "xsd:string"))
				{	soap_flag_return_--;
					continue;
				}
			soap_check_result(soap, "return");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct gapi1__doSpellingSuggestionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__doSpellingSuggestionResponse, 0, sizeof(struct gapi1__doSpellingSuggestionResponse), 0, soap_copy_gapi1__doSpellingSuggestionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_return_ > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct gapi1__doSpellingSuggestionResponse * SOAP_FMAC6 soap_new_gapi1__doSpellingSuggestionResponse(struct soap *soap, int n)
{	return soap_instantiate_gapi1__doSpellingSuggestionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__doSpellingSuggestionResponse(struct soap *soap, struct gapi1__doSpellingSuggestionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct gapi1__doSpellingSuggestionResponse * SOAP_FMAC4 soap_instantiate_gapi1__doSpellingSuggestionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__doSpellingSuggestionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__doSpellingSuggestionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct gapi1__doSpellingSuggestionResponse;
		if (size)
			*size = sizeof(struct gapi1__doSpellingSuggestionResponse);
	}
	else
	{	cp->ptr = (void*)new struct gapi1__doSpellingSuggestionResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct gapi1__doSpellingSuggestionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct gapi1__doSpellingSuggestionResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__doSpellingSuggestionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct gapi1__doSpellingSuggestionResponse %p -> %p\n", q, p));
	*(struct gapi1__doSpellingSuggestionResponse*)p = *(struct gapi1__doSpellingSuggestionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_gapi1__doGetCachedPage(struct soap *soap, struct gapi1__doGetCachedPage *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_std__string(soap, &a->key);
	soap_default_std__string(soap, &a->url);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_gapi1__doGetCachedPage(struct soap *soap, const struct gapi1__doGetCachedPage *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_std__string(soap, &a->key);
	soap_serialize_std__string(soap, &a->url);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_gapi1__doGetCachedPage(struct soap *soap, const struct gapi1__doGetCachedPage *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_gapi1__doGetCachedPage);
	if (soap_out_gapi1__doGetCachedPage(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__doGetCachedPage(struct soap *soap, const char *tag, int id, const struct gapi1__doGetCachedPage *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__doGetCachedPage), type);
	soap_out_std__string(soap, "key", -1, &a->key, "xsd:string");
	soap_out_std__string(soap, "url", -1, &a->url, "xsd:string");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct gapi1__doGetCachedPage * SOAP_FMAC4 soap_get_gapi1__doGetCachedPage(struct soap *soap, struct gapi1__doGetCachedPage *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__doGetCachedPage(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct gapi1__doGetCachedPage * SOAP_FMAC4 soap_in_gapi1__doGetCachedPage(struct soap *soap, const char *tag, struct gapi1__doGetCachedPage *a, const char *type)
{
	short soap_flag_key = 1, soap_flag_url = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct gapi1__doGetCachedPage *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__doGetCachedPage, sizeof(struct gapi1__doGetCachedPage), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_gapi1__doGetCachedPage(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "key", &a->key, "xsd:string"))
				{	soap_flag_key--;
					continue;
				}
			if (soap_flag_url && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "url", &a->url, "xsd:string"))
				{	soap_flag_url--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct gapi1__doGetCachedPage *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__doGetCachedPage, 0, sizeof(struct gapi1__doGetCachedPage), 0, soap_copy_gapi1__doGetCachedPage);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key > 0 || soap_flag_url > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct gapi1__doGetCachedPage * SOAP_FMAC6 soap_new_gapi1__doGetCachedPage(struct soap *soap, int n)
{	return soap_instantiate_gapi1__doGetCachedPage(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__doGetCachedPage(struct soap *soap, struct gapi1__doGetCachedPage *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct gapi1__doGetCachedPage * SOAP_FMAC4 soap_instantiate_gapi1__doGetCachedPage(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__doGetCachedPage(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__doGetCachedPage, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct gapi1__doGetCachedPage;
		if (size)
			*size = sizeof(struct gapi1__doGetCachedPage);
	}
	else
	{	cp->ptr = (void*)new struct gapi1__doGetCachedPage[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct gapi1__doGetCachedPage);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct gapi1__doGetCachedPage*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__doGetCachedPage(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct gapi1__doGetCachedPage %p -> %p\n", q, p));
	*(struct gapi1__doGetCachedPage*)p = *(struct gapi1__doGetCachedPage*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_gapi1__doGetCachedPageResponse(struct soap *soap, struct gapi1__doGetCachedPageResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->return_.xsd__base64Binary::soap_default(soap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_gapi1__doGetCachedPageResponse(struct soap *soap, const struct gapi1__doGetCachedPageResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->return_.soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_gapi1__doGetCachedPageResponse(struct soap *soap, const struct gapi1__doGetCachedPageResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_gapi1__doGetCachedPageResponse);
	if (soap_out_gapi1__doGetCachedPageResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_gapi1__doGetCachedPageResponse(struct soap *soap, const char *tag, int id, const struct gapi1__doGetCachedPageResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_gapi1__doGetCachedPageResponse), type);
	soap_element_result(soap, "return");
	a->return_.soap_out(soap, "return", -1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct gapi1__doGetCachedPageResponse * SOAP_FMAC4 soap_get_gapi1__doGetCachedPageResponse(struct soap *soap, struct gapi1__doGetCachedPageResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_gapi1__doGetCachedPageResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct gapi1__doGetCachedPageResponse * SOAP_FMAC4 soap_in_gapi1__doGetCachedPageResponse(struct soap *soap, const char *tag, struct gapi1__doGetCachedPageResponse *a, const char *type)
{
	short soap_flag_return_ = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct gapi1__doGetCachedPageResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_gapi1__doGetCachedPageResponse, sizeof(struct gapi1__doGetCachedPageResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_gapi1__doGetCachedPageResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
				if (a->return_.soap_in(soap, "return", "xsd:base64Binary"))
				{	soap_flag_return_--;
					continue;
				}
			soap_check_result(soap, "return");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct gapi1__doGetCachedPageResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_gapi1__doGetCachedPageResponse, 0, sizeof(struct gapi1__doGetCachedPageResponse), 0, soap_copy_gapi1__doGetCachedPageResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_return_ > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct gapi1__doGetCachedPageResponse * SOAP_FMAC6 soap_new_gapi1__doGetCachedPageResponse(struct soap *soap, int n)
{	return soap_instantiate_gapi1__doGetCachedPageResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_gapi1__doGetCachedPageResponse(struct soap *soap, struct gapi1__doGetCachedPageResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct gapi1__doGetCachedPageResponse * SOAP_FMAC4 soap_instantiate_gapi1__doGetCachedPageResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_gapi1__doGetCachedPageResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_gapi1__doGetCachedPageResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct gapi1__doGetCachedPageResponse;
		if (size)
			*size = sizeof(struct gapi1__doGetCachedPageResponse);
	}
	else
	{	cp->ptr = (void*)new struct gapi1__doGetCachedPageResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct gapi1__doGetCachedPageResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct gapi1__doGetCachedPageResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_gapi1__doGetCachedPageResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct gapi1__doGetCachedPageResponse %p -> %p\n", q, p));
	*(struct gapi1__doGetCachedPageResponse*)p = *(struct gapi1__doGetCachedPageResponse*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTogapi1__GoogleSearchResult(struct soap *soap, gapi1__GoogleSearchResult *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_gapi1__GoogleSearchResult))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTogapi1__GoogleSearchResult(struct soap *soap, gapi1__GoogleSearchResult *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTogapi1__GoogleSearchResult);
	if (soap_out_PointerTogapi1__GoogleSearchResult(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTogapi1__GoogleSearchResult(struct soap *soap, const char *tag, int id, gapi1__GoogleSearchResult *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_gapi1__GoogleSearchResult);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 gapi1__GoogleSearchResult ** SOAP_FMAC4 soap_get_PointerTogapi1__GoogleSearchResult(struct soap *soap, gapi1__GoogleSearchResult **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTogapi1__GoogleSearchResult(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1__GoogleSearchResult ** SOAP_FMAC4 soap_in_PointerTogapi1__GoogleSearchResult(struct soap *soap, const char *tag, gapi1__GoogleSearchResult **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1__GoogleSearchResult **)soap_malloc(soap, sizeof(gapi1__GoogleSearchResult *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (gapi1__GoogleSearchResult *)soap_instantiate_gapi1__GoogleSearchResult(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (gapi1__GoogleSearchResult **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_gapi1__GoogleSearchResult, sizeof(gapi1__GoogleSearchResult), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTogapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTogapi1__DirectoryCategory))
		soap_serialize_PointerTogapi1__DirectoryCategory(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTogapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTogapi1__DirectoryCategory);
	if (soap_out_PointerToPointerTogapi1__DirectoryCategory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTogapi1__DirectoryCategory(struct soap *soap, const char *tag, int id, gapi1__DirectoryCategory **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTogapi1__DirectoryCategory);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTogapi1__DirectoryCategory(soap, tag, id, *a, type);
}

SOAP_FMAC3 gapi1__DirectoryCategory *** SOAP_FMAC4 soap_get_PointerToPointerTogapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTogapi1__DirectoryCategory(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1__DirectoryCategory *** SOAP_FMAC4 soap_in_PointerToPointerTogapi1__DirectoryCategory(struct soap *soap, const char *tag, gapi1__DirectoryCategory ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1__DirectoryCategory ***)soap_malloc(soap, sizeof(gapi1__DirectoryCategory **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTogapi1__DirectoryCategory(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (gapi1__DirectoryCategory ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTogapi1__DirectoryCategory, sizeof(gapi1__DirectoryCategory *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTogapi1__ResultElement(struct soap *soap, gapi1__ResultElement **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTogapi1__ResultElement))
		soap_serialize_PointerTogapi1__ResultElement(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTogapi1__ResultElement(struct soap *soap, gapi1__ResultElement **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTogapi1__ResultElement);
	if (soap_out_PointerToPointerTogapi1__ResultElement(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTogapi1__ResultElement(struct soap *soap, const char *tag, int id, gapi1__ResultElement **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTogapi1__ResultElement);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTogapi1__ResultElement(soap, tag, id, *a, type);
}

SOAP_FMAC3 gapi1__ResultElement *** SOAP_FMAC4 soap_get_PointerToPointerTogapi1__ResultElement(struct soap *soap, gapi1__ResultElement ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTogapi1__ResultElement(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1__ResultElement *** SOAP_FMAC4 soap_in_PointerToPointerTogapi1__ResultElement(struct soap *soap, const char *tag, gapi1__ResultElement ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1__ResultElement ***)soap_malloc(soap, sizeof(gapi1__ResultElement **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTogapi1__ResultElement(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (gapi1__ResultElement ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTogapi1__ResultElement, sizeof(gapi1__ResultElement *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTogapi1__ResultElement(struct soap *soap, gapi1__ResultElement *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_gapi1__ResultElement))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTogapi1__ResultElement(struct soap *soap, gapi1__ResultElement *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTogapi1__ResultElement);
	if (soap_out_PointerTogapi1__ResultElement(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTogapi1__ResultElement(struct soap *soap, const char *tag, int id, gapi1__ResultElement *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_gapi1__ResultElement);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 gapi1__ResultElement ** SOAP_FMAC4 soap_get_PointerTogapi1__ResultElement(struct soap *soap, gapi1__ResultElement **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTogapi1__ResultElement(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1__ResultElement ** SOAP_FMAC4 soap_in_PointerTogapi1__ResultElement(struct soap *soap, const char *tag, gapi1__ResultElement **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1__ResultElement **)soap_malloc(soap, sizeof(gapi1__ResultElement *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (gapi1__ResultElement *)soap_instantiate_gapi1__ResultElement(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (gapi1__ResultElement **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_gapi1__ResultElement, sizeof(gapi1__ResultElement), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTogapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_gapi1__DirectoryCategory))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTogapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTogapi1__DirectoryCategory);
	if (soap_out_PointerTogapi1__DirectoryCategory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTogapi1__DirectoryCategory(struct soap *soap, const char *tag, int id, gapi1__DirectoryCategory *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_gapi1__DirectoryCategory);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 gapi1__DirectoryCategory ** SOAP_FMAC4 soap_get_PointerTogapi1__DirectoryCategory(struct soap *soap, gapi1__DirectoryCategory **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTogapi1__DirectoryCategory(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1__DirectoryCategory ** SOAP_FMAC4 soap_in_PointerTogapi1__DirectoryCategory(struct soap *soap, const char *tag, gapi1__DirectoryCategory **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1__DirectoryCategory **)soap_malloc(soap, sizeof(gapi1__DirectoryCategory *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (gapi1__DirectoryCategory *)soap_instantiate_gapi1__DirectoryCategory(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (gapi1__DirectoryCategory **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_gapi1__DirectoryCategory, sizeof(gapi1__DirectoryCategory), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTogapi1DirectoryCategoryArray(struct soap *soap, gapi1DirectoryCategoryArray *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTogapi1DirectoryCategoryArray(struct soap *soap, gapi1DirectoryCategoryArray *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTogapi1DirectoryCategoryArray);
	if (soap_out_PointerTogapi1DirectoryCategoryArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTogapi1DirectoryCategoryArray(struct soap *soap, const char *tag, int id, gapi1DirectoryCategoryArray *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_gapi1DirectoryCategoryArray);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 gapi1DirectoryCategoryArray ** SOAP_FMAC4 soap_get_PointerTogapi1DirectoryCategoryArray(struct soap *soap, gapi1DirectoryCategoryArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTogapi1DirectoryCategoryArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1DirectoryCategoryArray ** SOAP_FMAC4 soap_in_PointerTogapi1DirectoryCategoryArray(struct soap *soap, const char *tag, gapi1DirectoryCategoryArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1DirectoryCategoryArray **)soap_malloc(soap, sizeof(gapi1DirectoryCategoryArray *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (gapi1DirectoryCategoryArray *)soap_instantiate_gapi1DirectoryCategoryArray(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (gapi1DirectoryCategoryArray **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_gapi1DirectoryCategoryArray, sizeof(gapi1DirectoryCategoryArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTogapi1ResultElementArray(struct soap *soap, gapi1ResultElementArray *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTogapi1ResultElementArray(struct soap *soap, gapi1ResultElementArray *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTogapi1ResultElementArray);
	if (soap_out_PointerTogapi1ResultElementArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTogapi1ResultElementArray(struct soap *soap, const char *tag, int id, gapi1ResultElementArray *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_gapi1ResultElementArray);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 gapi1ResultElementArray ** SOAP_FMAC4 soap_get_PointerTogapi1ResultElementArray(struct soap *soap, gapi1ResultElementArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTogapi1ResultElementArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 gapi1ResultElementArray ** SOAP_FMAC4 soap_in_PointerTogapi1ResultElementArray(struct soap *soap, const char *tag, gapi1ResultElementArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (gapi1ResultElementArray **)soap_malloc(soap, sizeof(gapi1ResultElementArray *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (gapi1ResultElementArray *)soap_instantiate_gapi1ResultElementArray(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (gapi1ResultElementArray **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_gapi1ResultElementArray, sizeof(gapi1ResultElementArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

/* End of GAPIC.cpp */
