<?php
/**
 * Hungarian Language file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  István Pető and Gábor Hrotkó
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author István Pető
 * @author Gábor Hrotkó
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.hu.php 981 2007-03-21 13:24:38Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "You cannot access a language file directly.";
	exit;
}


//-- GENERAL
$pgv_lang["help_header"]			= "Általános tudnivalók:";
$pgv_lang["privacy_error_help"]			= "~Bizalmas adatok~<br/><br/>Ön számos eltérő okból olvashatja ezt az üzenetet:<br/><br/><b>1. Ön nem regisztrált tagja az oldalnak</b><br/>Ebben a GEDCOM-állományban az élő személyekre vonatkozó adatokat bizalmasan kezeljük. A nem regisztrált látogatók, illetve akik nem jelentkeztek be csak az elhunytak személyes adatait tekinthetik meg. A regisztrációhoz először kattintson a Belépés, majd az #pgv_lang[requestpassword]# hivatkozásra.<br/><br/><b>2. Ön rendelkezik felhasználónévvel és jelszóval...</b><br/>Ez esetben Ön nem jelentkezett be vagy inaktív volt egy ideig és lejárt a munkamenete.<br/><br/><b>3. Az érintett adat jellege \"Diszkrét\"</b><br/>A személy, akinek Ön a nevére kattintott azt kérte az adminisztrátortól, hogy adatait diszkrét módon kezeljék.<br/>Ezekben az esetekben a személyes adatokhoz csak az adminisztrátorok férhetnek hozzá.<br/><br/><b>4. Ön kívül esik a \"Rokonsági útvonalon\"</b><br/>Bizonyos esetekben előfordulhat - még akkor is, ha ön rendes tag <b>és</b> be is jelentkezett -, hogy ezt az üzenetet kapja: ekkor az érintett személy túl távoli rokona Önnek. Ezt az oldal adminisztrátora határozza meg az adott GEDCOM-ra vonatkozóan (Rokonsági fok maximlás nagysága). <br/>Példák:<br/>Ha a Rokonsági fok maximális nagysága <b>1</b>, Ön csak a közvetlen családjának - apa, anya, testvérek - adatait láthatja (de a házastársakat, a testvérek gyermekeit már nem) <br/><br/>Ha a Rokonsági fok maximális nagysága <b>2</b>, akkor Ön már láthatja a testvérei házastársának és az ő gyermekeinek adatait (de a gyermekek házastársait már nem).<br/>Minél magasabb a Rokonsági fok maximális nagysága, annál távolabbi rokonokat láthat Ön<br/><br/>Ha Ön úgy gondolja, hogy bizonyos adatokhoz hozzáférhet, a lapok oldalán lévő hivatkozáson át lépjen kapcsolatba az adminisztrátorral.<br/><br/>";
$pgv_lang["more_help"]				= "<br/>Ha szeretné, hogy a környezetérzékeny segítség elérhető legyen, győződjön meg arról, hogy a <b>#pgv_lang[show_context_help]#</b> (a Segítség menüben) be van kapcsolva, és kattintson az érintett elem mögötti <b>?</b>-re.<br/><br/>";
$pgv_lang["more_config_help"]			= "<br/><b>Bővebb információ</b><br/>#pgv_lang[context_help]#<br/><br/>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>ÁLTALÁNOS INFORMÁCIÓ</b></center></div><br/>";
$pgv_lang["best_display_help"]			= "~Az Én Képernyőm~<br/>A PhpGedView használatának optimális képernyő-felbontása 1024x768.<br/>Ahhoz, hogy minden elem teljesen látható legyen, Önnek legalább ekkora felbontást kell beállítania.<br/>Amennyiben alacsonyabb felbontást alkalmaz (pl. 800x600), vízszintesen kell majd görgetnie a képernyőt.<br/><br/>";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br/>A Nyomtatható változat hivatkozásra kattintva minden olyan elem eltüntethető a képernyőről, melyek kinyomtatva nem mutatnak jól (menüpontok, \"beviteli mezők\", \"fölösleges\" hivatkozások, kérdőjelek a környezetérzékeny segítséghez stb).<br/><br/>Az így létrejövő oldalon a lap alján megtalálhatja a Nyomtatás hivatkozást, melyre rákattintva elérheti nyomtatója párbeszédpaneljét. Nyomtatás után kattintson a <b>Vissza</b> hivatkozásra, és visszakerül a kiinduló oldalra.<br/><br/>Megjegyzés: Bár a \"Nyomtatható változatból\" sok hivatkozás eltávolításra kerül, a megmaradók továbbra is kattinthatók.<br/><br/>";
$pgv_lang["readme_help"]			= "<center>További információért olvassa el a <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> állományt.</center>";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~NYITÓOLDAL~<br/><br/>Ez a lap a Nyitóoldal, mely fogadja Önt a kiválasztott <a href=\"#def_gedcom\">GEDCOM</a> állományban. Ön bármikor visszatérhet ide a felső menüsorban található Nyitóoldal ikon segítségével. Ha az oldal több GEDCOM-állománnyal dolgozik, Ön egy lenyíló menüből választhatja ki a látni kívánt GEDCOM-ot.<br/><br/>Ez a segéd oldal tartalma:<ul><li><a href=\"#index_portal\"><b>Nyitóoldal</b></a><li><a href=\"#header\"><b>Fejléc</b></a><li><a href=\"#menu\"><b>Menük</b></a><li><a href=\"#header_general\"><b>Általános információk</b></a><li><a href=\"#def\"><b>Definicciók</b></a></ul><br/>";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>FEJLÉC</b></center></div><br/>A Fejléc megjelenik minden oldal tetején:<br/>számos, az oldalon való navigációt segítő hivatkozást tartalmaz.<br/>Mivel az oldal megjelenése a kiválasztott Asztaltéma#pgv_lang[redast]# függvényében eltérő lehet, ezek a fejlécet is érinthetik, így a hivatkozások is eltérőek lehetnek.<br/>Az itt található hivatkozások a következők:<br/>";
$pgv_lang["header_search_help"]			= "~Fejléc: Kereső-mező~<br/>Amilyen kicsi a kereső-mező, olyan hatékony.<br/>Ön majdnem bármilyen keresést elvégezhet a segítségével a PhpGedView-oldon. Amint Ön a ' <b>&gt;</b>'-ra vagy a <b>Keresés</b> gombra kattint, átirányítjuk a keresés főoldalára, ahol megtekintheti a találati listát.<br/>A keresésről annak főoldalán kaphat átfogóbb segítséget.<br/><br/>";
$pgv_lang["header_lang_select_help"]		= "~Fejléc: Nyelvválasztás~<br/>A PhpGedView egyik legfontosabb szolgáltatása a többnyelvűség támogatása, illetve a nyelvek közötti automatikus - a böngésző-beállítástól függő - választás.<br/>Ha ez a választás nem történik meg automatikusan (melyet valószínűleg az \"Előnyben részesített nyelv\" helytelen böngésző-beállítása okozhatja), Ön módosíthatja az oldal nyelvét a <b>Nyelvválasztás</b> segítségével.<br/>A Nyelvválasztás két módon jeleníthető meg:<br/>1. Klasszikus  \"lenyíló\" listában.<br/>2. A nemzeti zászlók segítségével.<br/>";
$pgv_lang["header_user_links_help"]		= "~Fejléc: Felhasználói hivatkozások~<br/>A hivatkozások kis csoportja, melyet a felhasználó minden oldalon ugyanott találhat (amíg meg nem változtatja az Asztaltémát).<br/>Ha Ön még nem jelentkezett be, kizárólag a  <b>Belépés</b> hivatkozást láthatja.<br/>Miután belépett, a következőket találja it:  <b>Bejelentkezve, mint (az Ön neve)</b>. Erre kattintva az Ön felhasználói adataihoz juthat.<br/>A <b>Kilépés</b> hivatkozással jelentkezhet ki.<br/>Ha Önnek vannak adminisztrátori jogosultságai, akkor szintén itt találja az <b>Adminisztráció</b> hivatkozását. Erre kattintva közvetlenül az Adminisztráció nyitólapjára juthat.<br/>";
$pgv_lang["header_favorites_help"]		= "~Fejléc: Kedvenceim~<br/>A Kedvenceim lenyíló-listája az Ön által a személyes oldalon kiválasztott Kedvenceket tünteti föl. Szintén itt láthatók az oldal adminisztrátora által az aktív GEDCOM-állományból kiválasztott személyeket.<br/>Az egyik Kedvencere kattintva közvetlenül elérhető az adott Személyes adatlap.<br/>Kedvencek hozzáadásáról további segítséget kaphat az Ön személyes oldalán.<br/><br/>";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class=\"name_head\"><center><b>MENÜPONTOK</b></center></div><br/>Az oldalak fejlécében (lenyíló) menüpontokat találhat.<br/><br/>A kurzor ikon fölé mozgatásával így elérheti az almenüket. A menüpontok ikonjára kattintva az almenüpontok közül az első helyen álló oldalra juthat.<br/><br/>Ön a következő fő menüpontok közül választhat:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br/><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br/><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br/><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br/><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br/><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br/><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br/><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></ul><br/>";
$pgv_lang["menu_famtree_help"]			= "~Nyitólap~<br/>Ön az oldalon elérhető összes GEDCOM-állomány közül választhat ezen a helyen. Minden GEDCOM-állománynak van egy ehhez hasonló egyéni Nyitóoldala. Ha az oldalon csak egy GEDCOM-állomány található, természetesen almenük nem érhetők el a Nyitóoldal ikonján keresztül.<br/><br/>";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]# menü~<br/>Ha Ön bejelentkezett, ezen menüpontban a következő elemeket találja meg: <ol><li>#pgv_lang[mygedview]#<br/>Elvezeti Önt az Ön \"kezdőlapjára\".</li><br/><li>#pgv_lang[editowndata]#<br/>Itt szerkesztheti az Ön személyes felhasználói beállításait.</li><br/><li>#pgv_lang[my_pedigree]#<br/>Ha Ön kiválasztotta a kezdő személyt ehhez a GEDCOM-állományhoz, ez a hivatkozás ennek a személynek az ősfájához fogja irányítani.</li><br/><li>#pgv_lang[my_indi]#<br/>Átirányítja Önt az Ön #pgv_lang[indi_info]# oldalára, ahol az Önre és családjára vontkozó genealógiai adatok találhatók.</li></ol><br/>";
$pgv_lang["menu_charts_help"]			= "~Grafikonok~<br/>Az összes működő grafikon érhető el erről a menüpontról:<dl><dt>Ősfa</dt><dd>Az aktuális GEDCOM-állomány ősfája, melynek kezdő személye lehet Ön (ha bejelentkezett), illetve egy Ön által kiválasztott személy.</dd><dt>Leszármazottak</dt><dd>A leszrámazottak fája többé-kevésbbé megfelel egy fordított ősfának.<br/>Az összehasonlítás összességében megállja a helyét, de amíg az ősfa egy adott személy őseit mutatja meg, addig a leszármazottak fája egy szemléy leszármazottait tünteti fel. </dd><dt>Kronológiai</dt><dd>Ezen az oldalon egy adott személy életének eseményeit mutatjuk be az idő múlásával. <br/>Tanulságos lehet két vagy több személy életét egymás mellett látni.</dd><dt>Rokonsági fok</dt><dd>Itt egy személynek Önhöz vagy egy másik személyhez fűződő rokonsági kapcsolatát ismerheti meg.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Listák~<br/>Ezen menüponton keresztül a következő listák jeleníthetők meg: <dl><dt>Személyek litája</dt><dt>Családok listája</dt><dd>Eben a két listában az aktuális GEDCOM-állomány személyeinek listáját találhatja.<br/>Az első a személyeket, a második a családokat tünteti fel.</dd><dt>Források listája</dt><dd>Itt a GEDCOM-állományban szereplő összes forrást tekintheti meg. </dd><dt>Helyszínek hierarchiája</dt><dd>Itt a helyszínek alapján kereshet meg személyeket. Egy két oszlopos listát kap, melyből a bal oldalon találja a személyekhez, a jobb oldalon pedig a családokhoz kötődő helyeket.</dd><dt>Multimédia lista</dt><dd>Ezt a menüpontot csak az adminisztrátor engedélyével láthatja. <br/>Az összes multimédia-állomány listáját tartalmazza, melyek az aktuális GEDCOM-hoz tartoznak. </dd></dl>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]# menü~<br/>Az #pgv_lang[anniversary_calendar]# a kiválasztott dátumhoz tartozó eseményeket tünteti fel az adott napon, hónapban vagy évben.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br/>Ezek a menük tovább viszik önt a #pgv_lang[anniversary_calendar]# hogy feltüntessék az összes eseményt az adott napon, hónapban vagy évben.</li></ol><br/>";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]# menü~<br/>Ön csak abban az esetben látja ezt a menüpontot, ha az adott GEDCOM-állományra vonatkozóan engedélyezet az adminisztrátor.<br/><br/>A #pgv_lang[clip_cart]# lehetővé teszi, hogy Ön \"darabokat\" vágjon le a családfából.<br/><br/>";
$pgv_lang["menu_search_help"]			= "~Keresés menü~<br/>A fejlécben található keresőmező részletesebb változata.<br/><br/>";
$pgv_lang["menu_help_help"]			= "~Segítség menü~<br/>#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>NYITÓOLDAL</b></center></div><br/>";
$pgv_lang["index_welcome_help"]			= "~FELHASZNÁLÓ ÜDVÖZLŐ BLOKK~<br/>Ez a blokk a következőket közli:<br/>Az aktuális GEDCOM-állomány, a dátum és az idő (ha az adminisztrátor engedélyezte) és a <b>Számláló</b>.<br/>A számláló kizárólag a Nyitóoldalon illetve a személyi lapokon tüntethető fel. <br/>A számláló az adott oldalt érintő \"találatokat\" rögzíti, vagyis azt, hogy az oldalt hányszor látogatták meg.<br/>Nem ellenőrzi a látogató URL-jét, tehzát ha valaki visszatér az oldara, azt új találatként értelmezi. <br/>";
$pgv_lang["index_login_help"]			= "~BEJELENTKEZŐ BLOKK~<br/>Bár Ön majdnem az összes oldalon be tud jelentkezni, leggyakrabban mégis a nyitóoldalon teszi ezt meg, mivel csak ezután kaphat jogosultásgot bizonyos adatok megtekintéséhez.<br/>A <b>felhasználónév</b> és a <b>jelszó</b> begépelésével valamint a Belépés gombra való kattintással tud bejelentkezni.<br/><br/>#pgv_lang[new_password_help]#<br/><br/>";
$pgv_lang["index_events_help"]			= "~ELKÖVETKEZŐ ESEMÉNYEK BLOKK~<br/>Ez a blokk az érintett GEDCOM-ból származó, a következő hónapban aktuális eseményeket tünteti fel.<br/><br/>";
$pgv_lang["index_onthisday_help"]		= "~A MAI NAPON AZ ÖN MÚLTJÁBÓL... BLOKK~<br/>Ez a blokk hasonlóan működik, mint az  \"Elkövetkező események\" blokk, viszont csak a mai napot érintő eseményeket tünteti fel.<br/>";
$pgv_lang["index_favorites_help"]		= "~GEDCOM KEDVENCEK BLOKK~<br/>A GEDCOM Kedvencek sokban hasonlít a MyGedView Portálon található \"Kedvenceim\" blokkra azzal a különbséggel, hogy ez esetben az adminisztrátornak van joga felvenni, törölni vagy megváltoztatni a kedvenceket.<br/>A blokk szerepe, hogy a látogatók figyelmét felhívja a különleges érdeklődésre számot tartó személy(ek)re. <br/>A \"GEDCOM kedvencek\" minden oldal fejlécében, egy lenyílóból érhetők el.<br/>Az ott található hivatkozások az adott személy adatlapjára mutatnak.<br/><br/>Helykímélés miatt a szövegdobozok minimális információt hordoznak, a cellák jobb oldalán található nagyító segítsgével juthat több adathoz.<br/>A személy nevére kattintva Ön eljuthat az illető személyi lapjához. <br/>Szintén a jobb oldalon találhatja a menüt, melyen bővebb infomációt vagy grafikonokat tartalmazó oldalakra vezető hivatkozásokat találhat.<br/>";
$pgv_lang["index_stats_help"]			= "~GEDCOM STATISZTIKA BLOKK~<br/>Ebben a blokkban az aktuális GEDCOM-állományra vontakozó legfontosabb statisztikai adatokat találhatja. <br/>Ha Ön több információra kíváncsi, a lap alján találhat lehetőséget a kapcsolat felvételére.<br/><br/>#pgv_lang[index_common_names_help]#";
$pgv_lang["index_common_names_help"]		= "~LEGYAKORIBB VEZETÉKNEVEK BLOKK~<br/>A GEDCOM-állományban legtöbbet előforduló vezetéknevek láthatók ebben a blokkban. A feltüntetett nevek számát az adminisztrátor szabja meg. <br/><br/>A nevek természetesen kattinthatóak, így bővebben tájékozódhat az adott személyről az #pgv_lang[individual_list]# útján.<br/>";
$pgv_lang["index_media_help"]			= "~VÉLETLEN MÉDIA BLOKK~<br/>Ebben a blokkban a PhpGedView minden az Ön látogatásakor egy véletlenszerűen kiválasztott média-elemet jelenít meg.<br/>A képre vagy a címére kattintva megtekintheti a teljes méretű változatot. <br/>A kép alatt ezen kívül talál még egy hivatkozást az ábrázolt személy adatlapjához.<br/>";
$pgv_lang["index_loggedin_help"]		= "~BEJELENTLKEZETT FELHASZNÁLÓK BLOKK~<br/>Ezen a helyen Ön nyomonkövetheti a bejelentkezett felhasználók számát.<br/>";
$pgv_lang["index_gedcom_news_help"]		= "~GEDCOM HÍREK BLOKK~<br/>A Hírek blokkja leginkább egy hirdetőtáblára hasonlít.<br/>Az oldal admnisztrátora fontos bejelentéseket vagy érdekes híreket tehet itt közzé.<br/><br/>Ha Önnek van valamilyen közérdekű, érdekes híre, küldje el az adminisztrátornak, aki felrakja azt a hirdetőtáblára.<br/><br/>";
$pgv_lang["index_gedcom_news_adm_help"]		= "A GEDCOM Hírek blokkja lehetővé teszi <b>HTML-kódok</b> használatát.<br/>Kérjük, ügyeljen a nyitó- és záróelemek következetes használatára. <br/>Ez esetben szükséges lehet a HTML-nyelv megfelelő szintű ismerete. <br/><br/>Ez a program emellett <b>stíluslapokat (CSS)</b> is használ, mely az asztaltémáknak megfelelően eltérő.<br/>Ön természetesen ezeket a stílusdefiníciókat is használhatja.<br/><br/>Ha bővebb információra van szüksége, a PhpGedView weboldalán bemutatunk néhány pédát, hogyan használjon stíluslap-elemeket a GEDCOM Hírek blokkjában.<br/>";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Természetesen az volna a kívánatos, ha olyan programot alkotnánk, mely egyáltalán nem igényel magyarázatot, olyan egyszerű lenne, mint egy könyv olvasása. <br/>Annak ellenére, hogy a program meglehetősen bonyolult, a felhasználói felületen Ön ezt általában nem veszi észre, majdnem az összes funkciója minden további magyarázat nélkül használható. <br/>Viszont számos olyan látogatónk és felhasználónk van, akik nem túlzottan jártasak a számítógép és az internet használatában, bizonyos helyeken Segítséget kínálunk Önnek.<br/>A Segítség menüben a következő elemek találhatók:<br/>";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Segítség ehhez az oldalhoz</b></dt><dd>Minden oldalhoz elérhető egy általános, \"oldalspecifikus segítség\".<br/>Ha Ön az adott oldalon jár, erre a menüpontra kattintva megtekintheti az oldal tartalmát bemutató \"oldalspecifikus segítséget\".<br/>Az oldalspecifikus segítség az esetek többségében elég rövid. <br/>Ha Önnek további tájékoztatásra van szüksége az oldalon található egyik elemről, akkor a Segítség menü harmadik lehetőségét vegye igénybe: a \"Környezetérzékeny segítséget\".</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>A Segítség tartalomjegyzéke</b></dt><dd>Erre a menüpontra kattintva  Ön megtekintheti egy felugró ablakban az összes fontosabb segítség-elemet. <br/>Ez az index a jövőben mind több element fog tartalmazni, mivel a kevésbbé fontos elemek is folyamatosan felvételre kerülnek.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ Lista</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Környezetérzékeny segítség elrejtése / megjelenítése</b></dt><dd>Talán ez a menüpont lehet a leginkább kényelmes Önnek. Erre kattintva ki- és bekapcsolhatja a \"Környezetérzékeny segítséget\".<br/>De mit is takar a \"Környezetérzékeny segítség\"?<br/>Ha bekapcsolja, egy kérdőjelet találhat az egyes hivatkozások, lenyíló listák és gombok jobb oldalán. Ezekre a <b>?</b>-kre kattintva az adott elemről szóló segítség jelenik meg a felugró ablakban.<br/>Természetesen a \"Környezetérzékeny segítség elrejtése \" kiválasztásával a kérdőjelek eltünnek addig, amíg újra erre a menüpontra nem kattint.</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>DEFINÍCIÓK</b></center></div><br/>A Segítségek szövegében olvasható fontosabb kifejezések magyarázata:<br/>";
$pgv_lang["def_portal_help"]			= "~Portál~<br/>Ezen az oldalon (sok másikhoz hasonlóan) a portál hasonlít egy étterem előcsarnokához. Ez az a hely, ahová Ön belép, de sok fontos lehetőséget is itt találhat meg, mint pl. a menük és magyarázatok.<br/><br/>";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM-állomány~<br/>A GEDCOM-állomány tartalmazza a csládra vonatkozó öszes információt. <br/>Minden tény, dátum, esemény ebben az állományban található meg.<br/>A GEDCOM-állományok igen szigorú szabályok alapján épülnek fel, mivel számos programnak platform- és rendszerfüggetlenül kell használni tudnia őket.<br/>";
$pgv_lang["def_gedcom_date_help"]		= "~Dátumok a GEDCOM-állományban~<br/>Mivel a GEDCOM-állományokban az elemek megjelenítésének nemzetközi szabályokat kell követnie, a dátumok jelölése is megállapodás szerint történik.<br/><br/>Habár a GEDCOM-állományban a dátumok szabad mezőként szerepelnek (azaz Ön akár szövegként is megadhatja őket), a következő magyarázatok segítik Önt a helyes dátumbevitelben:<br/>A teljes dátumformátum NN HHH ÉÉÉÉ, pl.<br/>01 Mar 1801 vagy 14 Dec 1950<br/>Ha a szóbanforgó dátum egy része hiányzik, az a bevitelnél kihagyható, pl. <br/>Mar 1801 vagy 14 Dec<br/>Ha Ön nem biztos valamiben, vagy a dátum nem nyert megerősítést, a következő beviteli módok használhatók:<br/>abt Mar 1801 (abt = about = körül)<br/>bef 20 Dec 1950 (bef = before = előtt)<br/>aft 1949 (aft = after = után)<br/>Ügyeljen arra, hogy a dátumokat és a rövidítéseket angolul rögzítse, hiszen ez a program fogja a dátumokat és rövidítéseket a kívánt nyelvre fordítani.<br/>Emellett a program számításokat is végez a dátumokkal, tehát ha ilyen módon pontatlan dátumok kerültek rögzítésre, a számítások is hibásak leszenk.<br/>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br/>A PhpGedView (vagy PGV) nem csupán statikus lapokat jelenít meg, hanem dinamikusan változik és sokoldalúan testre szabható.<br/><br/>A PhpGedView John Finlay által alkotott, a GEDCOM-állományok online megjelenítését szolgáló program. John egyedül látott hozzá a program fejlesztéséhez, azonban azóta fejlesztőkből és fordítókból álló nemzetközi csapat gyűlt köré, akik a program tökéletesítésén dolgoznak. A GEDCOM-állományok megjelenítésén kívül a PhpGedView lehetővé teszi a az online bővítést és szerkesztést is.<br/><br/>";
$pgv_lang["def_theme_help"]			= "~Asztaltéma~<br/>Az oldal számos eltérő \"kinézettel\", más néven Asztaltémával rendelkezik.<br/>Az oldal adminisztrátora mindig kijelöl egy Asztaltémát kezdőként, tehát mindenki, aki meglátogatja az oldalt, ugyanolyannak fogja látni. Ha az adminisztrátor lehetővé teszi, hogy a bejelentkezett felhasználók kiválaszthassák saját Asztaltémájukat, akkor ők lecserélhetik arra, ami nekik a legjobban tetszik.<br/>Ha egy felhasználó eltérő Asztaltémát választ, a beállítás akkor lép életbe, mikor bejelentkezik az oldalra.<br/>";

//-- Index-page MyGEDCOM		
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[upper_mygedview]#~<br/>Ez az Ön Személyes #pgv_lang[mgv]# oldala.<br/>Itt olyan hivatkozásokat talál - mint a <b>Személyes adataim,</b> az <b>Én és a családom</b> oldal (ez az Ön személyi lapja) és a <b>Családfám</b> -, melyek megkönnyítik az Ön személyes adataihoz való hozzáférést.  .<br/>Ezeken kívül többek között olyan blokkokat is használhat itt, mint az<b>Üzeneteim</b>, és a <b>Hírlap</b> (egyfajta jegyzetfüzet).<br/><br/>Az oldal felépítése hasonló a Nyitóoldaléhoz, de míg annak a tartalmát az oldal adminisztrátora állítja össze, addig ennek a szerkesztését Ön végezheti el.<br/><br/>Az oldal felhasználó üdvözlő blokkjában találhatja azt a hivatkozást, mely az oldal testreszabásában segíti Önt.<br/>A következő blokkok állnak az Ön rendelkezésére: <br/><br/>";
$pgv_lang["mygedview_customize_help"]		= "~A #pgv_lang[upper_mygedview]# TESTRESZABÁSA~<br/>Mikor Ön első alkalommal belép ide, akkor már találhat néhány blokkot az oldalon.<br/>Ha szeretné, természetesen van lehetőség a portál módosítására.<br/>A hivatkozásra kattintva egy űrlap jelenik meg a felugró ablakban, melyben Ön blokkokat adhat hozzá, törölhet, vagy megváltoztathatja a  sorrendüket.<br/>További magyarázat az űrlapon érhető el.<br/>";
$pgv_lang["mygedview_message_help"]		= "~ÜZENETEIM BLOKK~<br/>Ebben a blokkban az Önnek íródott üzeneteket találhatja meg.<br/>Természetesen Ön is küldhet üzenetet mind a felhasználóknak, mind az adminisztrátornak.<br/>A PhpGedView levelező rendszere úgy lett kialakítva, hogy védje az Ön bizalmas jellegű adatait. Önnek nem kell itt meghagynia e-mai címét, és mások sem láthatják azt.<br/>";
$pgv_lang["mygedview_favorites_help"]		= "~KEDVENCEIM BLOKK ~<br/>A Kedvenceim a könyvjezőhöz hasonlóan működik:<br/>Tételezzük fel, hogy van egy személy a családfán, akinek az adataira Ön rendszeresen kíváncsi.<br/>Csupán annyit kell tennie, hogy elmegy az adott személyi lapra és kiválasztja a \"Hozzáadás a Kedvencekhez\" opciót a Keddvencek lenyíló-listájából. Ezzel Ön a személyt kijelölte és hozzáadta a Kedvencekhez. <br/>Bárhol is járjon az oldalon, elegendő, ha rákattint az illető személy nevére a Fejlécben található \"Kedvenceim\" lenyíló-listában, és ez átirányítja Önt az érintett személyi lapjára.<br/><br/>Helykímélés miatt a szövegdobozok minimális információt hordoznak, a cellák jobb oldalán található nagyító segítsgével juthat több adathoz.<br/>A személy nevére kattintva Ön eljuthat az illető személyi lapjához. <br/>Szintén a jobb oldalon találhatja a menüt, melyen bővebb infomációt vagy grafikonokat tartalmazó oldalakra vezető hivatkozásokat találhat.<br/>";
$pgv_lang["mygedview_myjournal_help"]		= "~AZ ÉN HÍRLAPOM BLOKK ~<br/>Ön ebbe a blokkba írhat saját használatra jegyzeteket (vagy emlékeztetőket).<br/>Természetesen ha Ön beír ide egy jegyzetet, azt a következő látogatáskor is itt fogja találni.<br/><br/>Ezek a feljegyzések nem férhetők hoozzá a többi felhasználó számára.<br/>";
$pgv_lang["mygedview_welcome_help"]		= "<dl>~FELHASZNÁLÓ ÜDVÖZLŐ BLOKK ~<dt>A Felhasználó Üdvözlő Blokk a következőket tünteti fel:</dt><dd>- Az aktuális GEDCOM-állomány</dd><dd>- A dátum és az idő</dd><dd>- Hivatkozások a következőkhöz::</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (lásd még a megjegyzést)</dd><dd>- - #pgv_lang[my_indi]# (lásd még a megjegyzést)</dd><dd>- - #pgv_lang[customize_page]#</dd></dl><b>Megjegyzés:</b><br/>Az \"Én és a családom\" valamint a \"Családfám\" hivatkozásokat csak akkor láthatja, ha Ön is szerepel az aktuális GEDCOM-állományban.<br/>Tehát ez alapján lehetséges, hogy Ön szerepel az egyik GEDCOM-állományban és így megjelenik a fenti két hivatkozás, míg egy másik állomány esetében, melyben Ön nem szerepel, nem jelennek meg.<br/>";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~AZ ŐSFA~<br/><br/>A felhasználók többsége tudja, hogy mit takar az Ősfa kifejezés, de egy rövid összefoglaló az ezen az oldalon látható Ősfáról hasznos lehet:<br/>Az ősfa valójában a kezdő személy összes ősének felsorolása.<br/>Mikor Ön meglátogatja az oldalt, a bal oldalon látható személy a kezdő személy (bejelentkezés után tetszőleges kezdő személy választható).<br/><br/>Az \"összes ős\" tehát az apát és az anyát, az ő szüleiket, stb. jelenti.<br/>Ezen az oldalon az ősfa grafikus formában jelenik meg, tehát Önnek nem kell azzal töltenie az idejét, hogy sok oldalnyi szövegen rágja keresztül magát, hogy megtalálja a keresett őseit.<br/>Az egyes személyek szövegdobozokban jelennek meg a képernyőn. <br/><br/>* SZÖVEGDOBOZOK AZ ŐSFÁN<br/>Ha az ősfán a részletek megmutatása be van kapcsolva, Ön láthatja a személyek nevét, valamint a születési és elhalálozási dátumát.<br/>Ha egy személy nevére rákattint, egyenesen az illető személyi lapjára kerül<br/>Ha a \"részletek mutatása\" be van kapcsolva, két ikon jelenik meg a szövegdobozban:<br/><br/>* ŐSFA-IKON a SZÖVEGDOBOZBAN<br/>Ha a \"részletek mutatása\" be van kapcsolva, egy ősfa-ikon lesz látható a szövegdobozban, melyet az oldal beállításaitól függően az kattintással vagy az egér áthúzásával aktiválhat.<br/>Aktiválás után egy kis almenü jelenik meg:<br/>Az \"Ősfa\" és a \"Leszármazottak\" hasonlóak a főmenüben található elemekhez, viszont az így megjelenő grafikonok  kezdő személye abban szövegdobozban lévő személy, ahonnan elindítottuk az akciót.<br/>Ezen kívül itt szerepel még a  \"Családtagok házastárssal\" opció, mely alatt látható a házastárs neve, azt követően pedig a gyermekek neve.<br/>Az összes név kattintható.<br/><br/>* NAGYÍTÓ-IKON A SZÖVEGDOBOZBAN<br/>Ez az ikon felnagyítja a szövegdobozt, így több részlet válik láthatóvá, további dátumokat és eseményeket találhat így meg (a nevek kattinthatóak).<br/><br/>* A NYILAK<br/>A jobb vagy bal szélső szövegdobozok mellett jobbra vagy ballra mutató nyilakat találhat. <br/>A nyilakra kattintva  \"görgethető\" a képernyő a nyílnak megfelelő irányba.<br/><br/>További segítség az oldaon érhető el, a mezők és hivatkozások mögött látható <b>?</b>-re kattintva.";
$pgv_lang["show_full_help"]			= "~RÉSZLETEK ELREJTÉSE/MUTATÁSA~<br/><br/>Ennek a gombnak a segítségével Ön minden részletet megmutathat az egyes szövegdobozokban vagy el is rejtheti azokat.<br/>A részletek elrejtésével egy képernyőn több szövegdoboz jeleníthető meg.<br/><br/>Az elrejtett részletek esetében is lehetőség van az adatok feltárására, ha a Nagyító rendelkezésre áll a normál nézetben, ami attól függ, mit állított be az oldal adminisztrátora.<br/>Ha Önnek kattintania kell a Nagyítóra részletekért, akkor ebben az esetben is kattintson a szövegdobozra.<br/>Ha Önnek elegendő a Nagyítóra vinni a kurzort a részletekért, akkor ebben az esetben is húzza a kurzort az \"egyszerűsített\" szövegdobozra.";
$pgv_lang["talloffset_help"]			= "~DOBOZOK ELTOLÁSA A KÉPERNYŐN~<br/><br/>Ezzel az opcióval a szövegdobozok elrendezése állítható a képernyőn (\"álló\" és \"fekvő\") <br/> Ennek a beállításnak a módosítása hasznos lehet, ha Ön ki szeretné nyomtatni az oldat vagy másfajta képernyővel rendelkezik.";
$pgv_lang["rootid_help"]			= "~ÚJ KEZDŐ SZEMÉLY~<br/><br/>Ha Ön a családfát egy másik kezdő személlyel kívánja megjeleníteni, akkor ebbe a bevíteli mezőbe írja be a személy azonosítóját.<br/>Ha nem ismeri a személy azonosítóját, használja az <b>Azonosító</b> hivatkozást.<br/><br/><b>Azonosító szám</b><br/>A PhpGedView-ban használt azonosító szám nem egyezik meg a személy egyetlen hivatalos azonosító számával sem!<br/>Ezt a számot a GEDCOM-állományt létrehozó program rendeli hozzá a személyhez.<br/><br/>";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~GENERÁCIÓK SZÁMA~<br/><br/>Itt állíthatja be az egy oldalon megjelenítendő generációk száma.<br/><br/>A helyes szám a képernyő méretének és megjelenített adatok részletezettségének függvényében változik.<br/><br/>";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~BEJELENTKEZŐ OLDAL~<br/><br/>Ezen az oldalon van lehetőség a belépésre, új jelszó kérésére, valamint új felhasználó regisztrációjára.<br/>";
$pgv_lang["username_help"]			= "~FELHASZNÁLÓ~<br/><br/>Ebben a beviteli mezőbe gépelje be felhasználónevét.<br/><br/><b>Ügyeljen arra, hogy a mező érzékeny a kis- és nagybetűkre.</b> Ez azt jelenti, hogy a <b>ANevem</b> <u>nem</u> ugyan az mint a <b>anevem</b> vagy a <b>ANEVEM</b>.<br/><br/>";
$pgv_lang["password_help"]			= "~JELSZÓ~<br/><br/>Ebben a beviteli mezőbe gépelje be jelszavát.<br/><br/><b>Ügyeljen arra, hogy a mező érzékeny a kis- és nagybetűkre.</b> Ez azt jelenti hogy a <b>JELszó</b> <u>nem</u> ugyan az mint a <b>jelszó</b> vagy a <b>JELSZÒ</b>.<br/><br/>";
$pgv_lang["login_buttons_help"]			= "~BEJELENTKEZŐ GOMBOK~<br/><br/>Két gombot találhat itt, melyek a rendszerve való belépést szolgálják.<br/>Az, hogy a felhasználónév és a jelszó megadása után melyik oldalra kerül, attól függ, melyik gombra kattintott.<br/><br/>* A <b> #pgv_lang[login]# </b> gomb<br/>Ha erre kattint, Ön arra az oldalra fog kerülni, ahonnan ide érkezett.<br/>Tehát ha Ön úgy kattint a \" #pgv_lang[login]# \" gombra, hogy előtte az Ősfa oldalán járt, akkor oda is fog visszatérni.<br/><br/>* Az <b> #pgv_lang[admin]# </b> gomb<br/>Ha Önnek adminisztrátori jogosultsága van, akkor kattinthat erre a gombra, hogy egyenesen az Admnisztráció oldalára kerüljön.";
$pgv_lang["login_buttons_aut_help"]		= "~'HITELESÍTÉS' MÓD~<br/><br/>BEJELENTKEZŐ GOMBOK<br/><br/>Két gombot találhat itt, melyek a rendszerve való belépést szolgálják.<br/>Az, hogy a felhasználónév és a jelszó megadása után melyik oldalra kerül, attól függ, melyik gombra kattintott.<br/><br/>* A <b> #pgv_lang[login]# </b> gomb<br/>Ha erre a gombra kattint, akkora bejelentkezés után a MyGedView Portálra kerül, ahol szerkesztheti a beállításait, úk kedvenceket vehet föl vagy a régieket szerkesztheti, üzeneteket küldhet és fogadhat stb.<br/><br/>* Az <b> #pgv_lang[admin]# </b> gomb<br/>Ha Önnek adminisztrátori jogosultsága van, akkor kattinthat erre a gombra, hogy egyenesen az Admnisztráció oldalára kerüljön.";
$pgv_lang["new_password_help"]			= "~ÚJ JELSZÓ KÉRÉSE~<br/>Amennyiben Ön elfelejtette a jelszavát, kattintson erre a hivatkozásra egy új jelszóért.<br/>Ennek hatására átkerül az \"Elvesztettem a jelszavamat\" oldalra.";
$pgv_lang["new_user_help"]			= "~REGISZTRÁCIÓ KÉRÉSE~<br/><br/>Ha Ön olyan látogatója a honlapnak, aki szeretné regisztráltatni magát, kattintson ide.<br/>Ennek hatására átkerül \"Regisztráció kérése\" oldalra.";
$pgv_lang["mygedview_login_help"]		= "Ha Ön el szeretné érni a MyGedView Portált, regisztráltatnia kell magát a rendszerben.<br/><br/>A MyGedView Portál segítségével nyilvántarthatja \"kedvenceit\", hírlapot vezethet, kezelheti az üzeneteit, láthatja a bejelentkezett felhasználókat és tetszése szerint átalakíthatja a PhpGedView-t.<br/><br/>Kérjük, a belépéshez adja meg a felhasználónevét és jelszavát.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~LESZÁRMAZOTTAK OLDALA~<br/><br/>Ez az oldal egy adott személy leszármazottait tünteti fel.<br/><br/>Önnek kiválaszthatja a kezdő személyt ezen az oldalon, vagy eljuthat ide, ha egy másik oldalon a <b>#pgv_lang[descend_chart]#</b> hivatkozásra kattint.<br/><br/>";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~KRONOLÓGIA~<br/><br/>Ezen az oldalon egy vagy több személy életének eseményei tekinthetők át az idő múlásával.<br/>Ennek megfelelően Ön megvizsgálhatja pl. két vagy több személy sorsát egy adott időpontban.<br/><br/>Ha egy másik oldalon kattint a \"Kronológia\" ivatkozásra, akkor azt az egy személyt nézheti meg ezen a grafikonon.<br/>Ha a fejléc menüpontján keresztül jutott el ide, a kezdéshez meg kell adni a személy azonosítóját a megfelelő beviteli mezőben.";
$pgv_lang["add_person_help"]			= "~ÚJ SZEMÉLY HOZZÁADÁSA~<br/><br/>Ön ebben a Kronológiában több személyt is feltüntethet.<br/>A személy azonosítóját ebben a beviteli mezőben kell feltüntetni.<br/>Amennyiben nem tudja az azonosítót, használja az \"Azonosító\" hivatkozást.";
$pgv_lang["remove_person_help"]			= "~SZEMÉLY VISSZAVONÁSA~<br/><br/>Kattintson erre a hivatkozásra, ha el kívánja távolítani az adott személyt a Kronológiából.";
$pgv_lang["show_age_marker_help"]		= "~ÉLETKOR JELZŐ~<br/><br/>Ha bejelöli ezt a mezőt, megjelenik az életkor jelző, melyet Ön a Kronológiában előre-hátra mozgathat. <br/>Az életkor jelző megfelelő eszköz arra, hogy Ön ellenőrizhesse a személy életkorát egy adott esemény idején.<br/>Az életkor jelző minden egyes személy esetében be- és kikapcsolható.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~ROKONSÁGI FOK~<br/><br/>Ezen az oldalon Ön megjelenítheti két személy rokonsági viszonyait. <br/>Az eljárás nem igényli, hogy a két személy közvetlen vérrokonságban álljon egymással, mivel a program bármilyen rokoni kapcsolatot képes megtalálni.";
$pgv_lang["relationship_id_help"]		= "~AZ 1. ÉS A 2. SZEMÉLY AZONOSÍTÓJA~</b><br/><br/>Ha Ön valamelyik másik oldalon szereplő hivatkozáson át került ide (pl. a \"Rokonsága velem\" segítségével), akkor az adott két személy közötti rokoni kapcsolatot fogja itt megtalálni.<br/>Egyéb esetekben Önnek meg kell adni a személyek azonosítóját.<br/>Amennyiben nem tudja az azonosítókat, használja az \"Azonosító\" hivatkozást.";
$pgv_lang["next_path_help"]			= "~ALTERNATÍV ÚTVONAL~<br/><br/>Erre a gombra kattintva megtudhatja, van-e még egy másik, \"alternatív\" rokoni kapcsolat a két személy között. Az előző útvonalat újra megtekintheti, ha a sorszámával ellátot hivatkozásra kattint.<br/><br/>";
$pgv_lang["follow_spouse_help"]			= "~A \"HÁZASTÁRSON KERESZTÜLI ROKONSÁG ELLENŐRZÉSE\" JELÖLŐNÉGYZETE~<br/><br/>Ha Ön ezt a jelölőnégyzetet <b>nem</b> jelöli meg, akkor csak a vérrokonság kerül feltüntetésre.<br/>Ha a négyzetet bejelöli, akkor a házastárson keresztüli rokoni kapcsolatokat is megtekintheti.<br/><br/>";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~SZEMÉLYEK LISTÁJA~<br/><br/>Ezen az oldaon Ön megtekintheti a személyek listáját.<br/><br/>A listában a vezetéknév szerepel elsőként, ábécérendbe szedve.<br/>A lista megjelenítése a következőktől függ:<br/><b>1.</b> A kezdőbetű, melyre Ön kattintott.<br/><b>2.</b> Megjeleníthető csak a vezetéknevek illetve a teljes nevek listája.<br/><br/>Ha erről a témakörről további tájékotatást igényel, kattintson az egyes elemek mögött látható ?-re.";
$pgv_lang["alpha_help"]					= "~ÁBÉCÉ-INDEX~<br/><br/>Az ábécé-index egyes betűire kattintva az adott betűvel kezdődő nevek jeleníthetők meg.<br/>Az utolsó előtti elem lehet a listában az <b>\"pgv_lang[unknown]\"</b><br/>Ez akkor jelenik meg, ha a GEDCOM-állományban olyan személyek vannak, akiknek nincs rögzítve a vezetékneve (pl. a szerkesztő nem ismerte), vagy a támogatott nyelven nem értlmezhető karakterekből áll.<br/><br/><b>Fgyelem!</b><br/>Ha a GEDCOM-állományban az ismeretlen személy neve eredetileg valamilyen kóddal lett rögzítve (pl. n.a., ismeretlen), akkor az <b>\"pgv_lang[unknown]\"</b> hivatkozásra kattintva <b>nem</b> fog szerepelni a találati listában. Ön úgy találhatja meg ezeket a személyeket, ha a kód kezdőbetűjére (pl.\"<b>N</b>\" vagy \"<b>I</b>\") kattint.<br/>Ez abból fakad, hogy a program csak azt ellenőrzi, hogy a GEDCOM-állományban a vezetéknév pozíciója ki van-e töltve.<br/><br/>Az ábécé-index végén szerepel a <b>\"pgv_lang[all]</b>\" hivatkozás. Erre kattintva megjelenik a GEDCOM-állományban szereplő összes vezetéknév.<br/><br/><b>Miért hiányoznak egyes betűk?</b><br/>Előfordulhat, hogy az ábécé-index egyes betűi \"hiányoznak\". <br/>Természetesen nem vesztek el, csupán arról van szó, hogy ilyen kezdőbetűjű vezetéknevek nem szerepelnek az adott GEDCOM-állományban.";
$pgv_lang["name_list_help"]			= "~NEVEK LISTÁJA~<br/><br/>Ez a táblázat egyaránt tartalmazhatja a keresztnevek vagy a teljes nevek listáját.<br/>Mindkét esetben a megjelenített keresztnevek azzal a betűvel kezdődnek, melyet Ön kiválasztott az ábécé-indexből, kivéve, ha Ön a <b>Mind</b> hivatkozásra kattintott.<br/><br/>Az, hogy a keresztnevek vagy a teljes nevek listáját látja, a táblázat alatt látható hivatkozás állapotától függ.<br/><br/>";
$pgv_lang["skip_sublist_help"]			= "~TELJES NEVEK LISTÁJA~<br/><br/>Alapbeállításként Ön a neveknek egy közbülső - csak a vezetékneveket tartalmazó - listáját látja, miután kiválasztott egy betűt az ábécé-indexből.<br/>Ha Ön erre a hivatkozásra kattint, ezt a közbülső listát átugorhatja, és közvetlenül a teljes nevek listájához kerülhet.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~CSALÁDOK LISTÁJA~<br/><br/>Ezen az oldalon Ön megtekintheti a családok listáját.<br/><br/>A listában a vezetéknév szerepel először, ábécérendbe szedve.<br/>A lista megjelenítése a következőktől függ:<br/><b>1.</b> A kezdőbetű, melyre Ön kattintott.<br/><b>2.</b> Megjeleníthető csak a vezetéknevek illetve a teljes nevek listája.<br/><br/>Ha erről a témakörről további tájékoztatást igényel, kattintson az egyes elemek mögött látható ?-re.";
$pgv_lang["help_family.php"]			= "~INFORMÁCIÓS LAP A CSALÁDOKRÓL~<br/><br/>Ezen az oldalról Ön áttekintést kaphat az előző oldalon kiválasztott családról.<br/>Fentről lefelé haladva a következő elemeket találja itt:<br/>A férj és a szülei.<br/>A feleség és a szülei.<br/>A gyermekeik.<br/><br/>A szövegdobozok tartalma és kinézete megegyezik az Ősfa és a Leszármazottak fája esetében alkalmazottal.<br/>A szülők szövegdobozának jobb oldalán látható egy nyíl, amennyiben az illetőnek további ősei is léteznek ebben az állományban. A nyílra kattintva az adott család családi információs lapjára juthat.<br/>A gyermek(ek) szövegdoboza(i) alatt találhatja a \"Gyermek hozzáadása a családhoz\" hivatkozást.<br/>A gyermekek szövegdoboza mellett látható a \"Információk erről a családról\" című táblázat.<br/>Ha Önnek megfelelő jogosultsága van, szerkesztheti, törölheti, bővítheti az itt található adatokat.<br/><br/>A képernyő jobb oldalán a következő ikonokat és hivatkozásokat találhatja: \"A házaspár mutatása a Kronológiában\", \"A GEDCOM-rekord megtekintése\", illetve (ha engedélyezett) \"Hozzáadás a családfa-ágak kosarához\".<br/><br/>#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~GYERMEK HOZZÁADÁSA A CSALÁDHOZ~<br/><br/>Erre a hivatkozásra katintva Önnek lehetősége van további gyermekek hozzáadására.<br/><br/>A gyermek hozzáadása igen egyszerű: Kattintson a hivatkozásra, majd töltse ki a megjelenő űrlapot.<br/><br/>";
//-- same variables as individuals page

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~FORRÁSLISTA~<br/><br/>Ezen az oldaon Ön megtekintheti a források listáját.<br/>A személyek és a családok listájával ellentétben itt nincsen ábécé-index a lap tetjén. Ez azért van, mert az egyes források kapcsolódhatnak kereszt- és vezetéknevekhez, lehetnek nyilvános adatbázisok, intézmények stb., ami igen megnehezítené egy átfogó rangsor kialakítását. A források neve ábécé-rendben látható úgy, ahogy a GEDCOM-állományban is tárolva vannak.<br/><br/><b>FORRÁSOK</b><br/>Források nélkül nem építhetjük fel adatbázisunkat. Minden információ, melyet az adatbázisunkban tárolunk, egy forráson alapul. Forrás lehet egy rokon, egy intézmény, nyilvános adatbázis stb.<br/>Egy forrás kapcsolódhat több személyhez, illetve egy személyhez is számos forrást lehet kötni. Ön  minden egyes eseményhez kapcsolódóan rendelkezhet több forrással is, függetlenül attól, hogy az születési dátum, foglalkozás, házasság, gyermek születése, stb.";
$pgv_lang["sourcelist_listbox_help"]		= "~FORRÁSOK TÁBLÁZATA~<br/><br/>Ebben a táblázatban Ön a források nevét láthatja úgy, ahogyan azok a GEDCOM-állományban tárolva vannak.<br/>A nevek ábécé-rendben szereplnek.<br/><br/>Mikor Ön az egyik forrásra kattint, átkerül a forrás információs lapjára, ahol megtudhatja, hogy mely személyekhez/családokhoz kapcsolódik az adott forrás.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~FORRÁS INFORMÁCIÓS LAPJA~<br/><br/>Ezen a lapon Ön megtekintheti a kiválasztott forrásra vonatkozó részleteket, abban a formában, ahogy az a GEDCOM-állományban eltárolásra került. <br/><br/>Ezen kívül egy listát is talál itt azokról a személyekről és családokról, akik kapcsolódnak ehhez a forráshoz.<br/><br/>Ha az oldal adminisztrátora engedélyezte, további egy vagy két ikont is láthat itt:<br/>A GEDCOM-rekord megtekintése,<br/>Hozzáadás a családfa-ágak kosarához.<br/><br/>További segítséget az oldalon látható <b>?</b>-re kattintva kaphat.";
$pgv_lang["sources_listbox_help"]		= "~#pgv_lang[other_records]#~<br/><br/>Ebben a táblázatban azoknak személyeknek és családoknak a neve található, melyek kapcsolódnak ehhez a forráshoz.<br/>A neveket ábécé-rendbe szedve tüntetjük fel.<br/><br/>Ha Ön az egyik névere kattint, akkor az érintett személy vagy család személyi lapjára jut.";
$pgv_lang["show_source_gedcom_help"]		= "~A GEDCOM-REKORD MEGTEKINTÉSE~<br/><br/>Erre a hivatkozásra kattintva a GEDCOM-állományban tárolt információ jelenik meg eredeti formájában egy felugró ablakban.<br/><br/>";
$pgv_lang["add_source_clip_help"]		= "~HOZZÁADÁS A CSALÁDFA-ÁGAK KOSARÁHOZ~<br/><br/>Erre a hivatkozásra kattintva Ön hozzáadhatja az aktuális forrást a #pgv_lang[clip_cart]# -hoz hogy késöbb lehozhassa és az ön genelogiai programjába importálhassa.<br/><br/>";
$pgv_lang["delete_source_help"]			= "~FORRÁS TÖRLÉSE A GEDCOM-ÁLLOMÁNYBÓL~<br/><br/>Erre az opcióra kattintva Ön törlésre jelöli ki az aktuális forrást.<br/>Mit is jelent ez?<br/>Tegyük fel, hogy Önnek alapos indoka van a forrás eltávolítására. A hivatkozásra való kattintás után megjelenik egy ablak, melyben megerősítheti törlési szándékát, vagy elvetheti azt.<br/><br/>Ha Ön befejezi a folyamatot, egy kis idő múlva egy újabb felugró ablak tájékoztatja Önt, hogy a forrás törlésre került.<br/><br/>Azonban ha folytatja látogatását az oldalon, láthatja, hogy a forrás ugyanúgy látható és használható, mint azelőtt volt.<br/><br/>De ez <b>egyáltalán nem</b> hiba!<br/>Az oldal adminisztrátora fog kapni egy üzenetet, miszerint változtatás történt a GEDCOM-állományban, és Ön eltávolított egy forrást.<br/>Ezt az adminisztrátornak kell jóváhagyni (vagy elvetni), mely után a változtatást már nem lehet visszavonni.<br/>Kérdéses esetben az admnisztrátor kapcsolatba fog Önnel lépni.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~HELYSZÍNEK HIERARCHIÁJA~<br/>(azaz személyek egy adott helyen)<br/><br/>Ezen az oldaon Ön áttekintheti, hogy egy adott helyszínhez mely személyek és családok kötődnek.<br/><br/>Ha van valamilyen kapcsolat egy személy/család és egy esemény között egy adott helyszínen, akkor a program meg fogja azt találni Önnek.<br/><br/>Az eredmények egy két oszlopos táblázatban fognak megjelenni:<br/>Egyikben a személyek, a másikban a családok szerepelnek.<br/><br/>#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~A HELYSZÍNEK RANGSOROLÁSA~<br/><br/><b>ALAPÉRTELMEZETT RANGSOR</b><br/>A helyszíneket az alapértelmezett sorrendben mutatjuk meg Önnek.<br/>Ez azt jelenti, hogy a GEDCOM-állományban semmiféle speciális rangsor nem található, vagyis az oldalon előzetesen beállított sorrendet alkalmazzuk.<br/><br/>Ha ettől eltérő hierarchiát találunk a GEDCOM-állományban, akkor azt a sor végén látható (...)-ben mutatjuk meg Önnek.";
$pgv_lang["ppp_match_one_help"]			= "~A HELYSZÍNEK RANGSOROLÁSA~<br/><br/>RANGSOR A GEDCOM-BÓL<br/>A helszíneket a GEDCOM-állományban található hierarchia szerint mutatjuk be. <br/>Ez a beállítás fölülírja az alapértelmezett rangsort, melyet akkor használunk, ha a GEDCOM-állományban nem szerepel speciális hierarchia.";
$pgv_lang["ppp_numfound_help"]			= "~KAPCSOLAT A HELYSZÍNEK KÖZÖTT~<br/><br/>A program által talált egyezések száma. <br/>Ha Ön továbbra is lát egy táblázatot helyszínekkel, akkor még nem érte el a legalsó szintet.<br/>Ott választhat nevet a felkínált <b>Névlistából</b> vagy módosíthatja keresését, ha egy másik helyszínt választ a névlista fölött található <b>Helyszínlistából</b>.";
$pgv_lang["ppp_levels_help"]			= "~HELYSZÍN-SZINTEK~<br/><br/>Ez a lista megmutatja az aktuálisan megjelenített helyszín-szinteket. <br/>A helyszíneket bemutató táblázat tulajdonképpen a bal szélen látható helyszín-szint almenüjének felel meg.<br/><br/>Például:<br/>Az (alapértelmezett) sorrend a következő: #pgv_lang[default_form]#<br/>Az aktuális szint a \"Felső szint\", így a táblázat a GEDCOM-állományban található országokat tartalmazza.<br/>Ha az aktuális szint az \"USA, Felső szint\" , akkor a táblázat az USA államait mutatja meg.<br/><br/>Ön természetesen kattinthat az egyes szintekre, hogy egy vagy több szinttel visszalépjen.";
$pgv_lang["ppp_placelist_help"]			= "~#pgv_lang[place_list]#~<br/><br/>Ebben a táblázatban a megtalált helyszíneket tüntetjük fel. A listában található nevek természetesen kattinthatók. Rájuk kattintva úgy működnek, mint egy szűrő: egy szinttel mélyebbre viszik Önt. Csupán a legfelső szinten nem jelenik meg névlista, mindegyik alsóbb szinten láthatja az oda tartozó személyeket és családokat.<br/><br/>";
$pgv_lang["ppp_name_list_help"]			= "~NÉVLISTA~<br/><br/>Ez a táblázat megmutatja az adott helyszínhez bármilyen módon kötődő személyeket és/vagy családokat.<br/><br/>A listában található nevek természetesen kattinthatók.<br/>Rájuk kattintva elvezetik Önt az adott személy vagy család információs lapjára.<br/><br/>Ön természetesen megváltoztathatja ezt a listát, ha a feltüntetett helyszínek valamelyikére kattint.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMÉDIA LISTA~<br/><br/>A multimédia lista minden, a GEDCOM-állományban található multimédia-elemet feltüntet.<br/><br/>Az egyes multimédia-elemek dobozában megtalálható az állomány neve, valamint a személy(ek) és család(ok) neve (mind kattintható), melyeket Ön az adott elemhez hozzárendelt. <br/><br/>Egy személy vagy család nevére kattintva a személyi laphoz vagy a családi információs laphoz juthat el.<br/><br/>A multimédia-elem nevére vagy magára a multimédia-elemre kattintva (az állomány kiterjesztésétől függően) a PhpGedView belső képnézőjében vagy az Ön böngészőjéhez társított képnézőben megtekintheti az állományt.<br/><br/><br/>A jobb egérgombbal kattintva a multimédia-elemre, mindazon lehetőség az Ön rendelkezésére áll, mely a böngészőben is megtalálható, így például a kép elmentése, nyomtatása és beállítása háttérképnek.<br/>";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~MULTIMÉDIA ÁLLOMÁNYOK FELTÖLTÉSE~<br/><br/>Az állományok feltöltése meglehetősen egyszerű, ezért itt csupán kiegészítő információkat közlünk.<br/><br/><b>Előnézeti képek:</b><br/>Az előnézeti képek szélességét kb. 100 pixel körül érdemes megszabni. <br/>Az állomány nevét változatlanul kell hagyni.<br/><br/><b>Feltöltés:</b><br/>Az állományok automatikusan töltődnek fel a ../media könyvtárba (nagyméretű képek), illetve a  ../media/thumbs/ könyvtárba (az előnézeti képek).<br/><br/>#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~ÉVFORDULÓ-NAPTÁR~<br/><br/>Az Évforduló-naptár szerepe, hogy megmutassa Önnek az egyes napokhoz kötődő családi vagy személyes eseményeket (egy napra vagy egy hónapra vonatkoztatva).<br/><br/>Az Évforduló-naptár számos hatékony eszközt foglal magába: Fejlett szűrőrendszerrel rendelkezik, mellyel Ön kiválaszthatja a megfelelő eseményeket.<br/><br/>Az  <b>Adott napon</b> módban a keresés eredménye egy egyszerű lista vagy egy két oszlopos táblázat, melyek a megtalált személyeket és családokat mutatják be.<br/><br/>Az <b>Adott hónapban</b> mód választásával egy <b>naptár</b> jelenik meg, feltüntetve az érintett személyeket és családokat.<br/><br/>A lap tetején egy hivatkozásokat tartalmazó táblázat, valamint egy szöveges beviteli mező található, melyek segítségével Ön meghatározhatja a napot, hónapo, évet és eseményt, melyekhet kapcsolódó szemléyek érdeklik Önt.<br/>Az aktuális napot, hónapot és eseményt pirossal emeltük ki.<br/><br/>A nap és a hónap sorának végén két <b>\"gyorshivatkozást\"</b> találhat.<br/>Ezek segítségével ön megjeelnítheti az aktuális napra illetve hónapra vonatkozó listát, illetve naptárat.<br/><br/>A listában és a naptárban látható nevek mindegyike kattintható, így ezeken át eljuthat az adott személy vagy család adatlapjára.<br/><br/>#pgv_lang[more_help]#";
$pgv_lang["annivers_date_select_help"]		= "~NAP-VÁLASZTÓ~<br/><br/>A \"vezérlő-táblázat\" felső sora a <b>nap-választó</b>.<br/>Ennek szerepe magától értetődő: ezen keresztül tudja Ön kiválasztani a napot.<br/>A választás eredménye attól függ, hogy Ön éppen az  \"Adot napon\" vagy az \"Adott hónapban\" módban van.<br/><br/><b>Adott napon</b> mód:<br/>Ez esetben a program frissíti a képernyőt, és megjeleníti a kválasztott naphoz tartozó listát.<br/><br/><b>Adott hónapban</b>:<br/>Ha itt választ ki egy napot, a képernyő frissülni fog, de Ön továbbra is annak a hónapnak a naptárát látja, mint a választás előtt.<br/>Mindez azért van, hogy Önnek legyen lehetősége egy másik hónap és/vagy év megjelölésére, mielőtt akár az <b>#pgv_lang[viewday]#</b> vagy az <b>#pgv_lang[viewmonth]# gombra</b> kattint.<br/><br/>A sor végén talál egy <b>\"gyorshivatkozást\"</b> a mai dátummal.<br/>Erre kattintva megtekintheti a mai napra vonatkozó listát, mégpedig \"Adott napon\" módban, függetlenül attól, hogy Ön esetleg az \"Adott hónapban\" módban volt éppen.<br/>";
$pgv_lang["annivers_month_select_help"]		= "~HÓNAP-VÁLASZTÓ~<br/><br/>A \"vezérlő-tábla\" középső sora a <b>hónap-választó</b>.<br/>Hasonlóan a \"nap-választóhoz\", ennek az értelme is kézenfekvő: ezen keresztül tudja Ön kiválasztani a hónapot.<br/><br/>And also like the Day Selector is the result of clicking on a month in the \"Day mode\" different from clicking on a month in the \"Month mode\".<br/><br/>The <b>Day mode</b>:<br/>In this mode, when you have clicked a month, the screen will refresh and the list will be displayed with the dates for the new selected month.<br/>All other settings like day, year, and events will remain the same.<br/><br/>The <b>Month mode</b>:<br/>When you have the calendar on the screen and click a month in the \"Month\" row of the selector table, the calendar of the new month will be displayed.<br/><br/>At the end of the Month row you will see the <b>\"Quick Link\"</b> with the current month.<br/>Clicking that \"Quick Link\" will display the calendar of this month, no matter whether you are in the Month mode, or in the Day mode.<br/>";
$pgv_lang["annivers_year_select_help"]		= "~BEVITELI MEZŐ AZ ÉVNEK~<br/><br/>Ezen beviteli mezővel változtathatja meg az évet az \"Adott napon\" listában, illetve az \"Adott hónapban\" naptárban.<br/><br/>Ügyeljen arra, hogy az évszám begépelésével a képernyő tartalma nem frissül követlenül.<br/>Mivel a beviteli mező nem hivatkozás, ezért vagy a <b>#pgv_lang[viewday]#</b> vagy pedig a  <b>#pgv_lang[viewmonth]# gombra</b> kell kattintania, hogy frissítse a tartalmat.<br/>";
$pgv_lang["add_name_help"]				= "~#pgv_lang[add_name]#<br/><br/>Ez a hivatkozás lehetövé teszi hogy egy másik nevet adjunk egy személyhez. Vannak személyek akik más néven ismert. Ez a hivatkozás megengedi hogy hozzá adjunk egy új nevet a személyhez annélkül hogy a régebbi név megváltozzon.<br/><br/>";
$pgv_lang["add_facts_help"]			= "~#pgv_lang[add_fact]#~<br/><br/>Itt egy új eseményt tud az adathoz hozzá adni.<br/><br/>Elöször válasszon egy eseményt, majd kattintson a <b>#pgv_lang[add]#</b> gombra. Minden lehetséges eseményt itt megtalál.<br/><br/>";

//-- Clipping Cart-page

//-- GEDCOM Edit Utility

//-- Search-page

//-- Individuals-page

//-- Add Facts

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Ön ezen az oldalon változtathatja meg a személyes beállításait.<br/><br/>Módosíthatja felhasználói nevét, a teljes nevét, jelszavát, az alapértelmezett nyelvet, az e-mail címét, az asztaltémát és a kapcsolattartási módot.<br/><br/>Ugyanakkor az Ön azonosítóját, mely a GEDCOM-ban szerepel, nem tudja itt megváltoztatni.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br/><br/>Ebben a mezőben tudja megváltoztatni a felhasználói nevét, ha valamilyen okból nem szeretné a régit továbbra is használni.<br/><br/>Kérjük, vegye figyelembe, hogy a felhasználói név <b>érzékeny a kis- és nagybetűkre.case sensitive</b>. Ez azt jelenti, hogy a \"János\" nem egyezik meg a  \"jános\"-sal vagy a  \"JÁNOS\"-sal.<br/><br/>Ön <b>kizárólag</b> olyan karaktereket használhat (kis- és nagybetűk illetve számok), melyeket a program támogat.<br/><br/>Kérjük, <b>kerülje</b> az írásjelek, szóközök és egyéb, nem támogatott karakterek alkalamazását.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br/><br/>Ez egy belső (a GEDCOM-állományra utaló) azonosító, mely Önt az Ön genealógiai adataihoz kapcsolja. <br/><br/>Ezt az azonosítót kizárólag az oldal adminisztrátora változtathatja meg, így ha Ön úgy véli, az azonosító hibás, kapcsoaltba kell lépnie az adminisztrátorral.<br/>";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br/><br/>Ez a grafikonok kezdő (első) személyének azonosítója.<br/>Tehát ha Ön kiválasztja pl. az Ősfát a menüből, ezt a személyt találja az oldal bal szélén. <br/>Természetesen nem kizárólag Ön lehet a kezdő személy, bármely olyan személyt kijelölhet, akinek az adatai publikusak az Ön számára.<br/>Egyes grafikonoknál egyedileg is megválaszthatja a kezdő szemléyt, de az csak azokra az oldalakra érvényes.<br/>";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br/><br/>Mindeképpen érdemes rendszeresen megváltoztatni a jelszavát.<br/>Tartsa szem előtt, hogy aki tudja az Ön felasználói nevét és jelszavát, az hozzáférhet az Ön adataihoz. <br/>Válasszon olyan jelszót, mely legalább 6 karakterből áll (minél hosszabb, annál jobb). Használhat minden, a billentyűzeten található karaktert, ugyanakkor érdemes a \" (idézőjel) és a ' (aposztróf) alkalmazását kerülni. Általában működnek, viszont egyes esetekben hibához vezethetnek.<br/><br/><b>Érdemes nagybetűk, kisbetűk, számok és egyéb karakterek kombinációjából összeállítani a jelszót, pl. 5Z_q\$P4=r9.<br/><br/>A felhasználói névhez hasonlóan a jelszó is <b>érzékeny a kis- és nagybetűkre</b>. Így a \"Jo5hn\" nem egyezik meg a \"jo5hn\"-nal vagy a \"JO5HN\"-nal.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br/><br/>Mikor mÖn megváltoztatja a jelszavát, meg is kell erősítenie azt. <br/>Ennek a lépésnek az a szerepe, hogy elkerülje a gépelési hibákból eredő tévedéseket.<br/>Amennyiben a program eltérést talál a jelszó és a megerősítés között: Ön a következő hibaüzenetet fogja kapni: <b>#pgv_lang[password_mismatch]#</b>.<br/>Ebben az esetben mindkét jelszómezőt ki kell üríteni és a jelszót újra be kell gépelni.<br/>";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br/><br/>Itt beállíthatja az Ön számára aalapértelmezett nyelvet.<br/>Ugyanakkor a program képes felismerni a böngésző nyelvi beállításait, tehát a legtöbb esetben nem szükséges itt is beállítani a nyelvet.<br/>Természetesen a ha böngésző beállításai között az angol szerepel, mint preferált nyelv, és Ön hollandot vagy a hébert szeretné az <b>oldal nyelveként</b> látni, azt beállíthatja itt.<br/>";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br/><br/>Itt szerepel az Ön (valós) e-mail címe. természetesen fontos, hogy kapcsoaltot tudjunk tartani Önnel, ezért ha megváltozik az Ön e-mail címe (például új szolgáltatót vesz igénybe, vagy egyszerűen egy másik e-mail címre szeretné kapni leveleit), kérjük, hogy ne feledkezzen meg az új cím rögzítéséről.<br/>";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br/><br/>Ezen az oldalon számos asztaltéma áll az Ön rendelkezésre <br/>(melyeket egyszerűen hívhatunk az \"oldal kinézetének\" is). Minden asztaltéma esetében ugyanaz a megjelenített információ, csak Ön más formában láthatja. <br/>Ezt hasonlíthatjuk ahhoz, ha egy képet új keretbe, vagy akár új szobába helyezünk, de a kép attól még változatlan marad. <br/>Nyugodtan próbálja ki a rendelkezésre álló asztaltémákat, használja azt, amelyik a legjobban tetszik Önnek. <br/>Amikor újra bejelentkezik az odalra, a program az Ön kiválasztott asztaltémáját fogja aktiválni.<br/>";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br/>Rendszerünkben több kapcsolattartási módot használhat. <br/>Az e-mailt, mint <b>üzenetküldő<b> módot, az adminisztrátor állítja be, tehát Ön ezt nem tudja módosítani.<br/>Ugyanakkor az üzenetek <b>fogadásának</b> módját Ön is megváltoztathatja.<br/>Jelenleg az alábbi négy módszer küzül választhat:";
$pgv_lang["mail_option1_help"]			= "Ha ezt a lehetőséget választja, a PhpGedView belső üzenőrendszerét fogja használni, és Ön felé nem továbbítunk e-mailt.<br/>Így csak ezek a <b>belső üzenetek</b> jutnak el Önhöz a többi felhasználótól.<br/>Ha egy felhasználó üzenetet küld Önnek, az Ön személyes oldalán, az Üzeneteim blokkban fog megjelenni (kivéve, ha eltávolította ezt a blokkot).<br/>";
$pgv_lang["mail_option2_help"]			= "Ezen mód a #pgv_lang[messaging]#hez hasonlít egyetlen eltérésse:<br/>A fogadott üzenetről fog kapni egy másolatot arra az e-mail címre, melyet Ön a személyes beállításainál megadott.<br/>Ez az alapértelmezett kapcsolattartási mód.<br/>";
$pgv_lang["mail_option3_help"]			= "Ha ezt a módot választja, akkor csupán az e-mail címére fogja megkapni az Önnek küldött üzenetet, és a felhasználók nem érhetik Önt el a belső üzenőrendszeren keresztül.<br/>";
$pgv_lang["mail_option4_help"]			= "Ezen opció alapján Ön egyáltalán nem fog üzeneteket kapni. Még az adminisztrátor sem tudja elérni.<br/><br/>";

//-- Add user
//$pgv_lang["help_adduser.php"]			= "#pgv_lang[sorry]#";

//-- Admin
$pgv_lang["admin_help"]				= "Ezen az oldalon Ön azokat a hivatkozásokat találja, melyekkel eljuthat a konfigurációs oldalakhoz, adminisztrátori oldlakhoz, dokumentációkhoz és a napló-állományokhoz.<br/><br/>Az oldal címe alatt látható <b>rendszeridő</b> annak a szervernek az óráját mutatja, melyen az Ön oldala fut.<br/><br/><b>FIGYELEM!</b><br/>Ha Ön egy figyelmeztető üzenetet lát a rendszeridő alatt, akkor az Ön <b>config.php</b> állománya jelenleg is írható.<br/>A beállítások elvégzése után <b>biztonsági okokból</b> célszerű azt csak olvashatóvá tenni.<br/>Sajnos ezt Önnek kell <b>\"kézzel\"</b> elvégezni, mivel a PhpGedView jelenleg (még) nem tudja módosítani ezt a beállítást.<br/><br/>Az OLVASSEL Dokumentáció, a Felhasználói kézikönyv és a napló állományok kivételével a többi lehetőségról az adott oldalokon juthat további információhoz.";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~#pgv_lang[user_admin]#~<br/><br/>Ezen az oldalon Ön szerkesztheti a jelenlegi felhasználók beállításait, illetve új felhasználókat vehet fel.<br/><br/><b>Aktuális felhasználó-lista</b><br/>Ebben a táblázatban taálja meg at aktuális felhasználókat, státuszukat és jogosultságaikat.<br/>Itt <b>törölheti</b> vagy <b>szerkesztheti</b> az egyes felhasználókat.<br/><br/><b>Új felhasználó űrlap</b><br/>Ez az űrlap majdnem teljesen megegyezik a \"Felhasználói adataim\" hivatkozáson át elérhetővel.<br/>Bizonyos esetekben nem készítettünk speciálisan az adminisztrátornak szóló segítséget. Ilyenkor Ön a következő üzenetet fogja kapni:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br/><br/>Ez a felhasználó azonosítója a GEDCOM-állományban, melyet az adminisztrátor állít be.<br/>Csak ennek megadása után érheti el a felhasználó az \"Én ésa családom\" valamint a \"Családfám\" menüpontokat.<br/><br/>Miden egyes GEDCOM esetében lehetséges egyedileg megadni a felhasználó azonosítóját.<br/>Ha a felhasználó nem szerepel a GEDCOM-ban, hagyja a mezőt üresen.<br/><br/>";
$pgv_lang["useradmin_rootid_help"]		= "~A CSALÁDFA-GRAFIKON KEZDŐ SZEMÉLYE~<br/><br/>A programban kezelt minden egyes GEDCOM-állományhoz minde felhasználó esetében definiálhatja a <b>kezdő személyt</b>.<br/>Lehetséges, hogy a felhasználó azt szeretné, hogy vele kezdődjön a megjelenített ősfa, de ez nem szükségszerű.<br/><br/>A felhasználó saját maga is megváltoztathatja ezt a személyt a szemléyes beállításain keresztül.";
$pgv_lang["useradmin_can_admin_help"]		= "~#pgv_lang[can_admin]# CHECK BOX~<br/><br/>Ha ez a négyzet be van jelölve, a felhasználónak éppen olyan jogosultsága van, mint Önnek.<dl><dt>Tehát nem csupán </dt><dd>hozzáadhat / eltávolíthat / szerkeszthet felhasználókat,</dd><dd>egyszerre küldhet üzenetet az összes felhasználónak, </dd><dd>szerkesztheti a Nyitólap üzeneteit,</dd><dd>szerkesztheti és beállíthatja a nyelvi állományokat, </dd><dt>hanem ugyanígy</dt><dd>frissítheti a programot, </dd><dd>megváltoztathatja a beállításokat,</dd><dd>módosíthatja a GEDCOM-beállításokat,</dd><dd>szerkesztheti a diszkrét adatkezelésre vonatkozó beállításokat.</dd><dt>Illetve elláthat néhány további  feladatot is,</dt><dd>de azokat az oldalra vonatkozó beállításokat, melyek ezen programon kívül történnek, nem módosíthatja.</dd></dl> ";
$pgv_lang["useradmin_can_edit_help"]		= "~\"A FELHASZNÁLÓ SZERKESZTHET\" JELÖLŐNÉGYZET(EK)~<br/><br/>Ha ez a négyzet be van jelölve, a felhasználó szerkesztheti annak a GEDCOM-állománynak a rekordjait, mely a négyzet mellett látható.<br/><br/>A rekordokat érintő bármilyen változtatást Önnek - vagy más, adminisztrátori jogosultsággal rendelkező felhasználónak - kell <b>jóváhagyni</b>. A jóváhagyás után az érintett GEDCOM-állományt <b>újra kell importálni</b>, hogy a változások életbe léphessenek.";
$pgv_lang["useradmin_verified_help"]		= "~A FELHASZNÁLÓ MEGERŐSÍTETTE JELENTKEZÉSÉT~<br/><br/><b>Regisztráció</b><br/>A felhasználók a <b>Regisztrációs Modul</b> segítségével folyamodhat új hozzáférésért.<br/>Ha megtette, kapni fog egy e-mailt egy hivatkozással, mellyel megerősítheti jelentkezését.<br/>Ön látni fogja a jelölőnégyzeten, amikor ezt is megtette, és jöhet a következő lépés: <b>a felhasználó befogadása</b>.<br/>Ha a felhasználó nem erősített meg jelentkezését, Önnek várnia kell az engedélyezéssel.<br/><br/><b>A felhasználó kézi hozzáadása:</b><br/>Ha Ön az űrlap kitöltésével \"kézzel\" adja hozzá a felhasználót, ezt a négyzetet megjelölve fogja találni.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~AZ ADMINISZTRÁTOR ELFOGADTA A FELHASZNÁLÓT~<br/><br/>Ha a felhasználó a Regisztrációs Modult használta és megerősítette jelentkezését, az Ön jóváhagyása az utolsó lépés a regisztráció befejezése előtt.<br/><br/>Miután Ön elfogadta jelentkezését, a felhasználó kap egy e-mailt, hogy hozzáférése aktív, és a regisztráció során használt felhasználónévvel és jelszóval bejelentkezhet az oldalra.";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br/><br/>Ezt az űrlapot az adminisztrátor használlja a felhasználói adatok karbantartására.<br/><br/>Az űrlap sokban hasonlít a <b>#pgv_lang[add_user]#</b> vagy a <b>#pgv_lang[update_myaccount]#</b> űrlapokra.<br/><br/>";

//-- Upgrade utility

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~GEDCOM ÁLLOMÁNYOK FELTÖLTÉSE ÉS HOZZÁADÁSA~<dl><dt>GEDCOM állományok feltöltése</dt><dd>Az állományok feltöltése online végezhető el.<br/>Ön tetszőleges helyről végezheti el a feltöltést, ehhez nincs szüksége FTP-kapcsolatra.</dd><dt>GEDCOM állományok hozzáadása</dt><dd>Ha egy állomány már rendelkezésre áll az Ön GEDCOM-könyvtárában, akkor azt hozzáadhatja, nincs szüksége feltöltésre.<br/>Bizonyos esetekben a hozzáadást kell alkalmazni feltöltés helyett, például túl nagy mérető állományok vagy feltöltési korlátozások miatt.</dd></dl>Mindkét módszer négy egyszerű lépésen keresztül végrehajtható, melyek csupán az első lépésben különböznek egymástól.<br/>";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM KONFIGURÁCIÓS ÁLLOMÁNY~<br/><br/>Ebben az állományban tárolódik a GEDCOM-állományokra vonatkozó összes alapvető beállítás.<br/><br/>A GEDCOM-állományok adminisztrációs oldalán, a \"Konfigurációs állomány\" oszlopban találhatja meg az egyes konfigurációs állományok nevét és elérési útját.";
$pgv_lang["default_gedcom_help"]		= "~ALAPÉRTELMEZETT GEDCOM~<br/><br/>Amennyiben Ön egynél több GEDCOM-állományt használ, akkor ebben a mezőben láthatja, melyik állomány szzámít <b>alapértelmezettnek</b>.<br/><br/>Ezen állomány tartalmát láthatják azok a látogatók, akik még nem jelentkeztek be.<br/><br/>A regisztrált felhasználók a maguk számára felülírhatják ezt a beállítást, ha a felhasználói adataik között módosítják azt.<br/>";
$pgv_lang["delete_gedcom_help"]			= "~TÖRLÉS~<br/><br/>A PhpGedView mindig egy GEDCOM-állományból veszi át a megjelenített rekordokat. Mikor Ön a <b>Törlésre</b> kattint, a program minden, a GEDCOM-állományból származó adatot töröl.<br/>Természetesen az érintett GEDCOM-állomány továbbra is abban a könyvátban lesz megtalálható, ahová Ön feltöltötte. <br/><br/>Így ha a későbbiekben újra dolgozni szeretne vele, nem kell ismét feltölteni, elegendő az <b>Új GEDCOM-állomány hozzáadása</b> opciót kiválasztania.<br/><br/>Miután Ön a Törlésre kattintott, egy felugró ablakban kell <b>megerősítenie</b> ezt a döntést.";
//$pgv_lang["edit_gedcom_help"]			= "~GEDCOM Szerkesztés~<br/><br/>#pgv_lang[sorry]#";
$pgv_lang["add_gedcom_help"]			= "~ÚJ GEDCOM-ÁLLOMÁNY HOZZÁADÁSA~<br/><br/>Az új GEDCOM-állomány hozzáadásának lehetősége abban az esetben működik, ha Ön már valamilyen <i>külső megoldással</i> - például <b>FTP-</b> vagy <b>hálózati kapcsolaton</b> keresztül - feltöltötte a szerverre a GEDCOM-állományt.<br/>Amennyiben ez még nem történt meg, Önnek először fel kell töltenie az állományt, utána indíthatja el a hozzáadást.<br/><br/>A folyamaton lépésről lépésre vezetjük Önt keresztül.<br/>";
$pgv_lang["add_new_gedcom_help"]		= "~ÚJ GEDCOM ÁLLOMÁNY LÉTREHOZÁSA~<br/><br/>Biztosítjuk Önnek azt a lehetőséget is, hogy új GEDCOM-állományt hozzon létre a semmiből. <br/><br/>Ez az eljárási is néhány lépésen keresztül elvégezhető: Ezek közül az első tér el a feltöltésnél és a hozzáadásnál megismert eljárástól, a többi lépés ismerős lesz Önnek.<dl><dt>1. lépés: Az új GEDCOM-állomány lenevezése</dt><dd>Gépelje be az új GEDCOM-állomány nevét, a '.ged' kiterjesztés nélkül. Az új állomány a beviteli mező alatt látható könyvtárba fog kerülni.<br/>Kattintson a  <b>Hozzáadás</b> hivatkozásra.</dd><dt>2. lépés: Beállítások.</dt><dd>Ezt az oldalt Ön a GEDCOM-állományok beállításai kapcsán már megismerhette.</dd><dt>3. lépés: Ellenőrzés</dt><dd>Ez a lépés szintén ismerős lehet, ellenőrizzük az új GEDCOM-állományt.</dd><dt>4. lépés: Rekordok importálása</dt><dd>Mivel kezdetben egy rekordot kell importálni, a folyamat gyorsan le fog zajlani.</dd><dt>Létrehozás befejezése</dt><dd>Most már átléphet az ősfa oldalára, ahol láthatja az új GEDCOM-állomány első személyét. Kattintson a személy nevére és kezdje el feltölteni az adatait. Ezek után hozzáadhat új személyeket is, akik rokonságban állnak az első rögzített személlyel.</dd></dl>";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br/><br/>Önnek rendelkezésére áll az a lehetőség, hogy honlapon megtalálható GEDCOM-állományokat letöltse.<br/><br/>A \"GEDCOM-állomány letöltése\" oldalon eldöntheti, hogy átkonvertálja-e az állományt <b>UTF-8-as</b> kódolásból <b>ANSI (ISO-8859-1)-re</b>.<br/>Hogy melyik formátum a megfelelő az Ön számára, az attól függ, milyen programmal kívánja feldolgozni a letöltés után.<br/>Ellenőrizze a program dokumentációját, ha nem biztos a döntésben.";
$pgv_lang["edit_gedcoms_help"]			= "~GEDCOM-KEZELÉS~<br/><br/>A GEDCOM-állományok adminisztrációs oldala az a központi lap, melyen ön elvégezheti az <b>aktuális</b> és az <b>új</b> GEDCOM-állományokra vonatkozó beállításokat.<br/><dl><b>AKTUÁLIS  GEDCOM-ÁLLOMÁNYOK</b><br/><dt>Az <b>aktuális GEDCOM-állományok</b> táblázatában Önnek a következőkre van lehetősége:</dt><dd>Törlés</dd><dd>Szerkesztés</dd><dl><dt>Diszkréciós beállítások</dt><dd>A diszkréciós beállíátsok szerkesztlése is része ennek a táblázatnak, mivel minden GEDCOM-állománynak saját diszkréciós állománya van.</dd></dl><dd>Alapértelmezett GEDCOM beállítása</dd><dd>GEDCOM importálása</dd><dd>GEDCOM letöltése</dd><dt>Ezen kívül még a következő három oszlop található itt:</dt><dd>GEDCOM-állomány</dd><dd>GEDCOM-állomány címe</dd><dd>Konfigurációs állomány</dd></dl><dl><b>ÚJ GEDCOM-ÁLLOMÁNYOK</b><dt>Ezen az oldalon Önnek a következő lehetőségei vannak az <b>új</b> és/vagy a <b>már létező</b> GEDCOM-állomány hozzáadására.</dt><dd>Új GEDCOM-állomány hozzáadása</dd><dd>GEDCOM-állomány feltöltése</dd><dd>Új GEDCOM-állomány létrehozása</dd></dl>#pgv_lang[more_help]#<br/>";
$pgv_lang["edit_config_gedcom_help"]	= "~GEDCOM SZERKESZTÉSE~<br/><br/>Minden, Ön által használt GEDCOM-állomány rendelkezik saját <b>konfigurációs állománnyal</b>.<br/><br/>Ezen az űrlapon az olyan alapvető beállítások adhatók meg, mint a nyelv, naptár-formátum, e-mail lehetőségek stb.<br/>";
$pgv_lang["import_gedcom_help"]			= "~GEDCOM IMPORTÁLÁSA~<br/><br/>Az esetek többségében a GEDCOM-állományok importálása csak egy lépése az olyan folyamatoknak, mint pl. GEDCOM-állományok hozzáadása és feltöltése.<br/><br/>Ezen lépések egy logikai folyamat részét képezik és mindenképpen be kell őket fejezni, hogy Ön működéképes GEDCOM-állományt használhasson.<br/>Ha Ön nem fejezi be a folyamatot, <b>figyelmeztető</b> üzenetet fog látni, mely szerint az importálás nem készült él, és kattintson a megjelölt hivatkozásra a GEDCOM-állomány (újra)importálásához.<br/><br/><b>Importálás</b><br/>Abban az esetben, ha Ön vagy valamely másik felhasználó <b>online változtatást</b> végzett a GEDCOM-állományban, akkor azt újra kell importálni, hogy a módosítások rögzítésre kerüljenek.<br/><br/>A konfigurációs beállítások ugyanakkor az állomány újraimportálásával nem változnak meg, viszont a létező adatokat a program felülírja.";
$pgv_lang["upload_gedcom_help"]			= "~GEDCOM-ÁLLOMÁNY FELTÖLTÉSE~<br/><br/>A \"GEDCOM-állomány hozzáadása\" opciótól eltérően nem szükséges, hogy az állomány már a szerveren legyen.<br/><br/>Az 1. lépésben Önnek a számítógépen megtalálható állományt kell kiválasztania. Gépelje be a teljes elérési utat és az állomány bevét a beviteli mezőbe, vagy használja a <b>Böngészés</b> lehetőségét.<br/><br/>A feltöltési folyamat egyes lapjain további segítséget kaphat e témakörben.<br/>";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~A PhpGedView BEÁLLÍTÁSA~<br/><br/>Ezen az oldalon kell Önnek elvégeznie a program általános beállítását, miután elvégezte a PhpGedView telepítését, és első alkalommal futtatja a programot.<br/>#pgv_lang[review_readme]#<br/><br/>Mivel ezek a beállítások <b>általánosak</b>, ezért az egész programot és az összes GEDCOM-állományt érintik.<br/>Ugyanakkor az egyes GEDCOM-állományokra vonatkozó beállításokat is van lehetősége elvégezni.<br/>Ennek érdekében kattintson az űrlap fölött található hivatkozásra.<br/>Minden más esetben az erre vonatkozó hivatkozást megtalálja a a MyGedView Portál menüjében.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br/>Ezzel a jelentéssel Őn kitudja listázni azokat a személyeket akik egy bizonyos időben vagy helyen született.<br/><br/>";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>SEGÍTSÉG TARTALOMJEGYZÉK</b><br/><br/>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM infó";
$pgv_lang["help_contents_gedcom_places"]	= "Helyszínek a GEDCOM -ban";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>SEGÍTSÉG TARTALOMJEGYZÉK<br/><br/>ADMINISZTRÁTOR SEGÍTSÉG ELEMEI</b> hozzá lettek adva a lista elejéhez.<br/><br/>";
$pgv_lang["ah2_help"]				= "_PhpGedView Konfiguráció";
$pgv_lang["ah3_help"]				= "_GEDCOM: Hozzáadás vs Feltőltés";
$pgv_lang["ah4_help"]				= "_GEDCOM: Konfiguráció állomány";
$pgv_lang["ah5_help"]				= "_GEDCOM: Alap";
$pgv_lang["ah6_help"]				= "_GEDCOM: Törlés";
$pgv_lang["ah7_help"]				= "_GEDCOM: Hozzáadás";
$pgv_lang["ah8_help"]				= "_GEDCOM: Új";
$pgv_lang["ah9_help"]				= "_GEDCOM: Letőltés";
$pgv_lang["ah10_help"]				= "_GEDCOM: Adminisztráció oldal";
$pgv_lang["ah11_help"]				= "_GEDCOM: Konfiguráció";
$pgv_lang["ah12_help"]				= "_GEDCOM: Import";
$pgv_lang["ah13_help"]				= "_GEDCOM: Feltőltés";
$pgv_lang["ah14_help"]				= "_GEDCOM: Érvényesítés";
$pgv_lang["ah15_help"]				= "_GEDCOM: Átírás ANSI -ról UTF-8 -ra";
$pgv_lang["ah16_help"]				= "_GEDCOM: Bizalmas beállítások";
$pgv_lang["ah17_help"]				= "_Felhasználó Adminisztrálás";
$pgv_lang["ah18_help"]				= "_Adminisztrálás";
$pgv_lang["ah19_help"]				= "_GEDCOM: Média Eszköz";
$pgv_lang["ah20_help"]				= "_GEDCOM: Személy azonósitó változtatása";
$pgv_lang["ah21_help"]				= "_Nyelvi eszközök";
// 22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Támogatott nyelvek konfigurációja";
$pgv_lang["ah26_help"]				= "_FAQ lista: Szerkesztés";
$pgv_lang["help_faq.php"]			= "~Gyakran Ismételt Kérdések~<br/>#pgv_lang[text_faq_help]#<br/>";
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br/>#pgv_lang[hs_intro]#<br/><br/>#pgv_lang[hs_keyword_advice]#<br/><br/>#pgv_lang[hs_searchhow_advice]#<br/><br/>#pgv_lang[hs_searchin_advice]#";

//-- Index-page Portal

$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br/><br/>Ebbe a mezőbe irja be a személy azonosítóját akihez kapcsolni akar (pl. I100).";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";

?>
