#include <iostream>
#include <stdlib.h>
#include <string.h>

#include <gdk-pixbuf/gdk-pixdata.h>

#include "../imagesource/imagesource_desaturate.h"
#include "../layout.h"

#include "ppeffect_desaturate.h"
#include "ppeffect_desaturate_icon.cpp"

PPEffect_Desaturate::PPEffect_Desaturate(PPEffectHeader &header,enum PPEFFECT_STAGE stage)
	:	PPEffect(header,stage)
{
}


PPEffect_Desaturate::~PPEffect_Desaturate()
{
}


ImageSource *PPEffect_Desaturate::Apply(ImageSource *source)
{
	return(new ImageSource_Desaturate(source));
}


GdkPixbuf *PPEffect_Desaturate::icon=NULL;

GdkPixbuf *PPEffect_Desaturate::GetIcon_static()
{
	if(icon)
		return(icon);
	GdkPixdata pd;
	GError *err;

	if(!gdk_pixdata_deserialize(&pd,sizeof(PPEffect_Desaturate_Icon),PPEffect_Desaturate_Icon,&err))
		throw(err->message);

	if(!(icon=gdk_pixbuf_from_pixdata(&pd,false,&err)))
		throw(err->message);

	return(icon);
}
