/* PSK31 -- transmitter class
 * (C) 1998 Hansi Reiser DL9RDZ
 */

#ifndef __PSK31_TRANSMITTER_INCLUDED
#define __PSK31_TRANSMITTER_INCLUDED

#include <qobject.h>
#include "psk31_coder.h"
#include "psk31.h"

class psk31_transmitter : public QObject
{

Q_OBJECT

private:
	static unsigned int cwtab[58];
	psk31_coder coder;
	int audiofd;
	int qpsk;
	int lsb;
	float _txfreq;
	int txfreq;
	int txphase;
	/* process31 / filter_tx_sample */
	float txIold,txQold,txInew,txQnew;
	int stat;
	/* getnextsymbol */
	unsigned char shiftreg;     /* Transmit shift register */
	unsigned int codewordbuf;   /* Current codeword buffer */
	int full_duplex;
	int useqpsk;
	int keydown;
	int busy, idle;
	int new_tx;
	int echo_char, pending_sample;
	int txSample;
	int txStart;
	int break_in;

#define TXBUFSIZE 1024
	unsigned int txbuf[TXBUFSIZE], *txbuf_sta, *txbuf_end;
	char *strupr(char *str);
	int process_31();
	int filter_tx_sample(int stat);  /* 8000Hz-Process TX */
	int getnextsymbol();
	int get_buffer_entry();
	void send_cw_char(int ch);
	void putcodeword(int cw);
	int getcodeword();
public:
	psk31_transmitter() {
		txIold=txInew=1; txQold=txQnew=0;
		txbuf_sta=txbuf; txbuf_end=txbuf;
		stat=255;
		echo_char=0; new_tx=1;
		pending_sample=EMPTY_SAMPLE;
		set_freq(1250);
		txStart = 0;
		break_in = 0;
	}
	void set_mode(int q, int l) { 
		qpsk=q; lsb=l; 
		coder.setmode(q, l);
	}
	void set_freq(float f) { _txfreq=f; txfreq=(int)(65536.0/8000*f); }
	void get_info(int *q, int *l, float *f) {
		if(q) *q=qpsk; if(l) *l=lsb; if(f) *f=_txfreq;
	}
	void set_audiofd(int fd) { audiofd=fd; }
	void setFullDuplex( int fullDuplex ) { full_duplex = fullDuplex; }
	int send_char(int c);
	int send_string(char *str);
	int send_cw_string(int need_postamble, char *str);
	void sendpreamble();
	void sendpostamble();
	int processor(); /* returns TX_BUSY / NO_CHAR / sent character */

	void tune( void );
    /** Return the current tx sample */
    int getTxSample( void );
    /** Flush the tx buffer */
    void flush();
    void setBreakIn( int );

signals: // Signals
  /**  */
  void signalSymbol( int );
  /**  */
  void signalSample( short );
};

#endif
