/* PSK31  -- receiver class */
/* mods by Ted Williams - WA0EIR */
/* mods by Edson Pereira, PU1JTE, N1VTN */

#include <math.h>
#include <stdio.h>
#include <unistd.h>

#include "psk31receiver.h"
#include "coeff.h"   /* float fir1c[], fir2c[] */

const int Psk31Receiver::confidenceLen = CONFLEN;

/* returns: -1: new sym,now rxbuf full; 0=no new sym; 1=new sym */
/* currently: returns: new char, or NO_CHAR */
int Psk31Receiver::process_rx_sample(int sample)
{
   float s,c,scarg,smpl;
   int retval;

   smpl=sample*(1/32767.0);  /* scale to -1.0 .. 1.0 */

   /* Compute current rx LO value */
   rxphase=(rxphase+rxfreq)&0xFFFF;
   scarg=rxphase*(1.0/65536*2*M_PI);
   s=sin(scarg); c=cos(scarg);

   /* "mixer" to create I/Q out of Sample and LO */
   ibuf1_I[ibuf1_cur]=s*smpl; 
   ibuf1_Q[ibuf1_cur]=c*smpl;
   ibuf1_cur = (ibuf1_cur+1)%FIR1TAPS;

   /* Every 16 samples run 500Hz-RX-Process */
   if( (stat&0x0F) == 0 ) {
      retval=process_500();
   }
   else retval=NO_CHAR;
      stat=(stat+1)&0xFF;
   return retval;
}


/* returns received character (or NO_CHAR) */
int Psk31Receiver::process_500()
{
   float Ival, Qval;
   int cor, xxx, index, i;
   unsigned int temp;

   /* do the downsampling decimation filter into second buffer */ 
   Ival=ibuf2_I[ibuf2_cur]=do_fir(ibuf1_I, ibuf1_cur, fir1c, FIR1TAPS);
   Qval=ibuf2_Q[ibuf2_cur]=do_fir(ibuf1_Q, ibuf1_cur, fir1c, FIR1TAPS);
   if( (++ibuf2_cur) == FIR2TAPS ) ibuf2_cur=0;

   /* And do the second FIR filtering */
   Ival=do_fir(ibuf2_I, ibuf2_cur, fir2c, FIR2TAPS);
   Qval=do_fir(ibuf2_Q, ibuf2_cur, fir2c, FIR2TAPS);


   /* Compute amplitude in dB, shift itt to the left in 'temp' */
   /* i guess simply calling 'log' would be faster on modern machines? */
   temp= (unsigned int)(65536 * ( Ival*Ival + Qval*Qval ));
   if(temp)
   {
      xxx = 31;
      while( xxx && !( temp & 0x80000000 ) )
      {
        xxx--; temp <<= 1;
      }
      temp = (xxx << 20) | (( temp & 0x7FFFFFFF) >> 11);
   }

   /* Now to the bit synchronisation. */
   index=bitclk>>20;
   amp_buf[index]=temp;

   cor=0;
   for(i=0; i <  8; i++) cor+=amp_buf[i];
   for(   ; i < 16; i++) cor-=amp_buf[i];

   cor/=500;  /* syngain=0.002 */
   bitclk-=cor; 
   bitclk+=0x100000;
   if(bitclk&0xFF000000) {
      /* here we are at the center of the bit... */
      bitclk&=0xFFFFFF;
      complex IQval; IQval.x=Ival; IQval.y=Qval;
    //    strength = (int)((10.0 * log10( Ival*Ival + Qval*Qval ) + 96) * 0.67);
    // calculate the strength and do some rough scaling
    strength = (int)((10.0 * log10( Ival*Ival + Qval*Qval ) + 64));
    if (strength > 50) strength = 50;
    else if ( strength < 0 ) strength = 0;
    emit signalStrength();

      return process_rx_symbol(IQval);
   }
   else 
      return NO_CHAR;
}


int Psk31Receiver::process_rx_symbol(complex rxsymb)
{
   int diffphase, rxphase;
   static int confidenceIndex = 0;

   rxphase=psk31_coder::IQ2iphase(rxsymb)>>8;
   diffphase=(rxphase-lastphase)&0xFF;
   lastphase=rxphase;

   doafc(diffphase);	/* Do automatic frequency correction */

   if ( diffphase < 8 || diffphase > 247 )
        confidence_A[ confidenceIndex ] = 1;
   else if ( diffphase < 135 && diffphase > 119 )
        confidence_A[ confidenceIndex ] = 1;
   else confidence_A[ confidenceIndex ] = 0;

   if ( confidenceIndex++ > CONFLEN ) confidenceIndex = 0;

   lastdelta=diffphase;
   diffphase=diffphase2symbol(diffphase);

   dodcd(diffphase);   /* Do DCD */

   int res=coder.decode(rxsymb, diffphase);

   return res;
}

void Psk31Receiver::doafc(int dp)
{
   if( !dcd || !afc)
      return;    /* Don't correct if: DCD is off,  */
                 /* we're sending, or AFC disabled */
   if(qpsk)
      dp = (int)((char)((dp<<2)&0xFF));   /* remove 2 MSBs */
   else
      dp = (int)((char)((dp<<1)&0xFF));   /* remove 1 MSB */
   if(dp == -128) /* eliminate bias */
      dp = 0;

   #if 0 /* slow */
      _rxfreq += dp * 0.0002; /* apply correction */
   #else
      _rxfreq += dp * 0.0005; /* apply correction */
   #endif

   rxfreq = (int)(65536.0/8000*_rxfreq);
}

void Psk31Receiver::dodcd(int symbol)
{
   static unsigned long dcdshfreg;

   dcdshfreg <<= 2; /* Shift register left */
   dcdshfreg += symbol; /* Insert latest symbol */
   if(dcdshfreg == 0xAAAAAAAAL)
   {
      dcd = 1;
      emit dcdOn();
   }
   else if(dcdshfreg == 0L)
   {
      dcd = 0;
      _confidence = 0;
      resetConfidence();
   }
}


float Psk31Receiver::do_fir(float *base, int cur, float *coeff, int len)
{
   int c=0, i;
   float sum=0;

   for(i=cur; i<len; i++,c++) sum+=coeff[c]*base[i];
   for(i=0; i<cur-1; i++,c++) sum+=coeff[c]*base[i];
   return sum;
}


int Psk31Receiver::diffphase2symbol(int diffphase)
{
   /* Convert diffphase to symbol number (0...3) */
   if(qpsk)
      diffphase = ((diffphase + 0x20) & 0xC0) >> 6;
   else
      diffphase = ((diffphase + 0x40) & 0x80) >> 6;
   if(lsb)
      diffphase = (4 - diffphase) & 3;
   return diffphase;
}

void Psk31Receiver::resetConfidence( void )
{
   for ( int i = 0; i < CONFLEN; i ++ ) confidence_A[i] = 0;
}
