function Y = pfs_read_luminance( fileName )
% Read hdr image file (formats accepted by pfsin) and return
% luminance channel Y.
%
%  Y = hdr_read_luminance( fileName )

Y = -1;

  % Check if file exists
  fid = fopen( fileName, 'r' );
  if( fid == -1 ) 
    error( 'pfs_read_luminance: File "%s" does not exist', fileName );
  end
  fclose( fid );
     
%  try
    fid = pfspopen( sprintf( '%spfsin ''%s''%s', pfs_shell(), fileName, pfs_shell( 1 ) ), 'r' );
    pin = pfsopen( fid );
    pin = pfsget( pin );
    Y = pin.channels.Y;  
    pfsclose( pin );
    % TODO: Check why crashes on windows
    if ~ispc()
        pfspclose( fid );
    end
%  catch
 %   pfsclose( pin );
 %   pfspclose( fid );
%  end

end