(** Wrapper around Perl [HTTP::Request] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_HTTP_Request.ml,v 1.4 2005/01/13 16:06:04 rich Exp $
  *)

open Perl

open Pl_HTTP_Message
open Pl_URI

let _ = eval "use HTTP::Request"

class http_request sv =

object (self)
  inherit http_message sv

  method sv = sv

  method method_ =
    string_of_sv (call_method sv "method" [])
  method set_method meth =
    call_method_void sv "method" [sv_of_string meth]
  method uri =
    string_of_sv (call_method sv "uri" [])
  method set_uri uri =
    call_method_void sv "uri" [sv_of_string uri]
  method as_string =
    string_of_sv (call_method sv "as_string" [])

end

let new_ meth ?uri_obj ?uri (* ?header ?content *) () =
  let sv =
    match uri_obj, uri with
	None, None ->
	  failwith ("Pl_HTTP_Request.new_ must be called with either a "^
		    "~uri_obj (URI object) or ~uri (string) parameter.")
      | Some (uri_obj : uri), None ->
	  call_class_method "HTTP::Request" "new" [sv_of_string meth;
						   uri_obj#sv]
      | _, Some uri ->
	  call_class_method "HTTP::Request" "new" [sv_of_string meth;
						   sv_of_string uri]
  in
  new http_request sv
