/*
 * MUSCLE SmartCard Development ( http://www.linuxnet.com )
 *
 * Copyright (C) 2006
 *  Ludovic Rousseau <ludovic.rousseau@free.fr>
 *
 * $Id$
 */

/**
 * @file
 * @brief This keeps a list of defines for pcsc-lite.
 */

#ifndef __pcscd_h__
#define __pcscd_h__

#define SCARD_SCOPE_GLOBAL		0x0003	/**< Scope is global */

#define SCARD_RESET			0x0001	/**< Card was reset */
#define SCARD_INSERTED			0x0002	/**< Card was inserted */
#define SCARD_REMOVED			0x0004	/**< Card was removed */

#define BLOCK_STATUS_RESUME		0x00FF	/**< Normal resume */
#define BLOCK_STATUS_BLOCKING		0x00FA	/**< Function is blocking */

#define PCSCLITE_CONFIG_DIR		"/etc"

#define PCSCLITE_IPC_DIR		USE_IPCDIR
#define PCSCLITE_RUN_PID		PCSCLITE_IPC_DIR "/pcscd.pid"

#define PCSCLITE_READER_CONFIG		PCSCLITE_CONFIG_DIR "/reader.conf"
#define PCSCLITE_PUBSHM_FILE		PCSCLITE_IPC_DIR "/pcscd.pub"
#define PCSCLITE_CSOCK_NAME		PCSCLITE_IPC_DIR "/pcscd.comm"

#define PCSCLITE_SVC_IDENTITY		0x01030000	/**< Service ID */

#define PCSCLITE_INFINITE_TIMEOUT	4320000		/**< 50 day infinite t/o */

#define PCSCLITE_VERSION_NUMBER		"1.4.99"	/**< Current version */
#define PCSCLITE_CLIENT_ATTEMPTS	120		/**< Attempts to reach sv */
#define PCSCLITE_MCLIENT_ATTEMPTS	20		/**< Attempts to reach sv */
#define PCSCLITE_STATUS_POLL_RATE	400000		/**< Status polling rate */
#define PCSCLITE_LOCK_POLL_RATE		100000		/**< Lock polling rate */
#define PCSCLITE_MSG_KEY_LEN		16		/**< App ID key length */
#define PCSCLITE_RW_ATTEMPTS		100		/**< Attempts to rd/wrt */

/** Maximum applications */
#define PCSCLITE_MAX_APPLICATIONS			16
/** Maximum contexts by application */
#define PCSCLITE_MAX_APPLICATION_CONTEXTS		16
/** Maximum of applications contexts that pcscd can accept */
#define PCSCLITE_MAX_APPLICATIONS_CONTEXTS \
	PCSCLITE_MAX_APPLICATIONS * PCSCLITE_MAX_APPLICATION_CONTEXTS
/** Maximum channels on a reader context */
#define PCSCLITE_MAX_READER_CONTEXT_CHANNELS		16
/** Maximum channels on an application context */
#define PCSCLITE_MAX_APPLICATION_CONTEXT_CHANNELS	16

/* PCSCLITE_MAX_READERS is deprecated
 * use PCSCLITE_MAX_READERS_CONTEXTS instead */
/* extern int PCSCLITE_MAX_READERS __attribute__ ((deprecated)); */

#define PCSCLITE_MAX_THREADS		16	/**< Stat change threads */
#define PCSCLITE_STATUS_WAIT		200000	/**< Status Change Sleep */
#define PCSCLITE_TRANSACTION_TIMEOUT	40	/**< Transaction timeout */
#define MAX_LIBNAME			100
#define MAX_DEVICENAME		255

/*
 * The message and buffer sizes must be multiples of 16.
 * The max message size must be at least large enough
 * to accomodate the transmit_struct
 */
#define PCSCLITE_MAX_MESSAGE_SIZE	2048	/**< Transport msg len */
#define MAX_BUFFER_SIZE			264	/**< Maximum Tx/Rx Buffer for short APDU */
#define MAX_BUFFER_SIZE_EXTENDED	(4 + 3 + (1<<16) + 3)	/**< enhanced (64K + APDU + Lc + Le) Tx/Rx Buffer */
#define PCSCLITE_SERVER_ATTEMPTS	5	/**< Attempts to reach cl */

#endif
