#include "papaya/system.h"
class Connection;
typedef int (*SystemTriggerCallbackFunction)(regex_t *, Connection *, char *, char *, void *);

#ifdef WIN32

class Plugin;

#define PLUGIN_WRAPPER(x) addr_x p_x;

#define register_plugin (*p_register_plugin)
#define unregister_plugin (*p_unregister_plugin)

#define preference_add_editor (*p_preference_add_editor)
#define preference_remove_editor (*p_preference_remove_editor)

#define connection_get_socket (*p_connection_get_socket)
#define connection_get_vt (*p_connection_get_vt)
#define connection_get_name (*p_connection_get_name)
#define connection_get_mud (*p_connection_get_mud)
#define connection_get_next (*p_connection_get_next)
#define connection_query_preferences (*p_connection_query_preferences)

#define event_get_type (*p_event_get_type)

#define socket_write (*p_socket_write)
#define socket_get_telnet_option (*p_socket_get_telnet_option)

#define vt_append (*p_vt_append)
#define vt_add_to_tray (*p_vt_add_to_tray)
#define vt_remove_from_tray (*p_vt_remove_from_tray)
#define vt_scroll (*p_vt_scroll)

#define get_prefix (*p_get_prefix)
#define get_global_preferences (*p_get_global_preferences)
#define get_command_interpreter (*p_get_command_interpreter)
#define get_first_connection (*p_get_first_connection)
#define get_main_window (*p_get_main_window)
#define get_entity_handler (*p_get_entity_handler)
#define get_plugin_handler (*p_get_plugin_handler)
#define get_connection_by_name (*p_get_connection_by_name)

#define entity_handler_add_entity (*p_entity_handler_add_entity)
#define entity_handler_remove_entity (*p_entity_handler_remove_entity)

#define system_trigger_entity_new (*p_system_trigger_entity_new)

#define main_window_get_item_factory (*p_main_window_get_item_factory)
#define main_window_get_current_connection (*p_main_window_get_current_connection)
#define main_window_add_page_for_app (*p_main_window_add_page_for_app)

#define command_interpreter_interpret (*p_command_interpreter_interpret)

#define mud_get_preferences (*p_mud_get_preferences)
#define mud_get_password (*p_mud_get_password)
#define mud_set_password (*p_mud_set_password)
#define mud_get_login_name (*p_mud_get_login_name)
#define mud_set_login_name (*p_mud_set_login_name)
#define mud_get_login_trigger (*p_mud_get_login_trigger)
#define mud_set_login_trigger (*p_mud_set_login_trigger)
#define mud_get_password_trigger (*p_mud_get_password_trigger)
#define mud_set_password_trigger (*p_mud_set_password_trigger)

#define preferences_set_preference (*p_preferences_set_preference)
#define preferences_get_preference (*p_preferences_get_preference)
#define preferences_set_preference_boolean (*p_preferences_set_preference_boolean)
#define preferences_get_preference_boolean (*p_preferences_get_preference_boolean)
#define preferences_set_preference_integer (*p_preferences_set_preference_integer)
#define preferences_get_preference_integer (*p_preferences_get_preference_integer)

#define plugin_handler_client_message (*p_plugin_handler_client_message)
#define plugin_handler_add_input_filter (*p_plugin_handler_add_input_filter)
#define plugin_handler_add_output_filter (*p_plugin_handler_add_output_filter)
#define plugin_handler_add_prompt_filter (*p_plugin_handler_add_prompt_filter)
#define plugin_handler_add_telopt_filter (*p_plugin_handler_add_telopt_filter)
#define plugin_handler_remove_input_filter (*p_plugin_handler_remove_input_filter)
#define plugin_handler_remove_output_filter (*p_plugin_handler_remove_output_filter)
#define plugin_handler_remove_prompt_filter (*p_plugin_handler_remove_prompt_filter)
#define plugin_handler_remove_telopt_filter (*p_plugin_handler_remove_telopt_filter)
#define plugin_handler_remove_telopt_filters (*p_plugin_handler_remove_telopt_filters)

#define turf_protocol_add_command (*p_turf_protocol_add_command)
#define turf_protocol_is_supported (*p_turf_protocol_is_supported)

#define message_new (*p_message_new)

#define fade_get_shade (*p_fade_get_shade)
#define fade_get_editor (*p_fade_get_editor)
#define fade_on_prefs_cancel (*p_fade_on_prefs_cancel)
#define fade_on_prefs_apply (*p_fade_on_prefs_apply)
#define fade_string_max_colour (*p_fade_string_max_colour)
#define fade_string_mid_colour (*p_fade_string_mid_colour)
#define fade_string_min_colour (*p_fade_string_min_colour)
#define fade_string_use_three (*p_fade_string_use_three)
#define fade_new (*p_fade_new)
#define fade_reset (*p_fade_reset)
#define fade_delete (*p_fade_delete)

#include "Win32PluginAPITable.h"

void plugin_address_table_init(plugin_address_table_t *);

#else // WIN32
#include "papaya/Win32PluginAPIImplementation.h"

typedef void plugin_address_table_t;
void plugin_address_table_init(plugin_address_table_t *);

#endif // WIN32
