#ifndef INCLUDE_HISTORY_H
#define INCLUDE_HISTORY_H

#include <glib.h>

#define MAX_HISTORY 100

struct history_entry {
  char * cmd;
  struct history_entry * prev;
  struct history_entry * next;
};

class History {

 public:
  History(int, bool);
  ~History();
  
  void add(char *, gboolean ignore_same);
  char * getNext();
  char * getPrev();
  char * findMatch(char *, gboolean honour_null);
  void setMaxSize(int);
  void setCircular(bool);

 private:
  struct history_entry * commands; 
  int size;
  int max_size;
  int circular;
  struct history_entry * read_pos;
  struct history_entry * write_pos;
  struct history_entry * search_pos;
};

#endif
