
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk.h 1100 2006-09-09 15:41:29Z mschwerin $
 *
 */

#ifndef HAVE_ODK_EVENT_H
#define HAVE_ODK_EVENT_H
#ifdef __cplusplus
extern "C" {
#endif

#include "event.h"

typedef enum {
    EVENT_HANDLER_PRIORITY_LOW,
    EVENT_HANDLER_PRIORITY_NORMAL,
    EVENT_HANDLER_PRIORITY_HIGH
} odk_event_handler_priority_t;

void odk_run (odk_t * odk);
void odk_exit (odk_t * odk);

void odk_listen_to (odk_t * odk, const char *id);

void odk_add_event_handler (odk_t * odk, event_handler_t eh, void *data,
                            odk_event_handler_priority_t priority);
void odk_del_event_handler (odk_t * odk, event_handler_t eh);

void odk_oxine_event_send (odk_t * odk, oxine_event_t * event);
void odk_xine_event_send (odk_t * odk, bool force, int type);

bool odk_get_forward_events_to_xine (odk_t * odk);
void odk_set_forward_events_to_xine (odk_t * odk, bool forward);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_ODK_EVENT_H */
