#ifndef __OVCAM_COMPAT_H
#define __OVCAM_COMPAT_H

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 4, 23)
#  include <linux/slab.h>
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 5, 0)
#define dev_err(dev, format, arg...) printk(KERN_ERR __FILE__ ": " \
	format , ## arg)

#define dev_info(dev, format, arg...) printk(KERN_INFO __FILE__ ": " \
	format , ## arg)

#define dev_warn(dev, format, arg...) printk(KERN_WARNING __FILE__ ": " \
	format , ## arg)

#define dev_dbg(dev, format, arg...) pr_debug("[%s:%d] " \
	format "\n", __FUNCTION__, __LINE__ , ## arg)
#endif

#if !defined(module_param)
#define OV_MODULE_PARM_int(var) MODULE_PARM(var, "i")
#define module_param(var, type, mode) OV_MODULE_PARM_## type(var)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 5, 67)
static inline void * i2c_get_clientdata(struct i2c_client *dev)
{
	return dev->data;
}

static inline void i2c_set_clientdata(struct i2c_client *dev, void *data)
{
        dev->data = data;
}

static inline void * i2c_get_adapdata(struct i2c_adapter *dev)
{
	return dev->data;
}

static inline void i2c_set_adapdata(struct i2c_adapter *dev, void *data)
{
        dev->data = data;
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 4, 23)
static inline void * video_get_drvdata(struct video_device *vdev)
{
        return vdev->priv;
}

static inline void video_set_drvdata(struct video_device *vdev, void *data)
{
        vdev->priv = data;
}

static inline struct video_device *video_device_alloc(void)
{
	struct video_device *vfd;

	vfd = kmalloc(sizeof(*vfd),GFP_KERNEL);
	if (NULL == vfd)
		return NULL;
	memset(vfd,0,sizeof(*vfd));
	return vfd;
}

static inline void video_device_release(struct video_device *vfd)
{
	kfree(vfd);
}
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 13)
#  define TUNER_SET_TYPE _IOW('t',1,int)
#endif

#endif /* ! __OVCAM_COMPAT_H__ */
