/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ShearedStereoCameraDecorator!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESHEAREDSTEREOCAMERADECORATORINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGShearedStereoCameraDecoratorBase.h"
#include "OSGShearedStereoCameraDecorator.h"


OSG_USING_NAMESPACE

const OSG::BitVector  ShearedStereoCameraDecoratorBase::ZeroParallaxDistanceFieldMask = 
    (TypeTraits<BitVector>::One << ShearedStereoCameraDecoratorBase::ZeroParallaxDistanceFieldId);

const OSG::BitVector  ShearedStereoCameraDecoratorBase::OverlapFieldMask = 
    (TypeTraits<BitVector>::One << ShearedStereoCameraDecoratorBase::OverlapFieldId);

const OSG::BitVector ShearedStereoCameraDecoratorBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Real32          ShearedStereoCameraDecoratorBase::_sfZeroParallaxDistance
    The distance to the zero parallax plane.
*/
/*! \var Real32          ShearedStereoCameraDecoratorBase::_sfOverlap
    The overlap between left and right eye.
*/

//! ShearedStereoCameraDecorator description

FieldDescription *ShearedStereoCameraDecoratorBase::_desc[] = 
{
    new FieldDescription(SFReal32::getClassType(), 
                     "zeroParallaxDistance", 
                     ZeroParallaxDistanceFieldId, ZeroParallaxDistanceFieldMask,
                     false,
                     (FieldAccessMethod) &ShearedStereoCameraDecoratorBase::getSFZeroParallaxDistance),
    new FieldDescription(SFReal32::getClassType(), 
                     "overlap", 
                     OverlapFieldId, OverlapFieldMask,
                     false,
                     (FieldAccessMethod) &ShearedStereoCameraDecoratorBase::getSFOverlap)
};


FieldContainerType ShearedStereoCameraDecoratorBase::_type(
    "ShearedStereoCameraDecorator",
    "StereoCameraDecorator",
    NULL,
    (PrototypeCreateF) &ShearedStereoCameraDecoratorBase::createEmpty,
    ShearedStereoCameraDecorator::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ShearedStereoCameraDecoratorBase, ShearedStereoCameraDecoratorPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ShearedStereoCameraDecoratorBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ShearedStereoCameraDecoratorBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ShearedStereoCameraDecoratorBase::shallowCopy(void) const 
{ 
    ShearedStereoCameraDecoratorPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ShearedStereoCameraDecorator *>(this)); 

    return returnValue; 
}

UInt32 ShearedStereoCameraDecoratorBase::getContainerSize(void) const 
{ 
    return sizeof(ShearedStereoCameraDecorator); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ShearedStereoCameraDecoratorBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ShearedStereoCameraDecoratorBase *) &other, whichField);
}
#else
void ShearedStereoCameraDecoratorBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ShearedStereoCameraDecoratorBase *) &other, whichField, sInfo);
}
void ShearedStereoCameraDecoratorBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ShearedStereoCameraDecoratorBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ShearedStereoCameraDecoratorBase::ShearedStereoCameraDecoratorBase(void) :
    _sfZeroParallaxDistance   (Real32(1)), 
    _sfOverlap                (Real32(1)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ShearedStereoCameraDecoratorBase::ShearedStereoCameraDecoratorBase(const ShearedStereoCameraDecoratorBase &source) :
    _sfZeroParallaxDistance   (source._sfZeroParallaxDistance   ), 
    _sfOverlap                (source._sfOverlap                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ShearedStereoCameraDecoratorBase::~ShearedStereoCameraDecoratorBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ShearedStereoCameraDecoratorBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ZeroParallaxDistanceFieldMask & whichField))
    {
        returnValue += _sfZeroParallaxDistance.getBinSize();
    }

    if(FieldBits::NoField != (OverlapFieldMask & whichField))
    {
        returnValue += _sfOverlap.getBinSize();
    }


    return returnValue;
}

void ShearedStereoCameraDecoratorBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ZeroParallaxDistanceFieldMask & whichField))
    {
        _sfZeroParallaxDistance.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OverlapFieldMask & whichField))
    {
        _sfOverlap.copyToBin(pMem);
    }


}

void ShearedStereoCameraDecoratorBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ZeroParallaxDistanceFieldMask & whichField))
    {
        _sfZeroParallaxDistance.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OverlapFieldMask & whichField))
    {
        _sfOverlap.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ShearedStereoCameraDecoratorBase::executeSyncImpl(      ShearedStereoCameraDecoratorBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ZeroParallaxDistanceFieldMask & whichField))
        _sfZeroParallaxDistance.syncWith(pOther->_sfZeroParallaxDistance);

    if(FieldBits::NoField != (OverlapFieldMask & whichField))
        _sfOverlap.syncWith(pOther->_sfOverlap);


}
#else
void ShearedStereoCameraDecoratorBase::executeSyncImpl(      ShearedStereoCameraDecoratorBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ZeroParallaxDistanceFieldMask & whichField))
        _sfZeroParallaxDistance.syncWith(pOther->_sfZeroParallaxDistance);

    if(FieldBits::NoField != (OverlapFieldMask & whichField))
        _sfOverlap.syncWith(pOther->_sfOverlap);



}

void ShearedStereoCameraDecoratorBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ShearedStereoCameraDecoratorPtr>::_type("ShearedStereoCameraDecoratorPtr", "StereoCameraDecoratorPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ShearedStereoCameraDecoratorPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ShearedStereoCameraDecoratorPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGSHEAREDSTEREOCAMERADECORATORBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSHEAREDSTEREOCAMERADECORATORBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSHEAREDSTEREOCAMERADECORATORFIELDS_HEADER_CVSID;
}

