/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ResolutionDisplayFilter!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &ResolutionDisplayFilterBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 ResolutionDisplayFilterBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
ResolutionDisplayFilterPtr ResolutionDisplayFilterBase::create(void) 
{
    ResolutionDisplayFilterPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = ResolutionDisplayFilterPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
ResolutionDisplayFilterPtr ResolutionDisplayFilterBase::createEmpty(void) 
{ 
    ResolutionDisplayFilterPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the ResolutionDisplayFilter::_sfDownScale field.
inline
SFReal32 *ResolutionDisplayFilterBase::getSFDownScale(void)
{
    return &_sfDownScale;
}


//! Get the value of the ResolutionDisplayFilter::_sfDownScale field.
inline
Real32 &ResolutionDisplayFilterBase::getDownScale(void)
{
    return _sfDownScale.getValue();
}

//! Get the value of the ResolutionDisplayFilter::_sfDownScale field.
inline
const Real32 &ResolutionDisplayFilterBase::getDownScale(void) const
{
    return _sfDownScale.getValue();
}

//! Set the value of the ResolutionDisplayFilter::_sfDownScale field.
inline
void ResolutionDisplayFilterBase::setDownScale(const Real32 &value)
{
    _sfDownScale.setValue(value);
}


OSG_END_NAMESPACE

#define OSGRESOLUTIONDISPLAYFILTERBASE_INLINE_CVSID "@(#)$Id: $"

