/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ColorDisplayFilter!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECOLORDISPLAYFILTERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGColorDisplayFilterBase.h"
#include "OSGColorDisplayFilter.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  ColorDisplayFilterBase::GammaFieldMask = 
    (TypeTraits<BitVector>::One << ColorDisplayFilterBase::GammaFieldId);

const OSG::BitVector  ColorDisplayFilterBase::MatrixFieldMask = 
    (TypeTraits<BitVector>::One << ColorDisplayFilterBase::MatrixFieldId);

const OSG::BitVector  ColorDisplayFilterBase::WidthFieldMask = 
    (TypeTraits<BitVector>::One << ColorDisplayFilterBase::WidthFieldId);

const OSG::BitVector  ColorDisplayFilterBase::HeightFieldMask = 
    (TypeTraits<BitVector>::One << ColorDisplayFilterBase::HeightFieldId);

const OSG::BitVector  ColorDisplayFilterBase::DepthFieldMask = 
    (TypeTraits<BitVector>::One << ColorDisplayFilterBase::DepthFieldId);

const OSG::BitVector  ColorDisplayFilterBase::TableFieldMask = 
    (TypeTraits<BitVector>::One << ColorDisplayFilterBase::TableFieldId);

const OSG::BitVector ColorDisplayFilterBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Real32          ColorDisplayFilterBase::_sfGamma
    Gamma value of the rendered image
*/
/*! \var Matrix          ColorDisplayFilterBase::_sfMatrix
    Color transformation matrix
*/
/*! \var UInt32          ColorDisplayFilterBase::_sfWidth
    
*/
/*! \var UInt32          ColorDisplayFilterBase::_sfHeight
    
*/
/*! \var UInt32          ColorDisplayFilterBase::_sfDepth
    
*/
/*! \var Color3f         ColorDisplayFilterBase::_mfTable
    Shading table
*/

//! ColorDisplayFilter description

FieldDescription *ColorDisplayFilterBase::_desc[] = 
{
    new FieldDescription(SFReal32::getClassType(), 
                     "gamma", 
                     GammaFieldId, GammaFieldMask,
                     false,
                     (FieldAccessMethod) &ColorDisplayFilterBase::getSFGamma),
    new FieldDescription(SFMatrix::getClassType(), 
                     "matrix", 
                     MatrixFieldId, MatrixFieldMask,
                     false,
                     (FieldAccessMethod) &ColorDisplayFilterBase::getSFMatrix),
    new FieldDescription(SFUInt32::getClassType(), 
                     "width", 
                     WidthFieldId, WidthFieldMask,
                     false,
                     (FieldAccessMethod) &ColorDisplayFilterBase::getSFWidth),
    new FieldDescription(SFUInt32::getClassType(), 
                     "height", 
                     HeightFieldId, HeightFieldMask,
                     false,
                     (FieldAccessMethod) &ColorDisplayFilterBase::getSFHeight),
    new FieldDescription(SFUInt32::getClassType(), 
                     "depth", 
                     DepthFieldId, DepthFieldMask,
                     false,
                     (FieldAccessMethod) &ColorDisplayFilterBase::getSFDepth),
    new FieldDescription(MFColor3f::getClassType(), 
                     "table", 
                     TableFieldId, TableFieldMask,
                     false,
                     (FieldAccessMethod) &ColorDisplayFilterBase::getMFTable)
};


FieldContainerType ColorDisplayFilterBase::_type(
    "ColorDisplayFilter",
    "DisplayFilter",
    NULL,
    (PrototypeCreateF) &ColorDisplayFilterBase::createEmpty,
    ColorDisplayFilter::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ColorDisplayFilterBase, ColorDisplayFilterPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ColorDisplayFilterBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ColorDisplayFilterBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ColorDisplayFilterBase::shallowCopy(void) const 
{ 
    ColorDisplayFilterPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ColorDisplayFilter *>(this)); 

    return returnValue; 
}

UInt32 ColorDisplayFilterBase::getContainerSize(void) const 
{ 
    return sizeof(ColorDisplayFilter); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ColorDisplayFilterBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ColorDisplayFilterBase *) &other, whichField);
}
#else
void ColorDisplayFilterBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ColorDisplayFilterBase *) &other, whichField, sInfo);
}
void ColorDisplayFilterBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ColorDisplayFilterBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfTable.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ColorDisplayFilterBase::ColorDisplayFilterBase(void) :
    _sfGamma                  (Real32(2.4)), 
    _sfMatrix                 (), 
    _sfWidth                  (UInt32(1)), 
    _sfHeight                 (UInt32(1)), 
    _sfDepth                  (UInt32(2)), 
    _mfTable                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ColorDisplayFilterBase::ColorDisplayFilterBase(const ColorDisplayFilterBase &source) :
    _sfGamma                  (source._sfGamma                  ), 
    _sfMatrix                 (source._sfMatrix                 ), 
    _sfWidth                  (source._sfWidth                  ), 
    _sfHeight                 (source._sfHeight                 ), 
    _sfDepth                  (source._sfDepth                  ), 
    _mfTable                  (source._mfTable                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ColorDisplayFilterBase::~ColorDisplayFilterBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ColorDisplayFilterBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (GammaFieldMask & whichField))
    {
        returnValue += _sfGamma.getBinSize();
    }

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
    {
        returnValue += _sfMatrix.getBinSize();
    }

    if(FieldBits::NoField != (WidthFieldMask & whichField))
    {
        returnValue += _sfWidth.getBinSize();
    }

    if(FieldBits::NoField != (HeightFieldMask & whichField))
    {
        returnValue += _sfHeight.getBinSize();
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        returnValue += _sfDepth.getBinSize();
    }

    if(FieldBits::NoField != (TableFieldMask & whichField))
    {
        returnValue += _mfTable.getBinSize();
    }


    return returnValue;
}

void ColorDisplayFilterBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (GammaFieldMask & whichField))
    {
        _sfGamma.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
    {
        _sfMatrix.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WidthFieldMask & whichField))
    {
        _sfWidth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (HeightFieldMask & whichField))
    {
        _sfHeight.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        _sfDepth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TableFieldMask & whichField))
    {
        _mfTable.copyToBin(pMem);
    }


}

void ColorDisplayFilterBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (GammaFieldMask & whichField))
    {
        _sfGamma.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
    {
        _sfMatrix.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WidthFieldMask & whichField))
    {
        _sfWidth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (HeightFieldMask & whichField))
    {
        _sfHeight.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        _sfDepth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TableFieldMask & whichField))
    {
        _mfTable.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ColorDisplayFilterBase::executeSyncImpl(      ColorDisplayFilterBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (GammaFieldMask & whichField))
        _sfGamma.syncWith(pOther->_sfGamma);

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
        _sfMatrix.syncWith(pOther->_sfMatrix);

    if(FieldBits::NoField != (WidthFieldMask & whichField))
        _sfWidth.syncWith(pOther->_sfWidth);

    if(FieldBits::NoField != (HeightFieldMask & whichField))
        _sfHeight.syncWith(pOther->_sfHeight);

    if(FieldBits::NoField != (DepthFieldMask & whichField))
        _sfDepth.syncWith(pOther->_sfDepth);

    if(FieldBits::NoField != (TableFieldMask & whichField))
        _mfTable.syncWith(pOther->_mfTable);


}
#else
void ColorDisplayFilterBase::executeSyncImpl(      ColorDisplayFilterBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (GammaFieldMask & whichField))
        _sfGamma.syncWith(pOther->_sfGamma);

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
        _sfMatrix.syncWith(pOther->_sfMatrix);

    if(FieldBits::NoField != (WidthFieldMask & whichField))
        _sfWidth.syncWith(pOther->_sfWidth);

    if(FieldBits::NoField != (HeightFieldMask & whichField))
        _sfHeight.syncWith(pOther->_sfHeight);

    if(FieldBits::NoField != (DepthFieldMask & whichField))
        _sfDepth.syncWith(pOther->_sfDepth);


    if(FieldBits::NoField != (TableFieldMask & whichField))
        _mfTable.syncWith(pOther->_mfTable, sInfo);


}

void ColorDisplayFilterBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (TableFieldMask & whichField))
        _mfTable.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ColorDisplayFilterPtr>::_type("ColorDisplayFilterPtr", "DisplayFilterPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ColorDisplayFilterPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ColorDisplayFilterPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.46 2006/03/16 17:01:53 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGCOLORDISPLAYFILTERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCOLORDISPLAYFILTERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCOLORDISPLAYFILTERFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

