/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class StatisticsForeground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESTATISTICSFOREGROUNDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGStatisticsForegroundBase.h"
#include "OSGStatisticsForeground.h"


OSG_USING_NAMESPACE

const OSG::BitVector  StatisticsForegroundBase::ElementIDsFieldMask = 
    (TypeTraits<BitVector>::One << StatisticsForegroundBase::ElementIDsFieldId);

const OSG::BitVector  StatisticsForegroundBase::CollectorFieldMask = 
    (TypeTraits<BitVector>::One << StatisticsForegroundBase::CollectorFieldId);

const OSG::BitVector StatisticsForegroundBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Int32           StatisticsForegroundBase::_mfElementIDs
    The StatElemDesc IDs to use. If not set, use all in the descriptor.
*/
/*! \var StatCollector   StatisticsForegroundBase::_sfCollector
    The osg::StatisticsCollector that keeps the displayed statistics.
*/

//! StatisticsForeground description

FieldDescription *StatisticsForegroundBase::_desc[] = 
{
    new FieldDescription(MFInt32::getClassType(), 
                     "elementIDs", 
                     ElementIDsFieldId, ElementIDsFieldMask,
                     false,
                     (FieldAccessMethod) &StatisticsForegroundBase::getMFElementIDs),
    new FieldDescription(SFStatCollector::getClassType(), 
                     "collector", 
                     CollectorFieldId, CollectorFieldMask,
                     false,
                     (FieldAccessMethod) &StatisticsForegroundBase::getSFCollector)
};


FieldContainerType StatisticsForegroundBase::_type(
    "StatisticsForeground",
    "Foreground",
    NULL,
    NULL, 
    StatisticsForeground::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(StatisticsForegroundBase, StatisticsForegroundPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &StatisticsForegroundBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &StatisticsForegroundBase::getType(void) const 
{
    return _type;
} 


UInt32 StatisticsForegroundBase::getContainerSize(void) const 
{ 
    return sizeof(StatisticsForeground); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void StatisticsForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((StatisticsForegroundBase *) &other, whichField);
}
#else
void StatisticsForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((StatisticsForegroundBase *) &other, whichField, sInfo);
}
void StatisticsForegroundBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void StatisticsForegroundBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfElementIDs.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

StatisticsForegroundBase::StatisticsForegroundBase(void) :
    _mfElementIDs             (), 
    _sfCollector              (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

StatisticsForegroundBase::StatisticsForegroundBase(const StatisticsForegroundBase &source) :
    _mfElementIDs             (source._mfElementIDs             ), 
    _sfCollector              (source._sfCollector              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

StatisticsForegroundBase::~StatisticsForegroundBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 StatisticsForegroundBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ElementIDsFieldMask & whichField))
    {
        returnValue += _mfElementIDs.getBinSize();
    }

    if(FieldBits::NoField != (CollectorFieldMask & whichField))
    {
        returnValue += _sfCollector.getBinSize();
    }


    return returnValue;
}

void StatisticsForegroundBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ElementIDsFieldMask & whichField))
    {
        _mfElementIDs.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CollectorFieldMask & whichField))
    {
        _sfCollector.copyToBin(pMem);
    }


}

void StatisticsForegroundBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ElementIDsFieldMask & whichField))
    {
        _mfElementIDs.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CollectorFieldMask & whichField))
    {
        _sfCollector.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void StatisticsForegroundBase::executeSyncImpl(      StatisticsForegroundBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ElementIDsFieldMask & whichField))
        _mfElementIDs.syncWith(pOther->_mfElementIDs);

    if(FieldBits::NoField != (CollectorFieldMask & whichField))
        _sfCollector.syncWith(pOther->_sfCollector);


}
#else
void StatisticsForegroundBase::executeSyncImpl(      StatisticsForegroundBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (CollectorFieldMask & whichField))
        _sfCollector.syncWith(pOther->_sfCollector);


    if(FieldBits::NoField != (ElementIDsFieldMask & whichField))
        _mfElementIDs.syncWith(pOther->_mfElementIDs, sInfo);


}

void StatisticsForegroundBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ElementIDsFieldMask & whichField))
        _mfElementIDs.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<StatisticsForegroundPtr>::_type("StatisticsForegroundPtr", "ForegroundPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(StatisticsForegroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(StatisticsForegroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGSTATISTICSFOREGROUNDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSTATISTICSFOREGROUNDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSTATISTICSFOREGROUNDFIELDS_HEADER_CVSID;
}

