/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class RegisterCombinersChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEREGISTERCOMBINERSCHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGRegisterCombinersChunkBase.h"
#include "OSGRegisterCombinersChunk.h"


OSG_USING_NAMESPACE

const OSG::BitVector  RegisterCombinersChunkBase::Color0FieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::Color0FieldId);

const OSG::BitVector  RegisterCombinersChunkBase::Color1FieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::Color1FieldId);

const OSG::BitVector  RegisterCombinersChunkBase::ColorSumClampFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::ColorSumClampFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableArgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableArgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableBrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableBrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableCrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableCrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableDrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableDrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableAalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableAalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableBalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableBalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableCalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableCalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableDalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableDalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::OutputABrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::OutputABrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::OutputCDrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::OutputCDrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::OutputSumrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::OutputSumrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::ScalergbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::ScalergbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::BiasrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::BiasrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::OutputABalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::OutputABalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::OutputCDalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::OutputCDalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::OutputSumalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::OutputSumalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::DotABrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::DotABrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::DotCDrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::DotCDrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::MuxSumrgbFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::MuxSumrgbFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::ScalealphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::ScalealphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::BiasalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::BiasalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::MuxSumalphaFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::MuxSumalphaFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableEFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableEFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableFFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableFFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::VariableGFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::VariableGFieldId);

const OSG::BitVector  RegisterCombinersChunkBase::CombinerColor0FieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::CombinerColor0FieldId);

const OSG::BitVector  RegisterCombinersChunkBase::CombinerColor1FieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::CombinerColor1FieldId);

const OSG::BitVector  RegisterCombinersChunkBase::PerStageConstantsFieldMask = 
    (TypeTraits<BitVector>::One << RegisterCombinersChunkBase::PerStageConstantsFieldId);

const OSG::BitVector RegisterCombinersChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Color4f         RegisterCombinersChunkBase::_sfColor0
    
*/
/*! \var Color4f         RegisterCombinersChunkBase::_sfColor1
    
*/
/*! \var bool            RegisterCombinersChunkBase::_sfColorSumClamp
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableArgb
    input,mapping,component Usage triples for variable A, RGB part
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableBrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableCrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableDrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableAalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableBalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableCalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableDalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfOutputABrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfOutputCDrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfOutputSumrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfScalergb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfBiasrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfOutputABalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfOutputCDalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfOutputSumalpha
    
*/
/*! \var UInt8           RegisterCombinersChunkBase::_mfDotABrgb
    
*/
/*! \var UInt8           RegisterCombinersChunkBase::_mfDotCDrgb
    
*/
/*! \var UInt8           RegisterCombinersChunkBase::_mfMuxSumrgb
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfScalealpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfBiasalpha
    
*/
/*! \var UInt8           RegisterCombinersChunkBase::_mfMuxSumalpha
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableE
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableF
    
*/
/*! \var GLenum          RegisterCombinersChunkBase::_mfVariableG
    
*/
/*! \var Color4f         RegisterCombinersChunkBase::_mfCombinerColor0
    
*/
/*! \var Color4f         RegisterCombinersChunkBase::_mfCombinerColor1
    
*/
/*! \var UInt8           RegisterCombinersChunkBase::_sfPerStageConstants
    
*/

//! RegisterCombinersChunk description

FieldDescription *RegisterCombinersChunkBase::_desc[] = 
{
    new FieldDescription(SFColor4f::getClassType(), 
                     "color0", 
                     Color0FieldId, Color0FieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getSFColor0),
    new FieldDescription(SFColor4f::getClassType(), 
                     "color1", 
                     Color1FieldId, Color1FieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getSFColor1),
    new FieldDescription(SFBool::getClassType(), 
                     "colorSumClamp", 
                     ColorSumClampFieldId, ColorSumClampFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getSFColorSumClamp),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableArgb", 
                     VariableArgbFieldId, VariableArgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableArgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableBrgb", 
                     VariableBrgbFieldId, VariableBrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableBrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableCrgb", 
                     VariableCrgbFieldId, VariableCrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableCrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableDrgb", 
                     VariableDrgbFieldId, VariableDrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableDrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableAalpha", 
                     VariableAalphaFieldId, VariableAalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableAalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableBalpha", 
                     VariableBalphaFieldId, VariableBalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableBalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableCalpha", 
                     VariableCalphaFieldId, VariableCalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableCalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableDalpha", 
                     VariableDalphaFieldId, VariableDalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableDalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "outputABrgb", 
                     OutputABrgbFieldId, OutputABrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFOutputABrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "outputCDrgb", 
                     OutputCDrgbFieldId, OutputCDrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFOutputCDrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "outputSumrgb", 
                     OutputSumrgbFieldId, OutputSumrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFOutputSumrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "scalergb", 
                     ScalergbFieldId, ScalergbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFScalergb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "biasrgb", 
                     BiasrgbFieldId, BiasrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFBiasrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "outputABalpha", 
                     OutputABalphaFieldId, OutputABalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFOutputABalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "outputCDalpha", 
                     OutputCDalphaFieldId, OutputCDalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFOutputCDalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "outputSumalpha", 
                     OutputSumalphaFieldId, OutputSumalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFOutputSumalpha),
    new FieldDescription(MFUInt8::getClassType(), 
                     "dotABrgb", 
                     DotABrgbFieldId, DotABrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFDotABrgb),
    new FieldDescription(MFUInt8::getClassType(), 
                     "dotCDrgb", 
                     DotCDrgbFieldId, DotCDrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFDotCDrgb),
    new FieldDescription(MFUInt8::getClassType(), 
                     "muxSumrgb", 
                     MuxSumrgbFieldId, MuxSumrgbFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFMuxSumrgb),
    new FieldDescription(MFGLenum::getClassType(), 
                     "scalealpha", 
                     ScalealphaFieldId, ScalealphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFScalealpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "biasalpha", 
                     BiasalphaFieldId, BiasalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFBiasalpha),
    new FieldDescription(MFUInt8::getClassType(), 
                     "muxSumalpha", 
                     MuxSumalphaFieldId, MuxSumalphaFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFMuxSumalpha),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableE", 
                     VariableEFieldId, VariableEFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableE),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableF", 
                     VariableFFieldId, VariableFFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableF),
    new FieldDescription(MFGLenum::getClassType(), 
                     "variableG", 
                     VariableGFieldId, VariableGFieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFVariableG),
    new FieldDescription(MFColor4f::getClassType(), 
                     "combinerColor0", 
                     CombinerColor0FieldId, CombinerColor0FieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFCombinerColor0),
    new FieldDescription(MFColor4f::getClassType(), 
                     "combinerColor1", 
                     CombinerColor1FieldId, CombinerColor1FieldMask,
                     false,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getMFCombinerColor1),
    new FieldDescription(SFUInt8::getClassType(), 
                     "perStageConstants", 
                     PerStageConstantsFieldId, PerStageConstantsFieldMask,
                     true,
                     (FieldAccessMethod) &RegisterCombinersChunkBase::getSFPerStageConstants)
};


FieldContainerType RegisterCombinersChunkBase::_type(
    "RegisterCombinersChunk",
    "StateChunk",
    NULL,
    (PrototypeCreateF) &RegisterCombinersChunkBase::createEmpty,
    RegisterCombinersChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(RegisterCombinersChunkBase, RegisterCombinersChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &RegisterCombinersChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &RegisterCombinersChunkBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr RegisterCombinersChunkBase::shallowCopy(void) const 
{ 
    RegisterCombinersChunkPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const RegisterCombinersChunk *>(this)); 

    return returnValue; 
}

UInt32 RegisterCombinersChunkBase::getContainerSize(void) const 
{ 
    return sizeof(RegisterCombinersChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void RegisterCombinersChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((RegisterCombinersChunkBase *) &other, whichField);
}
#else
void RegisterCombinersChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((RegisterCombinersChunkBase *) &other, whichField, sInfo);
}
void RegisterCombinersChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void RegisterCombinersChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfVariableArgb.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableBrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableCrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableDrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableAalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableBalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableCalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableDalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfOutputABrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfOutputCDrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfOutputSumrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfScalergb.terminateShare(uiAspect, this->getContainerSize());
    _mfBiasrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfOutputABalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfOutputCDalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfOutputSumalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfDotABrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfDotCDrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfMuxSumrgb.terminateShare(uiAspect, this->getContainerSize());
    _mfScalealpha.terminateShare(uiAspect, this->getContainerSize());
    _mfBiasalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfMuxSumalpha.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableE.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableF.terminateShare(uiAspect, this->getContainerSize());
    _mfVariableG.terminateShare(uiAspect, this->getContainerSize());
    _mfCombinerColor0.terminateShare(uiAspect, this->getContainerSize());
    _mfCombinerColor1.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

RegisterCombinersChunkBase::RegisterCombinersChunkBase(void) :
    _sfColor0                 (), 
    _sfColor1                 (), 
    _sfColorSumClamp          (bool(false)), 
    _mfVariableArgb           (), 
    _mfVariableBrgb           (), 
    _mfVariableCrgb           (), 
    _mfVariableDrgb           (), 
    _mfVariableAalpha         (), 
    _mfVariableBalpha         (), 
    _mfVariableCalpha         (), 
    _mfVariableDalpha         (), 
    _mfOutputABrgb            (), 
    _mfOutputCDrgb            (), 
    _mfOutputSumrgb           (), 
    _mfScalergb               (), 
    _mfBiasrgb                (), 
    _mfOutputABalpha          (), 
    _mfOutputCDalpha          (), 
    _mfOutputSumalpha         (), 
    _mfDotABrgb               (), 
    _mfDotCDrgb               (), 
    _mfMuxSumrgb              (), 
    _mfScalealpha             (), 
    _mfBiasalpha              (), 
    _mfMuxSumalpha            (), 
    _mfVariableE              (), 
    _mfVariableF              (), 
    _mfVariableG              (), 
    _mfCombinerColor0         (), 
    _mfCombinerColor1         (), 
    _sfPerStageConstants      (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

RegisterCombinersChunkBase::RegisterCombinersChunkBase(const RegisterCombinersChunkBase &source) :
    _sfColor0                 (source._sfColor0                 ), 
    _sfColor1                 (source._sfColor1                 ), 
    _sfColorSumClamp          (source._sfColorSumClamp          ), 
    _mfVariableArgb           (source._mfVariableArgb           ), 
    _mfVariableBrgb           (source._mfVariableBrgb           ), 
    _mfVariableCrgb           (source._mfVariableCrgb           ), 
    _mfVariableDrgb           (source._mfVariableDrgb           ), 
    _mfVariableAalpha         (source._mfVariableAalpha         ), 
    _mfVariableBalpha         (source._mfVariableBalpha         ), 
    _mfVariableCalpha         (source._mfVariableCalpha         ), 
    _mfVariableDalpha         (source._mfVariableDalpha         ), 
    _mfOutputABrgb            (source._mfOutputABrgb            ), 
    _mfOutputCDrgb            (source._mfOutputCDrgb            ), 
    _mfOutputSumrgb           (source._mfOutputSumrgb           ), 
    _mfScalergb               (source._mfScalergb               ), 
    _mfBiasrgb                (source._mfBiasrgb                ), 
    _mfOutputABalpha          (source._mfOutputABalpha          ), 
    _mfOutputCDalpha          (source._mfOutputCDalpha          ), 
    _mfOutputSumalpha         (source._mfOutputSumalpha         ), 
    _mfDotABrgb               (source._mfDotABrgb               ), 
    _mfDotCDrgb               (source._mfDotCDrgb               ), 
    _mfMuxSumrgb              (source._mfMuxSumrgb              ), 
    _mfScalealpha             (source._mfScalealpha             ), 
    _mfBiasalpha              (source._mfBiasalpha              ), 
    _mfMuxSumalpha            (source._mfMuxSumalpha            ), 
    _mfVariableE              (source._mfVariableE              ), 
    _mfVariableF              (source._mfVariableF              ), 
    _mfVariableG              (source._mfVariableG              ), 
    _mfCombinerColor0         (source._mfCombinerColor0         ), 
    _mfCombinerColor1         (source._mfCombinerColor1         ), 
    _sfPerStageConstants      (source._sfPerStageConstants      ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

RegisterCombinersChunkBase::~RegisterCombinersChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 RegisterCombinersChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (Color0FieldMask & whichField))
    {
        returnValue += _sfColor0.getBinSize();
    }

    if(FieldBits::NoField != (Color1FieldMask & whichField))
    {
        returnValue += _sfColor1.getBinSize();
    }

    if(FieldBits::NoField != (ColorSumClampFieldMask & whichField))
    {
        returnValue += _sfColorSumClamp.getBinSize();
    }

    if(FieldBits::NoField != (VariableArgbFieldMask & whichField))
    {
        returnValue += _mfVariableArgb.getBinSize();
    }

    if(FieldBits::NoField != (VariableBrgbFieldMask & whichField))
    {
        returnValue += _mfVariableBrgb.getBinSize();
    }

    if(FieldBits::NoField != (VariableCrgbFieldMask & whichField))
    {
        returnValue += _mfVariableCrgb.getBinSize();
    }

    if(FieldBits::NoField != (VariableDrgbFieldMask & whichField))
    {
        returnValue += _mfVariableDrgb.getBinSize();
    }

    if(FieldBits::NoField != (VariableAalphaFieldMask & whichField))
    {
        returnValue += _mfVariableAalpha.getBinSize();
    }

    if(FieldBits::NoField != (VariableBalphaFieldMask & whichField))
    {
        returnValue += _mfVariableBalpha.getBinSize();
    }

    if(FieldBits::NoField != (VariableCalphaFieldMask & whichField))
    {
        returnValue += _mfVariableCalpha.getBinSize();
    }

    if(FieldBits::NoField != (VariableDalphaFieldMask & whichField))
    {
        returnValue += _mfVariableDalpha.getBinSize();
    }

    if(FieldBits::NoField != (OutputABrgbFieldMask & whichField))
    {
        returnValue += _mfOutputABrgb.getBinSize();
    }

    if(FieldBits::NoField != (OutputCDrgbFieldMask & whichField))
    {
        returnValue += _mfOutputCDrgb.getBinSize();
    }

    if(FieldBits::NoField != (OutputSumrgbFieldMask & whichField))
    {
        returnValue += _mfOutputSumrgb.getBinSize();
    }

    if(FieldBits::NoField != (ScalergbFieldMask & whichField))
    {
        returnValue += _mfScalergb.getBinSize();
    }

    if(FieldBits::NoField != (BiasrgbFieldMask & whichField))
    {
        returnValue += _mfBiasrgb.getBinSize();
    }

    if(FieldBits::NoField != (OutputABalphaFieldMask & whichField))
    {
        returnValue += _mfOutputABalpha.getBinSize();
    }

    if(FieldBits::NoField != (OutputCDalphaFieldMask & whichField))
    {
        returnValue += _mfOutputCDalpha.getBinSize();
    }

    if(FieldBits::NoField != (OutputSumalphaFieldMask & whichField))
    {
        returnValue += _mfOutputSumalpha.getBinSize();
    }

    if(FieldBits::NoField != (DotABrgbFieldMask & whichField))
    {
        returnValue += _mfDotABrgb.getBinSize();
    }

    if(FieldBits::NoField != (DotCDrgbFieldMask & whichField))
    {
        returnValue += _mfDotCDrgb.getBinSize();
    }

    if(FieldBits::NoField != (MuxSumrgbFieldMask & whichField))
    {
        returnValue += _mfMuxSumrgb.getBinSize();
    }

    if(FieldBits::NoField != (ScalealphaFieldMask & whichField))
    {
        returnValue += _mfScalealpha.getBinSize();
    }

    if(FieldBits::NoField != (BiasalphaFieldMask & whichField))
    {
        returnValue += _mfBiasalpha.getBinSize();
    }

    if(FieldBits::NoField != (MuxSumalphaFieldMask & whichField))
    {
        returnValue += _mfMuxSumalpha.getBinSize();
    }

    if(FieldBits::NoField != (VariableEFieldMask & whichField))
    {
        returnValue += _mfVariableE.getBinSize();
    }

    if(FieldBits::NoField != (VariableFFieldMask & whichField))
    {
        returnValue += _mfVariableF.getBinSize();
    }

    if(FieldBits::NoField != (VariableGFieldMask & whichField))
    {
        returnValue += _mfVariableG.getBinSize();
    }

    if(FieldBits::NoField != (CombinerColor0FieldMask & whichField))
    {
        returnValue += _mfCombinerColor0.getBinSize();
    }

    if(FieldBits::NoField != (CombinerColor1FieldMask & whichField))
    {
        returnValue += _mfCombinerColor1.getBinSize();
    }

    if(FieldBits::NoField != (PerStageConstantsFieldMask & whichField))
    {
        returnValue += _sfPerStageConstants.getBinSize();
    }


    return returnValue;
}

void RegisterCombinersChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (Color0FieldMask & whichField))
    {
        _sfColor0.copyToBin(pMem);
    }

    if(FieldBits::NoField != (Color1FieldMask & whichField))
    {
        _sfColor1.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ColorSumClampFieldMask & whichField))
    {
        _sfColorSumClamp.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableArgbFieldMask & whichField))
    {
        _mfVariableArgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableBrgbFieldMask & whichField))
    {
        _mfVariableBrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableCrgbFieldMask & whichField))
    {
        _mfVariableCrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableDrgbFieldMask & whichField))
    {
        _mfVariableDrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableAalphaFieldMask & whichField))
    {
        _mfVariableAalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableBalphaFieldMask & whichField))
    {
        _mfVariableBalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableCalphaFieldMask & whichField))
    {
        _mfVariableCalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableDalphaFieldMask & whichField))
    {
        _mfVariableDalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OutputABrgbFieldMask & whichField))
    {
        _mfOutputABrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OutputCDrgbFieldMask & whichField))
    {
        _mfOutputCDrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OutputSumrgbFieldMask & whichField))
    {
        _mfOutputSumrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ScalergbFieldMask & whichField))
    {
        _mfScalergb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BiasrgbFieldMask & whichField))
    {
        _mfBiasrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OutputABalphaFieldMask & whichField))
    {
        _mfOutputABalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OutputCDalphaFieldMask & whichField))
    {
        _mfOutputCDalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OutputSumalphaFieldMask & whichField))
    {
        _mfOutputSumalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DotABrgbFieldMask & whichField))
    {
        _mfDotABrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DotCDrgbFieldMask & whichField))
    {
        _mfDotCDrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MuxSumrgbFieldMask & whichField))
    {
        _mfMuxSumrgb.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ScalealphaFieldMask & whichField))
    {
        _mfScalealpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BiasalphaFieldMask & whichField))
    {
        _mfBiasalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MuxSumalphaFieldMask & whichField))
    {
        _mfMuxSumalpha.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableEFieldMask & whichField))
    {
        _mfVariableE.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableFFieldMask & whichField))
    {
        _mfVariableF.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VariableGFieldMask & whichField))
    {
        _mfVariableG.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CombinerColor0FieldMask & whichField))
    {
        _mfCombinerColor0.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CombinerColor1FieldMask & whichField))
    {
        _mfCombinerColor1.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PerStageConstantsFieldMask & whichField))
    {
        _sfPerStageConstants.copyToBin(pMem);
    }


}

void RegisterCombinersChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (Color0FieldMask & whichField))
    {
        _sfColor0.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (Color1FieldMask & whichField))
    {
        _sfColor1.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ColorSumClampFieldMask & whichField))
    {
        _sfColorSumClamp.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableArgbFieldMask & whichField))
    {
        _mfVariableArgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableBrgbFieldMask & whichField))
    {
        _mfVariableBrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableCrgbFieldMask & whichField))
    {
        _mfVariableCrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableDrgbFieldMask & whichField))
    {
        _mfVariableDrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableAalphaFieldMask & whichField))
    {
        _mfVariableAalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableBalphaFieldMask & whichField))
    {
        _mfVariableBalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableCalphaFieldMask & whichField))
    {
        _mfVariableCalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableDalphaFieldMask & whichField))
    {
        _mfVariableDalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OutputABrgbFieldMask & whichField))
    {
        _mfOutputABrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OutputCDrgbFieldMask & whichField))
    {
        _mfOutputCDrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OutputSumrgbFieldMask & whichField))
    {
        _mfOutputSumrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ScalergbFieldMask & whichField))
    {
        _mfScalergb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BiasrgbFieldMask & whichField))
    {
        _mfBiasrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OutputABalphaFieldMask & whichField))
    {
        _mfOutputABalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OutputCDalphaFieldMask & whichField))
    {
        _mfOutputCDalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OutputSumalphaFieldMask & whichField))
    {
        _mfOutputSumalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DotABrgbFieldMask & whichField))
    {
        _mfDotABrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DotCDrgbFieldMask & whichField))
    {
        _mfDotCDrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MuxSumrgbFieldMask & whichField))
    {
        _mfMuxSumrgb.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ScalealphaFieldMask & whichField))
    {
        _mfScalealpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BiasalphaFieldMask & whichField))
    {
        _mfBiasalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MuxSumalphaFieldMask & whichField))
    {
        _mfMuxSumalpha.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableEFieldMask & whichField))
    {
        _mfVariableE.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableFFieldMask & whichField))
    {
        _mfVariableF.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VariableGFieldMask & whichField))
    {
        _mfVariableG.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CombinerColor0FieldMask & whichField))
    {
        _mfCombinerColor0.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CombinerColor1FieldMask & whichField))
    {
        _mfCombinerColor1.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PerStageConstantsFieldMask & whichField))
    {
        _sfPerStageConstants.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void RegisterCombinersChunkBase::executeSyncImpl(      RegisterCombinersChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (Color0FieldMask & whichField))
        _sfColor0.syncWith(pOther->_sfColor0);

    if(FieldBits::NoField != (Color1FieldMask & whichField))
        _sfColor1.syncWith(pOther->_sfColor1);

    if(FieldBits::NoField != (ColorSumClampFieldMask & whichField))
        _sfColorSumClamp.syncWith(pOther->_sfColorSumClamp);

    if(FieldBits::NoField != (VariableArgbFieldMask & whichField))
        _mfVariableArgb.syncWith(pOther->_mfVariableArgb);

    if(FieldBits::NoField != (VariableBrgbFieldMask & whichField))
        _mfVariableBrgb.syncWith(pOther->_mfVariableBrgb);

    if(FieldBits::NoField != (VariableCrgbFieldMask & whichField))
        _mfVariableCrgb.syncWith(pOther->_mfVariableCrgb);

    if(FieldBits::NoField != (VariableDrgbFieldMask & whichField))
        _mfVariableDrgb.syncWith(pOther->_mfVariableDrgb);

    if(FieldBits::NoField != (VariableAalphaFieldMask & whichField))
        _mfVariableAalpha.syncWith(pOther->_mfVariableAalpha);

    if(FieldBits::NoField != (VariableBalphaFieldMask & whichField))
        _mfVariableBalpha.syncWith(pOther->_mfVariableBalpha);

    if(FieldBits::NoField != (VariableCalphaFieldMask & whichField))
        _mfVariableCalpha.syncWith(pOther->_mfVariableCalpha);

    if(FieldBits::NoField != (VariableDalphaFieldMask & whichField))
        _mfVariableDalpha.syncWith(pOther->_mfVariableDalpha);

    if(FieldBits::NoField != (OutputABrgbFieldMask & whichField))
        _mfOutputABrgb.syncWith(pOther->_mfOutputABrgb);

    if(FieldBits::NoField != (OutputCDrgbFieldMask & whichField))
        _mfOutputCDrgb.syncWith(pOther->_mfOutputCDrgb);

    if(FieldBits::NoField != (OutputSumrgbFieldMask & whichField))
        _mfOutputSumrgb.syncWith(pOther->_mfOutputSumrgb);

    if(FieldBits::NoField != (ScalergbFieldMask & whichField))
        _mfScalergb.syncWith(pOther->_mfScalergb);

    if(FieldBits::NoField != (BiasrgbFieldMask & whichField))
        _mfBiasrgb.syncWith(pOther->_mfBiasrgb);

    if(FieldBits::NoField != (OutputABalphaFieldMask & whichField))
        _mfOutputABalpha.syncWith(pOther->_mfOutputABalpha);

    if(FieldBits::NoField != (OutputCDalphaFieldMask & whichField))
        _mfOutputCDalpha.syncWith(pOther->_mfOutputCDalpha);

    if(FieldBits::NoField != (OutputSumalphaFieldMask & whichField))
        _mfOutputSumalpha.syncWith(pOther->_mfOutputSumalpha);

    if(FieldBits::NoField != (DotABrgbFieldMask & whichField))
        _mfDotABrgb.syncWith(pOther->_mfDotABrgb);

    if(FieldBits::NoField != (DotCDrgbFieldMask & whichField))
        _mfDotCDrgb.syncWith(pOther->_mfDotCDrgb);

    if(FieldBits::NoField != (MuxSumrgbFieldMask & whichField))
        _mfMuxSumrgb.syncWith(pOther->_mfMuxSumrgb);

    if(FieldBits::NoField != (ScalealphaFieldMask & whichField))
        _mfScalealpha.syncWith(pOther->_mfScalealpha);

    if(FieldBits::NoField != (BiasalphaFieldMask & whichField))
        _mfBiasalpha.syncWith(pOther->_mfBiasalpha);

    if(FieldBits::NoField != (MuxSumalphaFieldMask & whichField))
        _mfMuxSumalpha.syncWith(pOther->_mfMuxSumalpha);

    if(FieldBits::NoField != (VariableEFieldMask & whichField))
        _mfVariableE.syncWith(pOther->_mfVariableE);

    if(FieldBits::NoField != (VariableFFieldMask & whichField))
        _mfVariableF.syncWith(pOther->_mfVariableF);

    if(FieldBits::NoField != (VariableGFieldMask & whichField))
        _mfVariableG.syncWith(pOther->_mfVariableG);

    if(FieldBits::NoField != (CombinerColor0FieldMask & whichField))
        _mfCombinerColor0.syncWith(pOther->_mfCombinerColor0);

    if(FieldBits::NoField != (CombinerColor1FieldMask & whichField))
        _mfCombinerColor1.syncWith(pOther->_mfCombinerColor1);

    if(FieldBits::NoField != (PerStageConstantsFieldMask & whichField))
        _sfPerStageConstants.syncWith(pOther->_sfPerStageConstants);


}
#else
void RegisterCombinersChunkBase::executeSyncImpl(      RegisterCombinersChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (Color0FieldMask & whichField))
        _sfColor0.syncWith(pOther->_sfColor0);

    if(FieldBits::NoField != (Color1FieldMask & whichField))
        _sfColor1.syncWith(pOther->_sfColor1);

    if(FieldBits::NoField != (ColorSumClampFieldMask & whichField))
        _sfColorSumClamp.syncWith(pOther->_sfColorSumClamp);

    if(FieldBits::NoField != (PerStageConstantsFieldMask & whichField))
        _sfPerStageConstants.syncWith(pOther->_sfPerStageConstants);


    if(FieldBits::NoField != (VariableArgbFieldMask & whichField))
        _mfVariableArgb.syncWith(pOther->_mfVariableArgb, sInfo);

    if(FieldBits::NoField != (VariableBrgbFieldMask & whichField))
        _mfVariableBrgb.syncWith(pOther->_mfVariableBrgb, sInfo);

    if(FieldBits::NoField != (VariableCrgbFieldMask & whichField))
        _mfVariableCrgb.syncWith(pOther->_mfVariableCrgb, sInfo);

    if(FieldBits::NoField != (VariableDrgbFieldMask & whichField))
        _mfVariableDrgb.syncWith(pOther->_mfVariableDrgb, sInfo);

    if(FieldBits::NoField != (VariableAalphaFieldMask & whichField))
        _mfVariableAalpha.syncWith(pOther->_mfVariableAalpha, sInfo);

    if(FieldBits::NoField != (VariableBalphaFieldMask & whichField))
        _mfVariableBalpha.syncWith(pOther->_mfVariableBalpha, sInfo);

    if(FieldBits::NoField != (VariableCalphaFieldMask & whichField))
        _mfVariableCalpha.syncWith(pOther->_mfVariableCalpha, sInfo);

    if(FieldBits::NoField != (VariableDalphaFieldMask & whichField))
        _mfVariableDalpha.syncWith(pOther->_mfVariableDalpha, sInfo);

    if(FieldBits::NoField != (OutputABrgbFieldMask & whichField))
        _mfOutputABrgb.syncWith(pOther->_mfOutputABrgb, sInfo);

    if(FieldBits::NoField != (OutputCDrgbFieldMask & whichField))
        _mfOutputCDrgb.syncWith(pOther->_mfOutputCDrgb, sInfo);

    if(FieldBits::NoField != (OutputSumrgbFieldMask & whichField))
        _mfOutputSumrgb.syncWith(pOther->_mfOutputSumrgb, sInfo);

    if(FieldBits::NoField != (ScalergbFieldMask & whichField))
        _mfScalergb.syncWith(pOther->_mfScalergb, sInfo);

    if(FieldBits::NoField != (BiasrgbFieldMask & whichField))
        _mfBiasrgb.syncWith(pOther->_mfBiasrgb, sInfo);

    if(FieldBits::NoField != (OutputABalphaFieldMask & whichField))
        _mfOutputABalpha.syncWith(pOther->_mfOutputABalpha, sInfo);

    if(FieldBits::NoField != (OutputCDalphaFieldMask & whichField))
        _mfOutputCDalpha.syncWith(pOther->_mfOutputCDalpha, sInfo);

    if(FieldBits::NoField != (OutputSumalphaFieldMask & whichField))
        _mfOutputSumalpha.syncWith(pOther->_mfOutputSumalpha, sInfo);

    if(FieldBits::NoField != (DotABrgbFieldMask & whichField))
        _mfDotABrgb.syncWith(pOther->_mfDotABrgb, sInfo);

    if(FieldBits::NoField != (DotCDrgbFieldMask & whichField))
        _mfDotCDrgb.syncWith(pOther->_mfDotCDrgb, sInfo);

    if(FieldBits::NoField != (MuxSumrgbFieldMask & whichField))
        _mfMuxSumrgb.syncWith(pOther->_mfMuxSumrgb, sInfo);

    if(FieldBits::NoField != (ScalealphaFieldMask & whichField))
        _mfScalealpha.syncWith(pOther->_mfScalealpha, sInfo);

    if(FieldBits::NoField != (BiasalphaFieldMask & whichField))
        _mfBiasalpha.syncWith(pOther->_mfBiasalpha, sInfo);

    if(FieldBits::NoField != (MuxSumalphaFieldMask & whichField))
        _mfMuxSumalpha.syncWith(pOther->_mfMuxSumalpha, sInfo);

    if(FieldBits::NoField != (VariableEFieldMask & whichField))
        _mfVariableE.syncWith(pOther->_mfVariableE, sInfo);

    if(FieldBits::NoField != (VariableFFieldMask & whichField))
        _mfVariableF.syncWith(pOther->_mfVariableF, sInfo);

    if(FieldBits::NoField != (VariableGFieldMask & whichField))
        _mfVariableG.syncWith(pOther->_mfVariableG, sInfo);

    if(FieldBits::NoField != (CombinerColor0FieldMask & whichField))
        _mfCombinerColor0.syncWith(pOther->_mfCombinerColor0, sInfo);

    if(FieldBits::NoField != (CombinerColor1FieldMask & whichField))
        _mfCombinerColor1.syncWith(pOther->_mfCombinerColor1, sInfo);


}

void RegisterCombinersChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableArgbFieldMask & whichField))
        _mfVariableArgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableBrgbFieldMask & whichField))
        _mfVariableBrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableCrgbFieldMask & whichField))
        _mfVariableCrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableDrgbFieldMask & whichField))
        _mfVariableDrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableAalphaFieldMask & whichField))
        _mfVariableAalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableBalphaFieldMask & whichField))
        _mfVariableBalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableCalphaFieldMask & whichField))
        _mfVariableCalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableDalphaFieldMask & whichField))
        _mfVariableDalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (OutputABrgbFieldMask & whichField))
        _mfOutputABrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (OutputCDrgbFieldMask & whichField))
        _mfOutputCDrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (OutputSumrgbFieldMask & whichField))
        _mfOutputSumrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ScalergbFieldMask & whichField))
        _mfScalergb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (BiasrgbFieldMask & whichField))
        _mfBiasrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (OutputABalphaFieldMask & whichField))
        _mfOutputABalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (OutputCDalphaFieldMask & whichField))
        _mfOutputCDalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (OutputSumalphaFieldMask & whichField))
        _mfOutputSumalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (DotABrgbFieldMask & whichField))
        _mfDotABrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (DotCDrgbFieldMask & whichField))
        _mfDotCDrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (MuxSumrgbFieldMask & whichField))
        _mfMuxSumrgb.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ScalealphaFieldMask & whichField))
        _mfScalealpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (BiasalphaFieldMask & whichField))
        _mfBiasalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (MuxSumalphaFieldMask & whichField))
        _mfMuxSumalpha.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableEFieldMask & whichField))
        _mfVariableE.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableFFieldMask & whichField))
        _mfVariableF.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VariableGFieldMask & whichField))
        _mfVariableG.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (CombinerColor0FieldMask & whichField))
        _mfCombinerColor0.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (CombinerColor1FieldMask & whichField))
        _mfCombinerColor1.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<RegisterCombinersChunkPtr>::_type("RegisterCombinersChunkPtr", "StateChunkPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(RegisterCombinersChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(RegisterCombinersChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGREGISTERCOMBINERSCHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGREGISTERCOMBINERSCHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGREGISTERCOMBINERSCHUNKFIELDS_HEADER_CVSID;
}

