/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class StateSortingGroup!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESTATESORTINGGROUPINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGStateSortingGroupBase.h"
#include "OSGStateSortingGroup.h"


OSG_USING_NAMESPACE

const OSG::BitVector  StateSortingGroupBase::SortingFieldMask = 
    (TypeTraits<BitVector>::One << StateSortingGroupBase::SortingFieldId);

const OSG::BitVector StateSortingGroupBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            StateSortingGroupBase::_sfSorting
    Enables or disables the state sorting.
*/

//! StateSortingGroup description

FieldDescription *StateSortingGroupBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "sorting", 
                     SortingFieldId, SortingFieldMask,
                     false,
                     (FieldAccessMethod) &StateSortingGroupBase::getSFSorting)
};


FieldContainerType StateSortingGroupBase::_type(
    "StateSortingGroup",
    "NodeCore",
    NULL,
    (PrototypeCreateF) &StateSortingGroupBase::createEmpty,
    StateSortingGroup::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(StateSortingGroupBase, StateSortingGroupPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &StateSortingGroupBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &StateSortingGroupBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr StateSortingGroupBase::shallowCopy(void) const 
{ 
    StateSortingGroupPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const StateSortingGroup *>(this)); 

    return returnValue; 
}

UInt32 StateSortingGroupBase::getContainerSize(void) const 
{ 
    return sizeof(StateSortingGroup); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void StateSortingGroupBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((StateSortingGroupBase *) &other, whichField);
}
#else
void StateSortingGroupBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((StateSortingGroupBase *) &other, whichField, sInfo);
}
void StateSortingGroupBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void StateSortingGroupBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

StateSortingGroupBase::StateSortingGroupBase(void) :
    _sfSorting                (bool(false)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

StateSortingGroupBase::StateSortingGroupBase(const StateSortingGroupBase &source) :
    _sfSorting                (source._sfSorting                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

StateSortingGroupBase::~StateSortingGroupBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 StateSortingGroupBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (SortingFieldMask & whichField))
    {
        returnValue += _sfSorting.getBinSize();
    }


    return returnValue;
}

void StateSortingGroupBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (SortingFieldMask & whichField))
    {
        _sfSorting.copyToBin(pMem);
    }


}

void StateSortingGroupBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (SortingFieldMask & whichField))
    {
        _sfSorting.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void StateSortingGroupBase::executeSyncImpl(      StateSortingGroupBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (SortingFieldMask & whichField))
        _sfSorting.syncWith(pOther->_sfSorting);


}
#else
void StateSortingGroupBase::executeSyncImpl(      StateSortingGroupBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (SortingFieldMask & whichField))
        _sfSorting.syncWith(pOther->_sfSorting);



}

void StateSortingGroupBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<StateSortingGroupPtr>::_type("StateSortingGroupPtr", "NodeCorePtr");
#endif


OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGStateSortingGroupBase.cpp,v 1.6 2006/02/20 16:54:24 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGSTATESORTINGGROUPBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSTATESORTINGGROUPBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSTATESORTINGGROUPFIELDS_HEADER_CVSID;
}

