/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class MaterialGroup!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEMATERIALGROUPINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGMaterialGroupBase.h"
#include "OSGMaterialGroup.h"


OSG_USING_NAMESPACE

const OSG::BitVector  MaterialGroupBase::MaterialFieldMask = 
    (TypeTraits<BitVector>::One << MaterialGroupBase::MaterialFieldId);

const OSG::BitVector MaterialGroupBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var MaterialPtr     MaterialGroupBase::_sfMaterial
    
*/

//! MaterialGroup description

FieldDescription *MaterialGroupBase::_desc[] = 
{
    new FieldDescription(SFMaterialPtr::getClassType(), 
                     "material", 
                     MaterialFieldId, MaterialFieldMask,
                     false,
                     (FieldAccessMethod) &MaterialGroupBase::getSFMaterial)
};


FieldContainerType MaterialGroupBase::_type(
    "MaterialGroup",
    "Group",
    NULL,
    (PrototypeCreateF) &MaterialGroupBase::createEmpty,
    MaterialGroup::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(MaterialGroupBase, MaterialGroupPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &MaterialGroupBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &MaterialGroupBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr MaterialGroupBase::shallowCopy(void) const 
{ 
    MaterialGroupPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const MaterialGroup *>(this)); 

    return returnValue; 
}

UInt32 MaterialGroupBase::getContainerSize(void) const 
{ 
    return sizeof(MaterialGroup); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void MaterialGroupBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((MaterialGroupBase *) &other, whichField);
}
#else
void MaterialGroupBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((MaterialGroupBase *) &other, whichField, sInfo);
}
void MaterialGroupBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void MaterialGroupBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

MaterialGroupBase::MaterialGroupBase(void) :
    _sfMaterial               (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

MaterialGroupBase::MaterialGroupBase(const MaterialGroupBase &source) :
    _sfMaterial               (source._sfMaterial               ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

MaterialGroupBase::~MaterialGroupBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 MaterialGroupBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (MaterialFieldMask & whichField))
    {
        returnValue += _sfMaterial.getBinSize();
    }


    return returnValue;
}

void MaterialGroupBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (MaterialFieldMask & whichField))
    {
        _sfMaterial.copyToBin(pMem);
    }


}

void MaterialGroupBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (MaterialFieldMask & whichField))
    {
        _sfMaterial.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void MaterialGroupBase::executeSyncImpl(      MaterialGroupBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (MaterialFieldMask & whichField))
        _sfMaterial.syncWith(pOther->_sfMaterial);


}
#else
void MaterialGroupBase::executeSyncImpl(      MaterialGroupBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (MaterialFieldMask & whichField))
        _sfMaterial.syncWith(pOther->_sfMaterial);



}

void MaterialGroupBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<MaterialGroupPtr>::_type("MaterialGroupPtr", "GroupPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(MaterialGroupPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(MaterialGroupPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGMATERIALGROUPBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGMATERIALGROUPBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGMATERIALGROUPFIELDS_HEADER_CVSID;
}

